/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.update;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.widgets.Display;
import org.json.JSONArray;
import org.json.JSONObject;
import wj.ap.action.CreateNodeFileHelper;
import wj.ap.action.DeleteAction;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.explorer.ExplorerView;
import wj.ap.login.Account;
import wj.ap.update.LocalVersionInfo;
import wj.ap.update.ServerVersionAndFile;
import wj.ap.util.InternetHelper;
import wj.ap.util.ModelHelper;
import wj.ap.util.StatusHelper;
import wj.ap.util.WJ;

public class SyncHelper {
    public static void timingSync() {
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                System.out.println("\u540c\u6b65\u8c03\u7528");
                if (Account.getInstance().getToken() == null) {
                    return;
                }
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        SyncHelper.syncContent();
                    }
                }).start();
            }
        };
        timer.schedule(task, 10000L, 10000L);
    }

    public static void TestSynch() {
    }

    private static synchronized void syncContent() {
        System.out.println("\u540c\u6b65\u5f00\u59cb");
        JSONArray storyArrayServer = SyncHelper.getServerVersionInfo();
        if (storyArrayServer == null) {
            System.out.println("\u6ca1\u6709\u83b7\u53d6\u5230\u670d\u52a1\u5668\u4e0a\u7684\u7248\u672c\u4fe1\u606f");
            return;
        }
        JSONArray storyArrayServerCopy = new JSONArray(storyArrayServer.toString());
        SyncHelper.updateLocalDelete(storyArrayServer, storyArrayServerCopy);
        JSONArray storyArrayLocal = LocalVersionInfo.getLocalVersionInfoWithIsDirty(ExplorerModelHelper.getElement(null));
        SyncHelper.walkingServerVersion(storyArrayServer, storyArrayLocal, storyArrayServerCopy);
        storyArrayLocal = LocalVersionInfo.getLocalVersionInfoWithIsDirty(ExplorerModelHelper.getElement(null));
        SyncHelper.walkingLocalVersion(storyArrayLocal, storyArrayServer, storyArrayServerCopy);
        ServerVersionAndFile.commitVersion(storyArrayServerCopy);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExplorerView view = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName());
                view.updateTree();
            }
        });
        System.out.println("\u540c\u6b65\u5b8c\u6bd5");
    }

    private static void updateLocalDelete(JSONArray storyArrayServer, JSONArray storyArrayServerCopy) {
        String nodeIds = StatusHelper.getValue("deleteNodeId");
        if (nodeIds == null || nodeIds.equals("")) {
            return;
        }
        String[] nodeIdArray = nodeIds.split(";");
        if (nodeIdArray.length == 0) {
            return;
        }
        HashSet<String> nodeIdSet = new HashSet<String>(nodeIdArray.length);
        int i = 0;
        while (i < nodeIdArray.length) {
            if (!nodeIdArray[i].equals("")) {
                nodeIdSet.add(nodeIdArray[i]);
            }
            ++i;
        }
        i = 0;
        while (i < storyArrayServer.length()) {
            JSONObject storyServer = storyArrayServer.getJSONObject(i);
            String storyId = storyServer.getString("id");
            JSONObject storyServerCopy = SyncHelper.getObject(storyArrayServerCopy, storyId);
            if (nodeIdSet.contains(storyId)) {
                storyServer.put("status", (Object)"deleteFromPC");
                storyServerCopy.put("status", (Object)"deleteFromPC");
            } else {
                SyncHelper.updateLocalDelete4ChapterOrNote(nodeIdSet, storyServer, storyServerCopy, "content");
                SyncHelper.updateLocalDelete4ChapterOrNote(nodeIdSet, storyServer, storyServerCopy, "note");
            }
            ++i;
        }
        StatusHelper.setValue("deleteNodeId", "");
    }

    private static void updateLocalDelete4ChapterOrNote(Set<String> nodeIdSet, JSONObject storyServer, JSONObject storyServerCopy, String type) {
        if (storyServer.isNull(type)) {
            return;
        }
        JSONArray fileArrayServer = storyServer.getJSONArray(type);
        JSONArray fileArrayServerCopy = storyServerCopy.getJSONArray(type);
        int i = 0;
        while (i < fileArrayServer.length()) {
            JSONObject fileServer = fileArrayServer.getJSONObject(i);
            String fileId = fileServer.getString("id");
            JSONObject fileServerCopy = SyncHelper.getObject(fileArrayServerCopy, fileId);
            if (nodeIdSet.contains(fileId)) {
                fileServer.put("status", (Object)"deleteFromPC");
                fileServerCopy.put("status", (Object)"deleteFromPC");
                ServerVersionAndFile.deleteFileFromServer(fileId);
            }
            ++i;
        }
    }

    private static JSONArray getServerVersionInfo() {
        String versionGet = String.valueOf(InternetHelper.getHost()) + "/at/version/info";
        versionGet = Account.getInstance().addAccountInfo(versionGet);
        HttpGet httpGet = new HttpGet(versionGet);
        JSONArray storyArrayServer = null;
        try {
            HttpResponse response = InternetHelper.httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && response.getStatusLine().getStatusCode() == 200) {
                String result = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("UTF-8"));
                JSONObject obj = new JSONObject(result);
                if (obj.isNull("version")) {
                    ServerVersionAndFile.commitVersion(LocalVersionInfo.createServerVersionFromLocalVersion(ExplorerModelHelper.getElement(null)));
                } else {
                    storyArrayServer = new JSONArray(obj.getString("version"));
                }
            }
        }
        catch (ClientProtocolException clientProtocolException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return storyArrayServer;
    }

    private static void walkingServerVersion(JSONArray storyArrayServer, JSONArray storyArrayLocal, JSONArray storyArrayServerCopy) {
        int i = 0;
        while (i < storyArrayServer.length()) {
            JSONObject storyServer = storyArrayServer.getJSONObject(i);
            String storyId = storyServer.getString("id");
            JSONObject storyLocal = SyncHelper.getObject(storyArrayLocal, storyId);
            JSONObject storyServerCopy = SyncHelper.getObject(storyArrayServerCopy, storyId);
            String status = storyServer.getString("status");
            if (status.equals("newFromPC")) {
                SyncHelper.updateStory4NewFromPC(storyServer, storyArrayServerCopy);
            } else if (status.equals("newFromMobile")) {
                SyncHelper.updateStory4NewFromMobile(storyServer, storyServerCopy);
            } else if (status.equals("normal")) {
                SyncHelper.updateStory4Normal(storyServer, storyLocal, storyServerCopy);
            } else if (status.equals("deleteFromPC")) {
                SyncHelper.updateStory4DeleteFromPC(storyServer);
            } else if (status.equals("deleteFromMobile")) {
                SyncHelper.updateStory4DeleteFromMobile(storyServer, storyArrayServerCopy);
            }
            ++i;
        }
    }

    private static void updateStory4NewFromPC(JSONObject storyServer, JSONArray storyArrayServerCopy) {
        String storyId = storyServer.getString("id");
        Element storyNode = ExplorerModelHelper.getElement(storyId);
        if (storyNode == null) {
            SyncHelper.createStory(storyServer);
        }
    }

    private static void updateStory4NewFromMobile(JSONObject storyServer, JSONObject storyServerCopy) {
        String storyId = storyServer.getString("id");
        Element storyNode = ExplorerModelHelper.getElement(storyId);
        if (storyNode == null) {
            SyncHelper.createStory(storyServer);
        }
        storyServerCopy.put("status", (Object)"normal");
    }

    private static void createStory(JSONObject storyObj) {
        String storyId = storyObj.getString("id");
        Element storyNode = ExplorerModelHelper.createStoryNode("novel", storyObj.getString("name"), storyId);
        ExplorerModelHelper.insertElement(null, storyNode);
        CreateNodeFileHelper.createStoryNodeFile(storyNode);
        Element chapterFolder = ExplorerModelHelper.createFolderNode(storyNode.attributeValue("location"), "chapterFolder", "\u7ae0\u8282");
        ExplorerModelHelper.insertElement(storyNode.attributeValue("id"), chapterFolder);
        ModelHelper.createFolder(chapterFolder.attributeValue("location"));
        Element noteFolder = ExplorerModelHelper.createFolderNode(storyNode.attributeValue("location"), "noteFolder", "\u7d20\u6750");
        ExplorerModelHelper.insertElement(storyNode.attributeValue("id"), noteFolder);
        ModelHelper.createFolder(noteFolder.attributeValue("location"));
        if (storyObj.has("content")) {
            JSONArray chapterArrayServer = storyObj.getJSONArray("content");
            int no = chapterArrayServer.length() + 10000;
            int j = 0;
            while (j < chapterArrayServer.length()) {
                JSONObject chapterServer = chapterArrayServer.getJSONObject(j);
                String status = chapterServer.getString("status");
                if (!status.equals("deleteFromPC") && !status.equals("deleteFromMobile")) {
                    SyncHelper.createChapterFromServer(chapterServer, storyId, false, no - j);
                }
                ++j;
            }
        }
        if (storyObj.has("note")) {
            JSONArray noteArrayServer = storyObj.getJSONArray("note");
            int j = 0;
            while (j < noteArrayServer.length()) {
                JSONObject noteServer = noteArrayServer.getJSONObject(j);
                String status = noteServer.getString("status");
                if (!status.equals("deleteFromPC") && !status.equals("deleteFromMobile")) {
                    SyncHelper.createNoteFromServer(noteServer, storyId, false);
                }
                ++j;
            }
        }
    }

    private static void updateStory4Normal(JSONObject storyServer, JSONObject storyLocal, JSONObject storyServerCopy) {
        if (storyLocal == null) {
            SyncHelper.createStory(storyServer);
        } else {
            JSONArray fileArrayServerCopy;
            JSONArray fileArrayLocal;
            JSONArray fileArrayServer;
            String storyId = storyServer.getString("id");
            if (storyServer.has("content")) {
                fileArrayServer = storyServer.getJSONArray("content");
                fileArrayLocal = storyLocal.getJSONArray("content");
                fileArrayServerCopy = storyServerCopy.getJSONArray("content");
                SyncHelper.updateLocalFileByServerInfo(fileArrayServer, fileArrayLocal, fileArrayServerCopy, storyId, "chapter");
            }
            if (storyServer.has("note")) {
                fileArrayServer = storyServer.getJSONArray("note");
                fileArrayLocal = storyLocal.getJSONArray("note");
                fileArrayServerCopy = storyServerCopy.getJSONArray("note");
                SyncHelper.updateLocalFileByServerInfo(fileArrayServer, fileArrayLocal, fileArrayServerCopy, storyId, "note");
            }
        }
    }

    private static void updateLocalFileByServerInfo(JSONArray fileArrayServer, JSONArray fileArrayLocal, JSONArray fileArrayServerCopy, String storyId, String fileType) {
        int no = fileArrayServer.length() + 10000;
        int i = 0;
        while (i < fileArrayServer.length()) {
            JSONObject fileServer = fileArrayServer.getJSONObject(i);
            String fileId = fileServer.getString("id");
            JSONObject fileCopy = SyncHelper.getObject(fileArrayServerCopy, fileId);
            String status = fileServer.getString("status");
            if (status.equals("newFromPC")) {
                SyncHelper.updateFile4NewFromPC(fileServer, fileArrayServerCopy);
            } else if (status.equals("newFromMobile")) {
                SyncHelper.updateFile4NewFromMobile(storyId, fileServer, fileCopy, fileType, no - i);
            } else if (status.equals("normal")) {
                JSONObject fileLocal = SyncHelper.getObject(fileArrayLocal, fileId);
                if (fileLocal == null) {
                    if (fileType.equals("chapter")) {
                        SyncHelper.createChapterFromServer(fileServer, storyId, false, no - i);
                    } else if (fileType.equals("note")) {
                        SyncHelper.createNoteFromServer(fileServer, storyId, false);
                    }
                } else {
                    SyncHelper.updateFile4Normal(fileServer, fileLocal);
                }
            } else if (status.equals("deleteFromPC")) {
                SyncHelper.updateFile4DeleteFromPC(fileServer, fileType);
            } else if (status.equals("deleteFromMobile")) {
                SyncHelper.updateFile4DeleteFromMobile(fileServer, fileArrayServerCopy, fileType);
            }
            ++i;
        }
    }

    private static void updateStory4DeleteFromPC(JSONObject storyServer) {
        String storyId = storyServer.getString("id");
        Element storyNode = ExplorerModelHelper.getElement(storyId);
        if (storyNode != null) {
            DeleteAction.deleteStory(storyNode);
        }
    }

    private static void updateStory4DeleteFromMobile(JSONObject storyServer, JSONArray storyArrayServerCopy) {
        String storyId = storyServer.getString("id");
        Element storyNode = ExplorerModelHelper.getElement(storyId);
        if (storyNode != null) {
            DeleteAction.deleteStory(storyNode);
        }
        SyncHelper.removeItem(storyArrayServerCopy, storyId);
    }

    private static void walkingLocalVersion(JSONArray storyArrayLocal, JSONArray storyArrayServer, JSONArray storyArrayServerCopy) {
        int i = 0;
        while (i < storyArrayLocal.length()) {
            JSONObject storyServerCopy;
            JSONObject storyLocal = storyArrayLocal.getJSONObject(i);
            String storyId = storyLocal.getString("id");
            JSONObject storyServer = SyncHelper.getObject(storyArrayServer, storyId);
            if (storyServer == null) {
                LocalVersionInfo.removeIsDirty(storyLocal);
                LocalVersionInfo.addStatus(storyLocal);
                storyArrayServerCopy.put((Object)storyLocal);
                storyServerCopy = SyncHelper.getObject(storyArrayServerCopy, storyId);
                SyncHelper.commitStoryAllFile(storyLocal, storyServerCopy, "content");
                SyncHelper.commitStoryAllFile(storyLocal, storyServerCopy, "note");
            } else {
                storyServerCopy = SyncHelper.getObject(storyArrayServerCopy, storyId);
                storyServerCopy.put("name", storyLocal.get("name"));
                SyncHelper.commitChangeFile(storyLocal, storyServer, storyServerCopy, "content");
                SyncHelper.commitChangeFile(storyLocal, storyServer, storyServerCopy, "note");
            }
            ++i;
        }
    }

    private static void commitChangeFile(JSONObject storyLocal, JSONObject storyServer, JSONObject storyServerCopy, String type) {
        if (!storyServer.has(type)) {
            storyServer.put(type, (Object)new JSONArray());
            storyServerCopy.put(type, (Object)new JSONArray());
        }
        JSONArray arrayLocal = storyLocal.getJSONArray(type);
        JSONArray arrayServer = storyServer.getJSONArray(type);
        JSONArray arrayServerCopy = storyServerCopy.getJSONArray(type);
        int i = 0;
        while (i < arrayLocal.length()) {
            Element fileNode;
            JSONObject fileLocal = arrayLocal.getJSONObject(i);
            String fileId = fileLocal.getString("id");
            JSONObject fileServer = SyncHelper.getObject(arrayServer, fileId);
            if (fileServer == null) {
                fileNode = ExplorerModelHelper.getElement(fileId);
                if (ServerVersionAndFile.commitFile(fileNode)) {
                    fileLocal.remove("isDirty");
                    fileLocal.put("status", (Object)"newFromPC");
                    fileLocal.put("version", (Object)fileNode.attributeValue("version"));
                    arrayServerCopy.put((Object)fileLocal);
                }
            } else if (fileLocal.getBoolean("isDirty")) {
                fileNode = ExplorerModelHelper.getElement(fileId);
                JSONObject fileServerCopy = SyncHelper.getObject(arrayServerCopy, fileId);
                if (ServerVersionAndFile.commitFile(fileNode)) {
                    fileServerCopy.put("version", (Object)fileNode.attributeValue("version"));
                }
                fileServerCopy.put("name", fileLocal.get("name"));
            }
            ++i;
        }
    }

    private static void commitStoryAllFile(JSONObject storyLocal, JSONObject storyServerCopy, String type) {
        JSONArray chapterArrayLocal = storyLocal.getJSONArray(type);
        JSONArray chapterArrayServerCopy = storyServerCopy.getJSONArray(type);
        int j = 0;
        while (j < chapterArrayLocal.length()) {
            JSONObject chapterObj = chapterArrayLocal.getJSONObject(j);
            String chapterId = chapterObj.getString("id");
            Element fileNode = ExplorerModelHelper.getElement(chapterId);
            if (ServerVersionAndFile.commitFile(fileNode)) {
                JSONObject chapterObjServerCopy = SyncHelper.getObject(chapterArrayServerCopy, chapterId);
                chapterObjServerCopy.put("version", (Object)fileNode.attributeValue("version"));
            }
            ++j;
        }
    }

    private static void coverLocalFileByServerFile(JSONObject fileObj) {
        String fileId = fileObj.getString("id");
        Element fileNode = ExplorerModelHelper.getElement(fileId);
        ExplorerModelHelper.updateElement(fileId, "name", fileObj.getString("name"));
        ExplorerModelHelper.updateElement(fileId, "version", fileObj.getString("version"));
        String text = ServerVersionAndFile.getFileContentFromServer(fileId);
        ExplorerModelHelper.updateElement(fileId, "wordCount", String.valueOf(ModelHelper.getWordCount(text)));
        IFile file = ModelHelper.getFileByName(fileNode.attributeValue("location"));
        Document doc = ModelHelper.getDocument(file);
        ModelHelper.setContent(doc, text);
        ModelHelper.saveDocument(doc, file);
    }

    private static void copyLocalFile(JSONObject fileObjLocal) {
        String fileId = fileObjLocal.getString("id");
        Element oldfileNode = ExplorerModelHelper.getElement(fileId);
        Element parentNode = oldfileNode.getParent();
        String newFileName = "\u5907\u4efd-" + fileObjLocal.getString("name");
        String newFileId = WJ.getNo();
        String parentLocation = parentNode.attributeValue("location");
        Element newFileNode = ExplorerModelHelper.createFileNode(parentLocation, oldfileNode.getName(), newFileName, newFileId);
        ExplorerModelHelper.insertElement(parentNode.attributeValue("id"), newFileNode);
        CreateNodeFileHelper.createFileNodeFile(newFileNode);
        IFile file = ModelHelper.getFileByName(newFileNode.attributeValue("location"));
        Document doc = ModelHelper.getDocument(file);
        ModelHelper.setContent(doc, ModelHelper.getContent(ModelHelper.getDocument(oldfileNode.attributeValue("location"))));
        ModelHelper.saveDocument(doc, file);
    }

    private static void createNoteFromServer(JSONObject fileObj, String storyId, boolean isCreateNew) {
        Element storyNode = ExplorerModelHelper.getElement(storyId);
        Element folderNode = storyNode.element("noteFolder");
        if (folderNode == null) {
            folderNode = ExplorerModelHelper.createFolderNode(storyNode.attributeValue("location"), "noteFolder", "\u7d20\u6750");
            ExplorerModelHelper.insertElement(storyId, folderNode);
            ModelHelper.createFolder(folderNode.attributeValue("location"));
        }
        String fileId = isCreateNew ? WJ.getNo() : fileObj.getString("id");
        String folderLocation = folderNode.attributeValue("location");
        Element noteNode = ExplorerModelHelper.createFileNode(folderLocation, "note", fileObj.getString("name"), fileId);
        ExplorerModelHelper.insertElement(folderNode.attributeValue("id"), noteNode);
        CreateNodeFileHelper.createFileNodeFile(noteNode);
        IFile file = ModelHelper.getFileByName(noteNode.attributeValue("location"));
        Document doc = ModelHelper.getDocument(file);
        ModelHelper.setContent(doc, ServerVersionAndFile.getFileContentFromServer(fileId));
        ModelHelper.saveDocument(doc, file);
    }

    private static void createChapterFromServer(JSONObject fileObj, String storyId, boolean isCreateNew, int no) {
        Element storyNode = ExplorerModelHelper.getElement(storyId);
        Element folderNode = storyNode.element("chapterFolder");
        if (folderNode == null) {
            folderNode = ExplorerModelHelper.createFolderNode(storyNode.attributeValue("location"), "chapterFolder", "\u7ae0\u8282");
            ExplorerModelHelper.insertElement(storyId, folderNode);
            ModelHelper.createFolder(folderNode.attributeValue("location"));
        }
        String fileId = isCreateNew ? WJ.getNo() : fileObj.getString("id");
        Element chapterNode = ExplorerModelHelper.createFileNode(folderNode.attributeValue("location"), "chapter", fileObj.getString("name"), fileId);
        chapterNode.attribute("isDirty").setValue("false");
        chapterNode.attribute("no").setValue(String.valueOf(no));
        String content = ServerVersionAndFile.getFileContentFromServer(fileId);
        chapterNode.attribute("wordCount").setValue(String.valueOf(ModelHelper.getWordCount(content)));
        ExplorerModelHelper.insertElement(folderNode.attributeValue("id"), chapterNode);
        CreateNodeFileHelper.createFileNodeFile(chapterNode);
        IFile file = ModelHelper.getFileByName(chapterNode.attributeValue("location"));
        Document doc = ModelHelper.getDocument(file);
        ModelHelper.setContent(doc, content);
        ModelHelper.saveDocument(doc, file);
    }

    private static void updateFile4NewFromPC(JSONObject fileServer, JSONArray fileArrayServerCopy) {
        String fileId = fileServer.getString("id");
        Element fileNode = ExplorerModelHelper.getElement(fileId);
        if (fileNode == null) {
            SyncHelper.removeItem(fileArrayServerCopy, fileId);
        }
    }

    private static void updateFile4NewFromMobile(String storyId, JSONObject fileServer, JSONObject fileServerCopy, String fileType, int no) {
        String fileId = fileServer.getString("id");
        Element fileNode = ExplorerModelHelper.getElement(fileId);
        if (fileNode == null) {
            if (fileType.equals("chapter")) {
                SyncHelper.createChapterFromServer(fileServer, storyId, false, no);
            } else if (fileType.equals("note")) {
                SyncHelper.createNoteFromServer(fileServer, storyId, false);
            }
        }
        fileServerCopy.put("status", (Object)"normal");
    }

    private static void updateFile4Normal(JSONObject fileServer, JSONObject fileLocal) {
        if (fileServer.getInt("version") > fileLocal.getInt("version")) {
            if (fileLocal.getBoolean("isDirty")) {
                SyncHelper.copyLocalFile(fileLocal);
            }
            SyncHelper.coverLocalFileByServerFile(fileServer);
        }
    }

    private static void updateFile4DeleteFromPC(JSONObject fileServer, String fileType) {
        String fileId = fileServer.getString("id");
        Element fileNode = ExplorerModelHelper.getElement(fileId);
        if (fileNode != null) {
            if (fileType.equals("chapter")) {
                DeleteAction.deleteChapter(fileNode);
            } else {
                DeleteAction.deleteSingleFile(fileNode);
            }
        }
    }

    private static void updateFile4DeleteFromMobile(JSONObject fileServer, JSONArray fileArrayServerCopy, String fileType) {
        String fileId = fileServer.getString("id");
        Element fileNode = ExplorerModelHelper.getElement(fileId);
        if (fileNode != null) {
            if (fileType.equals("chapter")) {
                DeleteAction.deleteChapter(fileNode);
            } else {
                DeleteAction.deleteSingleFile(fileNode);
            }
        }
        SyncHelper.removeItem(fileArrayServerCopy, fileId);
    }

    private static JSONObject getObject(JSONArray array, String id) {
        int i = 0;
        while (i < array.length()) {
            JSONObject obj = array.getJSONObject(i);
            if (obj.getString("id").equals(id)) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    private static void removeItem(JSONArray array, String id) {
        int i = 0;
        while (i < array.length()) {
            JSONObject obj = array.getJSONObject(i);
            if (obj.getString("id").equals(id)) {
                array.remove(i);
            }
            ++i;
        }
    }
}

