/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import wj.ap.util.ModelHelper;

public class InternetHelper {
    public static final String GET = "GET";
    public static final String POST = "POST";
    private static String host;
    public static final HttpClient httpClient;

    static {
        httpClient = HttpClients.createMinimal();
    }

    public static byte[] readInputStream(InputStream inStream) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        int len = 0;
        try {
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            inStream.close();
            return outStream.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static InputStream getInputStream(String urlStr, String method) {
        try {
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(GET);
            conn.setConnectTimeout(3000);
            return conn.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JSONObject getJsonObject4Get(String urlStr) {
        InputStream is = InternetHelper.getInputStream(urlStr, GET);
        if (is == null) {
            return null;
        }
        return new JSONObject(new String(InternetHelper.readInputStream(is)));
    }

    public static String getHost() {
        if (host == null) {
            host = ModelHelper.getDocument("version.xml").getRootElement().elementText("host");
        }
        return host;
    }

    public static String get(String url, List<BasicNameValuePair> params) {
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Charset.forName("UTF-8"));
        try {
            HttpGet get = new HttpGet(String.valueOf(url) + "?" + EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName("UTF-8")));
            String result = (String)httpClient.execute((HttpUriRequest)get, (ResponseHandler)new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    StatusLine statusLine = response.getStatusLine();
                    int code = statusLine.getStatusCode();
                    if (code == 200) {
                        return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
                    }
                    return null;
                }
            });
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }
}

