/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.util.BundleUtility;
import org.osgi.framework.Bundle;
import wj.ap.explorer.ExplorerModelHelper;

public class ModelHelper {
    public static String getContent(Document doc) {
        Element root = doc.getRootElement();
        String rootName = root.getName();
        if (rootName.equals("chapter") || rootName.equals("note") || rootName.equals("theme") || rootName.equals("role") || rootName.equals("scene") || rootName.equals("storyline")) {
            return root.elementText("description");
        }
        if (rootName.equals("roles") || rootName.equals("storylines") || rootName.equals("script")) {
            List roleList = root.elements();
            StringBuilder sb = new StringBuilder();
            char c = '\u0000';
            for (Element role : roleList) {
                sb.append(ModelHelper.getContent(ModelHelper.getDocument(role.attributeValue("location")))).append(c);
            }
            return sb.substring(0, sb.length() - 1);
        }
        return null;
    }

    public static void setContent(Document doc, String newContent) {
        Element root = doc.getRootElement();
        String rootName = root.getName();
        if (rootName.equals("chapter") || rootName.equals("note") || rootName.equals("theme") || rootName.equals("role") || rootName.equals("scene") || rootName.equals("storyline")) {
            root.element("description").setText(newContent);
        }
    }

    public static void copyPublicModelFile() {
        String sourceName = "resources" + File.separator + "explorer" + ".xml";
        String targetName = "explorer.xml";
        ModelHelper.creatModelFile(sourceName, targetName);
        sourceName = "resources" + File.separator + "status.properties";
        targetName = "search.properties";
        ModelHelper.creatModelFile(sourceName, targetName);
        targetName = "status.properties";
        ModelHelper.creatModelFile(sourceName, targetName);
        sourceName = "resources" + File.separator + "sceneTag.xml";
        targetName = "sceneTag.xml";
        ModelHelper.creatModelFile(sourceName, targetName);
        sourceName = "resources" + File.separator + "roleTag.xml";
        targetName = "roleTag.xml";
        ModelHelper.creatModelFile(sourceName, targetName);
        sourceName = "resources" + File.separator + "sensitiveWord.txt";
        targetName = "sensitiveWord.txt";
        ModelHelper.creatModelFile(sourceName, targetName);
        sourceName = "resources" + File.separator + "version.xml";
        targetName = "version.xml";
        ModelHelper.creatModelFile(sourceName, targetName);
    }

    public static void copyModelFile(String modelName, String targetFile, String id) {
        String sourceName = "resources" + File.separator + modelName + ".xml";
        IFile file = ModelHelper.creatModelFile(sourceName, targetFile);
        Element root = ModelHelper.getDocument(file).getRootElement();
        root.attribute("location").setValue(targetFile);
        root.attribute("id").setValue(id);
        ModelHelper.saveDocument(root.getDocument(), file);
        sourceName = "resources" + File.separator + "history.xml";
        targetFile = String.valueOf(ModelHelper.getAdditionFolder(file)) + File.separator + "history.xml";
        ModelHelper.creatModelFile(sourceName, targetFile);
        sourceName = "resources" + File.separator + "status.properties";
        targetFile = String.valueOf(ModelHelper.getAdditionFolder(file)) + File.separator + "status.properties";
        ModelHelper.creatModelFile(sourceName, targetFile);
    }

    public static void copyFileFromResources(String sourceFile, String targetFolder) {
        String sourceName = "resources" + File.separator + sourceFile;
        String targetFile = String.valueOf(targetFolder) + File.separator + sourceFile;
        ModelHelper.creatModelFile(sourceName, targetFile);
    }

    public static void refreshProject() {
        IProject targetProject = ResourcesPlugin.getWorkspace().getRoot().getProject("_root_");
        if (targetProject == null) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            targetProject.refreshLocal(2, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static IFolder createFolder(String folderName) {
        IProject project = ModelHelper.getProject();
        IFolder moduleFolder = project.getFolder(folderName);
        if (moduleFolder.exists()) {
            return moduleFolder;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            moduleFolder.create(true, true, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return moduleFolder;
    }

    public static IFile creatModelFile(String sourceFileName, String targetFileName) {
        InputStream stream = ModelHelper.getPluginFileInputStream(sourceFileName);
        IFile newFile = ModelHelper.getProject().getFile(targetFileName);
        ModelHelper.fillFile(newFile, stream);
        return newFile;
    }

    public static void fillFile(IFile file, InputStream stream) {
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (file.exists()) {
                file.setContents(stream, true, true, (IProgressMonitor)monitor);
            } else {
                IContainer container = file.getParent();
                if (!container.exists()) {
                    ModelHelper.getProject().getFolder(container.getProjectRelativePath()).create(true, true, (IProgressMonitor)monitor);
                }
                file.create(stream, true, (IProgressMonitor)monitor);
            }
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static Document getDocument(InputStream fileInput) {
        Document doc = null;
        try {
            SAXReader saxReader = new SAXReader();
            InputStreamReader ir = new InputStreamReader(fileInput, "UTF-8");
            doc = saxReader.read((Reader)ir);
            fileInput.close();
            fileInput = null;
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static Document getDocument(IFile file) {
        return ModelHelper.readAndWriteDocument(file, null, true);
    }

    public static Document getDocument(String fileName) {
        IFile file = ModelHelper.getProject().getFile(fileName);
        return ModelHelper.readAndWriteDocument(file, null, true);
    }

    public static void deleteFolder(String folderName) {
        IFolder folder = ModelHelper.getProject().getFolder(folderName);
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            folder.delete(true, false, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void deleteFile(String filePath) {
        IFile file = ModelHelper.getProject().getFile(filePath);
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            file.delete(true, true, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void saveDocument(Document doc, IFile file) {
        ModelHelper.saveFile(file, doc.asXML());
    }

    public static void saveFile(IFile iFile, String content) {
        ModelHelper.readAndWriteDocument(iFile, content, false);
    }

    public static InputStream getPluginFileInputStream(String filePath) {
        Bundle bundle = Platform.getBundle((String)"authorTools");
        URL url = BundleUtility.find((Bundle)bundle, (String)filePath);
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return is;
    }

    public static IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject("_root_");
    }

    public static IFile getFileByName(String file) {
        IProject project = ModelHelper.getProject();
        return project.getFile(file);
    }

    public static String getAdditionFolder(IFile modelFile) {
        return ModelHelper.getAdditionFolder(modelFile.getProjectRelativePath().toString());
    }

    public static String getAdditionFolder(String modelFilePath) {
        return String.valueOf(modelFilePath) + "_";
    }

    public static String convertStreamToString(InputStream is) {
        StringBuilder sb;
        block12: {
            sb = new StringBuilder();
            try {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        sb.append(String.valueOf(line) + "\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static void copyToClipboard(String text) {
        Clipboard cb = new Clipboard(Display.getCurrent());
        TextTransfer textTransfer = TextTransfer.getInstance();
        cb.setContents(new Object[]{text}, new Transfer[]{textTransfer});
    }

    public static List<String> getAllRoleName() {
        Element rootExplorerElement = ExplorerModelHelper.getElement(null);
        List storyList = rootExplorerElement.elements();
        ArrayList<String> roleNameList = new ArrayList<String>();
        for (Element story : storyList) {
            List folderList = story.elements();
            for (Element folder : folderList) {
                List fileList = folder.elements();
                for (Element file : fileList) {
                    if (!file.getName().equals("role")) continue;
                    String path = file.attributeValue("location");
                    roleNameList.addAll(ModelHelper.getRoleName4File(path));
                }
            }
        }
        return roleNameList;
    }

    public static List<String> getRoleName4File(String roleFilePath) {
        List<Element> roleList = ModelHelper.getRoleElements(roleFilePath);
        ArrayList<String> roleNameList = new ArrayList<String>(roleList.size());
        for (Element role : roleList) {
            Element roleRoot = ModelHelper.getDocument(role.attributeValue("location")).getRootElement();
            if (roleRoot.elementText("name").trim().equals("")) continue;
            roleNameList.add(roleRoot.elementText("name").trim());
        }
        return roleNameList;
    }

    public static List<Element> getRoleElements(String roleFilePath) {
        Element root = ModelHelper.getDocument(roleFilePath).getRootElement();
        List roleList = root.elements("role");
        ArrayList<Element> roleElementList = new ArrayList<Element>(roleList.size());
        for (Element role : roleList) {
            roleElementList.add(role);
        }
        return roleElementList;
    }

    public static void updateContent(Element root, String content, IFile file) {
        String time = String.valueOf(System.currentTimeMillis());
        if (root.attributeValue("createTime").equals("")) {
            root.attribute("createTime").setValue(time);
        }
        root.attribute("lastModifyTime").setValue(time);
        root.element("description").setText(content);
        ModelHelper.saveDocument(root.getDocument(), file);
    }

    public static int getWordCount(String text) {
        if ((text = text.replaceAll("//\\w*\n", "")).lastIndexOf("//") > -1) {
            text = text.substring(0, text.lastIndexOf("//"));
        }
        Pattern pattern = Pattern.compile("[a-zA-Z']+");
        Matcher matcher = pattern.matcher(text);
        int total = 0;
        while (matcher.find()) {
            ++total;
        }
        String english = "[a-zA-Z]";
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!Character.isWhitespace(c) && !String.valueOf(c).matches(english)) {
                ++total;
            }
            ++i;
        }
        return total;
    }

    public static Element getElement(List<Element> nodeList, String roleId) {
        for (Element node : nodeList) {
            if (!node.attributeValue("id").equals(roleId)) continue;
            return node;
        }
        return null;
    }

    public static void initVersionInfo() {
    }

    public static Element addElement(Element mom, Element son) {
        Element newElement = mom.addElement(son.getName());
        newElement.addText(son.getText());
        List attributes = son.attributes();
        for (Attribute attribute : attributes) {
            newElement.addAttribute(attribute.getName(), attribute.getText());
        }
        List sons = son.elements();
        for (Element element : sons) {
            ModelHelper.addElement(newElement, element);
        }
        return newElement;
    }

    public static synchronized Document readAndWriteDocument(IFile iFile, String content, boolean isRead) {
        if (isRead) {
            Document doc = null;
            try {
                SAXReader saxReader = new SAXReader();
                InputStreamReader ir = new InputStreamReader(iFile.getContents(true), "UTF-8");
                doc = saxReader.read((Reader)ir);
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return doc;
        }
        try {
            FileOutputStream os = new FileOutputStream(iFile.getRawLocationURI().getPath());
            byte[] contentByte = content.getBytes("utf-8");
            ((OutputStream)os).write(contentByte);
            ((OutputStream)os).close();
            iFile.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

