/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import wj.ap.util.ModelHelper;

public class StatusHelper {
    public static String getValue(String key) {
        String file = StatusHelper.getProjectStatusFilePath();
        Properties properties = StatusHelper.getProperties(file);
        return properties.getProperty(key);
    }

    public static void setValue(String key, String value) {
        String file = StatusHelper.getProjectStatusFilePath();
        Properties properties = StatusHelper.getProperties(file);
        properties.put(key, value);
        StatusHelper.saveProperties(properties, file);
    }

    private static String getProjectStatusFilePath() {
        String file = ModelHelper.getProject().getLocation().toOSString();
        file = String.valueOf(file) + File.separator + "status.properties";
        return file;
    }

    public static String getValue(IFile modelFile, String key) {
        String file = StatusHelper.getModelFileStatusFilePath(modelFile);
        Properties properties = StatusHelper.getProperties(file);
        return properties.getProperty(key);
    }

    public static void setValue(IFile modelFile, String key, String value) {
        String file = StatusHelper.getModelFileStatusFilePath(modelFile);
        Properties properties = StatusHelper.getProperties(file);
        properties.put(key, value);
        StatusHelper.saveProperties(properties, file);
    }

    private static String getModelFileStatusFilePath(IFile modelFile) {
        String file = ModelHelper.getProject().getLocation().toOSString();
        file = String.valueOf(file) + File.separator + ModelHelper.getAdditionFolder(modelFile) + File.separator + "status.properties";
        return file;
    }

    public static void saveProperties(Properties properties, String file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            properties.store(fos, "bookchao");
            ((OutputStream)fos).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Properties getProperties(String file) {
        Properties properties = new Properties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            properties.load(in);
            ((InputStream)in).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }
}

