/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.ui.IEditorPart;
import wj.ap.util.StatusHelper;

public class StatusLineItem4WordCount {
    private StatusLineContributionItem currCountItem;
    private StatusLineContributionItem planCountItem;
    private StatusLineContributionItem ratioItem;
    private StatusLineContributionItem createTimeItem;
    private IStatusLineManager statusLine;
    private float planWordCount;
    private float ratio = 0.0f;

    public StatusLineItem4WordCount(IEditorPart editorPart) {
        this.statusLine = editorPart.getEditorSite().getActionBars().getStatusLineManager();
        this.currCountItem = new StatusLineContributionItem("currCountItem", 20);
        this.planCountItem = new StatusLineContributionItem("planCountItem", 20);
        this.ratioItem = new StatusLineContributionItem("ratioItem", 20);
        this.createTimeItem = new StatusLineContributionItem("createTimeItem", 100);
        this.statusLine.removeAll();
        this.statusLine.add((IContributionItem)this.currCountItem);
        this.statusLine.add((IContributionItem)this.planCountItem);
        this.statusLine.add((IContributionItem)this.ratioItem);
        this.statusLine.add((IContributionItem)this.createTimeItem);
        this.currCountItem.setText("\u5f53\u524d\u5b57\u6570\uff1a0");
        this.currCountItem.setVisible(true);
        this.createTimeItem.setVisible(true);
        this.updatePlanWordCount();
    }

    private void updatePlanWordCount() {
        StatusHelper statusHelper = new StatusHelper();
        String isEnable = StatusHelper.getValue("wordCountEnable");
        if (isEnable == null) {
            isEnable = "true";
        }
        boolean b = Boolean.parseBoolean(isEnable);
        this.planCountItem.setVisible(b);
        this.ratioItem.setVisible(b);
        if (b) {
            String count = StatusHelper.getValue("wordCount");
            if (count == null) {
                count = "3000";
            }
            this.planCountItem.setText("\u8ba1\u5212\u5b57\u6570\uff1a" + count);
            this.planWordCount = Float.parseFloat(count);
            String currCount = this.currCountItem.getText().split("\uff1a")[1];
            this.ratio = Float.parseFloat(currCount) / this.planWordCount * 100.0f;
            this.setRatio(this.ratio);
            this.statusLine.update(true);
        }
    }

    public void setCurrWordCount(int count) {
        this.currCountItem.setText("\u5f53\u524d\u5b57\u6570\uff1a" + count);
        if (this.ratioItem.isVisible()) {
            this.ratio = (float)count / this.planWordCount;
            this.ratio *= 100.0f;
            this.setRatio(this.ratio);
        }
    }

    private void setRatio(float ratio) {
        String s = String.format("\u5b8c\u6210\u7387\uff1a%.2f", Float.valueOf(ratio));
        this.ratioItem.setText(String.valueOf(s) + "%");
        if (ratio > 100.0f) {
            this.statusLine.setErrorMessage("\t\u5f53\u524d\u5b57\u6570\u5df2\u7ecf\u8d85\u51fa\u8ba1\u5212\u5b57\u6570\u3002");
        } else {
            this.statusLine.setErrorMessage(null);
        }
    }

    public float getRatio() {
        return this.ratio;
    }

    public void setCreateTime(String createTime) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Long.parseLong(createTime));
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy.MM.dd HH:mm");
        String time = dateformat.format(c.getTime());
        this.createTimeItem.setText("\u521b\u5efa\u65f6\u95f4\uff1a" + time);
    }
}

