/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.util;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import wj.ap.sys.Activator;

public class TreeViewHelper {
    private Tree tree;
    private IAction collapseAllAction = new CollapseAllAction();
    private IAction expandByDayAction = new ExpandByDayAction();
    private IAction expandByHourAction = new ExpandByHourAction();
    private IAction expandByMinAction = new ExpandByMinAction();
    private IAction expandByTimeAction = new ExpandByTimeAction();

    public TreeViewHelper(Tree tree) {
        this.tree = tree;
    }

    public IAction getCollapseAction() {
        return this.collapseAllAction;
    }

    public IAction getCollapseAllAction() {
        return this.collapseAllAction;
    }

    public IAction getExpandByDayAction() {
        return this.expandByDayAction;
    }

    public IAction getExpandByHourAction() {
        return this.expandByHourAction;
    }

    public IAction getExpandByMinAction() {
        return this.expandByMinAction;
    }

    public IAction getExpandByTimeAction() {
        return this.expandByTimeAction;
    }

    private void collapse(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            items[i].setExpanded(false);
            if (items[i].getItemCount() > 0) {
                this.collapse(items[i].getItems());
            }
            ++i;
        }
    }

    private void expandByLevel(int level) {
        if (level > 1) {
            TreeItem[] items1 = this.tree.getItems();
            int i = 0;
            while (i < items1.length) {
                items1[i].setExpanded(true);
                if (level > 2) {
                    TreeItem[] items2 = items1[i].getItems();
                    int j = 0;
                    while (j < items2.length) {
                        items2[j].setExpanded(true);
                        if (level > 3) {
                            TreeItem[] items3 = items2[j].getItems();
                            int k = 0;
                            while (k < items3.length) {
                                items3[k].setExpanded(true);
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            this.setImageDescriptor(Activator.getImageDescriptor("icons/collapseall.gif"));
            this.setToolTipText("\u5168\u90e8\u6536\u8d77");
        }

        public void run() {
            TreeViewHelper.this.collapse(TreeViewHelper.this.tree.getItems());
        }
    }

    private class ExpandByDayAction
    extends Action {
        public ExpandByDayAction() {
            this.setText("\u5929");
            this.setToolTipText("\u6309\u5929\u663e\u793a");
        }

        public void run() {
            TreeViewHelper.this.collapse(TreeViewHelper.this.tree.getItems());
        }
    }

    private class ExpandByHourAction
    extends Action {
        public ExpandByHourAction() {
            this.setText("\u5c0f\u65f6");
            this.setToolTipText("\u6309\u5c0f\u65f6\u663e\u793a");
        }

        public void run() {
            TreeViewHelper.this.collapse(TreeViewHelper.this.tree.getItems());
            TreeViewHelper.this.expandByLevel(2);
        }
    }

    private class ExpandByMinAction
    extends Action {
        public ExpandByMinAction() {
            this.setText("\u5206\u949f");
            this.setToolTipText("\u6309\u5206\u949f\u663e\u793a");
        }

        public void run() {
            TreeViewHelper.this.collapse(TreeViewHelper.this.tree.getItems());
            TreeViewHelper.this.expandByLevel(3);
        }
    }

    private class ExpandByTimeAction
    extends Action {
        public ExpandByTimeAction() {
            this.setText("\u6b21\u6570");
            this.setToolTipText("\u6309\u6b21\u6570\u663e\u793a");
        }

        public void run() {
            TreeViewHelper.this.collapse(TreeViewHelper.this.tree.getItems());
            TreeViewHelper.this.expandByLevel(4);
        }
    }
}

