/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tika.parser.txt.CharsetDetector;
import org.apache.tika.parser.txt.CharsetMatch;
import org.dom4j.Element;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import wj.ap.explorer.FileEditorInput;
import wj.ap.file.editor.ChapterEditor;
import wj.ap.file.editor.ITextEditor;
import wj.ap.file.editor.NoteEditor;
import wj.ap.file.editor.RoleEditor;
import wj.ap.file.editor.ScriptEditor;
import wj.ap.file.editor.StorylineEditor;
import wj.ap.file.editor.ThemeEditor;
import wj.ap.sys.Activator;
import wj.ap.textviewer.KeywordsHelper;
import wj.ap.textviewer.TextConfiguation;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.StatusHelper;

public class WJ {
    public static final String EXPLORER = "explorer";
    public static final String ROOT_PROJECT = "_root_";
    public static final String EVENT_ROLE_SELECT_BY_NAME = "eventRoleSelectByName";
    public static final String EVENT_ROLE_MODIFY = "eventRoleModify";
    public static final String EVENT_ROLE_TAG_MODIFY = "eventRoleTagModify";
    public static final String EVENT_ROLE_CREATE = "eventRoleCreate";
    public static final String EVENT_SCENE_MODIFY = "eventSceneModify";
    public static final String EVENT_SCENE_TAG_MODIFY = "eventSceneTagModify";
    public static final String EVENT_SEARCH = "eventSearch";
    public static final String EVENT_NEXT = "eventNext";
    public static final String EVENT_SEARCH_REMOVE_ALL = "eventSearchRemoveAll";
    public static final String EVENT_RELOAD = "eventReload";
    public static final String EVENT_EXPLORER_DELETE = "eventDeleteExplorerNode";
    public static final String EVENT_SEARCH_RESULT = "eventSearchResult";
    public static final String EVENT_EXPLORER_ADD = "eventExplorerAdd";
    public static final String EVENT_CHANGE_NAME = "eventExplorerChange";
    public static final String EVENT_EXPLORER_SELECT = "eventExplorerSelect";
    public static final String EVENT_SYSTEM_CLOSE = "eventSystemClose";
    public static final String EVENT_SELECT_SEARCH_WORD = "eventSelectSearchWord";
    private static Map<String, String> nodeType2editorId = new HashMap<String, String>();
    public static final String PLUGIN_ID = "authorTools";
    private static int counter;
    private static int threshold;

    static {
        nodeType2editorId.put("chapter", ChapterEditor.class.getName());
        nodeType2editorId.put("theme", ThemeEditor.class.getName());
        nodeType2editorId.put("roles", RoleEditor.class.getName());
        nodeType2editorId.put("note", NoteEditor.class.getName());
        nodeType2editorId.put("storylines", StorylineEditor.class.getName());
        nodeType2editorId.put("script", ScriptEditor.class.getName());
        counter = 0;
        Calendar c = Calendar.getInstance();
        int minutesInYear = c.get(6) * (c.get(11) * 60 + c.get(12));
        counter = minutesInYear * 100;
        threshold = 35;
    }

    public static String getCurrTime4yyMMddHHmmss() {
        SimpleDateFormat dateformat = new SimpleDateFormat("yyMMddHHmmss");
        return dateformat.format(new Date());
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static IViewPart BroughtToTop(String viewName) {
        IViewPart view = WJ.getActivePage().findView(viewName);
        if (view == null) {
            try {
                IViewPart part = WJ.getActivePage().showView(viewName);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        } else {
            WJ.getActivePage().activate((IWorkbenchPart)view);
        }
        return view;
    }

    public static String getEditorId(String nodeType) {
        return nodeType2editorId.get(nodeType);
    }

    public static String getNo() {
        return String.valueOf(counter++);
    }

    public static boolean validateFileName(String name) {
        return name.indexOf(92) == -1 && name.indexOf(47) == -1 && name.indexOf(58) == -1 && name.indexOf(42) == -1 && name.indexOf(63) == -1 && name.indexOf(34) == -1 && name.indexOf(60) == -1 && name.indexOf(62) == -1 && name.indexOf(124) == -1;
    }

    public static List<Map.Entry<Element, Integer>> sortElement(List<Element> elementList) {
        HashMap<Element, Integer> map = new HashMap<Element, Integer>(elementList.size());
        for (Element element : elementList) {
            map.put(element, Integer.parseInt(element.attributeValue("number")));
        }
        ArrayList<Map.Entry<Element, Integer>> list = new ArrayList<Map.Entry<Element, Integer>>();
        list.addAll(map.entrySet());
        ValueComparator vc = new ValueComparator();
        Collections.sort(list, vc);
        return list;
    }

    public static String getContent4txt(String fileName) {
        StringBuilder sb = new StringBuilder();
        try {
            String encode = WJ.getEncode(new BufferedInputStream(new FileInputStream(fileName)), "");
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), encode));
            char[] buffer = new char[0x200000];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                sb.append(buffer, 0, n);
            }
            ((Reader)reader).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static void refreshKeywordsInEditor(KeywordsHelper keywordsHelper) {
        String toggle = StatusHelper.getValue("toggleKeyWord");
        if (toggle == null || toggle.equals("on")) {
            IEditorReference[] editors = WJ.getActivePage().getEditorReferences();
            int i = 0;
            while (i < editors.length) {
                if (editors[i].getEditor(false) instanceof ITextEditor) {
                    TextViewer textViewer = ((ITextEditor)editors[i].getEditor(false)).getTextViewer();
                    textViewer.unconfigure();
                    textViewer.configure(new TextConfiguation(keywordsHelper));
                }
                ++i;
            }
        }
    }

    public static String getSysPath() {
        String absolutePath = null;
        try {
            absolutePath = FileLocator.toFileURL((URL)Activator.getDefault().getBundle().getEntry("/")).toExternalForm();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return absolutePath;
    }

    public static Image getPluginImg(String modelName) {
        String filePath = null;
        filePath = "icons/" + modelName;
        try {
            URL u = new URL(Activator.getDefault().getBundle().getEntry("/"), filePath);
            return ImageDescriptor.createFromURL((URL)u).createImage();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getEncode(InputStream data, String url) throws IOException {
        CharsetDetector detector = new CharsetDetector();
        detector.setText(data);
        CharsetMatch match = detector.detect();
        if (match.getConfidence() > threshold) {
            return match.getName();
        }
        CharsetMatch[] matches = detector.detectAll();
        String tmp = WJ.getConfidenceEncode(matches, "GB");
        if (tmp == null && (tmp = WJ.getConfidenceEncode(matches, "UTF")) == null) {
            tmp = WJ.getConfidenceEncode(matches, "BIG");
        }
        if (tmp == null) {
            tmp = "GBK";
        }
        return tmp;
    }

    private static String getConfidenceEncode(CharsetMatch[] matches, String flag) {
        CharsetMatch[] charsetMatchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            CharsetMatch m = charsetMatchArray[n2];
            if (m.getName().toUpperCase().startsWith(flag)) {
                return m.getName();
            }
            ++n2;
        }
        return null;
    }

    public static void reload(String fileId) {
        IEditorReference[] ers = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < ers.length) {
            if (ers[i] instanceof ITextEditor) {
                try {
                    FileEditorInput input = (FileEditorInput)ers[i].getEditorInput();
                    if (input.getExplorerNode().attributeValue("id").equals(fileId)) {
                        ((ITextEditor)ers[i]).reload();
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private static class ValueComparator
    implements Comparator<Map.Entry<Element, Integer>> {
        private ValueComparator() {
        }

        @Override
        public int compare(Map.Entry<Element, Integer> mp1, Map.Entry<Element, Integer> mp2) {
            return mp1.getValue() - mp2.getValue();
        }
    }
}

