/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.util;

import java.util.HashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Node;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import wj.ap.sys.Activator;
import wj.ap.util.ModelHelper;

public class WidgterToNode4TagHelper {
    private Map<Control, Node> widgetToNodeHash;
    private Map<Node, Control> NodeToWidgetHash;
    private String modifyEvent;
    private ModifyTextListener modifyTextListener;
    private ComboListener comboListener;
    private CheckboxSelectionListener checkboxSelectionListener;
    private IFile file;
    private Document doc;

    public WidgterToNode4TagHelper(IFile file, Document doc, String modifyEvent) {
        this.file = file;
        this.doc = doc;
        this.modifyEvent = modifyEvent;
    }

    public Map<Control, Node> getWidgetNodeMap() {
        return this.widgetToNodeHash;
    }

    public void mapTextSave(Text text, Node node) {
        this.mapComposite((Control)text, node);
        text.addModifyListener((ModifyListener)this.getModifyTextListener());
    }

    public void mapComboSave(Combo combo, Node node) {
        this.mapComposite((Control)combo, node);
        combo.addModifyListener((ModifyListener)this.getComboListener());
        combo.addSelectionListener((SelectionListener)this.getComboListener());
    }

    public void mapCheckboxSave(Button checkbox, Node node) {
        this.mapComposite((Control)checkbox, node);
        checkbox.addSelectionListener((SelectionListener)this.getCheckboxSelectionListener());
    }

    public void mapRadioSave(Button radio, Node node) {
        this.mapCheckboxSave(radio, node);
    }

    private void mapComposite(Control widget, Node node) {
        if (widget == null || node == null) {
            return;
        }
        if (this.widgetToNodeHash == null) {
            this.widgetToNodeHash = new HashMap<Control, Node>();
        }
        if (this.NodeToWidgetHash == null) {
            this.NodeToWidgetHash = new HashMap<Node, Control>();
        }
        this.widgetToNodeHash.put(widget, node);
        this.NodeToWidgetHash.put(node, widget);
        widget = this.NodeToWidgetHash.get(node);
        if (widget instanceof Text) {
            ((Text)widget).setText(node.getText());
        } else if (widget instanceof Label) {
            ((Label)widget).setText(node.getText());
        } else if (widget instanceof Button) {
            ((Button)widget).setSelection(Boolean.parseBoolean(node.getText()));
        } else if (widget instanceof Combo) {
            Combo combo = (Combo)widget;
            String newText = node.getText();
            int selIndex = combo.getSelectionIndex();
            if (selIndex < 0 || !newText.equals(combo.getItem(selIndex))) {
                String[] items = combo.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(newText)) {
                        combo.select(i);
                        return;
                    }
                    ++i;
                }
            }
            combo.setText(newText);
        }
    }

    public void save() {
        ModelHelper.saveDocument(this.doc, this.file);
    }

    private CheckboxSelectionListener getCheckboxSelectionListener() {
        if (this.checkboxSelectionListener == null) {
            this.checkboxSelectionListener = new CheckboxSelectionListener();
        }
        return this.checkboxSelectionListener;
    }

    private ComboListener getComboListener() {
        if (this.comboListener == null) {
            this.comboListener = new ComboListener();
        }
        return this.comboListener;
    }

    private ModifyTextListener getModifyTextListener() {
        if (this.modifyTextListener == null) {
            this.modifyTextListener = new ModifyTextListener();
        }
        return this.modifyTextListener;
    }

    private class CheckboxSelectionListener
    implements SelectionListener {
        private CheckboxSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.getSource();
            Node node = (Node)WidgterToNode4TagHelper.this.widgetToNodeHash.get(button);
            node.setText(Boolean.toString(button.getSelection()));
            WidgterToNode4TagHelper.this.save();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class ComboListener
    implements SelectionListener,
    ModifyListener {
        private ComboListener() {
        }

        public void modifyText(ModifyEvent e) {
            Combo combo = (Combo)e.getSource();
            Node node = (Node)WidgterToNode4TagHelper.this.widgetToNodeHash.get(combo);
            node.setText(combo.getText());
            WidgterToNode4TagHelper.this.save();
        }

        public void widgetSelected(SelectionEvent e) {
            Combo combo = (Combo)e.getSource();
            Node node = (Node)WidgterToNode4TagHelper.this.widgetToNodeHash.get(combo);
            node.setText(combo.getItem(combo.getSelectionIndex()));
            WidgterToNode4TagHelper.this.save();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class ModifyTextListener
    implements ModifyListener {
        private ModifyTextListener() {
        }

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.getSource();
            Node node = (Node)WidgterToNode4TagHelper.this.widgetToNodeHash.get(text);
            node.setText(text.getText().trim());
            Activator.getDefault().invoke(WidgterToNode4TagHelper.this.modifyEvent, node);
            WidgterToNode4TagHelper.this.save();
        }
    }
}

