/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public abstract class DynamicWizard
extends Wizard {
    private List<IWizardPage> pages = new ArrayList<IWizardPage>();
    private Image defaultImage = null;
    private ImageDescriptor defaultImageDescriptor = JFaceResources.getImageRegistry().getDescriptor("org.eclipse.jface.wizard.Wizard.pageImage");
    private boolean forcePreviousAndNextButtons = false;

    protected DynamicWizard() {
    }

    public void addPage(IWizardPage page) {
        this.pages.add(page);
        page.setWizard((IWizard)this);
    }

    public boolean addPage(IWizardPage page, IWizardPage nextPage) {
        int i = 0;
        while (i < this.pages.size()) {
            if (this.pages.get(i) == nextPage) {
                return this.addPage(page, i);
            }
            ++i;
        }
        return false;
    }

    public boolean addPage(IWizardPage page, int location) {
        if (location < 0 || location > this.pages.size()) {
            return false;
        }
        ArrayList<IWizardPage> newPages = new ArrayList<IWizardPage>();
        int i = 0;
        while (i < location) {
            newPages.add(this.pages.get(i));
            ++i;
        }
        page.setWizard((IWizard)this);
        newPages.add(page);
        i = location;
        while (i < this.pages.size()) {
            newPages.add(this.pages.get(i));
            ++i;
        }
        if (location != this.pages.size()) {
            ((IWizardPage)newPages.get(location + 1)).setPreviousPage(page);
        }
        page.setPreviousPage((IWizardPage)newPages.get(location - 1));
        this.pages = newPages;
        return true;
    }

    public void removePage(int number) {
        if (number < 0) {
            return;
        }
        if (number > this.pages.size() - 1) {
            return;
        }
        if (number == 0) {
            this.pages.remove(0);
        } else if (number == this.pages.size() - 1) {
            this.pages.remove(number);
        } else {
            IWizardPage wizarPage = this.pages.get(number + 1);
            wizarPage.setPreviousPage(this.pages.get(number - 1));
            this.pages.remove(number);
        }
    }

    public void removePage(IWizardPage page) {
        int number = -1;
        int i = 0;
        while (i < this.pages.size()) {
            if (this.pages.get(i) == page) {
                number = i;
            }
            ++i;
        }
        this.removePage(number);
    }

    public void removePage(String className) {
        int i = 0;
        while (i < this.pages.size()) {
            if (this.pages.get(i).getClass().getCanonicalName().equalsIgnoreCase(className)) {
                this.removePage(i);
            }
            ++i;
        }
    }

    public boolean canFinish() {
        int i = 0;
        while (i < this.pages.size()) {
            if (!this.pages.get(i).isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void createPageControls(Composite pageContainer) {
        int i = 0;
        while (i < this.pages.size()) {
            IWizardPage page = this.pages.get(i);
            page.createControl(pageContainer);
            Assert.isNotNull((Object)page.getControl(), (String)"getControl() of wizard page returns null. Did you call setControl() in your wizard page?");
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.pages.size()) {
            try {
                this.pages.get(i).dispose();
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.jface", 4, e.getMessage(), (Throwable)e);
                Policy.getLog().log((IStatus)status);
            }
            ++i;
        }
        if (this.defaultImage != null) {
            JFaceResources.getResources().destroyImage(this.defaultImageDescriptor);
            this.defaultImage = null;
        }
    }

    public Image getDefaultPageImage() {
        if (this.defaultImage == null) {
            this.defaultImage = JFaceResources.getResources().createImageWithDefault(this.defaultImageDescriptor);
        }
        return this.defaultImage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == this.pages.size() - 1 || index == -1) {
            return null;
        }
        return this.pages.get(index + 1);
    }

    public IWizardPage getPage(String name) {
        int i = 0;
        while (i < this.pages.size()) {
            IWizardPage page = this.pages.get(i);
            String pageName = page.getName();
            if (pageName.equals(name)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public IWizardPage[] getPages() {
        return this.pages.toArray(new IWizardPage[this.pages.size()]);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == 0 || index == -1) {
            return null;
        }
        return this.pages.get(index - 1);
    }

    public IWizardPage getStartingPage() {
        if (this.pages.size() == 0) {
            return null;
        }
        return this.pages.get(0);
    }

    public boolean needsPreviousAndNextButtons() {
        return this.forcePreviousAndNextButtons || this.pages.size() > 1;
    }

    public void setForcePreviousAndNextButtons(boolean b) {
        this.forcePreviousAndNextButtons = b;
    }

    public abstract boolean performFinish();

    public void setDefaultPageImageDescriptor(ImageDescriptor imageDescriptor) {
        this.defaultImageDescriptor = imageDescriptor;
    }
}

