/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.ui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class StatusBar
extends JPanel
implements ActionListener,
MouseListener {
    private static final int PROGRESS_MAX = 100;
    private static final int PROGRESS_MIN = 0;
    private JLabel label;
    private Dimension preferredSize;
    private JProgressBar progressBar;
    private Timer timer;
    private boolean forward;
    private static StatusBar statusBar;

    public StatusBar() {
        this.setLayout(new FlowLayout(0));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.progressBar = new JProgressBar(0, 0, 100);
        this.progressBar.setPreferredSize(new Dimension(60, this.progressBar.getPreferredSize().height + 2));
        this.progressBar.setVisible(false);
        this.label = new JLabel("                                                                                        ");
        this.preferredSize = new Dimension(this.getWidth(this.label.getText()), 2 * this.getFontHeight());
        this.add(this.progressBar);
        this.add(this.label);
    }

    public static StatusBar getInstance() {
        if (statusBar == null) {
            statusBar = new StatusBar();
        }
        return statusBar;
    }

    public static void setInstance(StatusBar sb) {
        statusBar = sb;
    }

    protected int getWidth(String s) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm == null) {
            return 0;
        }
        return fm.stringWidth(s);
    }

    protected int getFontHeight() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm == null) {
            return 0;
        }
        return fm.getHeight();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void setMessage(String message) {
        this.label.setText(message);
        this.label.repaint();
    }

    public void startBusyBar() {
        this.forward = true;
        if (this.timer == null) {
            this.setMessage("");
            this.progressBar.setVisible(true);
            this.timer = new Timer(15, this);
            this.timer.start();
        }
    }

    public void stopBusyBar() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.setMessage("");
        this.progressBar.setVisible(false);
        this.progressBar.setValue(0);
    }

    public void actionPerformed(ActionEvent evt) {
        int value = this.progressBar.getValue();
        if (this.forward) {
            if (value < 100) {
                this.progressBar.setValue(value + 1);
            } else {
                this.forward = false;
                this.progressBar.setValue(value - 1);
            }
        } else if (value > 0) {
            this.progressBar.setValue(value - 1);
        } else {
            this.forward = true;
            this.progressBar.setValue(value + 1);
        }
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mousePressed(MouseEvent mouseevent) {
    }

    public void mouseReleased(MouseEvent mouseevent) {
    }

    public void mouseExited(MouseEvent evt) {
        this.setMessage("");
    }

    public void mouseEntered(MouseEvent evt) {
        AbstractButton button;
        Action action;
        if (evt.getSource() instanceof AbstractButton && (action = (button = (AbstractButton)evt.getSource()).getAction()) != null) {
            String message = (String)action.getValue("LongDescription");
            this.setMessage(message);
        }
    }
}

