/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.ppc;

import sun.jvm.hotspot.asm.ppc.PPCRegister;

public class PPCRegisters {
    public static final int NUM_REGISTERS = 40;
    public static final PPCRegister PC = new PPCRegister(0);
    public static final PPCRegister PS = new PPCRegister(1);
    public static final PPCRegister R0 = new PPCRegister(2);
    public static final PPCRegister R1 = new PPCRegister(3);
    public static final PPCRegister R2 = new PPCRegister(4);
    public static final PPCRegister R3 = new PPCRegister(5);
    public static final PPCRegister R4 = new PPCRegister(6);
    public static final PPCRegister R5 = new PPCRegister(7);
    public static final PPCRegister R6 = new PPCRegister(8);
    public static final PPCRegister R7 = new PPCRegister(9);
    public static final PPCRegister R8 = new PPCRegister(10);
    public static final PPCRegister R9 = new PPCRegister(11);
    public static final PPCRegister R10 = new PPCRegister(12);
    public static final PPCRegister R11 = new PPCRegister(13);
    public static final PPCRegister R12 = new PPCRegister(14);
    public static final PPCRegister R13 = new PPCRegister(15);
    public static final PPCRegister R14 = new PPCRegister(16);
    public static final PPCRegister R15 = new PPCRegister(17);
    public static final PPCRegister R16 = new PPCRegister(18);
    public static final PPCRegister R17 = new PPCRegister(19);
    public static final PPCRegister R18 = new PPCRegister(20);
    public static final PPCRegister R19 = new PPCRegister(21);
    public static final PPCRegister R20 = new PPCRegister(22);
    public static final PPCRegister R21 = new PPCRegister(23);
    public static final PPCRegister R22 = new PPCRegister(24);
    public static final PPCRegister R23 = new PPCRegister(25);
    public static final PPCRegister R24 = new PPCRegister(26);
    public static final PPCRegister R25 = new PPCRegister(27);
    public static final PPCRegister R26 = new PPCRegister(28);
    public static final PPCRegister R27 = new PPCRegister(29);
    public static final PPCRegister R28 = new PPCRegister(30);
    public static final PPCRegister R29 = new PPCRegister(31);
    public static final PPCRegister R30 = new PPCRegister(32);
    public static final PPCRegister R31 = new PPCRegister(33);
    public static final PPCRegister CR = new PPCRegister(34);
    public static final PPCRegister LR = new PPCRegister(35);
    public static final PPCRegister CTR = new PPCRegister(36);
    public static final PPCRegister XER = new PPCRegister(37);
    public static final PPCRegister MQ = new PPCRegister(38);
    public static final PPCRegister VRSAVE = new PPCRegister(39);
    private static String[] registerNames = new String[40];

    public static int getNumberOfRegisters() {
        return 40;
    }

    public static String getRegisterName(int regNum) {
        return registerNames[regNum];
    }

    static {
        PPCRegisters.registerNames[PPCRegisters.PC.getNumber()] = "PC";
        PPCRegisters.registerNames[PPCRegisters.PS.getNumber()] = "PS";
        for (int i = R0.getNumber(); i <= R31.getNumber(); ++i) {
            PPCRegisters.registerNames[i] = "R" + i;
        }
        PPCRegisters.registerNames[PPCRegisters.CR.getNumber()] = "CR";
        PPCRegisters.registerNames[PPCRegisters.LR.getNumber()] = "LR";
        PPCRegisters.registerNames[PPCRegisters.CTR.getNumber()] = "CTR";
        PPCRegisters.registerNames[PPCRegisters.XER.getNumber()] = "XER";
        PPCRegisters.registerNames[PPCRegisters.MQ.getNumber()] = "MQ";
        PPCRegisters.registerNames[PPCRegisters.VRSAVE.getNumber()] = "VRSAVE";
    }
}

