/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger;

import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.DebuggerUtilities;
import sun.jvm.hotspot.debugger.MachineDescription;
import sun.jvm.hotspot.debugger.Page;
import sun.jvm.hotspot.debugger.PageCache;
import sun.jvm.hotspot.debugger.PageFetcher;
import sun.jvm.hotspot.debugger.ReadResult;
import sun.jvm.hotspot.debugger.UnalignedAddressException;
import sun.jvm.hotspot.debugger.UnmappedAddressException;

public abstract class DebuggerBase
implements Debugger {
    protected MachineDescription machDesc;
    protected DebuggerUtilities utils;
    protected long jbooleanSize;
    protected long jbyteSize;
    protected long jcharSize;
    protected long jdoubleSize;
    protected long jfloatSize;
    protected long jintSize;
    protected long jlongSize;
    protected long jshortSize;
    protected boolean javaPrimitiveTypesConfigured;
    protected long oopSize;
    protected long heapOopSize;
    protected long narrowOopBase;
    protected int narrowOopShift;
    private PageCache cache;
    private boolean useFastAccessors;
    private boolean bigEndian;

    protected DebuggerBase() {
    }

    public void configureJavaPrimitiveTypeSizes(long jbooleanSize, long jbyteSize, long jcharSize, long jdoubleSize, long jfloatSize, long jintSize, long jlongSize, long jshortSize) {
        this.jbooleanSize = jbooleanSize;
        this.jbyteSize = jbyteSize;
        this.jcharSize = jcharSize;
        this.jdoubleSize = jdoubleSize;
        this.jfloatSize = jfloatSize;
        this.jintSize = jintSize;
        this.jlongSize = jlongSize;
        this.jshortSize = jshortSize;
        if (jbooleanSize < 1L) {
            throw new RuntimeException("jboolean size is too small");
        }
        if (jbyteSize < 1L) {
            throw new RuntimeException("jbyte size is too small");
        }
        if (jcharSize < 2L) {
            throw new RuntimeException("jchar size is too small");
        }
        if (jdoubleSize < 8L) {
            throw new RuntimeException("jdouble size is too small");
        }
        if (jfloatSize < 4L) {
            throw new RuntimeException("jfloat size is too small");
        }
        if (jintSize < 4L) {
            throw new RuntimeException("jint size is too small");
        }
        if (jlongSize < 8L) {
            throw new RuntimeException("jlong size is too small");
        }
        if (jshortSize < 2L) {
            throw new RuntimeException("jshort size is too small");
        }
        if (jintSize != jfloatSize) {
            throw new RuntimeException("jint size and jfloat size must be equal");
        }
        if (jlongSize != jdoubleSize) {
            throw new RuntimeException("jlong size and jdouble size must be equal");
        }
        this.useFastAccessors = false;
        this.javaPrimitiveTypesConfigured = true;
    }

    public void putHeapConst(long heapOopSize, long narrowOopBase, int narrowOopShift) {
        this.heapOopSize = heapOopSize;
        this.narrowOopBase = narrowOopBase;
        this.narrowOopShift = narrowOopShift;
    }

    protected final void initCache(long pageSize, long maxNumPages) {
        this.cache = new PageCache(pageSize, maxNumPages, new Fetcher());
        if (this.machDesc != null) {
            this.bigEndian = this.machDesc.isBigEndian();
        }
    }

    protected final void setBigEndian(boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    protected final void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    protected final void disableCache() {
        if (this.cache != null) {
            this.cache.disable();
        }
    }

    protected final void enableCache() {
        if (this.cache != null) {
            this.cache.enable();
        }
    }

    protected final byte[] readBytes(long address, long numBytes) throws UnmappedAddressException, DebuggerException {
        if (this.cache != null) {
            return this.cache.getData(address, numBytes);
        }
        ReadResult res = this.readBytesFromProcess(address, numBytes);
        if (res.getData() != null) {
            return res.getData();
        }
        throw new UnmappedAddressException(res.getFailureAddress());
    }

    protected final void writeBytes(long address, long numBytes, byte[] data) throws UnmappedAddressException, DebuggerException {
        if (this.cache != null) {
            this.cache.clear(address, numBytes);
        }
        this.writeBytesToProcess(address, numBytes, data);
    }

    public boolean readJBoolean(long address) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jbooleanSize);
        if (this.useFastAccessors) {
            return this.cache.getByte(address) != 0;
        }
        byte[] data = this.readBytes(address, this.jbooleanSize);
        return this.utils.dataToJBoolean(data, this.jbooleanSize);
    }

    public byte readJByte(long address) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jbyteSize);
        if (this.useFastAccessors) {
            return this.cache.getByte(address);
        }
        byte[] data = this.readBytes(address, this.jbyteSize);
        return this.utils.dataToJByte(data, this.jbyteSize);
    }

    public char readJChar(long address) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jcharSize);
        if (this.useFastAccessors) {
            return this.cache.getChar(address, this.bigEndian);
        }
        byte[] data = this.readBytes(address, this.jcharSize);
        return this.utils.dataToJChar(data, this.jcharSize);
    }

    public double readJDouble(long address) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jdoubleSize);
        if (this.useFastAccessors) {
            return this.cache.getDouble(address, this.bigEndian);
        }
        byte[] data = this.readBytes(address, this.jdoubleSize);
        return this.utils.dataToJDouble(data, this.jdoubleSize);
    }

    public float readJFloat(long address) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jfloatSize);
        if (this.useFastAccessors) {
            return this.cache.getFloat(address, this.bigEndian);
        }
        byte[] data = this.readBytes(address, this.jfloatSize);
        return this.utils.dataToJFloat(data, this.jfloatSize);
    }

    public int readJInt(long address) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jintSize);
        if (this.useFastAccessors) {
            return this.cache.getInt(address, this.bigEndian);
        }
        byte[] data = this.readBytes(address, this.jintSize);
        return this.utils.dataToJInt(data, this.jintSize);
    }

    public long readJLong(long address) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jlongSize);
        if (this.useFastAccessors) {
            return this.cache.getLong(address, this.bigEndian);
        }
        byte[] data = this.readBytes(address, this.jlongSize);
        return this.utils.dataToJLong(data, this.jlongSize);
    }

    public short readJShort(long address) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jshortSize);
        if (this.useFastAccessors) {
            return this.cache.getShort(address, this.bigEndian);
        }
        byte[] data = this.readBytes(address, this.jshortSize);
        return this.utils.dataToJShort(data, this.jshortSize);
    }

    public long readCInteger(long address, long numBytes, boolean isUnsigned) throws UnmappedAddressException, UnalignedAddressException {
        this.checkConfigured();
        this.utils.checkAlignment(address, numBytes);
        if (this.useFastAccessors) {
            if (isUnsigned) {
                switch ((int)numBytes) {
                    case 1: {
                        return this.cache.getByte(address) & 0xFF;
                    }
                    case 2: {
                        return this.cache.getShort(address, this.bigEndian) & 0xFFFF;
                    }
                    case 4: {
                        return (long)this.cache.getInt(address, this.bigEndian) & 0xFFFFFFFFL;
                    }
                    case 8: {
                        return this.cache.getLong(address, this.bigEndian);
                    }
                }
                byte[] data = this.readBytes(address, numBytes);
                return this.utils.dataToCInteger(data, isUnsigned);
            }
            switch ((int)numBytes) {
                case 1: {
                    return this.cache.getByte(address);
                }
                case 2: {
                    return this.cache.getShort(address, this.bigEndian);
                }
                case 4: {
                    return this.cache.getInt(address, this.bigEndian);
                }
                case 8: {
                    return this.cache.getLong(address, this.bigEndian);
                }
            }
            byte[] data = this.readBytes(address, numBytes);
            return this.utils.dataToCInteger(data, isUnsigned);
        }
        byte[] data = this.readBytes(address, numBytes);
        return this.utils.dataToCInteger(data, isUnsigned);
    }

    public void writeJBoolean(long address, boolean value) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jbooleanSize);
        byte[] data = this.utils.jbooleanToData(value);
        this.writeBytes(address, this.jbooleanSize, data);
    }

    public void writeJByte(long address, byte value) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jbyteSize);
        byte[] data = this.utils.jbyteToData(value);
        this.writeBytes(address, this.jbyteSize, data);
    }

    public void writeJChar(long address, char value) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jcharSize);
        byte[] data = this.utils.jcharToData(value);
        this.writeBytes(address, this.jcharSize, data);
    }

    public void writeJDouble(long address, double value) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jdoubleSize);
        byte[] data = this.utils.jdoubleToData(value);
        this.writeBytes(address, this.jdoubleSize, data);
    }

    public void writeJFloat(long address, float value) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jfloatSize);
        byte[] data = this.utils.jfloatToData(value);
        this.writeBytes(address, this.jfloatSize, data);
    }

    public void writeJInt(long address, int value) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jintSize);
        byte[] data = this.utils.jintToData(value);
        this.writeBytes(address, this.jintSize, data);
    }

    public void writeJLong(long address, long value) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jlongSize);
        byte[] data = this.utils.jlongToData(value);
        this.writeBytes(address, this.jlongSize, data);
    }

    public void writeJShort(long address, short value) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jshortSize);
        byte[] data = this.utils.jshortToData(value);
        this.writeBytes(address, this.jshortSize, data);
    }

    public void writeCInteger(long address, long numBytes, long value) throws UnmappedAddressException, UnalignedAddressException {
        this.checkConfigured();
        this.utils.checkAlignment(address, numBytes);
        byte[] data = this.utils.cIntegerToData(numBytes, value);
        this.writeBytes(address, numBytes, data);
    }

    protected long readAddressValue(long address) throws UnmappedAddressException, UnalignedAddressException {
        return this.readCInteger(address, this.machDesc.getAddressSize(), true);
    }

    protected long readCompOopAddressValue(long address) throws UnmappedAddressException, UnalignedAddressException {
        long value = this.readCInteger(address, this.getHeapOopSize(), true);
        if (value != 0L) {
            value = this.narrowOopBase + (value << this.narrowOopShift);
        }
        return value;
    }

    protected void writeAddressValue(long address, long value) throws UnmappedAddressException, UnalignedAddressException {
        this.writeCInteger(address, this.machDesc.getAddressSize(), value);
    }

    protected final void checkConfigured() {
        if (this.machDesc == null) {
            throw new RuntimeException("MachineDescription must have been set by this point");
        }
        if (this.utils == null) {
            throw new RuntimeException("DebuggerUtilities must have been set by this point");
        }
    }

    protected final void checkJavaConfigured() {
        this.checkConfigured();
        if (!this.javaPrimitiveTypesConfigured) {
            throw new RuntimeException("Java primitive type sizes have not yet been configured");
        }
    }

    protected int parseCacheNumPagesProperty(int defaultNum) {
        String cacheNumPagesString = System.getProperty("cacheNumPages");
        if (cacheNumPagesString != null) {
            try {
                return Integer.parseInt(cacheNumPagesString);
            }
            catch (Exception e) {
                System.err.println("Error parsing cacheNumPages property:");
                e.printStackTrace();
            }
        }
        return defaultNum;
    }

    protected void invalidatePageCache(long startAddress, long numBytes) {
        this.cache.clear(startAddress, numBytes);
    }

    public long getJBooleanSize() {
        return this.jbooleanSize;
    }

    public long getJByteSize() {
        return this.jbyteSize;
    }

    public long getJCharSize() {
        return this.jcharSize;
    }

    public long getJDoubleSize() {
        return this.jdoubleSize;
    }

    public long getJFloatSize() {
        return this.jfloatSize;
    }

    public long getJIntSize() {
        return this.jintSize;
    }

    public long getJLongSize() {
        return this.jlongSize;
    }

    public long getJShortSize() {
        return this.jshortSize;
    }

    public long getHeapOopSize() {
        return this.heapOopSize;
    }

    public long getNarrowOopBase() {
        return this.narrowOopBase;
    }

    public int getNarrowOopShift() {
        return this.narrowOopShift;
    }

    class Fetcher
    implements PageFetcher {
        Fetcher() {
        }

        public Page fetchPage(long pageBaseAddress, long numBytes) {
            ReadResult res = DebuggerBase.this.readBytesFromProcess(pageBaseAddress, numBytes);
            if (res.getData() == null) {
                return new Page(pageBaseAddress, numBytes);
            }
            return new Page(pageBaseAddress, res.getData());
        }
    }
}

