/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic.ppc;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCFrame;
import sun.jvm.hotspot.debugger.macosx.MacOSXDebugger;
import sun.jvm.hotspot.runtime.VM;

public class PPCCFrame
extends BasicCFrame {
    private static final long ADDRESS_SIZE = VM.getVM().getAddressSize();
    private static final int RETURN_ADDR_OFFSET = 2;
    private Address pc;
    private Address sp;
    private MacOSXDebugger dbg;

    public PPCCFrame(MacOSXDebugger dbg, Address sp, Address pc) {
        super(dbg.getCDebugger());
        this.sp = sp;
        this.pc = pc;
        this.dbg = dbg;
    }

    public CFrame sender(ThreadProxy th) {
        if (this.sp == null) {
            return null;
        }
        Address nextSP = this.sp.getAddressAt(0L * ADDRESS_SIZE);
        if (nextSP == null) {
            return null;
        }
        Address nextPC = nextSP.addOffsetTo(2L * VM.getVM().getAddressSize()).getAddressAt(0L);
        if (nextPC == null) {
            return null;
        }
        return new PPCCFrame(this.dbg, nextSP, nextPC);
    }

    public Address pc() {
        return this.pc;
    }

    public Address localVariableBase() {
        return this.sp;
    }
}

