/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.macosx;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import sun.jvm.hotspot.debugger.DebuggerException;

public class DylibSymbolTable {
    private static final boolean DEBUG = false;
    Map symbolToAddrMap;

    private DylibSymbolTable(Map map) {
        this.symbolToAddrMap = map;
    }

    public static DylibSymbolTable buildSymbolTable(String dylibFilename) throws DebuggerException {
        BufferedReader nmOutput;
        Process nmProcess;
        String cmdString;
        HashMap<String, Long> nmMap = new HashMap<String, Long>();
        if (dylibFilename.charAt(0) != '/' || !dylibFilename.toLowerCase().endsWith(".dylib")) {
            throw new DebuggerException("Filename " + dylibFilename + " doesn't look like a dylib");
        }
        File dylibFile = new File(dylibFilename);
        if (!dylibFile.canRead()) {
            throw new DebuggerException("Can't read dylib file " + dylibFilename);
        }
        File nmBinary = new File("/usr/bin/nm");
        if (!nmBinary.canRead()) {
            throw new DebuggerException("Can't find nm program");
        }
        try {
            cmdString = "/usr/bin/nm " + dylibFilename;
            nmProcess = Runtime.getRuntime().exec(cmdString);
            nmOutput = new BufferedReader(new InputStreamReader(nmProcess.getInputStream()));
        }
        catch (Exception e) {
            throw new DebuggerException(e.toString());
        }
        while (true) {
            String line;
            try {
                line = nmOutput.readLine();
                if (line == null) {
                    break;
                }
            }
            catch (IOException e) {
                throw new DebuggerException("Error reading nm output:\n" + e.toString());
            }
            try {
                if (line.length() <= 0 || "0123456789abcdef".indexOf(line.charAt(0)) == -1) continue;
                String pcHexString = line.substring(0, 8);
                String symbolName = line.substring(11);
                if (symbolName.charAt(0) == '_') {
                    symbolName = symbolName.substring(1);
                }
                Long pc = new Long(Long.parseLong(pcHexString, 16));
                nmMap.put(symbolName, pc);
            }
            catch (Exception e) {
                throw new DebuggerException("Error reading nm output line:\n" + line + "\n" + e.toString());
            }
        }
        try {
            nmOutput.close();
            if (nmProcess.waitFor() != 0) {
                throw new DebuggerException("Executing of nm failed:\n" + cmdString);
            }
        }
        catch (InterruptedException e) {
            throw new DebuggerException("Error waiting for nm to die " + e.toString());
        }
        catch (IOException e) {
            throw new DebuggerException(e.toString());
        }
        return new DylibSymbolTable(nmMap);
    }

    public long lookup(String symbol) {
        if (this.symbolToAddrMap == null) {
            throw new RuntimeException("Incorrectly built DylibSymbolTable");
        }
        if (!this.symbolToAddrMap.containsKey(symbol)) {
            return 0L;
        }
        Long result = (Long)this.symbolToAddrMap.get(symbol);
        return result;
    }
}

