/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.macosx;

import java.io.File;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.amd64.AMD64ThreadContext;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;
import sun.jvm.hotspot.debugger.cdbg.ProcessControl;
import sun.jvm.hotspot.debugger.cdbg.basic.amd64.AMD64CFrame;
import sun.jvm.hotspot.debugger.cdbg.basic.ppc.PPCCFrame;
import sun.jvm.hotspot.debugger.cdbg.basic.x86.X86CFrame;
import sun.jvm.hotspot.debugger.macosx.MacOSXDebugger;
import sun.jvm.hotspot.debugger.ppc.PPCThreadContext;
import sun.jvm.hotspot.debugger.x86.X86ThreadContext;

class MacOSXCDebugger
implements CDebugger {
    private MacOSXDebugger dbg;

    MacOSXCDebugger(MacOSXDebugger dbg) {
        this.dbg = dbg;
    }

    public List getThreadList() throws DebuggerException {
        return this.dbg.getThreadList();
    }

    public List getLoadObjectList() throws DebuggerException {
        return this.dbg.getLoadObjectList();
    }

    public LoadObject loadObjectContainingPC(Address pc) throws DebuggerException {
        if (pc == null) {
            return null;
        }
        List objs = this.getLoadObjectList();
        Object[] arr = objs.toArray();
        int mid = -1;
        int low = 0;
        int high = arr.length - 1;
        while (low <= high) {
            mid = low + high >> 1;
            LoadObject midVal = (LoadObject)arr[mid];
            long cmp = pc.minus(midVal.getBase());
            if (cmp < 0L) {
                high = mid - 1;
                continue;
            }
            if (cmp > 0L) {
                long size = midVal.getSize();
                if (cmp >= size) {
                    low = mid + 1;
                    continue;
                }
                return (LoadObject)arr[mid];
            }
            return (LoadObject)arr[mid];
        }
        return null;
    }

    public CFrame topFrameForThread(ThreadProxy thread) throws DebuggerException {
        String cpu = this.dbg.getCPU();
        if (cpu.equals("ppc")) {
            PPCThreadContext context = (PPCThreadContext)thread.getContext();
            Address sp = context.getRegisterAsAddress(3);
            Address pc = context.getRegisterAsAddress(0);
            if (sp == null || pc == null) {
                return null;
            }
            return new PPCCFrame(this.dbg, sp, pc);
        }
        if (cpu.equals("x86")) {
            X86ThreadContext context = (X86ThreadContext)thread.getContext();
            Address ebp = context.getRegisterAsAddress(6);
            if (ebp == null) {
                return null;
            }
            Address pc = context.getRegisterAsAddress(14);
            if (pc == null) {
                return null;
            }
            return new X86CFrame(this, ebp, pc);
        }
        if (cpu.equals("x86_64") || cpu.equals("amd64")) {
            AMD64ThreadContext context = (AMD64ThreadContext)thread.getContext();
            Address rbp = context.getRegisterAsAddress(10);
            if (rbp == null) {
                return null;
            }
            Address pc = context.getRegisterAsAddress(17);
            if (pc == null) {
                return null;
            }
            return new AMD64CFrame(this, rbp, pc);
        }
        throw new DebuggerException(cpu + " is not yet supported");
    }

    public String getNameOfFile(String fileName) {
        return new File(fileName).getName();
    }

    public ProcessControl getProcessControl() throws DebuggerException {
        return null;
    }

    public boolean canDemangle() {
        return false;
    }

    public String demangle(String sym) {
        throw new UnsupportedOperationException();
    }
}

