/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.macosx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerBase;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.DebuggerUtilities;
import sun.jvm.hotspot.debugger.MachineDescription;
import sun.jvm.hotspot.debugger.NotInHeapException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.debugger.ReadResult;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.UnalignedAddressException;
import sun.jvm.hotspot.debugger.UnmappedAddressException;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.macosx.MacOSXAddress;
import sun.jvm.hotspot.debugger.macosx.MacOSXCDebugger;
import sun.jvm.hotspot.debugger.macosx.MacOSXDebugger;
import sun.jvm.hotspot.debugger.macosx.MacOSXOopHandle;
import sun.jvm.hotspot.debugger.macosx.MacOSXThread;
import sun.jvm.hotspot.utilities.PlatformInfo;

public class MacOSXDebuggerLocal
extends DebuggerBase
implements MacOSXDebugger {
    private MacOSXCDebugger cdbg;
    private boolean attached;
    private List threadList;
    private List loadObjectList;
    private long pid;
    private Map memoizedTidCache;

    public MacOSXDebuggerLocal(MachineDescription machDesc, boolean useCache) throws DebuggerException {
        this.machDesc = machDesc;
        this.memoizedTidCache = new HashMap();
        this.utils = new DebuggerUtilities(machDesc.getAddressSize(), machDesc.isBigEndian());
        if (useCache) {
            this.initCache(4096L, 4096L);
        }
    }

    public boolean hasProcessList() throws DebuggerException {
        return true;
    }

    public List getProcessList() throws DebuggerException {
        return this.getProcessList0();
    }

    public synchronized void attach(int processID) throws DebuggerException {
        if (this.attached) {
            throw new DebuggerException("Already attached to process " + this.pid);
        }
        this.threadList = new ArrayList();
        this.loadObjectList = new ArrayList();
        try {
            boolean res = this.attach0(processID);
            if (!res) {
                throw new DebuggerException("Error attaching to process, or no such process");
            }
            this.attached = true;
            this.pid = processID;
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
        this.memoizedTidCache.clear();
    }

    public synchronized void attach(String executableName, String coreFileName) throws DebuggerException {
        throw new DebuggerException("Core files not yet supported on Mac OS X");
    }

    public synchronized boolean detach() {
        if (!this.attached) {
            return false;
        }
        this.threadList = null;
        this.loadObjectList = null;
        this.attached = false;
        return this.detach0();
    }

    public Address parseAddress(String addressString) throws NumberFormatException {
        long addr = this.utils.scanAddress(addressString);
        return new MacOSXAddress(this, addr);
    }

    public String getOS() {
        return PlatformInfo.getOS();
    }

    public String getCPU() {
        return PlatformInfo.getCPU();
    }

    public boolean hasConsole() throws DebuggerException {
        return false;
    }

    public String consoleExecuteCommand(String cmd) throws DebuggerException {
        throw new DebuggerException("No debugger console available on Mac OS X");
    }

    public String getConsolePrompt() throws DebuggerException {
        return null;
    }

    public CDebugger getCDebugger() throws DebuggerException {
        if (this.cdbg == null) {
            String cpu = this.getCPU();
            if (!(cpu.equals("ppc") || cpu.equals("x86") || cpu.equals("amd64") || cpu.equals("x86_64"))) {
                return null;
            }
            this.cdbg = new MacOSXCDebugger(this);
        }
        return this.cdbg;
    }

    public synchronized Address lookup(String objectName, String symbol) {
        if (!this.attached) {
            return null;
        }
        long addr = this.lookupInProcess(objectName, symbol);
        if (addr == 0L) {
            return null;
        }
        return new MacOSXAddress(this, addr);
    }

    public synchronized OopHandle lookupOop(String objectName, String symbol) {
        Address addr = this.lookup(objectName, symbol);
        if (addr == null) {
            return null;
        }
        return addr.addOffsetToAsOopHandle(0L);
    }

    public MachineDescription getMachineDescription() {
        return this.machDesc;
    }

    public ThreadProxy getThreadForIdentifierAddress(Address addr) {
        return new MacOSXThread((MacOSXDebugger)this, addr);
    }

    public ThreadProxy getThreadForThreadId(long handle) {
        return new MacOSXThread((MacOSXDebugger)this, handle);
    }

    public long readJLong(long address) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jintSize);
        byte[] data = this.readBytes(address, this.jlongSize);
        return this.utils.dataToJLong(data, this.jlongSize);
    }

    public String addressValueToString(long address) {
        return this.utils.addressValueToString(address);
    }

    public MacOSXAddress readAddress(long address) throws UnmappedAddressException, UnalignedAddressException {
        long value = this.readAddressValue(address);
        return value == 0L ? null : new MacOSXAddress(this, value);
    }

    public MacOSXAddress readCompOopAddress(long address) throws UnmappedAddressException, UnalignedAddressException {
        long value = this.readCompOopAddressValue(address);
        return value == 0L ? null : new MacOSXAddress(this, value);
    }

    public MacOSXOopHandle readOopHandle(long address) throws UnmappedAddressException, UnalignedAddressException, NotInHeapException {
        long value = this.readAddressValue(address);
        return value == 0L ? null : new MacOSXOopHandle(this, value);
    }

    public MacOSXOopHandle readCompOopHandle(long address) throws UnmappedAddressException, UnalignedAddressException, NotInHeapException {
        long value = this.readCompOopAddressValue(address);
        return value == 0L ? null : new MacOSXOopHandle(this, value);
    }

    public int translateTID(int tid) throws DebuggerException {
        if (!this.attached) {
            throw new DebuggerException("Not attached to any process");
        }
        Integer Tid = new Integer(tid);
        if (this.memoizedTidCache.containsKey(Tid)) {
            Integer Value2 = (Integer)this.memoizedTidCache.get(Tid);
            return Value2;
        }
        int usable_tid = 0;
        try {
            usable_tid = this.translateTID0(tid);
        }
        catch (Exception e) {
            throw new DebuggerException(e.toString());
        }
        Integer UsableTid = new Integer(usable_tid);
        this.memoizedTidCache.put(Tid, UsableTid);
        return usable_tid;
    }

    public synchronized long[] getThreadIntegerRegisterSet(int tid) throws DebuggerException {
        if (!this.attached) {
            throw new DebuggerException("Not attached to any process");
        }
        long[] macRegisters = null;
        try {
            macRegisters = this.getThreadIntegerRegisterSet0(tid);
        }
        catch (Exception e) {
            throw new DebuggerException(e.toString());
        }
        return macRegisters;
    }

    public long getAddressValue(Address addr) {
        if (addr == null) {
            return 0L;
        }
        return ((MacOSXAddress)addr).getValue();
    }

    public Address newAddress(long value) {
        return new MacOSXAddress(this, value);
    }

    public List getThreadList() {
        this.requireAttach();
        return this.threadList;
    }

    public List getLoadObjectList() {
        this.requireAttach();
        return this.loadObjectList;
    }

    private void requireAttach() {
        if (!this.attached) {
            throw new RuntimeException("not attached to a process or Dr Watson dump");
        }
    }

    public synchronized ReadResult readBytesFromProcess(long address, long numBytes) throws UnmappedAddressException, DebuggerException {
        if (!this.attached) {
            throw new DebuggerException("Not attached to any process");
        }
        try {
            byte[] buf = new byte[(int)numBytes];
            long failureAddress = this.readBytesFromProcess0(address, numBytes, buf);
            if (failureAddress != 0L) {
                return new ReadResult(failureAddress);
            }
            return new ReadResult(buf);
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
    }

    public void writeBytesToProcess(long address, long numBytes, byte[] data) throws UnmappedAddressException, DebuggerException {
        throw new DebuggerException("Unimplemented");
    }

    public long readCInteger(long address, long numBytes, boolean isUnsigned) throws UnmappedAddressException, UnalignedAddressException {
        this.checkConfigured();
        this.utils.checkAlignment(address, numBytes == 8L ? 4L : numBytes);
        byte[] data = this.readBytes(address, numBytes);
        return this.utils.dataToCInteger(data, isUnsigned);
    }

    synchronized native long lookupInProcess(String var1, String var2);

    private native long readBytesFromProcess0(long var1, long var3, byte[] var5) throws IOException;

    private native long[] getThreadIntegerRegisterSet0(int var1) throws DebuggerException;

    private native int translateTID0(int var1);

    private native boolean attach0(int var1) throws DebuggerException, IOException;

    private native List getProcessList0();

    private native boolean detach0();

    static {
        System.loadLibrary("hsdbd");
    }
}

