/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.macosx;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.macosx.MacOSXDebugger;
import sun.jvm.hotspot.debugger.macosx.MacOSXThreadContextFactory;
import sun.jvm.hotspot.utilities.PlatformInfo;

class MacOSXThread
implements ThreadProxy {
    private MacOSXDebugger debugger;
    private int handle;

    MacOSXThread(MacOSXDebugger debugger, Address addr) {
        int mach_thread_usable;
        String arch = PlatformInfo.getCPU();
        int machThreadOffset = "amd64".equals(arch) || "x86_64".equals(arch) ? 68 : 52;
        this.debugger = debugger;
        Address pthread = addr.getAddressAt(0L);
        int mach_thread_foreign = (int)pthread.getCIntegerAt(machThreadOffset, 4L, true);
        try {
            mach_thread_usable = debugger.translateTID(mach_thread_foreign);
        }
        catch (DebuggerException d) {
            System.err.println("Problem translating TID: " + d.toString());
            d.printStackTrace(System.err);
            mach_thread_usable = 0;
        }
        this.handle = mach_thread_usable;
    }

    MacOSXThread(MacOSXDebugger debugger, long handle) {
        this.debugger = debugger;
        this.handle = (int)handle;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MacOSXThread)) {
            return false;
        }
        return ((MacOSXThread)obj).handle == this.handle;
    }

    public int hashCode() {
        return this.handle;
    }

    public ThreadContext getContext() throws IllegalThreadStateException {
        long[] data = this.debugger.getThreadIntegerRegisterSet(this.handle);
        ThreadContext context = MacOSXThreadContextFactory.createThreadContext(this.debugger);
        for (int i = 0; i < data.length; ++i) {
            context.setRegister(i, data[i]);
        }
        return context;
    }

    public boolean canSetContext() throws DebuggerException {
        return false;
    }

    public void setContext(ThreadContext context) throws IllegalThreadStateException, DebuggerException {
        throw new DebuggerException("Unimplemented");
    }

    public String toString() {
        return "t@" + this.handle;
    }
}

