/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.macosx;

import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.macosx.MacOSXDebugger;
import sun.jvm.hotspot.debugger.macosx.amd64.MacOSXAMD64ThreadContext;
import sun.jvm.hotspot.debugger.macosx.ppc.MacOSXPPCThreadContext;
import sun.jvm.hotspot.debugger.macosx.x86.MacOSXX86ThreadContext;

class MacOSXThreadContextFactory {
    MacOSXThreadContextFactory() {
    }

    static ThreadContext createThreadContext(MacOSXDebugger dbg) {
        String cpu = dbg.getCPU();
        if (cpu.equals("x86")) {
            return new MacOSXX86ThreadContext(dbg);
        }
        if (cpu.equals("ppc")) {
            return new MacOSXPPCThreadContext(dbg);
        }
        if (cpu.equals("amd64") || cpu.equals("x86_64")) {
            return new MacOSXAMD64ThreadContext(dbg);
        }
        throw new RuntimeException("cpu " + cpu + " is not yet supported");
    }
}

