/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.ppc;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.ThreadContext;

public abstract class PPCThreadContext
implements ThreadContext {
    public static final int PC = 0;
    public static final int PS = 1;
    public static final int R0 = 2;
    public static final int R1 = 3;
    public static final int R2 = 4;
    public static final int R3 = 5;
    public static final int R4 = 6;
    public static final int R5 = 7;
    public static final int R6 = 8;
    public static final int R7 = 9;
    public static final int R8 = 10;
    public static final int R9 = 11;
    public static final int R10 = 12;
    public static final int R11 = 13;
    public static final int R12 = 14;
    public static final int R13 = 15;
    public static final int R14 = 16;
    public static final int R15 = 17;
    public static final int R16 = 18;
    public static final int R17 = 19;
    public static final int R18 = 20;
    public static final int R19 = 21;
    public static final int R20 = 22;
    public static final int R21 = 23;
    public static final int R22 = 24;
    public static final int R23 = 25;
    public static final int R24 = 26;
    public static final int R25 = 27;
    public static final int R26 = 28;
    public static final int R27 = 29;
    public static final int R28 = 30;
    public static final int R29 = 31;
    public static final int R30 = 32;
    public static final int R31 = 33;
    public static final int CR = 34;
    public static final int LR = 35;
    public static final int CTR = 36;
    public static final int XER = 37;
    public static final int MQ = 38;
    public static final int VRSAVE = 39;
    public static final int SP = 3;
    public static final int FP = 18;
    public static final int NPRGREG = 40;
    private long[] data = new long[40];

    public int getNumRegisters() {
        return 40;
    }

    public String getRegisterName(int index) {
        if (2 <= index && index <= 33) {
            return "R" + index;
        }
        switch (index) {
            case 0: {
                return "PC";
            }
            case 1: {
                return "PS";
            }
            case 34: {
                return "CR";
            }
            case 35: {
                return "LR";
            }
            case 36: {
                return "CTR";
            }
            case 37: {
                return "XER";
            }
            case 38: {
                return "MQ";
            }
            case 39: {
                return "VRSAVE";
            }
        }
        return "ERROR";
    }

    public void setRegister(int index, long value) {
        this.data[index] = value;
    }

    public long getRegister(int index) {
        return this.data[index];
    }

    public abstract void setRegisterAsAddress(int var1, Address var2);

    public abstract Address getRegisterAsAddress(int var1);
}

