/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.livejvm;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.livejvm.BreakpointEvent;
import sun.jvm.hotspot.livejvm.CIntegerAccessor;
import sun.jvm.hotspot.livejvm.CStringAccessor;
import sun.jvm.hotspot.livejvm.Event;
import sun.jvm.hotspot.livejvm.ExceptionEvent;
import sun.jvm.hotspot.livejvm.JNIHandleAccessor;
import sun.jvm.hotspot.runtime.JNIid;
import sun.jvm.hotspot.runtime.VM;

public class ServiceabilityAgentJVMDIModule {
    private Debugger dbg;
    private String[] saLibNames;
    private String saLibName;
    private boolean attached;
    private boolean suspended;
    private static final int JVMDI_EVENT_BREAKPOINT = 2;
    private static final int JVMDI_EVENT_EXCEPTION = 4;
    private static long timeoutMillis = 3000L;
    private CIntegerAccessor saAttached;
    private CIntegerAccessor saEventPending;
    private CIntegerAccessor saEventKind;
    private JNIHandleAccessor saExceptionThread;
    private JNIHandleAccessor saExceptionClass;
    private JNIid saExceptionMethod;
    private CIntegerAccessor saExceptionLocation;
    private JNIHandleAccessor saExceptionException;
    private JNIHandleAccessor saExceptionCatchClass;
    private JNIid saExceptionCatchMethod;
    private CIntegerAccessor saExceptionCatchLocation;
    private JNIHandleAccessor saBreakpointThread;
    private JNIHandleAccessor saBreakpointClass;
    private JNIid saBreakpointMethod;
    private CIntegerAccessor saBreakpointLocation;
    private int SA_CMD_SUSPEND_ALL;
    private int SA_CMD_RESUME_ALL;
    private int SA_CMD_TOGGLE_BREAKPOINT;
    private int SA_CMD_BUF_SIZE;
    private CIntegerAccessor saCmdPending;
    private CIntegerAccessor saCmdType;
    private CIntegerAccessor saCmdResult;
    private CStringAccessor saCmdResultErrMsg;
    private CStringAccessor saCmdBkptSrcFileName;
    private CStringAccessor saCmdBkptPkgName;
    private CIntegerAccessor saCmdBkptLineNumber;
    private CIntegerAccessor saCmdBkptResWasError;
    private CIntegerAccessor saCmdBkptResLineNumber;
    private CIntegerAccessor saCmdBkptResBCI;
    private CIntegerAccessor saCmdBkptResWasSet;
    private CStringAccessor saCmdBkptResMethodName;
    private CStringAccessor saCmdBkptResMethodSig;

    public ServiceabilityAgentJVMDIModule(Debugger dbg, String[] saLibNames) {
        this.dbg = dbg;
        this.saLibNames = saLibNames;
    }

    public boolean canAttach() {
        return this.setupLookup("SA_CMD_SUSPEND_ALL");
    }

    public void attach() throws DebuggerException {
        if (!this.canAttach()) {
            throw new DebuggerException("Unable to initiate symbol lookup in SA's JVMDI module");
        }
        if (this.attached) {
            throw new DebuggerException("Already attached");
        }
        this.SA_CMD_SUSPEND_ALL = this.lookupConstInt("SA_CMD_SUSPEND_ALL");
        this.SA_CMD_RESUME_ALL = this.lookupConstInt("SA_CMD_RESUME_ALL");
        this.SA_CMD_TOGGLE_BREAKPOINT = this.lookupConstInt("SA_CMD_TOGGLE_BREAKPOINT");
        this.SA_CMD_BUF_SIZE = this.lookupConstInt("SA_CMD_BUF_SIZE");
        this.saAttached = this.lookupCInt("saAttached");
        this.saEventPending = this.lookupCInt("saEventPending");
        this.saEventKind = this.lookupCInt("saEventKind");
        this.saCmdPending = this.lookupCInt("saCmdPending");
        this.saCmdType = this.lookupCInt("saCmdType");
        this.saCmdResult = this.lookupCInt("saCmdResult");
        this.saCmdResultErrMsg = this.lookupCString("saCmdResultErrMsg", this.SA_CMD_BUF_SIZE);
        this.saCmdBkptSrcFileName = this.lookupCString("saCmdBkptSrcFileName", this.SA_CMD_BUF_SIZE);
        this.saCmdBkptPkgName = this.lookupCString("saCmdBkptPkgName", this.SA_CMD_BUF_SIZE);
        this.saCmdBkptLineNumber = this.lookupCInt("saCmdBkptLineNumber");
        this.saCmdBkptResWasError = this.lookupCInt("saCmdBkptResWasError");
        this.saCmdBkptResLineNumber = this.lookupCInt("saCmdBkptResLineNumber");
        this.saCmdBkptResBCI = this.lookupCInt("saCmdBkptResBCI");
        this.saCmdBkptResWasSet = this.lookupCInt("saCmdBkptResWasSet");
        this.saCmdBkptResMethodName = this.lookupCString("saCmdBkptResMethodName", this.SA_CMD_BUF_SIZE);
        this.saCmdBkptResMethodSig = this.lookupCString("saCmdBkptResMethodSig", this.SA_CMD_BUF_SIZE);
        this.lookup("saExceptionThread");
        this.lookup("saExceptionClass");
        this.lookup("saExceptionMethod");
        this.lookup("saExceptionLocation");
        this.lookup("saExceptionException");
        this.lookup("saExceptionCatchClass");
        this.lookup("saExceptionCatchMethod");
        this.lookup("saExceptionCatchLocation");
        this.lookup("saBreakpointThread");
        this.lookup("saBreakpointClass");
        this.lookup("saBreakpointMethod");
        this.lookup("saBreakpointLocation");
        this.saAttached.setValue(1L);
        this.attached = true;
    }

    public void detach() {
        this.saAttached.setValue(0L);
        this.attached = false;
        this.saLibName = null;
    }

    public void setCommandTimeout(long millis) {
        timeoutMillis = millis;
    }

    public long getCommandTimeout() {
        return timeoutMillis;
    }

    public boolean eventPending() {
        return this.saEventPending.getValue() != 0L;
    }

    public Event eventPoll() {
        if (this.saEventPending.getValue() == 0L) {
            return null;
        }
        int kind = (int)this.saEventKind.getValue();
        switch (kind) {
            case 4: {
                JNIHandleAccessor thread = this.lookupJNIHandle("saExceptionThread");
                JNIHandleAccessor clazz = this.lookupJNIHandle("saExceptionClass");
                JNIid method = this.lookupJNIid("saExceptionMethod");
                CIntegerAccessor location = this.lookupCInt("saExceptionLocation");
                JNIHandleAccessor exception = this.lookupJNIHandle("saExceptionException");
                JNIHandleAccessor catchClass = this.lookupJNIHandle("saExceptionCatchClass");
                JNIid catchMethod = this.lookupJNIid("saExceptionCatchMethod");
                CIntegerAccessor catchLocation = this.lookupCInt("saExceptionCatchLocation");
                return new ExceptionEvent(thread.getValue(), clazz.getValue(), method, (int)location.getValue(), exception.getValue(), catchClass.getValue(), catchMethod, (int)catchLocation.getValue());
            }
            case 2: {
                JNIHandleAccessor thread = this.lookupJNIHandle("saBreakpointThread");
                JNIHandleAccessor clazz = this.lookupJNIHandle("saBreakpointClass");
                JNIid method = this.lookupJNIid("saBreakpointMethod");
                CIntegerAccessor location = this.lookupCInt("saBreakpointLocation");
                return new BreakpointEvent(thread.getValue(), clazz.getValue(), method, (int)location.getValue());
            }
        }
        throw new DebuggerException("Unsupported event type " + kind);
    }

    public void eventContinue() {
        this.saEventPending.setValue(0L);
    }

    public void suspend() {
        this.saCmdType.setValue(this.SA_CMD_SUSPEND_ALL);
        this.saCmdPending.setValue(1L);
        this.waitForCommandCompletion();
        this.suspended = true;
    }

    public void resume() {
        this.saCmdType.setValue(this.SA_CMD_RESUME_ALL);
        this.saCmdPending.setValue(1L);
        this.waitForCommandCompletion();
        this.suspended = false;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public BreakpointToggleResult toggleBreakpoint(String srcFileName, String pkgName, int lineNo) {
        this.saCmdBkptSrcFileName.setValue(srcFileName);
        this.saCmdBkptPkgName.setValue(pkgName);
        this.saCmdBkptLineNumber.setValue(lineNo);
        this.saCmdType.setValue(this.SA_CMD_TOGGLE_BREAKPOINT);
        this.saCmdPending.setValue(1L);
        if (this.waitForCommandCompletion(true)) {
            return new BreakpointToggleResult((int)this.saCmdBkptResLineNumber.getValue(), (int)this.saCmdBkptResBCI.getValue(), this.saCmdBkptResWasSet.getValue() != 0L, this.saCmdBkptResMethodName.getValue(), this.saCmdBkptResMethodSig.getValue());
        }
        return new BreakpointToggleResult(this.saCmdResultErrMsg.getValue());
    }

    private CIntegerAccessor lookupCInt(String symbolName) {
        return new CIntegerAccessor(this.lookup(symbolName), 4L, false);
    }

    private CStringAccessor lookupCString(String symbolName, int bufLen) {
        return new CStringAccessor(this.lookup(symbolName), bufLen);
    }

    private JNIHandleAccessor lookupJNIHandle(String symbolName) {
        return new JNIHandleAccessor(this.lookup(symbolName), VM.getVM().getObjectHeap());
    }

    private JNIid lookupJNIid(String symbolName) {
        Address idAddr = this.lookup(symbolName).getAddressAt(0L);
        if (idAddr == null) {
            return null;
        }
        return new JNIid(idAddr, VM.getVM().getObjectHeap());
    }

    private int lookupConstInt(String symbolName) {
        Address addr = this.lookup(symbolName);
        return (int)addr.getCIntegerAt(0L, 4L, false);
    }

    private boolean setupLookup(String symbolName) {
        if (this.saLibName == null && this.saLibNames != null) {
            for (int i = 0; i < this.saLibNames.length; ++i) {
                Address addr = this.dbg.lookup(this.saLibNames[i], symbolName);
                if (addr == null) continue;
                this.saLibName = this.saLibNames[i];
                return true;
            }
            return false;
        }
        return true;
    }

    private Address lookup(String symbolName) {
        if (this.saLibName == null && this.saLibNames != null) {
            for (int i = 0; i < this.saLibNames.length; ++i) {
                Address addr = this.dbg.lookup(this.saLibNames[i], symbolName);
                if (addr == null) continue;
                this.saLibName = this.saLibNames[i];
                return addr;
            }
            throw new DebuggerException("Unable to find symbol " + symbolName + " in any of the known names for the SA");
        }
        Address addr = this.dbg.lookup(this.saLibName, symbolName);
        if (addr == null) {
            throw new DebuggerException("Unable to find symbol " + symbolName + " in " + this.saLibName);
        }
        return addr;
    }

    private void waitForCommandCompletion() {
        this.waitForCommandCompletion(false);
    }

    private boolean waitForCommandCompletion(boolean forBreakpoint) {
        boolean succeeded;
        long start;
        long cur = start = System.currentTimeMillis();
        while (this.saCmdPending.getValue() != 0L && cur - start < timeoutMillis) {
            try {
                Thread.currentThread();
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            cur = System.currentTimeMillis();
        }
        if (this.saCmdPending.getValue() != 0L) {
            this.detach();
            throw new DebuggerException("VM appears to have died");
        }
        boolean bl = succeeded = this.saCmdResult.getValue() == 0L;
        if (!(succeeded || forBreakpoint && this.saCmdBkptResWasError.getValue() == 0L)) {
            String err = this.saCmdResultErrMsg.getValue();
            throw new DebuggerException("Error executing JVMDI command: " + err);
        }
        return succeeded;
    }

    public static class BreakpointToggleResult {
        private boolean success;
        private String errMsg;
        private int lineNumber;
        private int bci;
        private boolean wasSet;
        private String methodName;
        private String methodSig;

        public BreakpointToggleResult(int lineNumber, int bci, boolean wasSet, String methodName, String methodSig) {
            this.lineNumber = lineNumber;
            this.bci = bci;
            this.wasSet = wasSet;
            this.methodName = methodName;
            this.methodSig = methodSig;
            this.success = true;
        }

        public BreakpointToggleResult(String errMsg) {
            this.errMsg = errMsg;
            this.success = false;
        }

        public boolean getSuccess() {
            return this.success;
        }

        public String getErrMsg() {
            return this.errMsg;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getBCI() {
            return this.bci;
        }

        public boolean getWasSet() {
            return this.wasSet;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodSignature() {
            return this.methodSig;
        }
    }
}

