/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.macosx_ppc;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.ppc.PPCThreadContext;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.ppc.PPCFrame;
import sun.jvm.hotspot.runtime.ppc.PPCRegisterMap;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class MacOSXPPCJavaThreadPDAccess
implements JavaThreadPDAccess {
    private static AddressField osThreadField;
    private static AddressField lastJavaFPField;
    private static CIntegerField osThreadThreadIDField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JavaThread");
        Type anchorType = db.lookupType("JavaFrameAnchor");
        osThreadField = type.getAddressField("_osthread");
        type = db.lookupType("OSThread");
        osThreadThreadIDField = type.getCIntegerField("_thread_id");
    }

    public Address getLastJavaFP(Address addr) {
        return null;
    }

    public Address getLastJavaPC(Address addr) {
        return null;
    }

    public Address getBaseOfStackPointer(Address addr) {
        return null;
    }

    public Frame getLastFramePD(JavaThread thread, Address addr) {
        Address fp = this.getLastJavaFP(addr);
        Address sp = thread.getLastJavaSP();
        PPCFrame fr = new PPCFrame(sp, fp, null);
        return fr;
    }

    public RegisterMap newRegisterMap(JavaThread thread, boolean updateMap) {
        return new PPCRegisterMap(thread, updateMap);
    }

    public Frame getCurrentFrameGuess(JavaThread thread, Address addr) {
        ThreadProxy t = this.getThreadProxy(addr);
        PPCThreadContext context = (PPCThreadContext)t.getContext();
        Address sp = context.getRegisterAsAddress(3);
        Address pc = context.getRegisterAsAddress(0);
        Address fp = sp.getAddressAt(0L);
        if (sp == null || pc == null || fp == null) {
            return null;
        }
        return new PPCFrame(sp, fp, pc);
    }

    public void printThreadIDOn(Address addr, PrintStream tty) {
        tty.print(this.getThreadProxy(addr));
    }

    public void printInfoOn(Address threadAddr, PrintStream tty) {
        tty.print("Thread id: ");
        this.printThreadIDOn(threadAddr, tty);
    }

    public Address getLastSP(Address addr) {
        ThreadProxy t = this.getThreadProxy(addr);
        PPCThreadContext context = (PPCThreadContext)t.getContext();
        return context.getRegisterAsAddress(3);
    }

    public ThreadProxy getThreadProxy(Address addr) {
        Address osThreadAddr = osThreadField.getValue(addr);
        Address tidAddr = osThreadAddr.addOffsetTo(osThreadThreadIDField.getOffset());
        JVMDebugger debugger = VM.getVM().getDebugger();
        return debugger.getThreadForIdentifierAddress(tidAddr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                MacOSXPPCJavaThreadPDAccess.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

