/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.ppc;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.compiler.OopMapSet;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.BasicObjectLock;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaCallWrapper;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.ppc.PPCRegisterMap;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.Assert;

public class PPCFrame
extends Frame {
    private static final boolean DEBUG = false;
    private static final int RETURN_ADDR_OFFSET = 2;
    private static final int INTERPRETED_FRAME_LINK_AREA_SLOTS = 6;
    private static final int INTERPRETED_FRAME_PARAM_AREA_SLOTS = 8;
    private static final int INTERPRETED_FRAME_METH_OFFSET = -1;
    private static final int INTERPRETED_FRAME_VARS_OFFSET = -2;
    private static final int INTERPRETED_FRAME_JSP_OFFSET = -3;
    private static final int INTERPRETED_FRAME_CONSC_OFFSET = -4;
    private static final int INTERPRETED_FRAME_BCX_OFFSET = -5;
    private static final int INTERPRETED_FRAME_JAVA_STACK_BOTTOM_OFFSET = -6;
    private static final int ENTRY_FRAME_CALL_WRAPPER_OFFSET = 6;
    Address raw_fp;

    private static synchronized void initialize(TypeDataBase db) {
    }

    private PPCFrame() {
    }

    public PPCFrame(Address raw_sp, Address raw_fp, Address pc) {
        this.raw_sp = raw_sp;
        this.raw_fp = raw_fp;
        this.pc = pc;
    }

    public Object clone() {
        PPCFrame frame = new PPCFrame();
        frame.raw_sp = this.raw_sp;
        frame.raw_fp = this.raw_fp;
        frame.pc = this.pc;
        return frame;
    }

    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        if (!(arg instanceof PPCFrame)) {
            return false;
        }
        PPCFrame other = (PPCFrame)arg;
        return AddressOps.equal(this.getSP(), other.getSP()) && AddressOps.equal(this.getFP(), other.getFP()) && AddressOps.equal(this.getPC(), other.getPC());
    }

    public int hashCode() {
        if (this.raw_sp == null) {
            return 0;
        }
        return ((Object)this.raw_sp).hashCode();
    }

    public String toString() {
        return "sp: " + (this.getSP() == null ? "null" : this.getSP().toString()) + ", fp: " + (this.getFP() == null ? "null" : this.getFP().toString()) + ", pc: " + (this.pc == null ? "null" : this.pc.toString());
    }

    public Address getID() {
        return this.raw_sp;
    }

    public Address getFP() {
        return this.raw_fp;
    }

    public Address getSP() {
        return this.raw_sp;
    }

    public boolean isSignalHandlerFrameDbg() {
        return false;
    }

    public int getSignalNumberDbg() {
        return 0;
    }

    public String getSignalNameDbg() {
        return null;
    }

    public boolean isInterpretedFrameValid() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isInterpretedFrame(), "Not an interpreted frame");
        }
        long addressSize = VM.getVM().getAddressSize();
        if (this.getFP() == null || this.getFP().andWithMask(addressSize - 1L) != null) {
            return false;
        }
        if (this.getSP() == null || this.getSP().andWithMask(addressSize - 1L) != null) {
            return false;
        }
        if (this.getFP().addOffsetTo(-1L * addressSize * -6L).addOffsetTo(-1L * addressSize * 13L).lessThan(this.getSP())) {
            return false;
        }
        return this.getFP().minus(this.getSP()) <= 4096L;
    }

    public Frame sender(RegisterMap regMap, CodeBlob cb) {
        PPCRegisterMap map = (PPCRegisterMap)regMap;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        map.setIncludeArgumentOops(false);
        if (this.isEntryFrame()) {
            return this.senderForEntryFrame(map);
        }
        if (this.isInterpretedFrame()) {
            return this.senderForInterpreterFrame(map);
        }
        if (!VM.getVM().isCore()) {
            if (cb == null) {
                cb = VM.getVM().getCodeCache().findBlob(this.getPC());
            } else if (Assert.ASSERTS_ENABLED) {
                Assert.that(cb.equals(VM.getVM().getCodeCache().findBlob(this.getPC())), "Must be the same");
            }
            if (cb != null) {
                return this.senderForCompiledFrame(map, cb, true);
            }
        }
        Address sender_sp = this.getSenderSP();
        Address sender_fp = sender_sp.getAddressAt(0L);
        return new PPCFrame(sender_sp, sender_fp, this.getSenderPC());
    }

    private Frame senderForEntryFrame(PPCRegisterMap map) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        JavaCallWrapper jcw = this.getEntryFrameCallWrapper();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(!this.entryFrameIsFirst(), "next Java fp must be non zero");
            Assert.that(jcw.getLastJavaSP().greaterThan(this.getSP()), "must be above this frame on stack");
        }
        Address lastJavaSP = jcw.getLastJavaSP();
        Address senderFP = lastJavaSP.getAddressAt(0L);
        Object senderPC = null;
        throw new RuntimeException("1.6-Bringup: Need to fix this");
    }

    private Frame senderForInterpreterFrame(PPCRegisterMap map) {
        Address oldFP = this.getFP().getAddressAt(0L);
        return new PPCFrame(this.getInterpreterFrameSenderSP(), oldFP, this.getSenderPC());
    }

    private Frame senderForCompiledFrame(PPCRegisterMap map, CodeBlob cb, boolean adjusted) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        if (!VM.getVM().isClientCompiler()) {
            throw new RuntimeException("Only support c1 on Mac OS X");
        }
        Address return_addr = this.getSenderPC();
        Address sender_sp = this.getSenderSP();
        Address sender_fp = sender_sp.getAddressAt(0L);
        if (map.getUpdateMap() && cb.getOopMaps() != null) {
            OopMapSet.updateRegisterMap(this, cb, map, true);
        }
        map.setIncludeArgumentOops(cb.callerMustGCArguments(map.getThread()));
        if (adjusted) {
            // empty if block
        }
        return new PPCFrame(sender_sp, sender_fp, return_addr);
    }

    protected boolean hasSenderPD() {
        return this.getFP() != null && this.getSP() != null;
    }

    public long frameSize() {
        return this.getSenderSP().minus(this.getSP()) / VM.getVM().getAddressSize();
    }

    public Address getLink() {
        return this.getFP();
    }

    public Address getUnextendedSP() {
        return this.getSP();
    }

    public Address getSenderPCAddr() {
        return this.getFP().addOffsetTo(2L * VM.getVM().getAddressSize());
    }

    public Address getSenderPC() {
        return this.getSenderPCAddr().getAddressAt(0L);
    }

    public Address getSenderSP() {
        return this.getFP();
    }

    public long getOopMapOffsetAdjustmentPD() {
        return 0L;
    }

    public Address addressOfInterpreterFrameLocals() {
        return this.addressOfStackSlot(-2);
    }

    private Address addressOfInterpreterFrameBCX() {
        return this.addressOfStackSlot(-5);
    }

    public int getInterpreterFrameBCI() {
        Address bcp = this.addressOfInterpreterFrameBCX().getAddressAt(0L);
        OopHandle methodHandle = this.addressOfInterpreterFrameMethod().getOopHandleAt(0L);
        Method method = (Method)VM.getVM().getObjectHeap().newOop(methodHandle);
        return this.bcpToBci(bcp, method);
    }

    public Address addressOfInterpreterFrameExpressionStack() {
        Address monitorEnd = this.addressOfStackSlot(-6).getAddressAt(0L);
        return monitorEnd.addOffsetTo(-1L * VM.getVM().getAddressSize());
    }

    public int getInterpreterFrameExpressionStackDirection() {
        return -1;
    }

    public Address addressOfInterpreterFrameTOS() {
        return this.addressOfStackSlot(-3).getAddressAt(0L);
    }

    public Address addressOfInterpreterFrameTOSAt(int slot) {
        return this.addressOfInterpreterFrameTOS().addOffsetTo((long)slot * VM.getVM().getAddressSize());
    }

    public Address getInterpreterFrameSenderSP() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isInterpretedFrame(), "interpreted frame expected");
        }
        return this.getFP();
    }

    public BasicObjectLock interpreterFrameMonitorBegin() {
        return new BasicObjectLock(this.addressOfStackSlot(-6));
    }

    public BasicObjectLock interpreterFrameMonitorEnd() {
        Address result = this.addressOfStackSlot(-6).getAddressAt(0L);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(AddressOps.gt(this.getFP(), result), "result must <  than frame pointer");
            Assert.that(AddressOps.lte(this.getSP(), result), "result must >= than stack pointer");
        }
        return new BasicObjectLock(result);
    }

    public int interpreterFrameMonitorSize() {
        return BasicObjectLock.size();
    }

    public Address addressOfInterpreterFrameMethod() {
        return this.addressOfStackSlot(-1);
    }

    public Address addressOfInterpreterFrameCPCache() {
        return this.addressOfStackSlot(-4);
    }

    public JavaCallWrapper getEntryFrameCallWrapper() {
        return new JavaCallWrapper(this.addressOfStackSlot(6).getAddressAt(0L));
    }

    protected Address addressOfSavedOopResult() {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    protected Address addressOfSavedReceiver() {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    private void dumpStack() {
        if (this.getFP() != null) {
            Address addr = this.getSP().addOffsetTo(-5L * VM.getVM().getAddressSize());
            while (AddressOps.lte(addr, this.getFP().addOffsetTo(5L * VM.getVM().getAddressSize()))) {
                String annotation = "";
                if (((Object)addr).equals(this.getFP())) {
                    annotation = " <- FP";
                }
                if (((Object)addr).equals(this.getSP())) {
                    annotation = " <- SP";
                }
                System.out.println(addr + ": " + addr.getAddressAt(0L) + annotation);
                addr = addr.addOffsetTo(VM.getVM().getAddressSize());
            }
        } else {
            Address addr = this.getSP().addOffsetTo(-5L * VM.getVM().getAddressSize());
            while (AddressOps.lte(addr, this.getSP().addOffsetTo(20L * VM.getVM().getAddressSize()))) {
                System.out.println(addr + ": " + addr.getAddressAt(0L));
                addr = addr.addOffsetTo(VM.getVM().getAddressSize());
            }
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                PPCFrame.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

