/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import sun.font.AppleNativeCharToGlyphMapper;
import sun.font.AppleNativeStrike;
import sun.font.CharToGlyphMapper;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;

public final class AppleNativeFont
extends Font2D {
    private boolean isFakeItalic;
    private String nativeFontName;
    private long nativeFontPtr;
    private static FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, false);

    private static native long createNativeFont(String var0, int var1, boolean var2);

    private static native void disposeNativeFont(long var0);

    public AppleNativeFont(String string) {
        this(string, string);
    }

    public AppleNativeFont(String string, String string2) {
        this.handle = new Font2DHandle(this);
        this.fullName = string;
        this.familyName = string2;
        this.nativeFontName = string2;
        this.setStyle();
    }

    public AppleNativeFont(AppleNativeFont appleNativeFont, String string) {
        this.handle = new Font2DHandle(this);
        this.fullName = string;
        this.familyName = string;
        this.nativeFontName = appleNativeFont.nativeFontName;
        this.style = appleNativeFont.style;
        this.isFakeItalic = appleNativeFont.isFakeItalic;
    }

    public AppleNativeFont createItalicVariant() {
        AppleNativeFont appleNativeFont = new AppleNativeFont(this, this.familyName);
        appleNativeFont.fullName = this.fullName + (this.style == 1 ? "" : "-") + "Italic-Derived";
        appleNativeFont.style |= 2;
        appleNativeFont.isFakeItalic = true;
        return appleNativeFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNativeFontPtr() {
        if (this.nativeFontPtr != 0L) {
            return this.nativeFontPtr;
        }
        AppleNativeFont appleNativeFont = this;
        synchronized (appleNativeFont) {
            this.nativeFontPtr = AppleNativeFont.createNativeFont(this.nativeFontName, this.style, this.isFakeItalic);
        }
        return this.nativeFontPtr;
    }

    protected synchronized void finalize() throws Throwable {
        if (this.nativeFontPtr != 0L) {
            AppleNativeFont.disposeNativeFont(this.nativeFontPtr);
        }
        this.nativeFontPtr = 0L;
    }

    @Override
    protected CharToGlyphMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new AppleNativeCharToGlyphMapper(this);
        }
        return this.mapper;
    }

    @Override
    protected FontStrike createStrike(FontStrikeDesc fontStrikeDesc) {
        if (this.isFakeItalic) {
            fontStrikeDesc = new FontStrikeDesc(fontStrikeDesc);
            fontStrikeDesc.glyphTx.concatenate(AffineTransform.getShearInstance(-0.2, 0.0));
        }
        return new AppleNativeStrike(this, fontStrikeDesc);
    }

    @Override
    public FontStrike getStrike(Font font) {
        return this.getStrike(font, DEFAULT_FRC);
    }

    public String toString() {
        return "AppleNativeFont{ fullName: " + this.fullName + ",  familyName: " + this.familyName + ", style: " + this.style + " } aka: " + super.toString();
    }
}

