(defun c:ang(/ lin name se)
   
  (defun dia(angl / dcl_file dcl_name dcl_id select ortho)
      (setq ortho 1)
      (setq dcl_file "ang.dcl")
      (setq dcl_name "ang_main")
      (setq dcl_id (load_dialog dcl_file))  
      (if (not (new_dialog dcl_name dcl_id)) (exit))        
          
      (action_tile "angl" "(setq angl (atof $value))")
      (action_tile "ortho" "(setq ortho (atof $value))")             
      (action_tile "accept" "(done_dialog 1)") 
      (action_tile "cancel" "(done_dialog 0)")
      (set_tile "angl" (rtos angl))     
      (setq select (start_dialog))
      (if (= 1 select)
          (progn
            (setvar "snapang" (* (/ angl 180) PI))
            (setvar "orthomode" ortho)
            (princ "\n ORTH_ANGLE change OK!")(princ)
          )   
          (progn
            (prompt"Progrem is cancelled by user.")(princ)
          )
      )
      (unload_dialog dcl_id)(princ)
  )
   
   
   
   (defun any (lin / angl name p1 p2 p3) 
     (if (= nil lin)
         (dia 0.0)
         (progn
             (setq name (entget lin))
             (if (= "POLYLINE" (cdr(assoc '0 name)))
                 (progn
                     (setq p1 (cdr(assoc '10 (entget(entnext lin)))))
                     (setq p2 (cdr(assoc '10 (entget(entnext(entnext lin))))))
                     (setq p3 (assoc '10 (entget(entnext(entnext(entnext lin))))))
                     (if (/= nil p3)
                         (progn
                            (princ "Selected Pline 'entpoint numbers over two!")
                            (princ)(princ)
                         )
                         (progn
                             (setq angl (* (/ (angle p1 p2) PI) 180)) 
                             (dia angl)
                         )
                     )
                 )
             )
             (if (= "LINE" (cdr(assoc '0 name)))
                 (progn
                       (setq angl (/ (* 180 (angle (cdr(assoc '10 name)) 
                                                   (cdr(assoc '11 name))
                                            )
                                     ) PI
                                   )
                       )
                       (dia angl)
                 )
             )
             (princ)
         ) 
     )
   )

  (prompt"Please select a line or Pline <RETURN is accepted as none>")
  (setq se (ssget))
  (if (= nil se)
      (progn (setq lin nil)(any lin))
      (progn
           (setq lin (ssname se 0))
           (setq name (entget lin))
           (if (or (= "LINE" (cdr(assoc '0 name)))
                   (= "POLYLINE" (cdr(assoc '0 name)))
               )
               (any lin)
               (progn
                 (princ "\n NOT a line or pline!")(princ)
               )
           )
      )
  )
)
