
;*************************** BGBZ.LSP *************************************
	(VMON)
	(defun *error* (msg)
	  (command "style" "" "" (/ 3.5 m) "" "" "" "" "")
	  (princ "error: ")
	  (princ msg)
	  (terpri)
	)
;************************** OBASE *******************************
	(defun bgbz_obase (value / dx dist ang pt0 pt1 pt2 pt3 pt4 pt5 txtp)
	  (setq pt0 (getpoint "\n Baseline From point:"))
	  (setq pt1 (getpoint pt0 "\n Elevation mark is location:"))
  ;;        (setq pt2 (getpoint pt1 "\n Next point for mark direction:"))
  ;;        (setq value (getstring "\n Enter elevation value:<0>"))
  ;;        (if (or (= value "") (= value " "))
  ;;          (setq value (strcat "%%p" "0"))
  ;;        )
	  (setq dx (abs (- (car pt0) (car pt1))))
	  (setq dist (+ dx (/ 6.0 m)))
	  (setq ang (angle pt0 pt1))
	  (if (and (>= ang (* 0.5 pi)) (<= ang (* 1.5 pi)))
	    (progn
	      (setq pt3 (polar pt0 pi dist))
	      (setq pt1 (polar pt0 pi dx))
	    )
	    (progn
	      (setq pt3 (polar pt0 0.0 dist))
	      (setq pt1 (polar pt0 0.0 dx))
	    )
	  )
	  (command "line" pt0 pt3 "")
	  (setq pt2 (getpoint pt1 "\n Side to mark ?"))
	  (setq ang (angle pt1 pt2))
	  (setq pt3 (polar pt1 (/ (* 5.0 pi) 6.0) (/ 4.0 m)))
	  (setq pt4 (polar pt1 (/ pi 6.0) (/ 4.0 m)))
	  (if (and (>= ang (* 0.5 pi)) (<= ang (* 1.5 pi)))
	    (progn
	      (setq pt5 (polar pt4 pi (/ 20.0 m)))
	      (setq txtp (polar pt4 pi (/ 18.0 m)))
	      (setq txtp (polar txtp (* 0.5 pi) (/ 1.0 m)))
	      (command "pline" pt3 "w" 0.0 "" pt1 pt4 pt5 "w" (/ 0.5 m) "" "")
	      (command "text" txtp 0.0 value)
	    )
	    (progn
	      (setq pt5 (polar pt3 0.0 (/ 20.0 m)))
	      (setq txtp (polar pt3 0.0 (/ 5.0 m)))
	      (setq txtp (polar txtp (* 0.5 pi) (/ 1.5 m)))
	      (command "pline" pt4 "w" 0.0 "" pt1 pt3 pt5 "w" (/ 0.5 m) "" "")
	      (command "text" txtp 0.0 value)
	    )
	  )
	)
      ;*********************** UBASE *********************************
	(defun bgbz_ubase (value / dx dist ang pt0 pt1 pt2 pt3 pt4 pt5 txtp)
	  (setq pt0 (getpoint "\n Baseline From point:"))
	  (setq pt1 (getpoint pt0 "\n Elevation-mark is location:"))
 ;;         (setq pt2 (getpoint pt1 "\n Side to mark ?"))
 ;;         (setq value (getstring "\n Enter Elevation value<0>:"))
 ;;         (if (or (= value "") (= value " "))
 ;;           (setq value (strcat "%%p" "0"))
 ;;         )
	  (setq dx (abs (- (car pt0) (car pt1))))
	  (setq dist (+ dx (/ 6.0 m)))
	  (setq ang (angle pt0 pt1))
	  (if (and (>= ang (* 0.5 pi)) (<= ang (* 1.5 pi)))
	    (progn
	      (setq pt3 (polar pt0 pi dist))
	      (setq pt1 (polar pt0 pi dx))
	    )
	    (progn
	      (setq pt3 (polar pt0 0.0 dist))
	      (setq pt1 (polar pt0 0.0 dx))
	    )
	  )
	  (command "line" pt0 pt3 "")
	  (setq pt2 (getpoint pt1 "\n Side to mark ?"))
	  (setq ang (angle pt1 pt2))
	  (setq pt3 (polar pt1 (/ (* 7.0 pi) 6.0) (/ 4.0 m)))
	  (setq pt4 (polar pt1 (/ (* 11.0 pi) 6.0) (/ 4.0 m)))
	  (if (and (>= ang (* 0.5 pi)) (<= ang (* 1.5 pi)))
	    (progn
	      (setq pt5 (polar pt4 pi (/ 20.0 m)))
	      (setq txtp (polar pt4 pi (/ 18.0 m)))
	      (setq txtp (polar txtp (* 1.5 pi) (/ 5.0 m)))
	      (command "pline" pt3 "w" 0.0 "" pt1 pt4 pt5 "w" (/ 0.5 m) "" "")
	      (command "text" txtp 0.0 value)
	    )
	    (progn
	      (setq pt5 (polar pt3 0.0 (/ 20.0 m)))
	      (setq txtp (polar pt3 0.0 (/ 5.0 m)))
	      (setq txtp (polar txtp (* 1.5 pi) (/ 5.0 m)))
	      (command "pline" pt4 "w" 0.0 "" pt1 pt3 pt5 "w" (/ 0.5 m) "" "")
	      (command "text" txtp 0.0 value)
	    )
	  )

	)
      
;========================info=====================        
(defun bgbz_info ( )
  (if (not (new_dialog "bgbz_info" dcl_id)) (exit)) 
  (action_tile "accept" "(done_dialog)")
  (start_dialog)
)
      
      ;************************* MAIN ********************************
	
	(defun c:bgbz (/ txt sel cont dcl_id dcl_name dcl_file)
	  
	  (initget 1)
	  (if (= m nil)
	    (progn
	      (setq m (getreal "\n Enter M=1:"))
	      (setq m (/ 1.0 m))
	    )
	  )
	  (command "style" "" "" (/ 3.5 m) "" "" "" "" "")
	  (if (= bgbz_elev_value nil)
	    (setq txt "%%p0")
	    (setq txt bgbz_elev_value)
	  )
	  (setq cont 1 sel "over")
	  (setq dcl_name "bgbz")
	  (setq dcl_file "bgbz.dcl")
	  (setq dcl_id (load_dialog dcl_file))              ;;loaded
	  
	  (while (/= cont 0)
	    (if (not (new_dialog dcl_name dcl_id)) (exit))    ;;display
	  
	    (set_tile "elev" txt)
	    (set_tile sel "1")
	    (action_tile "elev" "(setq txt $value)") 
	    (action_tile "over" "(setq sel $key)")
	    (action_tile "under" "(setq sel $key)") 
	    
	    (action_tile "info" "(bgbz_info)")
	    (action_tile "accept" "(done_dialog 1)")
	    (action_tile "exit" "(done_dialog 0)")
	    
	    (setq cont (start_dialog))
	    (if (= cont 1)
	      (progn
		(cond  
		  ((eq sel "over") (bgbz_obase txt))
		  ((eq sel "under") (bgbz_ubase txt))
		  (t (princ))
		)
		(princ "\n BGBZ OK.") (princ)
	      )
	      (progn (princ "\n Exit BGBZ.") (princ))
	    )
	  )
	  (setq bgbz_elev_value txt)
	  (unload_dialog dcl_id) (princ)
	)
;********** END  ********************************************************
















