
;*************************** BGBZ.LSP *************************************
	(VMON)
	(defun *error* (msg)
	  (princ "error: ") (princ msg)
          (command "style" "" "" (/ 3.5 m) "" "" "" "")
	)
;************************** OBASE *******************************
        (defun obase (/ dx dist ang pt0 pt1 pt2 pt3 pt4 pt5 txtp)
          (setq dx (abs (- (car pt0) (car pt1))))
          (setq dist (+ dx (/ 6.0 m)))
          (setq ang (angle pt0 pt1))
          (if (and (>= ang (* 0.5 pi)) (<= ang (* 1.5 pi)))
            (progn
              (setq pt3 (polar pt0 pi dist))
              (setq pt1 (polar pt0 pi dx))
            )
            (progn
              (setq pt3 (polar pt0 0.0 dist))
              (setq pt1 (polar pt0 0.0 dx))
            )
          )
          (command "line" pt0 pt3 "")
          (setq ang (angle pt1 pt2))
          (setq pt3 (polar pt1 (/ (* 5.0 pi) 6.0) (/ 5.0 m)))
          (setq pt4 (polar pt1 (/ pi 6.0) (/ 5.0 m)))
          (if (and (>= ang (* 0.5 pi)) (<= ang (* 1.5 pi)))
            (progn
              (setq pt5 (polar pt4 pi (/ 20.0 m)))
              (setq txtp (polar pt4 pi (/ 18.0 m)))
              (setq txtp (polar txtp (* 0.5 pi) (/ 1.5 m)))
              (command "pline" pt3 "w" 0.0 "" pt1 pt4 pt5 "w" (/ 0.5 m) "" "")
              (command "text" txtp 0.0 txt "")
            )
            (progn
              (setq pt5 (polar pt3 0.0 (/ 20.0 m)))
              (setq txtp (polar pt3 0.0 (/ 5.0 m)))
              (setq txtp (polar txtp (* 0.5 pi) (/ 1.5 m)))
              (command "pline" pt4 "w" 0.0 "" pt1 pt3 pt5 "w" (/ 0.5 m) "" "")
              (command "text" txtp 0.0 value "")
            )
          )
        )
      ;*********************** UBASE *********************************
        (defun ubase (pt0 pt1 pt2 txt / dx dist value ang pt3 pt4 pt5 txtp)
          (setq dx (abs (- (car pt0) (car pt1))))
          (setq dist (+ dx (/ 6.0 m)))
          (setq ang (angle pt0 pt1))
          (if (and (>= ang (* 0.5 pi)) (<= ang (* 1.5 pi)))
            (progn
              (setq pt3 (polar pt0 pi dist))
              (setq pt1 (polar pt0 pi dx))
            )
            (progn
              (setq pt3 (polar pt0 0.0 dist))
              (setq pt1 (polar pt0 0.0 dx))
            )
          )
          (command "line" pt0 pt3 "")
          (setq ang (angle pt1 pt2))
          (setq pt3 (polar pt1 (/ (* 7.0 pi) 6.0) (/ 5.0 m)))
          (setq pt4 (polar pt1 (/ (* 11.0 pi) 6.0) (/ 5.0 m)))
          (if (and (>= ang (* 0.5 pi)) (<= ang (* 1.5 pi)))
            (progn
              (setq pt5 (polar pt4 pi (/ 20.0 m)))
              (setq txtp (polar pt4 pi (/ 18.0 m)))
              (setq txtp (polar txtp (* 1.5 pi) (/ 5.0 m)))
              (command "pline" pt3 "w" 0.0 "" pt1 pt4 pt5 "w" (/ 0.5 m) "" "")
              (command "text" txtp 0.0 value "")
            )
            (progn
              (setq pt5 (polar pt3 0.0 (/ 20.0 m)))
              (setq txtp (polar pt3 0.0 (/ 5.0 m)))
              (setq txtp (polar txtp (* 1.5 pi) (/ 5.0 m)))
              (command "pline" pt4 "w" 0.0 "" pt1 pt3 pt5 "w" (/ 0.5 m) "" "")
              (command "text" txtp 0.0 value "")
            )
          )

        )
      ;************************* MAIN ********************************
        (defun c:bgbz (/ sel)
          (if (= m nil) (setq m (getreal "Enter M=")))
          (command "style" "" "" (/ 3.5 m) "" "" "" "")
          (if (or (null basep) (null basev))
            (progn
              (setq basep (getpoint "\n Base elevation point:"))
              (setq basev (getreal "\n Base elevation value:<0>"))
              (if (null basev) (setq basev 0.0))
            )
            (progn
              (princ "\n Note: It is necessary to select a fresh base ")
              (princ "   elev. point, while marking another section.")
              (setq basep1 (getpoint "\n Base elevation point:"))
              (if (null basep1)
                (princ "\n Base elev. point and value is the same as last section.")
                (progn
                  (setq basep basep1)
                  (setq show (strcat "\n Base elevation value" "<" (rots basev 2 0) ">"))
                  (setq basev1 (getreal show))
                  (if (null basev1) (princ) (setq basev basev1))
                )
              )
            )
          )
          (setq x0 (car basep) y0 (cadr basep))
          (setq pt0 (getpoint "\n Baseline From point:"))
          (setq pt1 (getpoint pt0 "\n Elevation-mark is location:"))
          (setq pt2 (getpoint "\n Next Point for direction:"))
          (setq show (strcat "\n Elevation value:<" value ">"))
          (setq txt (getstring show))
          (if (or (= txt "") (= txt " "))
            (setq txt value)
          )
          (setq k "loop")
          (while (= k "loop")
            (princ "\n 0--Exit 1--Marking over baseline 2--Marking under baseline")
            (initget "0 1 2")
            (setq sel (getkword "\n Enter selection:"))
            (cond
              ((eq sel "0") (setq k "skip"))
              ((eq sel "1") (obase))
              ((eq sel "2") (ubase))
            )
    	  )
          (prompt "\n Exit BGBZ...    OK!")
        )
;********************* End of program ********************************
















