;*************************** DMBZ.LSP (ver 2.0) *****************************
	(VMON)
	(defun *error* (msg)
	  ;(command "style" "ACC" "simplex,/acc/acc" 0 0.7 "" "" "")
	  (command "style" "" "" (/ 3.5 m) "" "" "" "" "")
	  (princ "error: ")
	  (princ msg)
	)
;***************************** Select Section Start **17/4-96***********************
	(defun select_section_start (p1 ang sign aw al l1 l2 
				     / vang p11 p12 p121 p122 p13 txtp
				    )
	  (setq vang (+ ang (/ pi 2.0)))
	  (setq p11 (polar p1 ang l1))
	  (setq p12 (polar p1 vang l1))
	  (setq p13 (polar p12 vang al))
	  (setq txtp (polar p12 (+ pi ang) (/ 6.0 m)))
	  (command "pline" p11 p1 p12 "")
	  (setq p121 (polar p12 (+ pi ang) (/ aw 2.0)))
	  (setq p122 (polar p12 ang (/ aw 2.0)))
	  (command "solid" p121 p122 p13 "" "")
	  (command "text" "m" txtp 0.0 sign)
	)          ; select section start
;=======================Select Section End=============================
	(defun select_section_end (p2 ang sign aw al l1 l2 
				   / vang p21 p22 p221 p222 p23 txtp
				  )
	  (setq vang (+ ang (/ pi 2.0)))
	  (setq p21 (polar p2 (+ pi ang) l1))
	  (setq p22 (polar p2 vang l1))
	  (setq p23 (polar p22 vang al))
	  (setq txtp (polar p22 ang (/ 6.0 m)))
	  (command "pline" p21 p2 p22 "")
	  (setq p221 (polar p22 ang (/ aw 2.0)))
	  (setq p222 (polar p22 (+ pi ang) (/ aw 2.0)))
	  (command "solid" p221 p222 p23 "" "")
	  (command "text" "m" txtp 0.0 sign)
	  (command)
	)    ; select section end
;========================== Sign Section =========================
	(defun section_sign (p1 sign scale_text 
				  / txtp p2 p3 sclt s_sign
				 )
	  (setq p2 (polar p1 0.0 (/ 15.0 m)))
	  (setq p3 (polar p1 pi (/ 15.0 m)))
	  (setq txtp (polar p1 (* 0.5 pi) (/ 6.0 m)))
	  (setq s_sign (strcat sign "--" sign))
	  (command "pline" p3 p2 "")
	  (command "style" "" "" (/ 7.0 m) "" "" "" "" "")     
	  (command "text" "m" txtp 0.0 s_sign)
	  (command "style" "" "" (/ 3.5 m) "" "" "" "" "") 
	  (setq txtp (polar p1 (* 1.5 pi) (/ 4.0 m)))
	  (command "text" "m" txtp 0.0 scale_text)
	  (command)
	)    ;sign section and view end


;======================================================================       

;========================== Sign View =========================
	(defun view_sign (p1 sign scale_text 
				  / txtp p2 p3 sclt
				 )
	  (setq p2 (polar p1 0.0 (/ 15.0 m)))
	  (setq p3 (polar p1 pi (/ 15.0 m)))
	  (setq txtp (polar p1 (* 0.5 pi) (/ 6.0 m)))
	  (command "pline" p3 p2 "")
	  (command "style" "" "" (/ 7.0 m) "" "" "" "" "")     
	  (command "text" "m" txtp 0.0 sign)
	  (command "style" "" "" (/ 3.5 m) "" "" "" "" "") 
	  (setq txtp (polar p1 (* 1.5 pi) (/ 4.0 m)))
	  (command "text" "m" txtp 0.0 scale_text)
	  (command)
	)    ;sign section and view end


;======================================================================       


;====================== Select View =====================================
	(defun select_view (p1 ang sign aw al l1 l2 / p2 p221 p222 p3 txtp txtm txta)
	  (setq p2 (polar p1 ang l1))
	  (setq p3 (polar p2 ang al))
	  (if (and (> ang (* 0.5 pi)) (<= ang (* 1.5 pi)))
	    (progn
	      (setq txtm (- ang (* 0.5 pi)))
	      (setq txta (+ (/ (* ang 180.0) pi) 180.0))
	    )
	    (progn
	      (setq txtm (+ ang (* 0.5 pi)))
	      (setq txta (/ (* ang 180.0) pi))
	    )
	  )
	  (setq txtp (polar p1 txtm (/ 6.0 m)))
	  (command "pline" p1 p2 "")
	  (setq p221 (polar p2 (+ ang (* 0.5 pi)) (/ aw 2.0)))
	  (setq p222 (polar p2 (- ang (* 0.5 pi)) (/ aw 2.0)))
	  (command "solid" p221 p222 p3 "" "")
	  (command "text" "m" txtp txta sign)
	) ;select view end

;======================================================================       


;========================info=====================        
(defun dmbz_info ( )
  (if (not (new_dialog "dmbz_info" dcl_id)) (exit)) 
  (action_tile "accept" "(done_dialog)")
  (start_dialog)
)


;===============Modify 10/10-96 CUIJIE===========================
(defun c:dmbz(/ p1 p2 ang dx dy aw al l1 l2 
		sn sign st scale_text ot ortho
		dcl_name dcl_file dcl_id
	     )
  (initget 1)
  (if (= m nil)
    (progn
      (setq m (getreal "\n Enter M=1:"))
      (setq m (/ 1.0 m))
    )
  )
  (setq aw (* 3.0 (/ 0.5 m)))
  (setq al (/ 8.0 m))
  (setq l1 (/ 8.0 m))
  (setq l2 (/ 6.0 m))
   
  
  (setq cont 1 sel "dmbz1" sel_last nil sign "A") 
  (if (= dmbz_scale_text nil) 
    (setq scale_text "1:5") 
    (setq scale_text dmbz_scale_text)
  )
  (setq ot "ortho" st "scale_text" sn "sign")
  (setq ortho (itoa (getvar "orthomode")))   ;orthomode get a int 0 or 1!!!
  
  
  (setq dcl_file "dmbz.dcl")
  (setq dcl_name "dmbz_main")
  (setq dcl_id (load_dialog dcl_file))              ;;loaded
	 
  (while (= cont 1)
    (if (/= sel_last sel)
      (progn
	(cond 
	  ((eq sel "dmbz1") (setq sign "A"))
	  ((eq sel "dmbz2") (setq sign "K"))
	  ((eq sel "dmbz3") (setq sign "A--A"))
	  (t (princ))
	)
      )
    )
    (if (not (new_dialog dcl_name dcl_id)) (exit))    ;;display
    (start_image "dmbz1")
      (setq x1 (dimx_tile "dmbz1"))
      (setq y1 (dimy_tile "dmbz1"))
      (slide_image 0 0 x1 y1 "dmbz1")
    (end_image)
  
    (start_image "dmbz2")
      (setq x1 (dimx_tile "dmbz2"))
      (setq y1 (dimy_tile "dmbz2"))
      (slide_image 0 0 x1 y1 "dmbz2")
    (end_image)
  
    (start_image "dmbz3")
      (setq x1 (dimx_tile "dmbz3"))
      (setq y1 (dimy_tile "dmbz3"))
      (slide_image 0 0 x1 y1 "dmbz3")
    (end_image)
   
    (start_image "dmbz4")
      (setq x1 (dimx_tile "dmbz4"))
      (setq y1 (dimy_tile "dmbz4"))
      (slide_image 0 0 x1 y1 "dmbz4")
    (end_image)
   
   ;initializing
    (mode_tile sel 2)
    (if (or (= sel "dmbz3") (= sel "dmbz4")) 
      (mode_tile st 0) 
      (mode_tile st 1)
    )

    (set_tile sn sign)
    (set_tile st scale_text)
    (set_tile ot ortho)
   
   ;action_tile
    (action_tile "dmbz1" "(mode_tile st 1) (mode_tile ot 0) (setq sel $key)")
    (action_tile "dmbz2" "(mode_tile st 1) (mode_tile ot 0) (setq sel $key)")
    (action_tile "dmbz3" "(mode_tile st 0) (mode_tile ot 1) (setq sel $key)")
    (action_tile "dmbz4" "(mode_tile st 0) (mode_tile ot 1) (setq sel $key)")
    
    (action_tile sn "(setq sign $value)")
    (action_tile st "(setq scale_text $value)")
    (action_tile ot "(setq ortho $value)")             
    
    (action_tile "info" "(dmbz_info)")    
    (action_tile "accept" "(done_dialog 1)")
    (action_tile "exit" "(done_dialog 0)")
     
    (setq cont (start_dialog))
    
    (setq sel_last sel)
    (if (= ortho "1") (command "orthomode" 1) (command "orthomode" 0))
    (if (= cont 1)
      (progn   
	(if (= sel "dmbz1")
	  (progn  
	    (command "style" "" "" (/ 7.0 m) "" "" "" "" "")
	    (setq p1 (getpoint "\n Section is location:"))
	    (setq p2 (getpoint p1 "\n Next point:"))
	    (setq ang (angle p1 p2))
	    (select_section_start p1 ang sign aw al l1 l2)
	    (select_section_end p2 ang sign aw al l1 l2)
	  )  
	)   
	(if (= sel "dmbz2")
	  (progn  
	    (command "style" "" "" (/ 7.0 m) "" "" "" "" "")
	    (setq p1 (getpoint "\n View from point:"))
	    (setq p2 (getpoint p1 "\n to point:"))
	    (setq ang (angle p1 p2))
	    (select_view p1 ang sign aw al l1 l2)
	  )  
	)   
	(if (= sel "dmbz3")
	  (progn  
	    (setq p1 (getpoint "\n Section or View sign is location:"))
	    (section_sign p1 sign scale_text)
	  )  
	)   
	(if (= sel "dmbz4")
	  (progn  
	    (setq p1 (getpoint "\n Section or View sign is location:"))
	    (view_sign p1 sign scale_text)
	  )  
	)   
      
      )
    )
  )  ;wend
  (setq dmbz_scale_text scale_text)
  (unload_dialog dcl_id)
  (command "style" "" "" (/ 3.5 m) "" "" "" "" "")
  (princ "\n Exit DMBZ.") (princ)
)     ; main end
;***************************** End of program ************************

