;*************************** DMBZ.LSP (ver 2.0) *****************************
        (VMON)
	(defun *error* (msg)
	  (princ "error: ")
          (princ msg)
          (prompt "\n DMBZ*.DWG not found !")
          (command "style" "" "" (/ 3.5 m) "" "" "" "" "")
	)
;***************************** Select Section Start *************************
        (defun sss(p1 ang mark aw al l1 l2 / vang p11 p12 p13 p121 p122 txtp)
          (setq vang (+ ang (/ pi 2.0)))
          (setq p11 (polar p1 ang l1))
          (setq p12 (polar p1 vang l1))
          (setq p13 (polar p12 vang al))
          (setq p121 (polar p12 ang (/ aw 2.0)))
          (setq p122 (polar p12 ang (/ aw 2.0)))
          (setq txtp (polar p12 (+ pi ang) (/ 6.0 m)))
          (command "pline" p11 p1 p12 "")
          (command "solid" p121 p122 p13 p121 "")
          (command "text" "m" txtp 0.0 mark)
        )
;****************************** Select Section End ************************
        (defun sse(p2 ang mark aw al l1 l2 / vang p21 p22 p23 txtp)
          (setq vang (+ ang (/ pi 2.0)))
          (setq p21 (polar p2 (+ pi ang) l1))
          (setq p22 (polar p2 vang l1))
          (setq p23 (polar p22 vang al))
          (setq txtp (polar p22 ang (/ 6.0 m)))
          (command "pline" p21 p2 p22 "w" aw 0.0 p23 "w" (/ 0.5 m) "" "")
          (command "text" "m" txtp 0.0 mark)
        )
;****************************** Mark Section/View ***************************
        (defun msv(p1 mark / txtp p2 p3)
          (setq p2 (polar p1 0.0 (/ 15.0 m)))
          (setq p3 (polar p1 pi (/ 15.0 m)))
          (setq txtp (polar p1 (* 0.5 pi) (/ 6.0 m)))
          (command "pline" p3 p1 p2 "")
          (command "text" "m" txtp 0.0 mark)
        )
;****************************** Select View ***************************
        (defun sv (p1 ang mark aw al l1 / p2 p3 txtp txtm txta)
          (setq p2 (polar p1 ang l1))
          (setq p3 (polar p2 ang al))
          (if (and (> ang (* 0.5 pi)) (<= ang (* 1.5 pi)))
            (progn
              (setq txtm (- ang (* 0.5 pi)))
              (setq txta (+ (/ (* ang 180.0) pi) 180.0))
            )
            (progn
              (setq txtm (+ ang (* 0.5 pi)))
              (setq txta (/ (* ang 180.0) pi))
            )
          )
          (setq txtp (polar p1 txtm (/ 6.0 m)))
          (command "pline" p1 p2 "w" aw 0.0 p3 "w" (/ 0.5 m) "" "")
          (command "text" "m" txtp txta mark)
        )

;************************* Come from Layout of Furnace **************
	(defun clf (p1 / p2 txt1 txt2)
          (setq txt1 (getstring "\n See Project No.:<306.6.01>"))
          (setq txt2 (getstring "\n See Drawing No.:<-2>"))
          (if (= txt1 "") (setq txt1 "306.6.01"))
          (if (= txt2 "") (setq txt2 "-2"))
          (setq txt2 (strcat "(             " txt2 ")"))
          (setq p2 (list (+ (car p1) (/ 4.5 m)) (cadr p1)))
          (setq p3 (list (+ (car p1) (/ 14.0 m)) (cadr p1)))
          (command "style" "" "" (/ 5.0 m) "" "" "" "" "")
          (command "text" p1 0.0 txt2)
          (command "text" p3 0.0 txt1)
          (command "insert" "dmbz4" p2 scl "" 0.0)
          (command "style" "" "" (/ 7.0 m) "" "" "" "" "")
          (command)
        )

;************************* See Layout of Furnace ********************
	(defun slf (p1 / p2 txt1 txt2)
          (setq txt1 (getstring "\n See Project No.:<306.6.01>"))
          (setq txt2 (getstring "\n See Drawing No.:<-3>"))
          (if (= txt1 "") (setq txt1 "306.6.01"))
          (if (= txt2 "") (setq txt2 "-3"))
          (setq txt2 (strcat "(            " txt2 ")"))
          (setq p2 (list (+ (car p1) (/ 4.5 m)) (cadr p1)))
          (setq p3 (list (+ (car p1) (/ 10.0 m)) (cadr p1)))
          (command "style" "" "" (/ 5.0 m) "" "" "" "" "")
          (command "text" p1 0.0 txt2)
          (command "text" p3 0.0 txt1)
          (command "insert" "dmbz3" p2 scl "" 0.0)
          (command "style" "" "" (/ 7.0 m) "" "" "" "" "")
          (command)
        )

;************************* Come form Furnace ************************
	(defun cff (p1 / p2 txt1)
          (setq txt1 (getstring "\n Come from Drawing No.:<1500-2>"))
          (if (= txt1 "") (setq txt1 "1500-2"))
          (setq txt1 (strcat "(     " txt1 ")"))
          (setq p2 (list (+ (car p1) (/ 4.0 m)) (cadr p1)))
          (command "style" "" "" (/ 5.0 m) "" "" "" "" "")
          (command "text" p1 0.0 txt1)
          (command "insert" "dmbz2" p2 scl "" 0.0)
          (command "style" "" "" (/ 7.0 m) "" "" "" "" "")
        )

;************************* See Furnace ******************************
	(defun sf (p1 / p2 txt1)
          (setq txt1 (getstring "\n See Drawing No.:<1500-3>"))
          (if (= txt1 "") (setq txt1 "1500-3"))
          (setq txt1 (strcat "(    "  txt1 ")"))
          (setq p2 (list (+ (car p1) (/ 4.0 m)) (cadr p1)))
          (command "style" "" "" (/ 5.0 m) "" "" "" "" "")
          (command "text" p1 0.0 txt1)
          (command "insert" "dmbz1" p2 scl "" 0.0)
          (command "style" "" "" (/ 7.0 m) "" "" "" "" "")
          (command)
        )


;**************************** MAIN **********************************
	(defun c:dmbz(/ pt0 pt1 pt2 ang sel k dx dy mark aw al l1 l2 ortho last)
          (initget 1)
          (if (= m nil)
            (setq m (getreal "Enter M="))
          )
          (command "style" "" "" (/ 5.0 m) "" "" "" "" "")
          (setq aw (* 3.0 (/ 0.5 m)))
          (setq al (/ 6.0 m))
          (setq l1 (/ 6.0 m))
          (setq l2 (/ 5.0 m))
          (initget 1)
          (setq pt0 (getpoint "\n DMBZ prompt area:"))
          (setq m1 (getvar "viewsize"))
          (setq m2 (/ m1 250.0))
          (setq scl (/ 1.0 m))
          (setq k 1)
          (while (/= k 0)
            (command "insert" "dmbzpmt" pt0 m2 "" 0.0)
            (setq sel (getint "\n Enter selection:"))
            (setq last (entlast))
            (command "erase" last "")
            (cond ((eq sel 0) (setq k 0))
              ((eq sel 1)
                (setq pt1 (getpoint "\n Section is location:"))
                (setq pt2 (getpoint pt1 "\n Next point:"))
                (setq ang (angle pt1 pt2))
                (setq mark (getstring "\n Section symbole<A>:"))
                (if (or (= mark "") (= mark " ")) (setq mark "A"))
                (setq ortho (getvar "orthomode"))
                (if (= ortho 1)
                  (progn
                    (setq dx (abs (- (car pt1) (car pt2))))
                    (setq dy (abs (- (cadr pt1) (cadr pt2))))
                    (if (and (>= ang 0.0) (< ang (* 0.25 pi)))
                      (progn
                        (setq ang 0.0)
                        (setq pt2 (polar pt1 ang dx))
                      )
                    )
                    (if (and (>= ang (* 0.25 pi)) (< ang (* 0.75 pi)))
                      (progn
                        (setq ang (* 0.5 pi))
                        (setq pt2 (polar pt1 ang dy))
                      )
                    )
                    (if (and (>= ang (* 0.75 pi)) (< ang (* 1.25 pi)))
                      (progn
                        (setq ang pi)
                        (setq pt2 (polar pt1 ang dx))
                      )
                    )
                    (if (and (>= ang (* 1.25 pi)) (< ang (* 1.75 pi)))
                      (progn
                        (setq ang (* 1.5 pi))
                        (setq pt2 (polar pt1 ang dy))
                      )
                    )
                    (if (and (>= ang (* 1.75 pi)) (< ang (* 2.0 pi)))
                      (progn
                       (setq ang 0.0)
                       (setq pt2 (polar pt1 ang dx))
                      )
                    )
                  )
                )
                (sss pt1 ang mark aw al l1 l2)
                (sse pt2 ang mark aw al l1 l2)
              )
              ((eq sel 2)
                (setq pt1 (getpoint "\n View is location:"))
                (setq pt2 (getpoint pt1 "\n Next point:"))
                (setq ang (angle pt1 pt2))
                (setq mark (getstring "\n View symbole<K>:"))
                (if (or (= mark "") (= mark " ")) (setq mark "K"))
                (setq ortho (getvar "orthomode"))
                (if (= ortho 1)
                  (progn
                    (if (and (>= ang 0.0) (< ang (* 0.25 pi)))
                      (setq ang 0.0)
                    )
                    (if (and (>= ang (* 0.25 pi)) (< ang (* 0.75 pi)))
                      (setq ang (* 0.5 pi))
                    )
                    (if (and (>= ang (* 0.75 pi)) (< ang (* 1.25 pi)))
                      (setq ang pi)
                    )
                    (if (and (>= ang (* 1.25 pi)) (< ang (* 1.75 pi)))
                      (setq ang (* 1.5 pi))
                    )
                    (if (and (>= ang (* 1.75 pi)) (< ang (* 2.0 pi)))
                      (setq ang 0.0)
                    )
                  )
                )
                (sv pt1 ang mark aw al l1)
              )
              ((eq sel 3)
                (setq pt1 (getpoint "\n Mark is location:"))
                (setq mark (getstring "\n Section symbole<A--A>:"))
                (if (or (= mark "") (= mark " ")) (setq mark "A--A"))
                (msv pt1 mark)
              )
              ((eq sel 4)
                (setq pt1 (getpoint "\n Write to point:"))
                (cff pt1)
              )
              ((eq sel 5)
                (setq pt1 (getpoint "\n Write to point:"))
                (sf pt1)
              )
              ((eq sel 6)
                (setq pt1 (getpoint "\n Write to point:"))
                (clf pt1)
              )
              ((eq sel 7)
                (setq pt1 (getpoint "\n Write to point:"))
                (slf pt1)
              )
              (t (setq k 1))
            )
          )
          (command "style" "" "" (/ 3.5 m) "" "" "" "" "")
          (prompt "\n Exit BMBZ...           OK!")
	)
;***************************** End of program ************************

;¯
;ȡ¯
;   ¯
;ȡ   ¯