=========================GHZL.lsp ==========================        ==============================GB2992-82================================ 

			    GB2992-82

=====================================================================
(VMON)
(defun *error* (msg)
  (command "style" "ACC" "simplex,acc" 0.0 "" "" "" "")
  (command "style" "standard" "" (/ 3.5 m) "" "" "" "" "")
  (princ "error: ")
  (princ msg)
)
;************************two wedge bricks*****************
(defun wedges_sel (arche_rad arche_ang arche_th brk_th brk_len
		   / cont1 cont2 cont name msg_txt)
  (setq cont "loop" cont1 nil cont2 nil b 0.0 a 0.0 a1 0.0 c 0.0)
  (setq path "f:/apps/block/ghzl_brk.dat")
  (setq data (open path "r"))
  (prompt "\n Finding bricks...") (princ)
  (while (= cont "loop") 
    (setq name (read-line data))
    (setq subname (substr name 1 2))
    (if (/= name "eof") 
      (if (or (= subname "Tc") (= subname "Ts") (= subname "Tk"))
	(progn
	  (setq b (atof (read-line data)))
	  (setq a (atof (read-line data)))
	  (setq a1 (atof (read-line data)))
	  (setq c (atof (read-line data)))
	  (if (or (= c 230.0) (= b 230.0))
	    (setq aa (+ 1.0 a))
	    (setq aa (+ 2.0 a))
	  )  
	  (if (= a 114.0) (setq aa (+ 2.0 a)))  
	  (setq r (/ (* aa b) (- a a1)))
	  (setq k (/ (* 2.0 pi b) (- a a1)))
	  (if (and (= b arche_th) (= a brk_th) (= c brk_len) (< r arche_rad))
	    (progn 
	      (setq sml_name name)
	      (setq sml_b b)
	      (setq sml_a a)
	      (setq sml_a1 a1)
	      (setq sml_c c)
	      (setq sml_r r)
	      (setq sml_k k)
	      (setq cont1 "ok")
	    )
	  )            
	  (if (and (= b arche_th) (= a brk_th) (= c brk_len) (> r arche_rad))
	    (progn
	      (setq big_name name)
	      (setq big_b b)
	      (setq big_a a)
	      (setq big_a1 a1)
	      (setq big_c c)
	      (setq big_r r)
	      (setq big_k k)
	      (setq cont2 "ok")
	    )
	  )  
	  (if (and (= cont1 "ok") (= cont2 "ok")) 
	    (setq cont "ok")
	  )
	)  
      )
      (setq cont "skip")
    )
  )
  (close data)
  (if (= cont "ok") 
    (progn 
      (princ "OK.")
      (wedges_q arche_rad arche_ang big_name big_r big_k sml_name sml_r sml_k)
  ;    (setq msg_txt (strcat "  " sml_name " " sml_q "   "  big_name " " big_q))
  ;    (message msg_txt)
      
      ;wedges 
      (bricks_mark big_name big_q sml_name sml_q) 
    )
    (progn
      (setq msg_txt "  No bricks found.")
      (message msg_txt)          
    )
  )
)        ;wedges_sel

;==============two wedge bricks calculation======================
(defun wedges_q (arche_rad arche_ang 
		 big_name big_r big_k 
		 sml_name sml_r sml_k)
  (setq big_dr (/ (- big_r sml_r) big_k))
  (setq sml_dr (/ (- big_r sml_r) sml_k))
  (setq big_q (* arche_ang (- arche_rad sml_r)))
  (setq big_q (rtos (/ big_q 360.0 big_dr) 2 0))
  (setq sml_q (* arche_ang (- big_r arche_rad)))
  (setq sml_q (rtos (/ sml_q 360.0 sml_dr) 2 0))     ;itoa with mode and luprec
  ;(bricks_mark big_name big_q sml_name sml_q) 
)   ;wedge_q
;*********************************************************




;********************rect and wedge brick****************
(defun rect_wedge_sel (arche_rad arche_ang arche_th brk_th brk_len
		   / cont1 cont2 name msg_txt)
   ;=============find wedge brick================
  (setq b 0.0 a 0.0 c 0.0 sml_r 0.0 name "start" sml_name nil)
  (setq path "f:/apps/block/ghzl_brk.dat")
  (setq data (open path "r"))
  (prompt "\n Finding wedge brick...") (princ)
  (while (/= name "eof") 
    (setq name (read-line data))   
    (setq subname (substr name 1 2))   
    (if (or (= subname "Tc") (= subname "Ts") (= subname "Tk"))
      (progn
	(setq b (atof (read-line data)))   
	(setq a (atof (read-line data)))
	(setq a1 (atof (read-line data)))
	(setq c (atof (read-line data)))
	(if (or (= c 230.0) (= b 230.0))
	  (setq aa (+ 1.0 a))
	  (setq aa (+ 2.0 a))
	)  
	(if (= a 114.0) (setq aa (+ 2.0 a)))  
	(setq r (/ (* aa b) (- a a1)))
	(setq k (/ (* 2.0 pi b) (- a a1)))
	(if (and (= b arche_th) (= a brk_th) (= c brk_len)
		 (< r arche_rad) (> r sml_r))
	  (progn 
	    (setq sml_name name)   ;sml_name=wedge brick name
	    (setq sml_b b)
	    (setq sml_a a)
	    (setq sml_a1 a1)
	    (setq sml_c c)
	    (setq sml_r r)
	    (setq sml_k k)
	    (setq cont1 "ok")
	  )
	)            
      )  
    )
  )       ;while name/= eof
  (if (= sml_name nil) (setq cont1 "skip"))   
  (close data)   
  (if (= cont1 "ok") 
    (princ "OK.")
    (progn 
      (setq msg_txt "  No wedge brick found.")
      (message msg_txt)          
    )
  )  
;================find rect brick================
  (setq cont2 "loop" name nil b 0.0 a 0.0 c 0.0)
  (setq path "f:/apps/block/ghzl_brk.dat")
  (setq data (open path "r"))
  (prompt "\n Finding rectang brick...") (princ)
  (while (= cont2 "loop") 
    (setq name (read-line data))   
    (setq subname (substr name 1 2))   
    (if (and (/= name "eof") (= subname "Tz"))
      (progn
	(setq a (atof (read-line data)))   
	(setq b (atof (read-line data)))
	(setq c (atof (read-line data)))
	;Tc Ts_Tz
	(if (and (= c brk_th)       
		(or (and (= a arche_th) (= b brk_len))
		    (and (= b arche_th) (= a brk_len))
		 )
	    )
	  (progn
	    (setq big_name name)    ;big_name=rect brick name 
	    (setq big_a a) 
	    (setq big_b b)
	    (setq big_c c)
	    (if (or (= sml_a 230.0) (= sml_b 230.0))
	      (setq big_c (+ 1.0 c))
	      (setq big_c (+ 2.0 c))
	    )  
	    (setq cont2 "ok")
	  )
	)
	
	;Tk_Tz
	(if (and (= b brk_th) (= (substr sml_name 1 2) "Tk")
		 ( = a arche_th) (= c brk_len)
	    )
	  (progn
	    (setq big_name name)    ;big_name=rect brick name 
	    (setq big_a a) 
	    (setq big_b b)
	    (setq big_c c)
	    (if (or (= sml_a 230.0) (= sml_b 230.0))
	      (setq big_c (+ 1.0 b))  ;b-->c for call calc
	      (setq big_c (+ 2.0 b))
	    )  
	    (setq cont2 "ok")
	  )
	)
      
      
      )
      (setq cont2 "skip")
    )  
  )  
  (close data)
  (if (and (= cont1 "ok") (= cont2 "ok"))
    (progn 
      (princ "OK.")
      (rect_wedge_q arche_rad arche_ang big_name big_c sml_name sml_r sml_k)
;      (setq msg_txt (strcat "  " sml_name " " sml_q "   "  big_name " " big_q))
;      (message msg_txt)
      (setq big_name (strcat big_name " "))
      ;rect and wedge
      (bricks_mark big_name big_q sml_name sml_q) 
    )
    (progn 
      (setq msg_txt "  No rectang brick found.")
      (message msg_txt)          
    )
  )
) ;rect_wedge_sel

;==============rect-wedge brick calculation=================== 
(defun rect_wedge_q (arche_rad arche_ang 
		     big_name big_c 
		     sml_name sml_r sml_k) 
  (setq big_dr (/ big_c (* 2.0 pi)))
  (setq big_q (* arche_ang (- arche_rad sml_r)))
  (setq big_q (rtos (/ big_q 360.0 big_dr) 2 0))
  (setq sml_q (rtos (/ (* arche_ang sml_k) 360.0) 2 0))     ;itoa with mode and luprec
  ;(bricks_mark big_name big_q sml_name sml_q) 
)   ;rect_wedge_q


;**********************************************************
;=========================show and mark=======================
(defun bricks_mark (big_name big_q sml_name sml_q 
		    / cont ang a90 a270
		      p1 p2 p21 p3 p4 p5 p6 
		      hz1 hz2 txt1 txt2 
		      hz1_len hz2_len txt1_len txt2_len len
		      sml_txt big_txt
		   )
  
  (setq sml_txt (strcat "      " sml_name "          " sml_q))   
  (setq big_txt (strcat "      " big_name "          " big_q))
  
  (if (not (new_dialog "ghzl_result" dcl_id)) (exit)) 
  
  (set_tile "sml_brk" sml_txt)
  (set_tile "big_brk" big_txt)
    
  (action_tile "accept" "(done_dialog 1)")
  (action_tile "mark" "(done_dialog -1)")  
  (setq cont (start_dialog))
  
  (if (= cont -1)
    (progn
      (setq p1 (getpoint "\n Leader from point:"))
      (setq p2 (getpoint p1 "\n to point:"))
      (command "line" p1 p2 "") 
      (setq p21 (getpoint p2 "\n Side to Mark ?"))  
      (setq ang (angle p2 p21))
     ; (setq ang (angle p1 p2))
      (setq hz1 "ÿ")
      (setq hz2 "")
      (setq txt1 (strcat sml_name " " sml_q))
      (setq txt2 (strcat " " big_name " " big_q))
      (setq hz1_len (* (strlen hz1) (* 0.7 (/ 3.5 m))))
      (setq hz2_len (* (strlen hz2) (* 0.7 (/ 3.5 m))))
      (setq txt1_len (* (strlen txt1) (* 0.7 (/ 3.5 m))))
      (setq txt2_len (* (strlen txt2) (* 0.7 (/ 3.5 m))))
      (setq len (+ hz1_len hz2_len txt1_len txt2_len))
    ;  (if (and (> ang (* 0.5 pi)) (< ang (* 1.5 pi)))  
    ;    (progn
    ;      (setq p6 (polar p2 pi len))
    ;      (setq p1 (polar (polar p2 pi len) (* 0.5 pi) (/ 1.0 m)))
    ;    )
    ;    (progn
    ;      (setq p6 (polar p2 0.0 len))
    ;      (setq p1 (polar p2 (* 0.5 pi) (/ 1.0 m)))
    ;    )
    ;  )
  
      (setq a90 (* 0.5 pi))
      (setq a270 (* 1.5 pi))
      (if (and (>= ang a90) (< ang a270))
	(progn
	  (setq p6 (polar p2 pi len))
	  (setq p1 (polar (polar p2 pi len) (* 0.5 pi) (/ 1.0 m)))
	)
	(progn
	  (setq p6 (polar p2 0.0 len))
	  (setq p1 (polar p2 (* 0.5 pi) (/ 1.0 m)))
	)
      )
    
      (command "line" p2 p6 "")
      (setq p2 (polar p1 0.0 (- hz1_len (* 1.0 (/ 3.5 m)))))
      (setq p3 (polar p2 0.0 txt1_len))    
      (setq p4 (polar p3 0.0 hz2_len))     
      (setq p5 (polar p4 0.0 txt2_len))
      (command "style" "ACC" "simplex,acc" (/ 4.5 m) 0.7 "" "" "" "")
      (command "text" p1 0.0 hz1)
      (command "text" p3 0.0 hz2)
      (command "text" p5 0.0 hz2)
      (command "style" "standard" "" (/ 3.5 m) 0.7 "" "" "" "")     
      (command "text" p2 0.0 txt1)
      (command "text" p4 0.0 txt2)
      (command "style" "ACC" "simplex,acc" 0.0 "" "" "" "")
    )
  )
)

;ÿ
;
;
;

;========================action DCL==============================

;========================help=====================        
(defun ghzl_help ( )
  (if (not (new_dialog "ghzl_help" dcl_id)) (exit)) 
  
  (start_image "ghzl_brk")
    (setq x1 (dimx_tile "ghzl_brk"))
    (setq y1 (dimy_tile "ghzl_brk"))
    (slide_image 0 0 x1 y1 "ghzl_brk")
  (end_image)
  
  (action_tile "accept" "(done_dialog)")
  (start_dialog)
)

;========================info=====================        
(defun ghzl_info ( )
  (if (not (new_dialog "ghzl_info" dcl_id)) (exit)) 
  (action_tile "accept" "(done_dialog)")
  (start_dialog)
)


;==========================select entities==============
(defun select ( / ang rad ang1 ang2
		  ent_selected ent_name ent_list ent_title
		  ent_bugle
		  cta arf
		  cont sel
		  msg_txt
		  cont
	      )
  (setq ent_selected nil ent_name nil ent_list nil
	ent_txt nil ent_title nil pi 3.14159 cont nil)
  
  (setq ent_name (entsel "\n Please select an inside arche-line:" ))
  (if (/= ent_name nil)
    (progn
      (setq ent_name (car ent_name))
      (setq ent_list (entget ent_name))
      (setq ent_title (cdr (assoc '0 ent_list)))
      (if (= ent_title "ARC")
	(progn
	  (setq arche_rad (cdr (assoc '40 ent_list)))
	  (setq ang1 (cdr (assoc '50 ent_list)))             
	  (setq ang2 (cdr (assoc '51 ent_list)))              
	  (if (> ang2 ang1)
	    (setq arche_ang (- ang2 ang1))
	    (progn
	      (setq arche_ang (- ang1 ang2))           
	      (setq arche_ang (- (* 2.0 pi) arche_ang))
	    )
	  )              
	  (setq arche_ang (* (/ 180.0 pi) arche_ang))
	)
      )
      (if (= ent_title "CIRCLE") 
	(progn
	  (setq arche_rad (cdr (assoc '40 ent_list)))
	  (setq arche_ang 360.0)
	)
      )
      (if (= ent_title "POLYLINE") 
	(progn
	  (setq cont "loop")
	  (while (= cont "loop")
	    (setq ent_name (entnext ent_name))
	    (setq ent_list (entget ent_name))
	    (setq ent_bugle (cdr (assoc '42 ent_list)))
	    (if (/= ent_bugle 0.0)
	      (progn
		(setq ent_x1 (cadr (assoc '10 ent_list)))   
		(setq ent_y1 (caddr (assoc '10 ent_list)))   
		(setq ent_p1 (list ent_x1 ent_y1))
		(setq ent_name (entnext ent_name))  
		(setq ent_list (entget ent_name))    
		(setq ent_x2 (cadr (assoc '10 ent_list)))   
		(setq ent_y2 (caddr (assoc '10 ent_list)))   
		(setq ent_p2 (list ent_x2 ent_y2))
	
		(setq dist (distance ent_p1 ent_p2))  
		(setq h (/ (* ent_bugle dist) 2.0))
		(setq cta (- pi (* 2.0 (atan (/ dist 2.0 h)))))
		(setq arche_ang (* 2.0 cta))
		(setq arche_ang (* 180 (/ arche_ang pi)))
		(setq arche_rad (/ dist 2.0 (sin cta)))
		(if (> arche_ang 360.0) 
		  (progn
		    (setq arche_ang (- 720.0 arche_ang))
		    (setq arche_rad (abs arche_rad))
		  )
		)
		(setq cont "ok")
	      )
	    )
	  )
	)
      )
    )
    (progn 
      (setq msg_txt "  No any entity found.")
      (message msg_txt)          
    )
  )
)  ;select termination

;=======================message=====================

(defun message (msg_txt)
  (if (not (new_dialog "ghzl_message" dcl_id)) (exit)) 
  (set_tile "message" msg_txt)
  (action_tile "accept" "(done_dialog)")
  (start_dialog)
)        


;=========================list=================
(defun arche_th_list ()
  ;arche_th
  ; 0    1     2    3
  ;114  150   230  300
  (start_list "arche_th" 3) 
    (add_list "114")          ;no0
    (add_list "150")          ;no1
    (add_list "230")          ;no2
    (add_list "300")          ;no3
  (end_list)
)

(defun brk_len_list ()
  ;arche_th
  ; 0    1     2    3
  ;114  150   230  300
  ;bricks_len: c
  ; 0    1     2     3    4     5    6
  ;65   114   150   172  225   230  300
  (if (= arche_th_no "0")       ;114
    (progn
      (start_list "brk_len" 3) 
      (add_list "230")        ;no0
      (end_list)
      (set_tile "brk_len" "0")                          ;only new_list no
    )
  )  
  (if (= arche_th_no "1")       ;150
    (progn
      (start_list "brk_len" 3) 
      (add_list "300")        ;no0
      (end_list)
      (set_tile "brk_len" "0")                          ;only new_list no
    )
  )  
  (if (= arche_th_no "2")       ;230
    (progn
      (start_list "brk_len" 3) 
      (add_list "114")        ;no0
      (add_list "172")        ;n01  
      (add_list "65")         ;no2
      (end_list)
      (if (= brk_th_no "2") 
	(set_tile "brk_len" "2") 
	(set_tile "brk_len" brk_len_no)
      )
    )
  )  
  (if (= arche_th_no "3")        ;300
    (progn
      (start_list "brk_len" 3) 
      (add_list "150")         ;no0
      (add_list "225")         ;no1
      (end_list)
      (if (= brk_len_no "0") (set_tile "brk_len" "0"))  ;let new_list no
      (if (= brk_len_no "1") (set_tile "brk_len" "1"))
    )
  )  
)

(defun brk_th_list ()
  ;arche_th
  ; 0    1     2    3
  ;114  150   230  300
  ;brk_th
  ; 0    1     2 
  ;65   75    114 
  (if (or (= arche_th_no "0") (= arche_th_no "1") (= arche_th_no "3"))
    (progn
      (start_list "brk_th" 3)
      (add_list "65")           ;no0
      (add_list "75")           ;no1
      (end_list)
      (if (= brk_th_no "0") (set_tile "brk_th" "0"))  ;let new_list no
      (if (= brk_th_no "1") (set_tile "brk_th" "1"))
    )
  )
  (if (= arche_th_no "2")
    (progn
      (start_list "brk_th" 3)
      (add_list "65")           ;no0
      (add_list "75")           ;no1
      (add_list "114")          ;no2
      (end_list)
      (if (= brk_len_no "2") 
	(set_tile "brk_th" "2") 
	(set_tile "brk_th" brk_th_no)
      )
    )
  )
)


;====================main===========================
(defun c:ghzl ( / cont sel)
  (command "regenauto" "off")    ;;Regen off 
  (initget 1)
  (if (= nil m)  
    (progn
      (setq m (getreal "Enter M=1:"))
      (setq m (/ 1.0 m))
      (command "style" "standard" "" (/ 3.5 m) "" "" "" "" "")
      (command)
    )
  )
  (if (= ghzl_arche_rad nil)
    (setq arche_rad 0.0)
    (setq arche_rad ghzl_arche_rad)
  )
  (if (= ghzl_arche_ang nil)
    (setq arche_ang 0.0)
    (setq arche_ang ghzl_arche_ang)
  )
  
  (setq dcl_file "ghzl.dcl")
  (setq dcl_name "ghzl_main") 
  (setq dcl_id (load_dialog dcl_file))              ;;loaded
  
 ;================================================== 
  (if (not (new_dialog dcl_name dcl_id)) (exit))    ;;display 1
  (set_tile "input" "0")  
  (mode_tile "arche" 1)
  (mode_tile "brick" 1)
  (mode_tile "style" 1)
  (mode_tile "accept" 1)  
  ;(mode_tile "cancel" 1)  
  
  ;OK cancel Help Info:
  (action_tile "help" "(ghzl_help)")
  (action_tile "info" "(ghzl_info)")  
  (action_tile "select" "(done_dialog 1)")
  (action_tile "input" "(done_dialog -1)")  
  (action_tile "cancel" "(done_dialog 0)")    
  
  (setq cont (start_dialog))
  
  (if (= cont 1) (select))    
  (if (/= cont 0)
    (progn
      (if (not (new_dialog dcl_name dcl_id)) (exit))    ;;display 2
      (set_tile "arche_rad" (rtos arche_rad 2 2))
      (set_tile "arche_ang" (rtos arche_ang 2 2))

      ;initializing list...
      (setq sel nil)
      (arche_th_list) 
      (set_tile "arche_th" "0")
      (setq arche_th_no "0")      ;114
      (setq brk_len_no "0")     ;230
      (brk_len_list) 
      (setq brk_th_no "0")     ;65
      (brk_th_list)
	  
      (set_tile "wedges" "1")
      (set_tile "rect_wedge" "0")
      (set_tile "input" "1")
      (mode_tile "select" 1)
      (mode_tile "input" 1)
      
      ;arche: 
      (action_tile "arche_rad" "(setq arche_rad (atof $value))")
      (action_tile "arche_ang" "(setq arche_ang (atof $value))")  
  
      (action_tile "arche_th" "(setq arche_th_no $value) (brk_len_list) (brk_th_list)") 
      (action_tile "brk_len" "(setq brk_len_no $value) (brk_th_list)")
      (action_tile "brk_th" "(setq brk_th_no $value) (brk_len_list)")
  
      ;adaption style:
      (action_tile "wedges" "(setq sel $key)")
      (action_tile "rect_wedge" "(setq sel $key)")
  
      ;OK cancel Help Info:
      (action_tile "help" "(ghzl_help)")
      (action_tile "info" "(ghzl_info)")  
      (action_tile "accept" "(done_dialog 1)")
      (action_tile "cancel" "(done_dialog 0)")
  
      (setq cont (start_dialog))
  
      ;let valume:
      ;arche_th
      (if (= arche_th_no "0") (setq arche_th 114.0))
      (if (= arche_th_no "1") (setq arche_th 150.0))
      (if (= arche_th_no "2") (setq arche_th 230.0))
      (if (= arche_th_no "3") (setq arche_th 300.0))
  
      ;brk_len
      (if (= arche_th_no "0") (setq brk_len 230.0)) ;b114 ;c230  
      (if (= arche_th_no "1") (setq brk_len 300.0)) ;b150 ;c300
      (if (= arche_th_no "2")
	(progn
	  (if (= brk_len_no "0") (setq brk_len 114.0))
	  (if (= brk_len_no "1") (setq brk_len 172.0)) 
	  (if (or (= brk_th_no "2") (= brk_len_no "2")) (setq brk_len 65.0)) 
	)
      )
      (if (= arche_th_no "3")
	(progn
	  (if (= brk_len_no "0") (setq brk_len 150.0)) 
	  (if (= brk_len_no "1") (setq brk_len 225.0)) 
	)
      )
  
      ;brk_th
      (if (or (= arche_th_no "0") (= arche_th_no "1") (= arche_th_no "3"))
	(progn
	  (if (= brk_th_no "0") (setq brk_th 65.0))
	  (if (= brk_th_no "1") (setq brk_th 75.0))
	)
      )  
      (if (= arche_th_no "2") 
	(progn 
	  (if (= brk_th_no "0") (setq brk_th 65.0))
	  (if (= brk_th_no "1") (setq brk_th 75.0))
	  (if (or (= brk_len_no "2") (= brk_th_no "2")) (setq brk_th 114.0))
	)
      )
      
      (setq ghzl_arche_rad arche_rad)
      (setq ghzl_arche_ang arche_ang)
      
      (if (= cont 1)  
	(progn  
	  (setq arche_rad (+ arche_rad arche_th)) 
	  (if (or (= sel "wedges") (= sel nil))
	    (wedges_sel arche_rad arche_ang arche_th brk_th brk_len)
	    (rect_wedge_sel arche_rad arche_ang arche_th brk_th brk_len) 
	  )
	)   
      ) 
    )  
  )    
  (command "style" "ACC" "simplex,acc" 0.0 "" "" "" "")
  (command "style" "standard" "" (/ 3.5 m) "" "" "" "" "")
  (unload_dialog dcl_id)
  (if (= cont 1) 
    (progn (princ "\n GHZL OK.") (princ))
    (progn (princ "\n GHZL cancelled.") (princ))
  )
)
;************************EOF**********************************

