
;********************* JHBZ.LSP **********************
	(VMON)
	(defun *error* (msg)
	  (princ "error: ")
	  (princ msg)
	  (command "style" "" "" (/ 3.5 m) "" "" "" "" "")
	  (terpri)
	)

;===================hor======================      
(defun jhbz_hor (piece_no p1 ang / txtp)
  (setq txtp (polar p1 a90 (/ 1.0 m)))
  (setq txtp (polar txtp ang (/ under_len 2.0)))
  (command "text" "c" txtp 0.0 piece_no)
) ;jhbz_hor end     

;===================ver======================     
(defun jhbz_ver (piece_no p1 ang / txtp)
  (setq txtp (polar p1 a90 (/ 1.0 m)))
  (setq txtp (polar txtp ang (/ under_len 2.0)))
  (command "text" "c" txtp 0.0 piece_no)
)  ;jhbz_ver end    

;===================hor_cont=================      
(defun jhbz_hor_cont (piece_no p1 ang under_len
		      / cont kk ns x1 y1 drta
			txtp
		     )
    
  
  
  (setq txtp (polar p1 a90 (/ 1.0 m)))
  (setq txtp (polar txtp ang (/ under_len 2.0)))
  
  (command "text" "c" txtp 0.0 piece_no)
  
  (while (/= cont 0)
    (setq piece_no_len (strlen piece_no))
    (setq kk nil)
    (setq ns 1)
    (while (<= ns piece_no_len)
      (setq as (ascii (substr piece_no ns 1)))
      (setq ns (+ 1 ns))
      (if (or (and (>= as 48) (<= as 57)) 
	      (= as 46)
	  )
	(princ)
	(setq kk "no")
      )
    )  ;wend
    (if (/= kk "no")
      (progn
	(setq piece_no (atoi piece_no))
	(setq piece_no (+ piece_no 1))    
	(setq piece_no_last (- piece_no 1))    
	(setq piece_no (itoa piece_no))
	(setq piece_no_last (itoa piece_no_last))    
      )
      (setq piece_no_last piece_no)
    )  ;endif
    

    (if (not (new_dialog dcl_name dcl_id)) (exit))    ;;display
    
    (set_tile "piece_no" piece_no)
  ;  (set_tile sel_last "1")
    (mode_tile "buttons" 1)    
    (mode_tile "note" 0)
  ;  (action_tile "hor" "(setq sel $key)") 
  ;  (action_tile "ver" "(setq sel $key)")
  ;  (action_tile "hor_cont" "(setq sel $key)") 
  ;  (action_tile "ver_cont" "(setq sel $key)")   
    
    (action_tile "piece_no" "(setq piece_no $value)")
    
    (action_tile "info" "(jhbz_info)")
    (action_tile "accept" "(done_dialog 1)")
    (action_tile "exit" "(done_dialog 0)")
    
    (setq cont (start_dialog))
    
    (if (= cont 1)
      (progn
	(setq x1 (car p1) y1 (cadr p1))
	(setq drta (/ 2.0 m))
	(if (= ang 0.0)  ;a0
	  (progn
	    (command "line" 
	      (list (+ x1 under_len) y1)
	      (list (+ x1 under_len (/ drta 2.0)) (- y1 drta))
	      (list (+ x1 under_len drta) y1)
	      (list (+ x1 (* 2.0 under_len) drta) y1)          
	      ""
	    )
	    (setq p1 (polar p1 0.0 (+ drta under_len)))
	  ) 
	  (progn         ;a180
	    (command "line" 
	      (list (- x1 under_len) y1)
	      (list (- x1 under_len (/ drta 2.0)) (- y1 drta))
	      (list (- x1 under_len drta) y1)
	      (list (- x1 (* 2.0 under_len) drta) y1)          
	      ""
	    )
	    (setq p1 (polar p1 pi (+ drta under_len)))
	  ) 
	)
	
	(setq txtp (polar p1 a90 (/ 1.0 m)))
	(setq txtp (polar txtp ang (/ under_len 2.0)))
	(command "text" "c" txtp 0.0 piece_no)
      )
    )
  )  ;wend
)   ;end hor_cont   

;===================ver_cont=================      
(defun jhbz_ver_cont (piece_no p1 ang arf under_len
		      / cont kk ns x1 y1 drta 
			p3 txtp
		     )
    
  (setq txtp (polar p1 a90 (/ 1.0 m)))
  (setq txtp (polar txtp ang (/ under_len 2.0)))
  (command "text" "c" txtp 0.0 piece_no)
  (while (/= cont 0)
    (setq piece_no_len (strlen piece_no))
    (setq kk nil)
    (setq ns 1)
    (while (<= ns piece_no_len)
      (setq as (ascii (substr piece_no ns 1)))
      (setq ns (+ 1 ns))
      (if (or (and (>= as 48) (<= as 57)) 
	      (= as 46)
	  )
	(princ)
	(setq kk "no")
      )
    )  ;wend
    (if (/= kk "no")
      (progn
	(setq piece_no (atoi piece_no))
	(setq piece_no (+ piece_no 1))    
	(setq piece_no_last (- piece_no 1))    
	(setq piece_no (itoa piece_no))
	(setq piece_no_last (itoa piece_no_last))    
      )
      (setq piece_no_last piece_no)
    )  ;endif
    

    (if (not (new_dialog dcl_name dcl_id)) (exit))    ;;display
    
    (set_tile "piece_no" piece_no)
  ;  (set_tile sel_last "1")
    (mode_tile "buttons" 1)    
    (mode_tile "note" 0)    
  ;  (action_tile "hor" "(setq sel $key)") 
  ;  (action_tile "ver" "(setq sel $key)")
  ;  (action_tile "hor_cont" "(setq sel $key)") 
  ;  (action_tile "ver_cont" "(setq sel $key)")   
    
    (action_tile "piece_no" "(setq piece_no $value)")
    
    (action_tile "info" "(jhbz_info)")
    (action_tile "accept" "(done_dialog 1)")
    (action_tile "exit" "(done_dialog 0)")
    
    (setq cont (start_dialog))
    
    (if (= cont 1)
      (progn
	(setq x1 (car p1) y1 (cadr p1))
	(if (= arf a90)
	  (progn
	    (if (or (= ang 0.0) (= ang a360))  ;a0 or a360
	      (progn
		(command "line" 
		  (list x1 y1)
		  (list x1 (+ y1 under_len))
		  (list (+ x1 under_len) (+ y1 under_len))              
		  ""
		)
	      ) 
	      (progn         ;a180
		(command "line" 
		  (list x1 y1)
		  (list x1 (+ y1 under_len))
		  (list (- x1 under_len) (+ y1 under_len))              
		  ""
		)
	      ) 
	    )
	    (setq p1 (polar p1 a90 under_len)) 
	  )  ;true  end
	  (progn       ;(arf=a270)
	    (if (or (= ang 0.0) (= ang a360))  ;a0 or a360
	      (progn
		(command "line" 
		  (list x1 y1)
		  (list x1 (- y1 under_len))
		  (list (+ x1 under_len) (- y1 under_len))              
		  ""
		)
	      ) 
	      (progn         ;a180
		(command "line" 
		  (list x1 y1)
		  (list x1 (- y1 under_len))
		  (list (- x1 under_len) (- y1 under_len))              
		  ""
		)
	      ) 
	    )
	    (setq p1 (polar p1 a270 under_len))
	  )  ;false end
	)   ;endif (arf=a90)
	
	(setq txtp (polar p1 a90 (/ 1.0 m)))
	(setq txtp (polar txtp ang (/ under_len 2.0)))
	(command "text" "c" txtp 0.0 piece_no)
      )
    )
  )  ;wend
)   ;end ver_cont   


;========================info=====================        
(defun jhbz_info ( )
  (if (not (new_dialog "jhbz_info" dcl_id)) (exit)) 
  (action_tile "accept" "(done_dialog)")
  (start_dialog)
)

;************************* MAIN ********************************
(defun c:jhbz (/ p0 p1 p2
		 k kk ns sel sel_last
		 under_len ang ang_last
		 dcl_id dcl_name dcl_file
	     )
  (initget 1)
  (if (= m nil)
    (progn
      (setq m (getreal "\n Enter M=1:"))
      (setq m (/ 1.0 m))
    )
  )
  
  (command "regenauto" "off")    ;;Regen off 
  (command "style" "" "" (/ 5.0 m) "" "" "" "" "")
  
  (if (= jhbz_start_no nil) (setq jhbz_start_no "0"))
  
  (setq piece_no jhbz_start_no) 
  (setq p0 "point" sel "hor" sel_last "hor" cont 1)
  (setq under_len (/ 10.0 m))
  
  (setq a90 (* 0.5 pi))
  (setq a180 pi)
  (setq a270 (* 1.5 pi))
  (setq a360 (* 2.0 pi))
  
  (setq dcl_name "jhbz_main")
  (setq dcl_file "jhbz.dcl")
  (setq dcl_id (load_dialog dcl_file))
  (setq k 0)  
  
  (while (/= cont 0)
    (if (not (new_dialog dcl_name dcl_id)) (exit))    ;;display
    
    (setq k (1+ k))    
    
    (setq piece_no_len (strlen piece_no))
    (setq kk nil)
    (setq ns 1)
    (while (<= ns piece_no_len)
      (setq as (ascii (substr piece_no ns 1)))
      (setq ns (+ 1 ns))
      (if (or (and (>= as 48) (<= as 57)) 
	      (= as 46)
	  )
	(princ)
	(setq kk "no")
      )
    )
    (if (/= kk "no")
      (progn
	(setq piece_no (atoi piece_no))
	(setq piece_no (+ piece_no 1))    
	(setq piece_no (itoa piece_no))
      )
    )  
    (set_tile "piece_no" piece_no)
    (set_tile sel_last "1")
    
    (mode_tile "buttons" 0)    
    (mode_tile "note" 1)    
    
    (action_tile "hor" "(setq sel $key)") 
    (action_tile "ver" "(setq sel $key)")
    (action_tile "hor_cont" "(setq sel $key)") 
    (action_tile "ver_cont" "(setq sel $key)")   
    (action_tile "piece_no" "(setq piece_no $value)")
    
    (action_tile "info" "(jhbz_info)")
    (action_tile "accept" "(done_dialog 1)")
    (action_tile "exit" "(done_dialog 0)")
    
    (setq cont (start_dialog))
    
    (if (= cont 1)
      (progn
	(setq p0 (getpoint "\n Leader from point:"))
	(setq p1 (getpoint p0 "\n to point:"))
	(if (or (/= sel sel_last) (= k 1)) 
	  (setq x0 (car p1) y0 (cadr p1))
	)
	(setq x1 (car p1) y1 (cadr p1))
	(cond
	  ((eq sel "hor") (setq p1 (list x1 y0)))      
	  ((eq sel "ver") (setq p1 (list x0 y1)))      
	  (t (princ))      
	)            
	
	;p2
	(setq ang (angle p0 p1))
	(if (or (and (>= ang a270) (< ang a360)) 
		(and (>= ang 0.0) (< ang a90))   
	    )
	  (setq ang 0.0)
	  (setq ang pi)
	)
	
	;up & down is centerd
	(if (and (= sel "ver") (= ang 0.0) 
		 (/= sel sel_last)
	    ) 
	  (setq ang_last ang)
	)
	
	(if (and (= sel "ver") (= ang_last 0.0) 
		 (/= ang ang_last) (= sel sel_last)
	    ) 
	  (setq p1 (polar p1 0.0 under_len))
	)
	(if (and (= sel "ver") (= ang_last pi) 
		 (/= ang ang_last) (= sel sel_last)
	    ) 
	  (setq p1 (polar p1 pi under_len))
	)
	
	(if (= sel "hor_cont")
	  (progn
	   (command "line" p0 p1 "")
	    (setq p3 (getpoint p1 "\n Side to mark continually ?"))
	    (setq ang (angle p1 p3))
	    (if (and (>= ang a90) (< ang a270))
	      (setq ang a180)
	      (setq ang 0.0)
	    )
	    (setq p2 (polar p1 ang under_len))        
	    (command "line" p1 p2 "")          
	  )
	  (progn
	    (setq p2 (polar p1 ang under_len))        
	    (command "line" p0 p1 p2 "")
	  )
	)
	
	(if (= sel "ver_cont")
	  (progn
	    (setq p3 (getpoint p1 "\n Up or down to mark continually ?"))
	    (setq arf (angle p1 p3))
	    (if (and (>= arf 0.0) (< arf a180))
	      (setq arf a90)
	      (setq arf a270)
	    )
	  )
	)
	
	
	(cond
	  ((eq sel "hor") (jhbz_hor piece_no p1 ang))      
	  ((eq sel "ver") (jhbz_ver piece_no p1 ang))      
	  ((eq sel "hor_cont") 
	    (jhbz_hor_cont piece_no p1 ang under_len)
	    (setq piece_no piece_no_last)
	    (setq k 0)  ;re-lead
	  )      
	  ((eq sel "ver_cont") 
	    (jhbz_ver_cont piece_no p1 ang arf under_len)
	    (setq piece_no piece_no_last)
	    (setq k 0)  ;re-lead
	  )      
	  (t (princ))      
	)            
      )
    )
    (setq sel_last sel)
  )     ;wend
  (setq jhbz_start_no (itoa (- (atoi piece_no) 1)))
  (command "style" "" "" (/ 3.5 m) "" "" "" "" "")
  (princ"\n Exit JHBZ.")(princ)
)  ;terminate of program.
;****************************************************************************












