;********************** PC.LSP --Polycircle ****************************
        (VMON)
	(defun c:pc (/ mode p0 p1 p2 p3 d r x12 x23 y12 y23 p12 p23 p121 p231)
          (initget "3p 2p Center")
	  (setq mode (getkword "\n Enter mode  3P/2P/Center:<C>"))
          (if (= mode nil) (setq mode "Center"))
;---------------------------- 3p -----------------------------
          (if (= mode "3p")
            (progn
              (setq p1 (getpoint "\n First point of Pcircle:"))
              (setq p2 (getpoint "\n Second point of Pcircle:"))
              (setq p3 (getpoint "\n Third point of Pcircle:"))
              (setq x1 (car p1) y1 (cadr p1))
              (setq x2 (car p2) y2 (cadr p2))
              (setq x3 (car p3) y3 (cadr p3))
              (setq x12 (/ (+ x1 x2) 2) y12 (/ (+ y1 y2) 2))
              (setq x23 (/ (+ x2 x3) 2) y23 (/ (+ y2 y3) 2))
              (setq p12 (list x12 y12) p23 (list x23 y23))
              (setq ang12 (+ (angle p1 p2) (* 0.5 pi)))
              (setq ang23 (+ (angle p2 p3) (* 0.5 pi)))
              (setq p121 (polar p12 ang12 1))
              (setq p231 (polar p23 ang23 1))
              (setq p0 (inters p12 p121 p23 p231 nil))
              (command "pline" p1 "a" "a" 359.99 "c" p0 "")
            )
          )
;-------------------------- 2p -----------------------------
          (if (= mode "2p")
            (progn
              (setq p1 (getpoint "\n First line of Pcircle:"))
              (setq p2 (getpoint "\n Second line of Pcircle:"))
              (setq x1 (car p1) y1 (cadr p1))
              (setq x2 (car p2) y2 (cadr p2))
              (setq x0 (/ (+ x1 x2) 2))
              (setq y0 (/ (+ y1 y2) 2))
              (setq p0 (list x0 y0))
              (command "pline" p1 "a" "a" 359.99 "c" p0 "")
            )
          )
;-------------------------- Center --------------------------------
          (if (= mode "Center")
            (progn
              (setq p0 (getpoint "\n Center of Pcircle:"))
              (setq d (getstring "\n Radius/<Diameter>:"))
              (if (= (strcase d) "R")
                (progn
                  (setq d (getreal "\n Radius:"))
                  (setq d (* 2 d))
                )
                (setq d (atof d))
              )
              (setq p1 (polar p0 0 (/ d 2.0)))
              (command "pline" p1 "a" "a" 359.99 "c" p0 "")
            )
          )
          (prompt "\n A Pcircle OK !       ")
        )
;*********************** End of program *******************
