
;********************* FTL12/PFL.LSP about Flange **********************
	(vmon)
;******************************* error ******************************
	(defun *error* (msg)
	  (princ "error: ")
	  (princ msg)
	  (prompt "\n No exist DN or Data file-PFL.DAT not found !")
	)
;************************ Main view of PN2.5 ************************
	(defun fmv (d d1 d2 b swd swn / p0 ps1 ps2 ang pc ps)
	  (setq p0 (getpoint "\n Center of flange:"))
	  (setq ps1 (polar p0 (/ pi 3.0) (/ d 2.0)))
	  (setq ps2 (polar p0 (/ pi 3.0) (/ d2 2.0)))
	  (command "pline" ps1 "a" "a" 359.99 "c" p0 "")
	  (command "pline" ps2 "a" "a" 359.99 "c" p0 "")
	  (setq ang (/ (* 2.0 pi) swn))
	  (setq alf (/ ang 2.0))
	  (setq k 1)
	  (while (<= k swn)
	    (setq pc (polar p0 alf (/ d1 2)))
	    (setq ps (polar pc (/ pi 3.0) (/ swd 2.0)))
	    (command "pline" ps "a" "a" 359.99 "c" pc "")
	    (setq alf (+ alf ang))
	    (setq k (+ k 1))
	  )
	)
;***********************  Section view of PN2.5 ***************************
	(defun fsv (d d1 d2 b swd swn / p0 ang p1 p2 p3 p4)
	  (setq p0 (getpoint "\n Center of flange:"))
	  (setq p1 (getpoint p0 "\n Second point:"))
	  (setq ang (angle p1 p0))
	  (setq vang (- ang (* 0.5 pi)))
	  (setq p1 (polar p0 vang (/ d 2.0)))
	  (setq p4 (polar p0 (+ vang pi) (/ d 2.0)))
	  (setq p2 (polar p1 ang b))
	  (setq p3 (polar p4 ang b))
	  (command "pline" p1 p2 p3 p4 "c" "")
	  (setq p1 (polar p0 vang (/ d2 2.0)))
	  (setq p4 (polar p0 (+ vang pi) (/ d2 2.0)))
	  (setq p2 (polar p1 ang b))
	  (setq p3 (polar p4 ang b))
	  (command "pline" p1 p2 "")
	  (command "pline" p4 p3 "")
	  (setq p1 (polar p0 vang (+ (/ d1 2.0) (/ swd 2.0))))
	  (setq p4 (polar p0 vang (- (/ d1 2.0) (/ swd 2.0))))
	  (setq p2 (polar p1 ang b))
	  (setq p3 (polar p4 ang b))
	  (command "pline" p1 p2 "")
	  (command "pline" p4 p3 "")
	  (setq p1 (polar p0 (+ vang pi) (- (/ d1 2.0) (/ swd 2.0))))
	  (setq p4 (polar p0 (+ vang pi) (+ (/ d1 2.0) (/ swd 2.0))))
	  (setq p2 (polar p1 ang b))
	  (setq p3 (polar p4 ang b))
	  (command "pline" p1 p2 "")
	  (command "pline" p4 p3 "")
	)
;********************************* main ***********************************
	(defun c:pfl1 ( / std line k kk kkk w dn d0 d d1 d2 b swd swn sww sw)
	  (initget "S U")
	  (setq std (getkword "\n PN0.25MPa Flange  Standard/Unstandard ?<S>"))
	  (if (= std nil) (setq std "S"))
	  (if (= std "S")
	    (progn
	      (setq kk (getstring "\n Enter Metric-Diameter DN=<125>"))
	      (if (or (= kk " ") (= kk "")) (setq kk "125"))
	      (setq path "f:/apps/block/pfl.dat")
	      (setq data (open path "r"))
	      (prompt "\n Reading data, please wait...")
	      (setq k "loop")
	      (while (/= k "skip")
		(setq line (read (read-line data)))
		(setq dn (nth 0 line))
		(if (= kk dn)
		  (progn
		    (setq k "skip")
		    (setq d0 (nth 1 line))
		    (setq d (atof(nth 2 line)))
		    (setq d1 (atof(nth 3 line)))
		    (setq d2 (atof(nth 4 line)))
		    (setq b (atof(nth 5 line)))
		    (setq swd (atof(nth 6 line)))
		    (setq swn (atof(nth 7 line)))
		    (setq sw (nth 8 line))
		    (setq sww (atof(nth 9 line)))
		  )
		)
	      )
	      (prompt "OK")
	    )
	    (progn
	      (setq d (getreal "\n Outside Diameter:"))
	      (setq d2 (getreal "\n inside Diameter:"))
	      (setq d1 (getreal "\n Screws array Diameter:"))
	      (setq b (getreal "\n Thick of flange:"))
	      (setq swd (getreal "\n Screw hole Diameter:"))
	      (setq swn (getreal "\n Nnmber of Screw:"))
	    )
	  )
	  (initget "M S")
	  (setq kkk (getkword "\n Main view/Section view ?<M>"))
	  (if (= kkk nil) (setq kkk "M"))
	  (if (= kkk "M")
	    (fmv d d1 d2 b swd swn)
	    (fsv d d1 d2 b swd swn)
	  )
	  (princ "\n * Screws is ") (princ sw)
	  (princ "   * Pipe diameter is D") (princ d0) (princ " ")
	  (princ "\n * DN") (princ dn) (princ " Flange weight is ") (princ sww) (prompt "kg")
	)
;*************************** End of program ************************
