(defun c:support(/ d0 w0 h0 l0 dcl_id x1 y1 select)
    (defun cirl(de we)
      (sqrt (- (* (/ de 2) (/ de 2))
	       (* (/ we 2) (/ we 2))
	     )
      )
    )


    (defun mid (l h p0 / x0 y0 x1 x2 y0 y3 p1 p2 p3 p4 )
      (setq x0 (car p0) y0 (cadr p0))
      (setq x1 (- x0 (/ l 2.0)) x2 (+ x0 (/ l 2.0)) y3 (+ y0 h))
	  (setq p1 (list x1 y0) p2 (list x2 y0) p3 (list x2 y3) p4 (list x1 y3))
	  (command "pline" p1 p2 p3 p4 "c" "")
    )

    (defun draw (d0 w0 h0 l0 / x y p1 p2 p3 p4 p5 p6 p7 x1 x2 y3 xx yy cpx1 cpy1 tatal num pp1 pp2 ar)
       (defun jh1(pp1 pp2 txt)
	       (command "circle" pp1 "5")
	       (command "line" pp1 pp2 "@-300,0" "")
	       (command "text" (list (- (car pp2) 200) (+ (cadr pp2) 20)) "" txt )
       )


       (defun jh2(pp1 pp2 txt)
	       (command "circle" pp1 "5")
	       (command "line" pp1 pp2 "@300,0" "")
	       (command "text" (list (+ (car pp2) 200) (+ (cadr pp2) 20)) "" txt )
       )

       (setq x 2500.0)
       (setq y 4000.0)
       (setq xx (+ x 2000) yy (- y h0))
       (command "layer" "m" "dvdy" "c" "2" "dvdy" "lt" "divide" "dvdy" "")
       (command "circle" (list x y) (/ d0 2.0) "")
       (command "line" (list (+ x 1500) (+ y (/ d0 2)))
		       "@900,0" "")

       (command "line" (list (+ x 1500) (- y (/ d0 2)))
		       "@900,0" "")
       (command "insert" "fb115" (list (+ x 1500) (- y (/ d0 2))) d0 "" "")
       (command "insert" "fb115" (list (+ x 1500 900) (+ y (/ d0 2))) d0 "" "180")


       (command "layer" "m" "centr" "c" "1" "centr" "lt" "center" "centr" "")
       (command "line" (list (- x (/ d0 2.0) 100.0) y ) "@3500,0" "")
       (command "line" (list x (+ y (/ d0 2.0) 100.0)) "@0,-2000" "")
       (command "line" (list xx (- yy 100.0)) "@0,2000" "")

       (command "layer" "s" "0" "")
       (setq p1 (polar (list x y) (/ (* PI 7.0) 6.0) (/ d0 2.0)))
       (setq p2 (polar (list x y) (/ PI -6.0) (/ d0 2.0)))
       (command "pline" p1 "a" "r" (/ d0 2.0) p2 "")
       (mid w0 '20 (list x (- y h0)))

       (setq p3 (polar (list x y) (/ (* PI 7.0) 6.0) (+ (/ d0 2.0) 20)))
       (setq p5 (polar (list x y) (/ (* PI 7.0) 6.0) (+ (/ d0 2.0) 50)))
       (setq p4 (polar (list x y) (/ PI -6.0) (+ (/ d0 2.0) 20)))
       (setq p6 (polar (list x y) (/ PI -6.0) (+ (/ d0 2.0) 50)))
       (setq p7 (list (+ (- x (/ w0 2)) 10) (+ (- y h0) 20.0)))
       (setq p8 (list (- (+ x (/ w0 2)) 10) (+ (- y h0) 20.0)))
       (command "pline" p7 p5 p3 "a" "r" (+ (/ d0 2) 20) p4 "l" p6 p8 "c")
       (command "pline" p1 p3 "")
       (command "pline" p2 p4 "")
       (setq lf (cirl (+ d0 40) (- w0 200)))
       (command "pline" (list (+ (- x (/ w0 2)) 100) (+ (- y h0) 20))
			(list (+ (- x (/ w0 2)) 100) (- y lf))
			""
       )

       (setq lf (cirl (+ d0 40) (- w0 200 20)))
       (command "pline" (list (+ (- x (/ w0 2)) 120) (+ (- y h0) 20))
	    (list (+ (- x (/ w0 2)) 120) (- y lf))
			""
       )

       (setq lf (cirl (+ d0 40) (- w0 200)))
       (command "pline" (list (- (+ x (/ w0 2)) 100) (+ (- y h0) 20))
			(list (- (+ x (/ w0 2)) 100) (- y lf))
			""
       )

       (setq lf (cirl (+ d0 40) (- w0 200 20)))
       (command "pline" (list (- (+ x (/ w0 2)) 120) (+ (- y h0) 20))
	    (list (- (+ x (/ w0 2)) 120) (- y lf))
			""
       )

       
       (mid l0 (- h0 (- y (cadr p1))) (list xx yy))
       (command "layer" "m" "dim" "c" "157" "dim" "lt" "continuous" "dim" "")
       (command "pline" (list (- xx (/ l0 2)) (+ yy 20)) (list (+ xx (/ l0 2)) (+ yy 20)) "")
       (command "pline" (list (- xx (/ l0 2)) (cadr p4))
			(list (+ xx (/ l0 2)) (cadr p4)) "")
       (command "pline" (list (- xx 10) (+ yy 20))
			(list (- xx 10) (cadr p4)) "")

       (command "pline" (list (+ xx 10) (+ yy 20))
			(list (+ xx 10) (cadr p4)) "")

       (setq lf (cirl (+ d0 40) (- w0 200)))
       (command "pline" (list (- xx (/ l0 2)) (- y lf))
			(list (- xx 10) (- y lf)) "")

       (command "pline" (list (+ xx (/ l0 2)) (- y lf))
			(list (+ xx 10) (- y lf)) "")

       (command "pline" (list (- xx 10) (cadr p5)) "@20,0" "")

       (command "line" p1 (list x y) p2 "")


       (command "dim" "ver" (list x y) (list x (- y h0))
			    (list (- x (/ d0 2) 250) y) ""
		      "hor" (list (- x (/ w0 2)) (- y h0))
			    (list (+ x (/ w0 2)) (- y h0))
			    (list x (- y h0 450)) ""
		      "hor" (list (- xx (/ l0 2)) yy)
			    (list (+ xx (/ l0 2)) yy)
			    (list xx (- yy 250)) ""
		       "ang" "" (list x y) p1 p2 (list x (- y (/ d0 3))) ""
						 (list x (- y (/ d0 3))) ""

		       "rad" (polar (list x y) (/ (* PI 4.0) 3.0)  (- (/ d0 2.0) 50))
			     (strcat "R" (rtos (+ (/ d0 2.0) 2.0)))
		       "ali" (polar (list x y) (/ (* PI 4.0) 2.8)  (/ d0 2.0))
			     (polar (list x y) (/ (* PI 4.0) 2.8) (+ (/ d0 2.0) 20))
			     (polar (list x y) (/ (* PI 4.0) 2.8) (+ (/ d0 2.0) 20))
			      "   6"
		       "ver" (list x (- y (/ d0 2.0) 20))
			     (list x (+ (- y h0) 20))
			     (list (- x 50) y)
			     (rtos (- h0 (/ d0 2.0) 6 10))
		       "hor" (list (+ (- x (/ w0 2)) 100) (+ (- y h0) 20))
			     (list (+ (- x (/ w0 2)) 120) (+ (- y h0) 20))
			     (list (+ (- x (/ w0 2)) 120) (+ (- y h0) 150))
			     "10  "

		       "hor" (list (- (+ x (/ w0 2)) 100) (+ (- y h0) 20))
			     (list (- (+ x (/ w0 2)) 120) (+ (- y h0) 20))
			     (list (- (+ x (/ w0 2)) 120) (+ (- y h0) 150))
			     "   10"

		       "ver" p7 (list (- x (/ w0 2)) (- y h0))
				(list (- x (/ w0 2) 150) (- y h0))
				"   10"
			"hor" (list (+ (- x (/ w0 2)) 100) (+ (- y h0) 20))
			      (list (- (+ x (/ w0 2)) 100) (+ (- y h0) 20))
			      (list x (- y h0 250)) ""
			"hor" (list (+ xx 10) (- yy 20))
			      (list (- xx 10) (- yy 20))
			      (list (- xx 10) (+ yy 320))
			      "   10"
		       "hor"  (list (- xx (/ l0 2)) (+ yy 300))
			      (list (- xx 10) (+ yy 300))
			      (list (- xx 10) (+ yy 300 500))
			      (rtos (- (/ l0 2) 5))
		       "hor"  (list (+ xx (/ l0 2)) (+ yy 300))
			      (list (- xx 10) (+ yy 300))
			      (list (- xx 10) (+ yy 300 500))
			      (rtos (- (/ l0 2) 5))
		       "hor" p5 p6 (list x (+ y 500)) ""
		       "ver" (list xx (+ yy h0 (/ d0 2)))
			     (list xx (- (+ yy h0) (/ d0 2)))
			     (list (- xx 250) yy)
			     (strcat "%%c" (rtos d0))
		       "exit"
       )

       (setvar "CMDECHO" 0)
       (command "regenauto" "off")
       (command "style" "" "" (/ 5 m) 0.7 "" "" "" "")

       (jh1 (list x (- y (/ d0 2)))
	    (list (- x 1000) (+ y 1000))
	     "1"
	)
       (jh1 (list (+ x (/ w0 3)) (+ (- y h0) 10))
	    (list (- x 1000) (- y h0 500))
	    "2"
       )
       (jh1 (list (- xx (/ l0 3)) (+ yy 80))
	    (list (- xx 800) (- y 500))
	    "3"
	)
	(jh2 (list xx (+ yy 200))
	     (list (+ xx 800) (- y 500))
	     "4"
	)

	(command "style" "" "" (/ 3.5 m) 0.7 "" "" "" "")
	(setvar "CMDECHO" 1)

	(command "insert" "fb003" "7800,840,0" "20" "" "")
	(command "layer" "s" "0" "")

	(setq num 1)
	(setq cpx1 4200 cpy1 1320)
	(while (<= num 4)
	  (setq hz "ְ ")
	  (command "style" "ACC" "simplex,/acc/acc" (/ 4.5 m) 0.7 "" "" "")
	  (command "text" (list (+ 80 cpx1) (+ 20 (* (- num 1) 140) cpy1)) "" (rtos num))
	  (command "text" (list (+ 80 200 cpx1) (+ 20 (* (- num 1) 140) cpy1)) 0.0 hz)
	  (command "style" "standard" "" (/ 3.5 m) "0.7" "" "" "" "")
	  (command "text" (list (+ 80 200 1000 200 cpx1) (+ 20 (* (- num 1) 140) cpy1)) "" "Q235")
	  (setq num (+ num 1))
	)

	(command "style" "standard" "" (/ 3.5 m) "0.7" "" "" "" "")

	(setq txt2 (strcat (rtos (* d0 PI 0.3333)) "x" (rtos l0) "x" "6"))
	(command "text" (list (+ 200 250 cpx1) (+ 20 cpy1)) "" txt2)
	(setq txt2 (strcat (rtos w0) "x" (rtos l0) "x" "10"))
	(command "text" (list (+ 200 250 cpx1) (+ 20 140 cpy1)) "" txt2)
	    (setq lf (cirl (+ d0 12) (- w0 200)))
	    (setq lf (- h0 lf 10))
	    (setq txt2 (strcat (rtos lf) "x" (rtos (/ (- l0 10) 2)) "x" "10"))
	(command "text" (list (+ 200 250 cpx1) (+ 20 140 140 cpy1)) "" txt2)
	  (setq ar (/ (- (* (+ (distance p5 p6) w0)
		    (- h0 (* 0.25 (+ d0 12)) 10)
		    0.5
		 )
		 (* 0.614 (/ (+ d0 12) 2) (/ (+ d0 12) 2))
	      ) 1000000))
	  (setq txt2 (rtos ar 2 2))
	  (setq txt2 (strcat "s=" txt2 "m2"))
	 (command "text" (list (+ 200 250 cpx1) (+ 20 140 140 140 cpy1)) "" txt2)


	(command "text" (list (+ 80 200 1000 cpx1) (+ 20 cpy1)) "" "1")
	(command "text" (list (+ 80 200 1000 cpx1) (+ 20 140 cpy1)) "" "1")
	(command "text" (list (+ 80 200 1000 cpx1) (+ 20 140 140 cpy1)) "" "4")
	(command "text" (list (+ 80 200 1000 cpx1) (+ 20 140 140 140 cpy1)) "" "1")

	(setq tatal 0)

	(command "text" (list (+ 80 200 1000 200 400 cpx1) (+ 20 cpy1)) ""
			(rtos (* d0 PI 0.3333 0.001 l0 0.001 6 0.001 7800) 2 1)
	)
	(command "text" (list (+ 80 200 1000 200 400 300 cpx1) (+ 20 cpy1)) ""
			(rtos (* d0 PI 0.3333 0.001 l0 0.001 6 0.001 7800) 2 1)
	)
	(setq tatal (+ tatal (* d0 PI 0.3333 0.001 l0 0.001 6 0.001 7800)))


	(command "text" (list (+ 80 200 1000 200 400 cpx1) (+ 20 140 cpy1)) ""
			(rtos (* w0 0.001 l0 0.001 10 0.001 7800) 2 1)
	)
	(command "text" (list (+ 80 200 1000 200 400 300 cpx1) (+ 20 140 cpy1)) ""
			(rtos (* w0 0.001 l0 0.001 10 0.001 7800) 2 1)
	)
      (setq tatal (+ tatal (* w0 0.001 l0 0.001 10 0.001 7800)))


	(command "text" (list (+ 80 200 1000 200 400 cpx1) (+ 20 140 140 cpy1)) ""
			(rtos (* lf 0.001 (/ (- l0 10) 2) 0.001 10 0.001 7800) 2 1)
	)
	(command "text" (list (+ 80 200 1000 200 400 300 cpx1) (+ 20 140 140 cpy1)) ""
			(rtos (* lf 0.001 (/ (- l0 10) 2) 0.001 10 0.001 7800 4.0) 2 1)
	)
      (setq tatal (+ tatal (* lf 0.001 (/ (- l0 10) 2) 0.001 10 0.001 7800 4.0)))

	(command "text" (list (+ 80 200 1000 200 400 cpx1) (+ 20 140 140 140 cpy1)) ""
			(rtos (* ar 0.01 7800) 2 1)
	)
	(command "text" (list (+ 80 200 1000 200 400 300 cpx1) (+ 20 140 140 140 cpy1)) ""
			(rtos (* ar 0.01 7800) 2 1)
	)
       (setq tatal (+ tatal (* ar 0.01 7800)))
       (command "style" "standard" "" (/ 6 m) "0.7" "" "" "" "")
       (command "text" (list '7050 '880) "" (rtos tatal 2 1))
       (command "style" "standard" "" (/ 3.5 m) "0.7" "" "" "" "")

	  (setq hz "֧   ")
	  (command "style" "ACC" "simplex,/acc/acc" (/ 8.0 m) 0.7 "" "" "")
	  (command "text" (list '4850 '450) "" hz)
	  (command "style" "ACC" "simplex,/acc/acc" (/ 5.0 m) 0.7 "" "" "")
	  (setq hz "ע:˼E43")
	  (command "text" (list '1050 '900) "" hz)
	  (command "style" "standard" "" (/ 3.5 m) "0.7" "" "" "" "")
	  (princ"\n Support auto_design run OK!")(princ)

	    
)
	(defun info(dcl_id)
	  (if (not(new_dialog "myfirst" dcl_id)) (exit))
	  (action_tile "accept" "(done_dialog)")
	  (start_dialog)
	)

	(defun help(dcl_id)
	  (if (not(new_dialog "mythird" dcl_id)) (exit))
	  (action_tile "accept" "(done_dialog)")
	  (start_dialog)
	)




      (mapcar 'setvar '("cmdecho" "blipmode" "luprec" "expert") '(1 1 0 0))
      (setq dcl_id (load_dialog "support.dcl"))
      (if (not(new_dialog "mysecond" dcl_id)) (exit))
	  (start_image "icon")
	  (setq x1 (dimx_tile "icon"))
	  (setq y1 (dimy_tile "icon"))
      (slide_image 0 0 x1 y1 "support")
	  (end_image)
  
      (action_tile "diameter" "(setq diameter (atof $value))")
      (action_tile "width" "(setq width (atof $value))")
      (action_tile "height" "(setq height (atof $value))")
      (action_tile "length" "(setq length (atof $value))")
      (action_tile "cancel" "(done_dialog 0)")
      (action_tile "info" "(info dcl_id)")
      (action_tile "help" "(help dcl_id)")
      (action_tile "accept" "(done_dialog 1)")

      (setq select (start_dialog))
      (if (= 1 select)
	  (draw diameter width height length)
	  (progn
	    (princ)
	    (prompt"Dialog progrem is cancelled by user")(princ)
	  )
      )
      (unload_dialog dcl_id)(princ)
    
)
