
;********************* FTL13/TFL.LSP about Flange with Hill*************
	(vmon)
;******************************* error ******************************
	(defun *error* (msg)
	  (princ "error: ")
	  (princ msg)
	  (prompt "\n No exist DN/PN or Data file-TFL.DAT not found !")
	)
;************************ Main view ************************
	(defun fmv (d d1 d2 d3 f b swd swn / p0 ps1 ps2 ang pc ps d4)
	  (setq p0 (getpoint "\n Center of flange:"))
	  (setq d4 (+ d2 f f))
	  (setq ps1 (polar p0 (/ pi 3.0) (/ d 2.0)))
	  (setq ps2 (polar p0 (/ pi 3.0) (/ d2 2.0)))
	  (setq ps3 (polar p0 (/ pi 3.0) (/ d3 2.0)))
	  (setq ps4 (polar p0 (/ pi 3.0) (/ d4 2.0)))
	  (command "pline" ps1 "a" "a" 359.99 "c" p0 "")
	  (command "pline" ps2 "a" "a" 359.99 "c" p0 "")
	  (command "pline" ps3 "a" "a" 359.99 "c" p0 "")
	  (command "pline" ps4 "a" "a" 359.99 "c" p0 "")
	  (setq ang (/ (* 2.0 pi) swn))
	  (setq alf (/ ang 2.0))
	  (setq k 1)
	  (while (<= k swn)
	    (setq pc (polar p0 alf (/ d1 2)))
	    (setq ps (polar pc (/ pi 3.0) (/ swd 2.0)))
	    (command "pline" ps "a" "a" 359.99 "c" pc "")
	    (setq alf (+ alf ang))
	    (setq k (+ k 1))
	  )
	)
;***********************  Section view ***************************
	(defun fsv (d d1 d2 d3 f b swd swn / p0 ang p1 p2 p3 p4 p5 p6 p7 p8)
	  (setq p0 (getpoint "\n Center of flange:"))
	  (setq p1 (getpoint p0 "\n Second point:"))
	  (setq ang (angle p1 p0))
	  (setq vang (- ang (* 0.5 pi)))
	  (setq p1 (polar p0 vang (/ d 2.0)))
	  (setq p4 (polar p0 (+ vang pi) (/ d 2.0)))
	  (setq p2 (polar p1 ang (- b f)))
	  (setq p3 (polar p4 ang (- b f)))
	  (setq p5 (polar p2 (+ vang pi) (/ (- d (+ d2 f f)) 2.0)))
	  (setq p8 (polar p5 (+ vang pi) (+ d2 f f)))
	  (setq p6 (polar p5 ang f))
	  (setq p6 (polar p6 (+ vang pi) f))
	  (setq p7 (polar p6 (+ vang pi) d2))
	  (command "pline" p1 p2 p5 p6 p7 p8 p3 p4 "c" "")
	  (setq p1 (polar p0 vang (/ d3 2.0)))
	  (setq p4 (polar p0 (+ vang pi) (/ d3 2.0)))
	  (setq p2 (polar p1 ang b))
	  (setq p3 (polar p4 ang b))
	  (command "pline" p1 p2 "")
	  (command "pline" p4 p3 "")
	  (setq p1 (polar p0 vang (+ (/ d1 2.0) (/ swd 2.0))))
	  (setq p4 (polar p0 vang (- (/ d1 2.0) (/ swd 2.0))))
	  (setq p2 (polar p1 ang (- b f)))
	  (setq p3 (polar p4 ang (- b f)))
	  (command "pline" p1 p2 "")
	  (command "pline" p4 p3 "")
	  (setq p1 (polar p0 (+ vang pi) (- (/ d1 2.0) (/ swd 2.0))))
	  (setq p4 (polar p0 (+ vang pi) (+ (/ d1 2.0) (/ swd 2.0))))
	  (setq p2 (polar p1 ang (- b f)))
	  (setq p3 (polar p4 ang (- b f)))
	  (command "pline" p1 p2 "")
	  (command "pline" p4 p3 "")
	)
;********************************* main ***********************************
	(defun c:tfl ( / std k k1 k2 k3 w dn pn d d0 d1 d2 d3 b swd swn sww sw h)
	  (initget "S U")
	  (setq std (getkword "\n Standard/Unstandard ?<S>"))
	  (if (= std nil) (setq std "S"))
	  (if (= std "S")
	    (progn
	      (initget "0.25 .25 0.6 .6 1 1.0 1.6 2.5")
	      (setq k3 (getkword "\n Enter Metric-Pressure 0.25/0.6/1.0/1.6/2.5MPa PN=<1.6>"))
	      (if (= k3 ".25") (setq k3 "0.25"))
	      (if (= k3 ".6") (setq k3 "0.6"))
	      (if (= k3 "1") (setq k3 "1.0"))
	      (if (= k3 nil) (setq k3 "1.6"))
	      (setq k3 (strcat "*PN" k3 "*"))
	      (setq k1 (getstring "\n Enter Metric-Diameter DN=<125>"))
	      (if (or (= k1 " ") (= k1 "")) (setq k1 "125"))
	      (setq path "f:/apps/block/tfl.dat")
	      (setq data (open path "r"))
	      (prompt "\n Reading data, please wait...")
	      (while (/= k3 (read-line data)))
	      (prompt "OK")
	      (setq k "loop")
	      (while (/= k "skip")
		(setq line (read (read-line data)))
		(setq dn (nth 0 line))
		(if (= k1 dn) (setq k "skip"))
		(setq d0 (atof(nth 1 line)))
		(setq d (atof(nth 2 line)))
		(setq d1 (atof(nth 3 line)))
		(setq d2 (atof(nth 4 line)))
		(setq f (atof(nth 5 line)))
		(setq b (atof(nth 6 line)))
		(setq swd (atof(nth 7 line)))
		(setq swn (atof(nth 8 line)))
		(setq sw (nth 9 line))
		(setq h (atof(nth 10 line)))
		(setq sww (atof(nth 11 line)))
	      )
	      (setq d3 (+ d0 h h))
	      (close data)
	    )
	    (progn
	      (setq d (getreal "\n Outside Diameter:"))
	      (setq d3 (getreal "\n Inside Diameter:"))
	      (setq d1 (getreal "\n Screws array Diameter:"))
	      (setq d2 (getreal "\n Hill Diameter:"))
	      (setq f (getreal "\n Hill height:"))
	      (setq b (getreal "\n Thick of flange:"))
	      (setq swd (getreal "\n Screw hole Diameter:"))
	      (setq swn (getreal "\n Nnmber of Screw:"))
	    )
	  )
	  (initget "M S")
	  (setq k2 (getkword "\n Main view/Section view ?<M>"))
	  (if (= k2 nil) (setq k2 "M"))
	  (if (= k2 "M")
	    (fmv d d1 d2 d3 f b swd swn)
	    (fsv d d1 d2 d3 f b swd swn)
	  )
	  (princ "\n * Screws is ") (princ sw)
	  (princ "  * Pipe Outside-diameter is ") (princ d0) (princ)
	  (princ "\n * DN") (princ dn) (princ " Flange weight is ") (princ sww) (prompt "kg") (princ)
	)
;*************************** End og program ************************






