/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@ctrl/tinycolor/dist/module/conversion.js":
/*!****************************************************************!*\
  !*** ./node_modules/@ctrl/tinycolor/dist/module/conversion.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"rgbToRgb\": () => (/* binding */ rgbToRgb),\n/* harmony export */   \"rgbToHsl\": () => (/* binding */ rgbToHsl),\n/* harmony export */   \"hslToRgb\": () => (/* binding */ hslToRgb),\n/* harmony export */   \"rgbToHsv\": () => (/* binding */ rgbToHsv),\n/* harmony export */   \"hsvToRgb\": () => (/* binding */ hsvToRgb),\n/* harmony export */   \"rgbToHex\": () => (/* binding */ rgbToHex),\n/* harmony export */   \"rgbaToHex\": () => (/* binding */ rgbaToHex),\n/* harmony export */   \"rgbaToArgbHex\": () => (/* binding */ rgbaToArgbHex),\n/* harmony export */   \"convertDecimalToHex\": () => (/* binding */ convertDecimalToHex),\n/* harmony export */   \"convertHexToDecimal\": () => (/* binding */ convertHexToDecimal),\n/* harmony export */   \"parseIntFromHex\": () => (/* binding */ parseIntFromHex),\n/* harmony export */   \"numberInputToObject\": () => (/* binding */ numberInputToObject)\n/* harmony export */ });\n/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ \"./node_modules/@ctrl/tinycolor/dist/module/util.js\");\n\n// `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:\n// <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>\n/**\n * Handle bounds / percentage checking to conform to CSS color spec\n * <http://www.w3.org/TR/css3-color/>\n * *Assumes:* r, g, b in [0, 255] or [0, 1]\n * *Returns:* { r, g, b } in [0, 255]\n */\nfunction rgbToRgb(r, g, b) {\n    return {\n        r: (0,_util__WEBPACK_IMPORTED_MODULE_0__.bound01)(r, 255) * 255,\n        g: (0,_util__WEBPACK_IMPORTED_MODULE_0__.bound01)(g, 255) * 255,\n        b: (0,_util__WEBPACK_IMPORTED_MODULE_0__.bound01)(b, 255) * 255,\n    };\n}\n/**\n * Converts an RGB color value to HSL.\n * *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]\n * *Returns:* { h, s, l } in [0,1]\n */\nfunction rgbToHsl(r, g, b) {\n    r = (0,_util__WEBPACK_IMPORTED_MODULE_0__.bound01)(r, 255);\n    g = (0,_util__WEBPACK_IMPORTED_MODULE_0__.bound01)(g, 255);\n    b = (0,_util__WEBPACK_IMPORTED_MODULE_0__.bound01)(b, 255);\n    var max = Math.max(r, g, b);\n    var min = Math.min(r, g, b);\n    var h = 0;\n    var s = 0;\n    var l = (max + min) / 2;\n    if (max === min) {\n        s = 0;\n        h = 0; // achromatic\n    }\n    else {\n        var d = max - min;\n        s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n        switch (max) {\n            case r:\n                h = (g - b) / d + (g < b ? 6 : 0);\n                break;\n            case g:\n                h = (b - r) / d + 2;\n                break;\n            case b:\n                h = (r - g) / d + 4;\n                break;\n            default:\n                break;\n        }\n        h /= 6;\n    }\n    return { h: h, s: s, l: l };\n}\nfunction hue2rgb(p, q, t) {\n    if (t < 0) {\n        t += 1;\n    }\n    if (t > 1) {\n        t -= 1;\n    }\n    if (t < 1 / 6) {\n        return p + (q - p) * (6 * t);\n    }\n    if (t < 1 / 2) {\n        return q;\n    }\n    if (t < 2 / 3) {\n        return p + (q - p) * (2 / 3 - t) * 6;\n    }\n    return p;\n}\n/**\n * Converts an HSL color value to RGB.\n *\n * *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]\n * *Returns:* { r, g, b } in the set [0, 255]\n */\nfunction hslToRgb(h, s, l) {\n    var r;\n    var g;\n    var b;\n    h = (0,_util__WEBPACK_IMPORTED_MODULE_0__.bound01)(h, 360);\n    s = (0,_util__WEBPACK_IMPORTED_MODULE_0__.bound01)(s, 100);\n    l = (0,_util__WEBPACK_IMPORTED_MODULE_0__.bound01)(l, 100);\n    if (s === 0) {\n        // achromatic\n        g = l;\n        b = l;\n        r = l;\n    }\n    else {\n        var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n        var p = 2 * l - q;\n        r = hue2rgb(p, q, h + 1 / 3);\n        g = hue2rgb(p, q, h);\n        b = hue2rgb(p, q, h - 1 / 3);\n    }\n    return { r: r * 255, g: g * 255, b: b * 255 };\n}\n/**\n * Converts an RGB color value to HSV\n *\n * *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]\n * *Returns:* { h, s, v } in [0,1]\n */\nfunction rgbToHsv(r, g, b) {\n    r = (0,_util__WEBPACK_IMPORTED_MODULE_0__.bound01)(r, 255);\n    g = (0,_util__WEBPACK_IMPORTED_MODULE_0__.bound01)(g, 255);\n    b = (0,_util__WEBPACK_IMPORTED_MODULE_0__.bound01)(b, 255);\n    var max = Math.max(r, g, b);\n    var min = Math.min(r, g, b);\n    var h = 0;\n    var v = max;\n    var d = max - min;\n    var s = max === 0 ? 0 : d / max;\n    if (max === min) {\n        h = 0; // achromatic\n    }\n    else {\n        switch (max) {\n            case r:\n                h = (g - b) / d + (g < b ? 6 : 0);\n                break;\n            case g:\n                h = (b - r) / d + 2;\n                break;\n            case b:\n                h = (r - g) / d + 4;\n                break;\n            default:\n                break;\n        }\n        h /= 6;\n    }\n    return { h: h, s: s, v: v };\n}\n/**\n * Converts an HSV color value to RGB.\n *\n * *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]\n * *Returns:* { r, g, b } in the set [0, 255]\n */\nfunction hsvToRgb(h, s, v) {\n    h = (0,_util__WEBPACK_IMPORTED_MODULE_0__.bound01)(h, 360) * 6;\n    s = (0,_util__WEBPACK_IMPORTED_MODULE_0__.bound01)(s, 100);\n    v = (0,_util__WEBPACK_IMPORTED_MODULE_0__.bound01)(v, 100);\n    var i = Math.floor(h);\n    var f = h - i;\n    var p = v * (1 - s);\n    var q = v * (1 - f * s);\n    var t = v * (1 - (1 - f) * s);\n    var mod = i % 6;\n    var r = [v, q, p, p, t, v][mod];\n    var g = [t, v, v, q, p, p][mod];\n    var b = [p, p, t, v, v, q][mod];\n    return { r: r * 255, g: g * 255, b: b * 255 };\n}\n/**\n * Converts an RGB color to hex\n *\n * Assumes r, g, and b are contained in the set [0, 255]\n * Returns a 3 or 6 character hex\n */\nfunction rgbToHex(r, g, b, allow3Char) {\n    var hex = [\n        (0,_util__WEBPACK_IMPORTED_MODULE_0__.pad2)(Math.round(r).toString(16)),\n        (0,_util__WEBPACK_IMPORTED_MODULE_0__.pad2)(Math.round(g).toString(16)),\n        (0,_util__WEBPACK_IMPORTED_MODULE_0__.pad2)(Math.round(b).toString(16)),\n    ];\n    // Return a 3 character hex if possible\n    if (allow3Char &&\n        hex[0].startsWith(hex[0].charAt(1)) &&\n        hex[1].startsWith(hex[1].charAt(1)) &&\n        hex[2].startsWith(hex[2].charAt(1))) {\n        return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);\n    }\n    return hex.join('');\n}\n/**\n * Converts an RGBA color plus alpha transparency to hex\n *\n * Assumes r, g, b are contained in the set [0, 255] and\n * a in [0, 1]. Returns a 4 or 8 character rgba hex\n */\n// eslint-disable-next-line max-params\nfunction rgbaToHex(r, g, b, a, allow4Char) {\n    var hex = [\n        (0,_util__WEBPACK_IMPORTED_MODULE_0__.pad2)(Math.round(r).toString(16)),\n        (0,_util__WEBPACK_IMPORTED_MODULE_0__.pad2)(Math.round(g).toString(16)),\n        (0,_util__WEBPACK_IMPORTED_MODULE_0__.pad2)(Math.round(b).toString(16)),\n        (0,_util__WEBPACK_IMPORTED_MODULE_0__.pad2)(convertDecimalToHex(a)),\n    ];\n    // Return a 4 character hex if possible\n    if (allow4Char &&\n        hex[0].startsWith(hex[0].charAt(1)) &&\n        hex[1].startsWith(hex[1].charAt(1)) &&\n        hex[2].startsWith(hex[2].charAt(1)) &&\n        hex[3].startsWith(hex[3].charAt(1))) {\n        return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0) + hex[3].charAt(0);\n    }\n    return hex.join('');\n}\n/**\n * Converts an RGBA color to an ARGB Hex8 string\n * Rarely used, but required for \"toFilter()\"\n */\nfunction rgbaToArgbHex(r, g, b, a) {\n    var hex = [\n        (0,_util__WEBPACK_IMPORTED_MODULE_0__.pad2)(convertDecimalToHex(a)),\n        (0,_util__WEBPACK_IMPORTED_MODULE_0__.pad2)(Math.round(r).toString(16)),\n        (0,_util__WEBPACK_IMPORTED_MODULE_0__.pad2)(Math.round(g).toString(16)),\n        (0,_util__WEBPACK_IMPORTED_MODULE_0__.pad2)(Math.round(b).toString(16)),\n    ];\n    return hex.join('');\n}\n/** Converts a decimal to a hex value */\nfunction convertDecimalToHex(d) {\n    return Math.round(parseFloat(d) * 255).toString(16);\n}\n/** Converts a hex value to a decimal */\nfunction convertHexToDecimal(h) {\n    return parseIntFromHex(h) / 255;\n}\n/** Parse a base-16 hex value into a base-10 integer */\nfunction parseIntFromHex(val) {\n    return parseInt(val, 16);\n}\nfunction numberInputToObject(color) {\n    return {\n        r: color >> 16,\n        g: (color & 0xff00) >> 8,\n        b: color & 0xff,\n    };\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@ctrl/tinycolor/dist/module/conversion.js\n");

/***/ }),

/***/ "./node_modules/@ctrl/tinycolor/dist/module/css-color-names.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@ctrl/tinycolor/dist/module/css-color-names.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"names\": () => (/* binding */ names)\n/* harmony export */ });\n// https://github.com/bahamas10/css-color-names/blob/master/css-color-names.json\n/**\n * @hidden\n */\nvar names = {\n    aliceblue: '#f0f8ff',\n    antiquewhite: '#faebd7',\n    aqua: '#00ffff',\n    aquamarine: '#7fffd4',\n    azure: '#f0ffff',\n    beige: '#f5f5dc',\n    bisque: '#ffe4c4',\n    black: '#000000',\n    blanchedalmond: '#ffebcd',\n    blue: '#0000ff',\n    blueviolet: '#8a2be2',\n    brown: '#a52a2a',\n    burlywood: '#deb887',\n    cadetblue: '#5f9ea0',\n    chartreuse: '#7fff00',\n    chocolate: '#d2691e',\n    coral: '#ff7f50',\n    cornflowerblue: '#6495ed',\n    cornsilk: '#fff8dc',\n    crimson: '#dc143c',\n    cyan: '#00ffff',\n    darkblue: '#00008b',\n    darkcyan: '#008b8b',\n    darkgoldenrod: '#b8860b',\n    darkgray: '#a9a9a9',\n    darkgreen: '#006400',\n    darkgrey: '#a9a9a9',\n    darkkhaki: '#bdb76b',\n    darkmagenta: '#8b008b',\n    darkolivegreen: '#556b2f',\n    darkorange: '#ff8c00',\n    darkorchid: '#9932cc',\n    darkred: '#8b0000',\n    darksalmon: '#e9967a',\n    darkseagreen: '#8fbc8f',\n    darkslateblue: '#483d8b',\n    darkslategray: '#2f4f4f',\n    darkslategrey: '#2f4f4f',\n    darkturquoise: '#00ced1',\n    darkviolet: '#9400d3',\n    deeppink: '#ff1493',\n    deepskyblue: '#00bfff',\n    dimgray: '#696969',\n    dimgrey: '#696969',\n    dodgerblue: '#1e90ff',\n    firebrick: '#b22222',\n    floralwhite: '#fffaf0',\n    forestgreen: '#228b22',\n    fuchsia: '#ff00ff',\n    gainsboro: '#dcdcdc',\n    ghostwhite: '#f8f8ff',\n    goldenrod: '#daa520',\n    gold: '#ffd700',\n    gray: '#808080',\n    green: '#008000',\n    greenyellow: '#adff2f',\n    grey: '#808080',\n    honeydew: '#f0fff0',\n    hotpink: '#ff69b4',\n    indianred: '#cd5c5c',\n    indigo: '#4b0082',\n    ivory: '#fffff0',\n    khaki: '#f0e68c',\n    lavenderblush: '#fff0f5',\n    lavender: '#e6e6fa',\n    lawngreen: '#7cfc00',\n    lemonchiffon: '#fffacd',\n    lightblue: '#add8e6',\n    lightcoral: '#f08080',\n    lightcyan: '#e0ffff',\n    lightgoldenrodyellow: '#fafad2',\n    lightgray: '#d3d3d3',\n    lightgreen: '#90ee90',\n    lightgrey: '#d3d3d3',\n    lightpink: '#ffb6c1',\n    lightsalmon: '#ffa07a',\n    lightseagreen: '#20b2aa',\n    lightskyblue: '#87cefa',\n    lightslategray: '#778899',\n    lightslategrey: '#778899',\n    lightsteelblue: '#b0c4de',\n    lightyellow: '#ffffe0',\n    lime: '#00ff00',\n    limegreen: '#32cd32',\n    linen: '#faf0e6',\n    magenta: '#ff00ff',\n    maroon: '#800000',\n    mediumaquamarine: '#66cdaa',\n    mediumblue: '#0000cd',\n    mediumorchid: '#ba55d3',\n    mediumpurple: '#9370db',\n    mediumseagreen: '#3cb371',\n    mediumslateblue: '#7b68ee',\n    mediumspringgreen: '#00fa9a',\n    mediumturquoise: '#48d1cc',\n    mediumvioletred: '#c71585',\n    midnightblue: '#191970',\n    mintcream: '#f5fffa',\n    mistyrose: '#ffe4e1',\n    moccasin: '#ffe4b5',\n    navajowhite: '#ffdead',\n    navy: '#000080',\n    oldlace: '#fdf5e6',\n    olive: '#808000',\n    olivedrab: '#6b8e23',\n    orange: '#ffa500',\n    orangered: '#ff4500',\n    orchid: '#da70d6',\n    palegoldenrod: '#eee8aa',\n    palegreen: '#98fb98',\n    paleturquoise: '#afeeee',\n    palevioletred: '#db7093',\n    papayawhip: '#ffefd5',\n    peachpuff: '#ffdab9',\n    peru: '#cd853f',\n    pink: '#ffc0cb',\n    plum: '#dda0dd',\n    powderblue: '#b0e0e6',\n    purple: '#800080',\n    rebeccapurple: '#663399',\n    red: '#ff0000',\n    rosybrown: '#bc8f8f',\n    royalblue: '#4169e1',\n    saddlebrown: '#8b4513',\n    salmon: '#fa8072',\n    sandybrown: '#f4a460',\n    seagreen: '#2e8b57',\n    seashell: '#fff5ee',\n    sienna: '#a0522d',\n    silver: '#c0c0c0',\n    skyblue: '#87ceeb',\n    slateblue: '#6a5acd',\n    slategray: '#708090',\n    slategrey: '#708090',\n    snow: '#fffafa',\n    springgreen: '#00ff7f',\n    steelblue: '#4682b4',\n    tan: '#d2b48c',\n    teal: '#008080',\n    thistle: '#d8bfd8',\n    tomato: '#ff6347',\n    turquoise: '#40e0d0',\n    violet: '#ee82ee',\n    wheat: '#f5deb3',\n    white: '#ffffff',\n    whitesmoke: '#f5f5f5',\n    yellow: '#ffff00',\n    yellowgreen: '#9acd32',\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@ctrl/tinycolor/dist/module/css-color-names.js\n");

/***/ }),

/***/ "./node_modules/@ctrl/tinycolor/dist/module/format-input.js":
/*!******************************************************************!*\
  !*** ./node_modules/@ctrl/tinycolor/dist/module/format-input.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"inputToRGB\": () => (/* binding */ inputToRGB),\n/* harmony export */   \"stringInputToObject\": () => (/* binding */ stringInputToObject),\n/* harmony export */   \"isValidCSSUnit\": () => (/* binding */ isValidCSSUnit)\n/* harmony export */ });\n/* harmony import */ var _conversion__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./conversion */ \"./node_modules/@ctrl/tinycolor/dist/module/conversion.js\");\n/* harmony import */ var _css_color_names__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./css-color-names */ \"./node_modules/@ctrl/tinycolor/dist/module/css-color-names.js\");\n/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util */ \"./node_modules/@ctrl/tinycolor/dist/module/util.js\");\n/* eslint-disable @typescript-eslint/no-redundant-type-constituents */\n\n\n\n/**\n * Given a string or object, convert that input to RGB\n *\n * Possible string inputs:\n * ```\n * \"red\"\n * \"#f00\" or \"f00\"\n * \"#ff0000\" or \"ff0000\"\n * \"#ff000000\" or \"ff000000\"\n * \"rgb 255 0 0\" or \"rgb (255, 0, 0)\"\n * \"rgb 1.0 0 0\" or \"rgb (1, 0, 0)\"\n * \"rgba (255, 0, 0, 1)\" or \"rgba 255, 0, 0, 1\"\n * \"rgba (1.0, 0, 0, 1)\" or \"rgba 1.0, 0, 0, 1\"\n * \"hsl(0, 100%, 50%)\" or \"hsl 0 100% 50%\"\n * \"hsla(0, 100%, 50%, 1)\" or \"hsla 0 100% 50%, 1\"\n * \"hsv(0, 100%, 100%)\" or \"hsv 0 100% 100%\"\n * ```\n */\nfunction inputToRGB(color) {\n    var rgb = { r: 0, g: 0, b: 0 };\n    var a = 1;\n    var s = null;\n    var v = null;\n    var l = null;\n    var ok = false;\n    var format = false;\n    if (typeof color === 'string') {\n        color = stringInputToObject(color);\n    }\n    if (typeof color === 'object') {\n        if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {\n            rgb = (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.rgbToRgb)(color.r, color.g, color.b);\n            ok = true;\n            format = String(color.r).substr(-1) === '%' ? 'prgb' : 'rgb';\n        }\n        else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {\n            s = (0,_util__WEBPACK_IMPORTED_MODULE_1__.convertToPercentage)(color.s);\n            v = (0,_util__WEBPACK_IMPORTED_MODULE_1__.convertToPercentage)(color.v);\n            rgb = (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.hsvToRgb)(color.h, s, v);\n            ok = true;\n            format = 'hsv';\n        }\n        else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {\n            s = (0,_util__WEBPACK_IMPORTED_MODULE_1__.convertToPercentage)(color.s);\n            l = (0,_util__WEBPACK_IMPORTED_MODULE_1__.convertToPercentage)(color.l);\n            rgb = (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.hslToRgb)(color.h, s, l);\n            ok = true;\n            format = 'hsl';\n        }\n        if (Object.prototype.hasOwnProperty.call(color, 'a')) {\n            a = color.a;\n        }\n    }\n    a = (0,_util__WEBPACK_IMPORTED_MODULE_1__.boundAlpha)(a);\n    return {\n        ok: ok,\n        format: color.format || format,\n        r: Math.min(255, Math.max(rgb.r, 0)),\n        g: Math.min(255, Math.max(rgb.g, 0)),\n        b: Math.min(255, Math.max(rgb.b, 0)),\n        a: a,\n    };\n}\n// <http://www.w3.org/TR/css3-values/#integers>\nvar CSS_INTEGER = '[-\\\\+]?\\\\d+%?';\n// <http://www.w3.org/TR/css3-values/#number-value>\nvar CSS_NUMBER = '[-\\\\+]?\\\\d*\\\\.\\\\d+%?';\n// Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.\nvar CSS_UNIT = \"(?:\".concat(CSS_NUMBER, \")|(?:\").concat(CSS_INTEGER, \")\");\n// Actual matching.\n// Parentheses and commas are optional, but not required.\n// Whitespace can take the place of commas or opening paren\nvar PERMISSIVE_MATCH3 = \"[\\\\s|\\\\(]+(\".concat(CSS_UNIT, \")[,|\\\\s]+(\").concat(CSS_UNIT, \")[,|\\\\s]+(\").concat(CSS_UNIT, \")\\\\s*\\\\)?\");\nvar PERMISSIVE_MATCH4 = \"[\\\\s|\\\\(]+(\".concat(CSS_UNIT, \")[,|\\\\s]+(\").concat(CSS_UNIT, \")[,|\\\\s]+(\").concat(CSS_UNIT, \")[,|\\\\s]+(\").concat(CSS_UNIT, \")\\\\s*\\\\)?\");\nvar matchers = {\n    CSS_UNIT: new RegExp(CSS_UNIT),\n    rgb: new RegExp('rgb' + PERMISSIVE_MATCH3),\n    rgba: new RegExp('rgba' + PERMISSIVE_MATCH4),\n    hsl: new RegExp('hsl' + PERMISSIVE_MATCH3),\n    hsla: new RegExp('hsla' + PERMISSIVE_MATCH4),\n    hsv: new RegExp('hsv' + PERMISSIVE_MATCH3),\n    hsva: new RegExp('hsva' + PERMISSIVE_MATCH4),\n    hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n    hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,\n    hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n    hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,\n};\n/**\n * Permissive string parsing.  Take in a number of formats, and output an object\n * based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`\n */\nfunction stringInputToObject(color) {\n    color = color.trim().toLowerCase();\n    if (color.length === 0) {\n        return false;\n    }\n    var named = false;\n    if (_css_color_names__WEBPACK_IMPORTED_MODULE_2__.names[color]) {\n        color = _css_color_names__WEBPACK_IMPORTED_MODULE_2__.names[color];\n        named = true;\n    }\n    else if (color === 'transparent') {\n        return { r: 0, g: 0, b: 0, a: 0, format: 'name' };\n    }\n    // Try to match string input using regular expressions.\n    // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]\n    // Just return an object and let the conversion functions handle that.\n    // This way the result will be the same whether the tinycolor is initialized with string or object.\n    var match = matchers.rgb.exec(color);\n    if (match) {\n        return { r: match[1], g: match[2], b: match[3] };\n    }\n    match = matchers.rgba.exec(color);\n    if (match) {\n        return { r: match[1], g: match[2], b: match[3], a: match[4] };\n    }\n    match = matchers.hsl.exec(color);\n    if (match) {\n        return { h: match[1], s: match[2], l: match[3] };\n    }\n    match = matchers.hsla.exec(color);\n    if (match) {\n        return { h: match[1], s: match[2], l: match[3], a: match[4] };\n    }\n    match = matchers.hsv.exec(color);\n    if (match) {\n        return { h: match[1], s: match[2], v: match[3] };\n    }\n    match = matchers.hsva.exec(color);\n    if (match) {\n        return { h: match[1], s: match[2], v: match[3], a: match[4] };\n    }\n    match = matchers.hex8.exec(color);\n    if (match) {\n        return {\n            r: (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.parseIntFromHex)(match[1]),\n            g: (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.parseIntFromHex)(match[2]),\n            b: (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.parseIntFromHex)(match[3]),\n            a: (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.convertHexToDecimal)(match[4]),\n            format: named ? 'name' : 'hex8',\n        };\n    }\n    match = matchers.hex6.exec(color);\n    if (match) {\n        return {\n            r: (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.parseIntFromHex)(match[1]),\n            g: (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.parseIntFromHex)(match[2]),\n            b: (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.parseIntFromHex)(match[3]),\n            format: named ? 'name' : 'hex',\n        };\n    }\n    match = matchers.hex4.exec(color);\n    if (match) {\n        return {\n            r: (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.parseIntFromHex)(match[1] + match[1]),\n            g: (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.parseIntFromHex)(match[2] + match[2]),\n            b: (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.parseIntFromHex)(match[3] + match[3]),\n            a: (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.convertHexToDecimal)(match[4] + match[4]),\n            format: named ? 'name' : 'hex8',\n        };\n    }\n    match = matchers.hex3.exec(color);\n    if (match) {\n        return {\n            r: (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.parseIntFromHex)(match[1] + match[1]),\n            g: (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.parseIntFromHex)(match[2] + match[2]),\n            b: (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.parseIntFromHex)(match[3] + match[3]),\n            format: named ? 'name' : 'hex',\n        };\n    }\n    return false;\n}\n/**\n * Check to see if it looks like a CSS unit\n * (see `matchers` above for definition).\n */\nfunction isValidCSSUnit(color) {\n    return Boolean(matchers.CSS_UNIT.exec(String(color)));\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@ctrl/tinycolor/dist/module/format-input.js\n");

/***/ }),

/***/ "./node_modules/@ctrl/tinycolor/dist/module/index.js":
/*!***********************************************************!*\
  !*** ./node_modules/@ctrl/tinycolor/dist/module/index.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"TinyColor\": () => (/* binding */ TinyColor),\n/* harmony export */   \"tinycolor\": () => (/* binding */ tinycolor)\n/* harmony export */ });\n/* harmony import */ var _conversion__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./conversion */ \"./node_modules/@ctrl/tinycolor/dist/module/conversion.js\");\n/* harmony import */ var _css_color_names__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./css-color-names */ \"./node_modules/@ctrl/tinycolor/dist/module/css-color-names.js\");\n/* harmony import */ var _format_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./format-input */ \"./node_modules/@ctrl/tinycolor/dist/module/format-input.js\");\n/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./util */ \"./node_modules/@ctrl/tinycolor/dist/module/util.js\");\n\n\n\n\nvar TinyColor = /** @class */ (function () {\n    function TinyColor(color, opts) {\n        if (color === void 0) { color = ''; }\n        if (opts === void 0) { opts = {}; }\n        var _a;\n        // If input is already a tinycolor, return itself\n        if (color instanceof TinyColor) {\n            // eslint-disable-next-line no-constructor-return\n            return color;\n        }\n        if (typeof color === 'number') {\n            color = (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.numberInputToObject)(color);\n        }\n        this.originalInput = color;\n        var rgb = (0,_format_input__WEBPACK_IMPORTED_MODULE_1__.inputToRGB)(color);\n        this.originalInput = color;\n        this.r = rgb.r;\n        this.g = rgb.g;\n        this.b = rgb.b;\n        this.a = rgb.a;\n        this.roundA = Math.round(100 * this.a) / 100;\n        this.format = (_a = opts.format) !== null && _a !== void 0 ? _a : rgb.format;\n        this.gradientType = opts.gradientType;\n        // Don't let the range of [0,255] come back in [0,1].\n        // Potentially lose a little bit of precision here, but will fix issues where\n        // .5 gets interpreted as half of the total, instead of half of 1\n        // If it was supposed to be 128, this was already taken care of by `inputToRgb`\n        if (this.r < 1) {\n            this.r = Math.round(this.r);\n        }\n        if (this.g < 1) {\n            this.g = Math.round(this.g);\n        }\n        if (this.b < 1) {\n            this.b = Math.round(this.b);\n        }\n        this.isValid = rgb.ok;\n    }\n    TinyColor.prototype.isDark = function () {\n        return this.getBrightness() < 128;\n    };\n    TinyColor.prototype.isLight = function () {\n        return !this.isDark();\n    };\n    /**\n     * Returns the perceived brightness of the color, from 0-255.\n     */\n    TinyColor.prototype.getBrightness = function () {\n        // http://www.w3.org/TR/AERT#color-contrast\n        var rgb = this.toRgb();\n        return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;\n    };\n    /**\n     * Returns the perceived luminance of a color, from 0-1.\n     */\n    TinyColor.prototype.getLuminance = function () {\n        // http://www.w3.org/TR/2008/REC-WCAG20-20081211/#relativeluminancedef\n        var rgb = this.toRgb();\n        var R;\n        var G;\n        var B;\n        var RsRGB = rgb.r / 255;\n        var GsRGB = rgb.g / 255;\n        var BsRGB = rgb.b / 255;\n        if (RsRGB <= 0.03928) {\n            R = RsRGB / 12.92;\n        }\n        else {\n            // eslint-disable-next-line prefer-exponentiation-operator\n            R = Math.pow((RsRGB + 0.055) / 1.055, 2.4);\n        }\n        if (GsRGB <= 0.03928) {\n            G = GsRGB / 12.92;\n        }\n        else {\n            // eslint-disable-next-line prefer-exponentiation-operator\n            G = Math.pow((GsRGB + 0.055) / 1.055, 2.4);\n        }\n        if (BsRGB <= 0.03928) {\n            B = BsRGB / 12.92;\n        }\n        else {\n            // eslint-disable-next-line prefer-exponentiation-operator\n            B = Math.pow((BsRGB + 0.055) / 1.055, 2.4);\n        }\n        return 0.2126 * R + 0.7152 * G + 0.0722 * B;\n    };\n    /**\n     * Returns the alpha value of a color, from 0-1.\n     */\n    TinyColor.prototype.getAlpha = function () {\n        return this.a;\n    };\n    /**\n     * Sets the alpha value on the current color.\n     *\n     * @param alpha - The new alpha value. The accepted range is 0-1.\n     */\n    TinyColor.prototype.setAlpha = function (alpha) {\n        this.a = (0,_util__WEBPACK_IMPORTED_MODULE_2__.boundAlpha)(alpha);\n        this.roundA = Math.round(100 * this.a) / 100;\n        return this;\n    };\n    /**\n     * Returns whether the color is monochrome.\n     */\n    TinyColor.prototype.isMonochrome = function () {\n        var s = this.toHsl().s;\n        return s === 0;\n    };\n    /**\n     * Returns the object as a HSVA object.\n     */\n    TinyColor.prototype.toHsv = function () {\n        var hsv = (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.rgbToHsv)(this.r, this.g, this.b);\n        return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this.a };\n    };\n    /**\n     * Returns the hsva values interpolated into a string with the following format:\n     * \"hsva(xxx, xxx, xxx, xx)\".\n     */\n    TinyColor.prototype.toHsvString = function () {\n        var hsv = (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.rgbToHsv)(this.r, this.g, this.b);\n        var h = Math.round(hsv.h * 360);\n        var s = Math.round(hsv.s * 100);\n        var v = Math.round(hsv.v * 100);\n        return this.a === 1 ? \"hsv(\".concat(h, \", \").concat(s, \"%, \").concat(v, \"%)\") : \"hsva(\".concat(h, \", \").concat(s, \"%, \").concat(v, \"%, \").concat(this.roundA, \")\");\n    };\n    /**\n     * Returns the object as a HSLA object.\n     */\n    TinyColor.prototype.toHsl = function () {\n        var hsl = (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.rgbToHsl)(this.r, this.g, this.b);\n        return { h: hsl.h * 360, s: hsl.s, l: hsl.l, a: this.a };\n    };\n    /**\n     * Returns the hsla values interpolated into a string with the following format:\n     * \"hsla(xxx, xxx, xxx, xx)\".\n     */\n    TinyColor.prototype.toHslString = function () {\n        var hsl = (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.rgbToHsl)(this.r, this.g, this.b);\n        var h = Math.round(hsl.h * 360);\n        var s = Math.round(hsl.s * 100);\n        var l = Math.round(hsl.l * 100);\n        return this.a === 1 ? \"hsl(\".concat(h, \", \").concat(s, \"%, \").concat(l, \"%)\") : \"hsla(\".concat(h, \", \").concat(s, \"%, \").concat(l, \"%, \").concat(this.roundA, \")\");\n    };\n    /**\n     * Returns the hex value of the color.\n     * @param allow3Char will shorten hex value to 3 char if possible\n     */\n    TinyColor.prototype.toHex = function (allow3Char) {\n        if (allow3Char === void 0) { allow3Char = false; }\n        return (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.rgbToHex)(this.r, this.g, this.b, allow3Char);\n    };\n    /**\n     * Returns the hex value of the color -with a # prefixed.\n     * @param allow3Char will shorten hex value to 3 char if possible\n     */\n    TinyColor.prototype.toHexString = function (allow3Char) {\n        if (allow3Char === void 0) { allow3Char = false; }\n        return '#' + this.toHex(allow3Char);\n    };\n    /**\n     * Returns the hex 8 value of the color.\n     * @param allow4Char will shorten hex value to 4 char if possible\n     */\n    TinyColor.prototype.toHex8 = function (allow4Char) {\n        if (allow4Char === void 0) { allow4Char = false; }\n        return (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.rgbaToHex)(this.r, this.g, this.b, this.a, allow4Char);\n    };\n    /**\n     * Returns the hex 8 value of the color -with a # prefixed.\n     * @param allow4Char will shorten hex value to 4 char if possible\n     */\n    TinyColor.prototype.toHex8String = function (allow4Char) {\n        if (allow4Char === void 0) { allow4Char = false; }\n        return '#' + this.toHex8(allow4Char);\n    };\n    /**\n     * Returns the shorter hex value of the color depends on its alpha -with a # prefixed.\n     * @param allowShortChar will shorten hex value to 3 or 4 char if possible\n     */\n    TinyColor.prototype.toHexShortString = function (allowShortChar) {\n        if (allowShortChar === void 0) { allowShortChar = false; }\n        return this.a === 1 ? this.toHexString(allowShortChar) : this.toHex8String(allowShortChar);\n    };\n    /**\n     * Returns the object as a RGBA object.\n     */\n    TinyColor.prototype.toRgb = function () {\n        return {\n            r: Math.round(this.r),\n            g: Math.round(this.g),\n            b: Math.round(this.b),\n            a: this.a,\n        };\n    };\n    /**\n     * Returns the RGBA values interpolated into a string with the following format:\n     * \"RGBA(xxx, xxx, xxx, xx)\".\n     */\n    TinyColor.prototype.toRgbString = function () {\n        var r = Math.round(this.r);\n        var g = Math.round(this.g);\n        var b = Math.round(this.b);\n        return this.a === 1 ? \"rgb(\".concat(r, \", \").concat(g, \", \").concat(b, \")\") : \"rgba(\".concat(r, \", \").concat(g, \", \").concat(b, \", \").concat(this.roundA, \")\");\n    };\n    /**\n     * Returns the object as a RGBA object.\n     */\n    TinyColor.prototype.toPercentageRgb = function () {\n        var fmt = function (x) { return \"\".concat(Math.round((0,_util__WEBPACK_IMPORTED_MODULE_2__.bound01)(x, 255) * 100), \"%\"); };\n        return {\n            r: fmt(this.r),\n            g: fmt(this.g),\n            b: fmt(this.b),\n            a: this.a,\n        };\n    };\n    /**\n     * Returns the RGBA relative values interpolated into a string\n     */\n    TinyColor.prototype.toPercentageRgbString = function () {\n        var rnd = function (x) { return Math.round((0,_util__WEBPACK_IMPORTED_MODULE_2__.bound01)(x, 255) * 100); };\n        return this.a === 1\n            ? \"rgb(\".concat(rnd(this.r), \"%, \").concat(rnd(this.g), \"%, \").concat(rnd(this.b), \"%)\")\n            : \"rgba(\".concat(rnd(this.r), \"%, \").concat(rnd(this.g), \"%, \").concat(rnd(this.b), \"%, \").concat(this.roundA, \")\");\n    };\n    /**\n     * The 'real' name of the color -if there is one.\n     */\n    TinyColor.prototype.toName = function () {\n        if (this.a === 0) {\n            return 'transparent';\n        }\n        if (this.a < 1) {\n            return false;\n        }\n        var hex = '#' + (0,_conversion__WEBPACK_IMPORTED_MODULE_0__.rgbToHex)(this.r, this.g, this.b, false);\n        for (var _i = 0, _a = Object.entries(_css_color_names__WEBPACK_IMPORTED_MODULE_3__.names); _i < _a.length; _i++) {\n            var _b = _a[_i], key = _b[0], value = _b[1];\n            if (hex === value) {\n                return key;\n            }\n        }\n        return false;\n    };\n    TinyColor.prototype.toString = function (format) {\n        var formatSet = Boolean(format);\n        format = format !== null && format !== void 0 ? format : this.format;\n        var formattedString = false;\n        var hasAlpha = this.a < 1 && this.a >= 0;\n        var needsAlphaFormat = !formatSet && hasAlpha && (format.startsWith('hex') || format === 'name');\n        if (needsAlphaFormat) {\n            // Special case for \"transparent\", all other non-alpha formats\n            // will return rgba when there is transparency.\n            if (format === 'name' && this.a === 0) {\n                return this.toName();\n            }\n            return this.toRgbString();\n        }\n        if (format === 'rgb') {\n            formattedString = this.toRgbString();\n        }\n        if (format === 'prgb') {\n            formattedString = this.toPercentageRgbString();\n        }\n        if (format === 'hex' || format === 'hex6') {\n            formattedString = this.toHexString();\n        }\n        if (format === 'hex3') {\n            formattedString = this.toHexString(true);\n        }\n        if (format === 'hex4') {\n            formattedString = this.toHex8String(true);\n        }\n        if (format === 'hex8') {\n            formattedString = this.toHex8String();\n        }\n        if (format === 'name') {\n            formattedString = this.toName();\n        }\n        if (format === 'hsl') {\n            formattedString = this.toHslString();\n        }\n        if (format === 'hsv') {\n            formattedString = this.toHsvString();\n        }\n        return formattedString || this.toHexString();\n    };\n    TinyColor.prototype.toNumber = function () {\n        return (Math.round(this.r) << 16) + (Math.round(this.g) << 8) + Math.round(this.b);\n    };\n    TinyColor.prototype.clone = function () {\n        return new TinyColor(this.toString());\n    };\n    /**\n     * Lighten the color a given amount. Providing 100 will always return white.\n     * @param amount - valid between 1-100\n     */\n    TinyColor.prototype.lighten = function (amount) {\n        if (amount === void 0) { amount = 10; }\n        var hsl = this.toHsl();\n        hsl.l += amount / 100;\n        hsl.l = (0,_util__WEBPACK_IMPORTED_MODULE_2__.clamp01)(hsl.l);\n        return new TinyColor(hsl);\n    };\n    /**\n     * Brighten the color a given amount, from 0 to 100.\n     * @param amount - valid between 1-100\n     */\n    TinyColor.prototype.brighten = function (amount) {\n        if (amount === void 0) { amount = 10; }\n        var rgb = this.toRgb();\n        rgb.r = Math.max(0, Math.min(255, rgb.r - Math.round(255 * -(amount / 100))));\n        rgb.g = Math.max(0, Math.min(255, rgb.g - Math.round(255 * -(amount / 100))));\n        rgb.b = Math.max(0, Math.min(255, rgb.b - Math.round(255 * -(amount / 100))));\n        return new TinyColor(rgb);\n    };\n    /**\n     * Darken the color a given amount, from 0 to 100.\n     * Providing 100 will always return black.\n     * @param amount - valid between 1-100\n     */\n    TinyColor.prototype.darken = function (amount) {\n        if (amount === void 0) { amount = 10; }\n        var hsl = this.toHsl();\n        hsl.l -= amount / 100;\n        hsl.l = (0,_util__WEBPACK_IMPORTED_MODULE_2__.clamp01)(hsl.l);\n        return new TinyColor(hsl);\n    };\n    /**\n     * Mix the color with pure white, from 0 to 100.\n     * Providing 0 will do nothing, providing 100 will always return white.\n     * @param amount - valid between 1-100\n     */\n    TinyColor.prototype.tint = function (amount) {\n        if (amount === void 0) { amount = 10; }\n        return this.mix('white', amount);\n    };\n    /**\n     * Mix the color with pure black, from 0 to 100.\n     * Providing 0 will do nothing, providing 100 will always return black.\n     * @param amount - valid between 1-100\n     */\n    TinyColor.prototype.shade = function (amount) {\n        if (amount === void 0) { amount = 10; }\n        return this.mix('black', amount);\n    };\n    /**\n     * Desaturate the color a given amount, from 0 to 100.\n     * Providing 100 will is the same as calling greyscale\n     * @param amount - valid between 1-100\n     */\n    TinyColor.prototype.desaturate = function (amount) {\n        if (amount === void 0) { amount = 10; }\n        var hsl = this.toHsl();\n        hsl.s -= amount / 100;\n        hsl.s = (0,_util__WEBPACK_IMPORTED_MODULE_2__.clamp01)(hsl.s);\n        return new TinyColor(hsl);\n    };\n    /**\n     * Saturate the color a given amount, from 0 to 100.\n     * @param amount - valid between 1-100\n     */\n    TinyColor.prototype.saturate = function (amount) {\n        if (amount === void 0) { amount = 10; }\n        var hsl = this.toHsl();\n        hsl.s += amount / 100;\n        hsl.s = (0,_util__WEBPACK_IMPORTED_MODULE_2__.clamp01)(hsl.s);\n        return new TinyColor(hsl);\n    };\n    /**\n     * Completely desaturates a color into greyscale.\n     * Same as calling `desaturate(100)`\n     */\n    TinyColor.prototype.greyscale = function () {\n        return this.desaturate(100);\n    };\n    /**\n     * Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.\n     * Values outside of this range will be wrapped into this range.\n     */\n    TinyColor.prototype.spin = function (amount) {\n        var hsl = this.toHsl();\n        var hue = (hsl.h + amount) % 360;\n        hsl.h = hue < 0 ? 360 + hue : hue;\n        return new TinyColor(hsl);\n    };\n    /**\n     * Mix the current color a given amount with another color, from 0 to 100.\n     * 0 means no mixing (return current color).\n     */\n    TinyColor.prototype.mix = function (color, amount) {\n        if (amount === void 0) { amount = 50; }\n        var rgb1 = this.toRgb();\n        var rgb2 = new TinyColor(color).toRgb();\n        var p = amount / 100;\n        var rgba = {\n            r: (rgb2.r - rgb1.r) * p + rgb1.r,\n            g: (rgb2.g - rgb1.g) * p + rgb1.g,\n            b: (rgb2.b - rgb1.b) * p + rgb1.b,\n            a: (rgb2.a - rgb1.a) * p + rgb1.a,\n        };\n        return new TinyColor(rgba);\n    };\n    TinyColor.prototype.analogous = function (results, slices) {\n        if (results === void 0) { results = 6; }\n        if (slices === void 0) { slices = 30; }\n        var hsl = this.toHsl();\n        var part = 360 / slices;\n        var ret = [this];\n        for (hsl.h = (hsl.h - ((part * results) >> 1) + 720) % 360; --results;) {\n            hsl.h = (hsl.h + part) % 360;\n            ret.push(new TinyColor(hsl));\n        }\n        return ret;\n    };\n    /**\n     * taken from https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js\n     */\n    TinyColor.prototype.complement = function () {\n        var hsl = this.toHsl();\n        hsl.h = (hsl.h + 180) % 360;\n        return new TinyColor(hsl);\n    };\n    TinyColor.prototype.monochromatic = function (results) {\n        if (results === void 0) { results = 6; }\n        var hsv = this.toHsv();\n        var h = hsv.h;\n        var s = hsv.s;\n        var v = hsv.v;\n        var res = [];\n        var modification = 1 / results;\n        while (results--) {\n            res.push(new TinyColor({ h: h, s: s, v: v }));\n            v = (v + modification) % 1;\n        }\n        return res;\n    };\n    TinyColor.prototype.splitcomplement = function () {\n        var hsl = this.toHsl();\n        var h = hsl.h;\n        return [\n            this,\n            new TinyColor({ h: (h + 72) % 360, s: hsl.s, l: hsl.l }),\n            new TinyColor({ h: (h + 216) % 360, s: hsl.s, l: hsl.l }),\n        ];\n    };\n    /**\n     * Compute how the color would appear on a background\n     */\n    TinyColor.prototype.onBackground = function (background) {\n        var fg = this.toRgb();\n        var bg = new TinyColor(background).toRgb();\n        var alpha = fg.a + bg.a * (1 - fg.a);\n        return new TinyColor({\n            r: (fg.r * fg.a + bg.r * bg.a * (1 - fg.a)) / alpha,\n            g: (fg.g * fg.a + bg.g * bg.a * (1 - fg.a)) / alpha,\n            b: (fg.b * fg.a + bg.b * bg.a * (1 - fg.a)) / alpha,\n            a: alpha,\n        });\n    };\n    /**\n     * Alias for `polyad(3)`\n     */\n    TinyColor.prototype.triad = function () {\n        return this.polyad(3);\n    };\n    /**\n     * Alias for `polyad(4)`\n     */\n    TinyColor.prototype.tetrad = function () {\n        return this.polyad(4);\n    };\n    /**\n     * Get polyad colors, like (for 1, 2, 3, 4, 5, 6, 7, 8, etc...)\n     * monad, dyad, triad, tetrad, pentad, hexad, heptad, octad, etc...\n     */\n    TinyColor.prototype.polyad = function (n) {\n        var hsl = this.toHsl();\n        var h = hsl.h;\n        var result = [this];\n        var increment = 360 / n;\n        for (var i = 1; i < n; i++) {\n            result.push(new TinyColor({ h: (h + i * increment) % 360, s: hsl.s, l: hsl.l }));\n        }\n        return result;\n    };\n    /**\n     * compare color vs current color\n     */\n    TinyColor.prototype.equals = function (color) {\n        return this.toRgbString() === new TinyColor(color).toRgbString();\n    };\n    return TinyColor;\n}());\n\n// kept for backwards compatability with v1\nfunction tinycolor(color, opts) {\n    if (color === void 0) { color = ''; }\n    if (opts === void 0) { opts = {}; }\n    return new TinyColor(color, opts);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@ctrl/tinycolor/dist/module/index.js\n");

/***/ }),

/***/ "./node_modules/@ctrl/tinycolor/dist/module/util.js":
/*!**********************************************************!*\
  !*** ./node_modules/@ctrl/tinycolor/dist/module/util.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"bound01\": () => (/* binding */ bound01),\n/* harmony export */   \"clamp01\": () => (/* binding */ clamp01),\n/* harmony export */   \"isOnePointZero\": () => (/* binding */ isOnePointZero),\n/* harmony export */   \"isPercentage\": () => (/* binding */ isPercentage),\n/* harmony export */   \"boundAlpha\": () => (/* binding */ boundAlpha),\n/* harmony export */   \"convertToPercentage\": () => (/* binding */ convertToPercentage),\n/* harmony export */   \"pad2\": () => (/* binding */ pad2)\n/* harmony export */ });\n/**\n * Take input from [0, n] and return it as [0, 1]\n * @hidden\n */\nfunction bound01(n, max) {\n    if (isOnePointZero(n)) {\n        n = '100%';\n    }\n    var isPercent = isPercentage(n);\n    n = max === 360 ? n : Math.min(max, Math.max(0, parseFloat(n)));\n    // Automatically convert percentage into number\n    if (isPercent) {\n        n = parseInt(String(n * max), 10) / 100;\n    }\n    // Handle floating point rounding errors\n    if (Math.abs(n - max) < 0.000001) {\n        return 1;\n    }\n    // Convert into [0, 1] range if it isn't already\n    if (max === 360) {\n        // If n is a hue given in degrees,\n        // wrap around out-of-range values into [0, 360] range\n        // then convert into [0, 1].\n        n = (n < 0 ? (n % max) + max : n % max) / parseFloat(String(max));\n    }\n    else {\n        // If n not a hue given in degrees\n        // Convert into [0, 1] range if it isn't already.\n        n = (n % max) / parseFloat(String(max));\n    }\n    return n;\n}\n/**\n * Force a number between 0 and 1\n * @hidden\n */\nfunction clamp01(val) {\n    return Math.min(1, Math.max(0, val));\n}\n/**\n * Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1\n * <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>\n * @hidden\n */\nfunction isOnePointZero(n) {\n    return typeof n === 'string' && n.indexOf('.') !== -1 && parseFloat(n) === 1;\n}\n/**\n * Check to see if string passed in is a percentage\n * @hidden\n */\nfunction isPercentage(n) {\n    return typeof n === 'string' && n.indexOf('%') !== -1;\n}\n/**\n * Return a valid alpha value [0,1] with all invalid values being set to 1\n * @hidden\n */\nfunction boundAlpha(a) {\n    a = parseFloat(a);\n    if (isNaN(a) || a < 0 || a > 1) {\n        a = 1;\n    }\n    return a;\n}\n/**\n * Replace a decimal with it's percentage value\n * @hidden\n */\nfunction convertToPercentage(n) {\n    if (n <= 1) {\n        return \"\".concat(Number(n) * 100, \"%\");\n    }\n    return n;\n}\n/**\n * Force a hex value to have 2 characters\n * @hidden\n */\nfunction pad2(c) {\n    return c.length === 1 ? '0' + c : String(c);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@ctrl/tinycolor/dist/module/util.js\n");

/***/ }),

/***/ "./node_modules/@vue/devtools-api/lib/esm/const.js":
/*!*********************************************************!*\
  !*** ./node_modules/@vue/devtools-api/lib/esm/const.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"HOOK_SETUP\": () => (/* binding */ HOOK_SETUP),\n/* harmony export */   \"HOOK_PLUGIN_SETTINGS_SET\": () => (/* binding */ HOOK_PLUGIN_SETTINGS_SET)\n/* harmony export */ });\nconst HOOK_SETUP = 'devtools-plugin:setup';\nconst HOOK_PLUGIN_SETTINGS_SET = 'plugin:settings:set';\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQHZ1ZS9kZXZ0b29scy1hcGkvbGliL2VzbS9jb25zdC5qcy5qcyIsIm1hcHBpbmdzIjoiOzs7OztBQUFBO0FBQ0EiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly92dWVfM19zdGFydGVyX3BsdWdpbi8uL25vZGVfbW9kdWxlcy9AdnVlL2RldnRvb2xzLWFwaS9saWIvZXNtL2NvbnN0LmpzP2I3NzQiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGNvbnN0IEhPT0tfU0VUVVAgPSAnZGV2dG9vbHMtcGx1Z2luOnNldHVwJztcbmV4cG9ydCBjb25zdCBIT09LX1BMVUdJTl9TRVRUSU5HU19TRVQgPSAncGx1Z2luOnNldHRpbmdzOnNldCc7XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@vue/devtools-api/lib/esm/const.js\n");

/***/ }),

/***/ "./node_modules/@vue/devtools-api/lib/esm/env.js":
/*!*******************************************************!*\
  !*** ./node_modules/@vue/devtools-api/lib/esm/env.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"getDevtoolsGlobalHook\": () => (/* binding */ getDevtoolsGlobalHook),\n/* harmony export */   \"getTarget\": () => (/* binding */ getTarget),\n/* harmony export */   \"isProxyAvailable\": () => (/* binding */ isProxyAvailable)\n/* harmony export */ });\nfunction getDevtoolsGlobalHook() {\n    return getTarget().__VUE_DEVTOOLS_GLOBAL_HOOK__;\n}\nfunction getTarget() {\n    // @ts-ignore\n    return (typeof navigator !== 'undefined' && typeof window !== 'undefined')\n        ? window\n        : typeof __webpack_require__.g !== 'undefined'\n            ? __webpack_require__.g\n            : {};\n}\nconst isProxyAvailable = typeof Proxy === 'function';\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQHZ1ZS9kZXZ0b29scy1hcGkvbGliL2VzbS9lbnYuanMuanMiLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vdnVlXzNfc3RhcnRlcl9wbHVnaW4vLi9ub2RlX21vZHVsZXMvQHZ1ZS9kZXZ0b29scy1hcGkvbGliL2VzbS9lbnYuanM/YWJjNSJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZnVuY3Rpb24gZ2V0RGV2dG9vbHNHbG9iYWxIb29rKCkge1xuICAgIHJldHVybiBnZXRUYXJnZXQoKS5fX1ZVRV9ERVZUT09MU19HTE9CQUxfSE9PS19fO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGdldFRhcmdldCgpIHtcbiAgICAvLyBAdHMtaWdub3JlXG4gICAgcmV0dXJuICh0eXBlb2YgbmF2aWdhdG9yICE9PSAndW5kZWZpbmVkJyAmJiB0eXBlb2Ygd2luZG93ICE9PSAndW5kZWZpbmVkJylcbiAgICAgICAgPyB3aW5kb3dcbiAgICAgICAgOiB0eXBlb2YgZ2xvYmFsICE9PSAndW5kZWZpbmVkJ1xuICAgICAgICAgICAgPyBnbG9iYWxcbiAgICAgICAgICAgIDoge307XG59XG5leHBvcnQgY29uc3QgaXNQcm94eUF2YWlsYWJsZSA9IHR5cGVvZiBQcm94eSA9PT0gJ2Z1bmN0aW9uJztcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@vue/devtools-api/lib/esm/env.js\n");

/***/ }),

/***/ "./node_modules/@vue/devtools-api/lib/esm/index.js":
/*!*********************************************************!*\
  !*** ./node_modules/@vue/devtools-api/lib/esm/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"isPerformanceSupported\": () => (/* reexport safe */ _time_js__WEBPACK_IMPORTED_MODULE_0__.isPerformanceSupported),\n/* harmony export */   \"now\": () => (/* reexport safe */ _time_js__WEBPACK_IMPORTED_MODULE_0__.now),\n/* harmony export */   \"setupDevtoolsPlugin\": () => (/* binding */ setupDevtoolsPlugin)\n/* harmony export */ });\n/* harmony import */ var _env_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./env.js */ \"./node_modules/@vue/devtools-api/lib/esm/env.js\");\n/* harmony import */ var _const_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./const.js */ \"./node_modules/@vue/devtools-api/lib/esm/const.js\");\n/* harmony import */ var _proxy_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./proxy.js */ \"./node_modules/@vue/devtools-api/lib/esm/proxy.js\");\n/* harmony import */ var _time_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./time.js */ \"./node_modules/@vue/devtools-api/lib/esm/time.js\");\n\n\n\n\n\n\nfunction setupDevtoolsPlugin(pluginDescriptor, setupFn) {\n    const descriptor = pluginDescriptor;\n    const target = (0,_env_js__WEBPACK_IMPORTED_MODULE_1__.getTarget)();\n    const hook = (0,_env_js__WEBPACK_IMPORTED_MODULE_1__.getDevtoolsGlobalHook)();\n    const enableProxy = _env_js__WEBPACK_IMPORTED_MODULE_1__.isProxyAvailable && descriptor.enableEarlyProxy;\n    if (hook && (target.__VUE_DEVTOOLS_PLUGIN_API_AVAILABLE__ || !enableProxy)) {\n        hook.emit(_const_js__WEBPACK_IMPORTED_MODULE_2__.HOOK_SETUP, pluginDescriptor, setupFn);\n    }\n    else {\n        const proxy = enableProxy ? new _proxy_js__WEBPACK_IMPORTED_MODULE_3__.ApiProxy(descriptor, hook) : null;\n        const list = target.__VUE_DEVTOOLS_PLUGINS__ = target.__VUE_DEVTOOLS_PLUGINS__ || [];\n        list.push({\n            pluginDescriptor: descriptor,\n            setupFn,\n            proxy,\n        });\n        if (proxy)\n            setupFn(proxy.proxiedTarget);\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQHZ1ZS9kZXZ0b29scy1hcGkvbGliL2VzbS9pbmRleC5qcy5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZXMiOlsid2VicGFjazovL3Z1ZV8zX3N0YXJ0ZXJfcGx1Z2luLy4vbm9kZV9tb2R1bGVzL0B2dWUvZGV2dG9vbHMtYXBpL2xpYi9lc20vaW5kZXguanM/M2Y0ZSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBnZXRUYXJnZXQsIGdldERldnRvb2xzR2xvYmFsSG9vaywgaXNQcm94eUF2YWlsYWJsZSB9IGZyb20gJy4vZW52LmpzJztcbmltcG9ydCB7IEhPT0tfU0VUVVAgfSBmcm9tICcuL2NvbnN0LmpzJztcbmltcG9ydCB7IEFwaVByb3h5IH0gZnJvbSAnLi9wcm94eS5qcyc7XG5leHBvcnQgKiBmcm9tICcuL2FwaS9pbmRleC5qcyc7XG5leHBvcnQgKiBmcm9tICcuL3BsdWdpbi5qcyc7XG5leHBvcnQgKiBmcm9tICcuL3RpbWUuanMnO1xuZXhwb3J0IGZ1bmN0aW9uIHNldHVwRGV2dG9vbHNQbHVnaW4ocGx1Z2luRGVzY3JpcHRvciwgc2V0dXBGbikge1xuICAgIGNvbnN0IGRlc2NyaXB0b3IgPSBwbHVnaW5EZXNjcmlwdG9yO1xuICAgIGNvbnN0IHRhcmdldCA9IGdldFRhcmdldCgpO1xuICAgIGNvbnN0IGhvb2sgPSBnZXREZXZ0b29sc0dsb2JhbEhvb2soKTtcbiAgICBjb25zdCBlbmFibGVQcm94eSA9IGlzUHJveHlBdmFpbGFibGUgJiYgZGVzY3JpcHRvci5lbmFibGVFYXJseVByb3h5O1xuICAgIGlmIChob29rICYmICh0YXJnZXQuX19WVUVfREVWVE9PTFNfUExVR0lOX0FQSV9BVkFJTEFCTEVfXyB8fCAhZW5hYmxlUHJveHkpKSB7XG4gICAgICAgIGhvb2suZW1pdChIT09LX1NFVFVQLCBwbHVnaW5EZXNjcmlwdG9yLCBzZXR1cEZuKTtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICAgIGNvbnN0IHByb3h5ID0gZW5hYmxlUHJveHkgPyBuZXcgQXBpUHJveHkoZGVzY3JpcHRvciwgaG9vaykgOiBudWxsO1xuICAgICAgICBjb25zdCBsaXN0ID0gdGFyZ2V0Ll9fVlVFX0RFVlRPT0xTX1BMVUdJTlNfXyA9IHRhcmdldC5fX1ZVRV9ERVZUT09MU19QTFVHSU5TX18gfHwgW107XG4gICAgICAgIGxpc3QucHVzaCh7XG4gICAgICAgICAgICBwbHVnaW5EZXNjcmlwdG9yOiBkZXNjcmlwdG9yLFxuICAgICAgICAgICAgc2V0dXBGbixcbiAgICAgICAgICAgIHByb3h5LFxuICAgICAgICB9KTtcbiAgICAgICAgaWYgKHByb3h5KVxuICAgICAgICAgICAgc2V0dXBGbihwcm94eS5wcm94aWVkVGFyZ2V0KTtcbiAgICB9XG59XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@vue/devtools-api/lib/esm/index.js\n");

/***/ }),

/***/ "./node_modules/@vue/devtools-api/lib/esm/proxy.js":
/*!*********************************************************!*\
  !*** ./node_modules/@vue/devtools-api/lib/esm/proxy.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ApiProxy\": () => (/* binding */ ApiProxy)\n/* harmony export */ });\n/* harmony import */ var _const_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./const.js */ \"./node_modules/@vue/devtools-api/lib/esm/const.js\");\n/* harmony import */ var _time_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./time.js */ \"./node_modules/@vue/devtools-api/lib/esm/time.js\");\n\n\nclass ApiProxy {\n    constructor(plugin, hook) {\n        this.target = null;\n        this.targetQueue = [];\n        this.onQueue = [];\n        this.plugin = plugin;\n        this.hook = hook;\n        const defaultSettings = {};\n        if (plugin.settings) {\n            for (const id in plugin.settings) {\n                const item = plugin.settings[id];\n                defaultSettings[id] = item.defaultValue;\n            }\n        }\n        const localSettingsSaveId = `__vue-devtools-plugin-settings__${plugin.id}`;\n        let currentSettings = Object.assign({}, defaultSettings);\n        try {\n            const raw = localStorage.getItem(localSettingsSaveId);\n            const data = JSON.parse(raw);\n            Object.assign(currentSettings, data);\n        }\n        catch (e) {\n            // noop\n        }\n        this.fallbacks = {\n            getSettings() {\n                return currentSettings;\n            },\n            setSettings(value) {\n                try {\n                    localStorage.setItem(localSettingsSaveId, JSON.stringify(value));\n                }\n                catch (e) {\n                    // noop\n                }\n                currentSettings = value;\n            },\n            now() {\n                return (0,_time_js__WEBPACK_IMPORTED_MODULE_0__.now)();\n            },\n        };\n        if (hook) {\n            hook.on(_const_js__WEBPACK_IMPORTED_MODULE_1__.HOOK_PLUGIN_SETTINGS_SET, (pluginId, value) => {\n                if (pluginId === this.plugin.id) {\n                    this.fallbacks.setSettings(value);\n                }\n            });\n        }\n        this.proxiedOn = new Proxy({}, {\n            get: (_target, prop) => {\n                if (this.target) {\n                    return this.target.on[prop];\n                }\n                else {\n                    return (...args) => {\n                        this.onQueue.push({\n                            method: prop,\n                            args,\n                        });\n                    };\n                }\n            },\n        });\n        this.proxiedTarget = new Proxy({}, {\n            get: (_target, prop) => {\n                if (this.target) {\n                    return this.target[prop];\n                }\n                else if (prop === 'on') {\n                    return this.proxiedOn;\n                }\n                else if (Object.keys(this.fallbacks).includes(prop)) {\n                    return (...args) => {\n                        this.targetQueue.push({\n                            method: prop,\n                            args,\n                            resolve: () => { },\n                        });\n                        return this.fallbacks[prop](...args);\n                    };\n                }\n                else {\n                    return (...args) => {\n                        return new Promise(resolve => {\n                            this.targetQueue.push({\n                                method: prop,\n                                args,\n                                resolve,\n                            });\n                        });\n                    };\n                }\n            },\n        });\n    }\n    async setRealTarget(target) {\n        this.target = target;\n        for (const item of this.onQueue) {\n            this.target.on[item.method](...item.args);\n        }\n        for (const item of this.targetQueue) {\n            item.resolve(await this.target[item.method](...item.args));\n        }\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@vue/devtools-api/lib/esm/proxy.js\n");

/***/ }),

/***/ "./node_modules/@vue/devtools-api/lib/esm/time.js":
/*!********************************************************!*\
  !*** ./node_modules/@vue/devtools-api/lib/esm/time.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"isPerformanceSupported\": () => (/* binding */ isPerformanceSupported),\n/* harmony export */   \"now\": () => (/* binding */ now)\n/* harmony export */ });\nlet supported;\nlet perf;\nfunction isPerformanceSupported() {\n    var _a;\n    if (supported !== undefined) {\n        return supported;\n    }\n    if (typeof window !== 'undefined' && window.performance) {\n        supported = true;\n        perf = window.performance;\n    }\n    else if (typeof __webpack_require__.g !== 'undefined' && ((_a = __webpack_require__.g.perf_hooks) === null || _a === void 0 ? void 0 : _a.performance)) {\n        supported = true;\n        perf = __webpack_require__.g.perf_hooks.performance;\n    }\n    else {\n        supported = false;\n    }\n    return supported;\n}\nfunction now() {\n    return isPerformanceSupported() ? perf.now() : Date.now();\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQHZ1ZS9kZXZ0b29scy1hcGkvbGliL2VzbS90aW1lLmpzLmpzIiwibWFwcGluZ3MiOiI7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZXMiOlsid2VicGFjazovL3Z1ZV8zX3N0YXJ0ZXJfcGx1Z2luLy4vbm9kZV9tb2R1bGVzL0B2dWUvZGV2dG9vbHMtYXBpL2xpYi9lc20vdGltZS5qcz81MTM0Il0sInNvdXJjZXNDb250ZW50IjpbImxldCBzdXBwb3J0ZWQ7XG5sZXQgcGVyZjtcbmV4cG9ydCBmdW5jdGlvbiBpc1BlcmZvcm1hbmNlU3VwcG9ydGVkKCkge1xuICAgIHZhciBfYTtcbiAgICBpZiAoc3VwcG9ydGVkICE9PSB1bmRlZmluZWQpIHtcbiAgICAgICAgcmV0dXJuIHN1cHBvcnRlZDtcbiAgICB9XG4gICAgaWYgKHR5cGVvZiB3aW5kb3cgIT09ICd1bmRlZmluZWQnICYmIHdpbmRvdy5wZXJmb3JtYW5jZSkge1xuICAgICAgICBzdXBwb3J0ZWQgPSB0cnVlO1xuICAgICAgICBwZXJmID0gd2luZG93LnBlcmZvcm1hbmNlO1xuICAgIH1cbiAgICBlbHNlIGlmICh0eXBlb2YgZ2xvYmFsICE9PSAndW5kZWZpbmVkJyAmJiAoKF9hID0gZ2xvYmFsLnBlcmZfaG9va3MpID09PSBudWxsIHx8IF9hID09PSB2b2lkIDAgPyB2b2lkIDAgOiBfYS5wZXJmb3JtYW5jZSkpIHtcbiAgICAgICAgc3VwcG9ydGVkID0gdHJ1ZTtcbiAgICAgICAgcGVyZiA9IGdsb2JhbC5wZXJmX2hvb2tzLnBlcmZvcm1hbmNlO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgICAgc3VwcG9ydGVkID0gZmFsc2U7XG4gICAgfVxuICAgIHJldHVybiBzdXBwb3J0ZWQ7XG59XG5leHBvcnQgZnVuY3Rpb24gbm93KCkge1xuICAgIHJldHVybiBpc1BlcmZvcm1hbmNlU3VwcG9ydGVkKCkgPyBwZXJmLm5vdygpIDogRGF0ZS5ub3coKTtcbn1cbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@vue/devtools-api/lib/esm/time.js\n");

/***/ }),

/***/ "./node_modules/@vue/reactivity/dist/reactivity.esm-bundler.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@vue/reactivity/dist/reactivity.esm-bundler.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"EffectScope\": () => (/* binding */ EffectScope),\n/* harmony export */   \"ITERATE_KEY\": () => (/* binding */ ITERATE_KEY),\n/* harmony export */   \"ReactiveEffect\": () => (/* binding */ ReactiveEffect),\n/* harmony export */   \"computed\": () => (/* binding */ computed),\n/* harmony export */   \"customRef\": () => (/* binding */ customRef),\n/* harmony export */   \"deferredComputed\": () => (/* binding */ deferredComputed),\n/* harmony export */   \"effect\": () => (/* binding */ effect),\n/* harmony export */   \"effectScope\": () => (/* binding */ effectScope),\n/* harmony export */   \"enableTracking\": () => (/* binding */ enableTracking),\n/* harmony export */   \"getCurrentScope\": () => (/* binding */ getCurrentScope),\n/* harmony export */   \"isProxy\": () => (/* binding */ isProxy),\n/* harmony export */   \"isReactive\": () => (/* binding */ isReactive),\n/* harmony export */   \"isReadonly\": () => (/* binding */ isReadonly),\n/* harmony export */   \"isRef\": () => (/* binding */ isRef),\n/* harmony export */   \"markRaw\": () => (/* binding */ markRaw),\n/* harmony export */   \"onScopeDispose\": () => (/* binding */ onScopeDispose),\n/* harmony export */   \"pauseTracking\": () => (/* binding */ pauseTracking),\n/* harmony export */   \"proxyRefs\": () => (/* binding */ proxyRefs),\n/* harmony export */   \"reactive\": () => (/* binding */ reactive),\n/* harmony export */   \"readonly\": () => (/* binding */ readonly),\n/* harmony export */   \"ref\": () => (/* binding */ ref),\n/* harmony export */   \"resetTracking\": () => (/* binding */ resetTracking),\n/* harmony export */   \"shallowReactive\": () => (/* binding */ shallowReactive),\n/* harmony export */   \"shallowReadonly\": () => (/* binding */ shallowReadonly),\n/* harmony export */   \"shallowRef\": () => (/* binding */ shallowRef),\n/* harmony export */   \"stop\": () => (/* binding */ stop),\n/* harmony export */   \"toRaw\": () => (/* binding */ toRaw),\n/* harmony export */   \"toRef\": () => (/* binding */ toRef),\n/* harmony export */   \"toRefs\": () => (/* binding */ toRefs),\n/* harmony export */   \"track\": () => (/* binding */ track),\n/* harmony export */   \"trigger\": () => (/* binding */ trigger),\n/* harmony export */   \"triggerRef\": () => (/* binding */ triggerRef),\n/* harmony export */   \"unref\": () => (/* binding */ unref)\n/* harmony export */ });\n/* harmony import */ var _vue_shared__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @vue/shared */ \"./node_modules/@vue/shared/dist/shared.esm-bundler.js\");\n\n\nfunction warn(msg, ...args) {\r\n    console.warn(`[Vue warn] ${msg}`, ...args);\r\n}\n\nlet activeEffectScope;\r\nconst effectScopeStack = [];\r\nclass EffectScope {\r\n    constructor(detached = false) {\r\n        this.active = true;\r\n        this.effects = [];\r\n        this.cleanups = [];\r\n        if (!detached && activeEffectScope) {\r\n            this.parent = activeEffectScope;\r\n            this.index =\r\n                (activeEffectScope.scopes || (activeEffectScope.scopes = [])).push(this) - 1;\r\n        }\r\n    }\r\n    run(fn) {\r\n        if (this.active) {\r\n            try {\r\n                this.on();\r\n                return fn();\r\n            }\r\n            finally {\r\n                this.off();\r\n            }\r\n        }\r\n        else if ((true)) {\r\n            warn(`cannot run an inactive effect scope.`);\r\n        }\r\n    }\r\n    on() {\r\n        if (this.active) {\r\n            effectScopeStack.push(this);\r\n            activeEffectScope = this;\r\n        }\r\n    }\r\n    off() {\r\n        if (this.active) {\r\n            effectScopeStack.pop();\r\n            activeEffectScope = effectScopeStack[effectScopeStack.length - 1];\r\n        }\r\n    }\r\n    stop(fromParent) {\r\n        if (this.active) {\r\n            this.effects.forEach(e => e.stop());\r\n            this.cleanups.forEach(cleanup => cleanup());\r\n            if (this.scopes) {\r\n                this.scopes.forEach(e => e.stop(true));\r\n            }\r\n            // nested scope, dereference from parent to avoid memory leaks\r\n            if (this.parent && !fromParent) {\r\n                // optimized O(1) removal\r\n                const last = this.parent.scopes.pop();\r\n                if (last && last !== this) {\r\n                    this.parent.scopes[this.index] = last;\r\n                    last.index = this.index;\r\n                }\r\n            }\r\n            this.active = false;\r\n        }\r\n    }\r\n}\r\nfunction effectScope(detached) {\r\n    return new EffectScope(detached);\r\n}\r\nfunction recordEffectScope(effect, scope) {\r\n    scope = scope || activeEffectScope;\r\n    if (scope && scope.active) {\r\n        scope.effects.push(effect);\r\n    }\r\n}\r\nfunction getCurrentScope() {\r\n    return activeEffectScope;\r\n}\r\nfunction onScopeDispose(fn) {\r\n    if (activeEffectScope) {\r\n        activeEffectScope.cleanups.push(fn);\r\n    }\r\n    else if ((true)) {\r\n        warn(`onScopeDispose() is called when there is no active effect scope` +\r\n            ` to be associated with.`);\r\n    }\r\n}\n\nconst createDep = (effects) => {\r\n    const dep = new Set(effects);\r\n    dep.w = 0;\r\n    dep.n = 0;\r\n    return dep;\r\n};\r\nconst wasTracked = (dep) => (dep.w & trackOpBit) > 0;\r\nconst newTracked = (dep) => (dep.n & trackOpBit) > 0;\r\nconst initDepMarkers = ({ deps }) => {\r\n    if (deps.length) {\r\n        for (let i = 0; i < deps.length; i++) {\r\n            deps[i].w |= trackOpBit; // set was tracked\r\n        }\r\n    }\r\n};\r\nconst finalizeDepMarkers = (effect) => {\r\n    const { deps } = effect;\r\n    if (deps.length) {\r\n        let ptr = 0;\r\n        for (let i = 0; i < deps.length; i++) {\r\n            const dep = deps[i];\r\n            if (wasTracked(dep) && !newTracked(dep)) {\r\n                dep.delete(effect);\r\n            }\r\n            else {\r\n                deps[ptr++] = dep;\r\n            }\r\n            // clear bits\r\n            dep.w &= ~trackOpBit;\r\n            dep.n &= ~trackOpBit;\r\n        }\r\n        deps.length = ptr;\r\n    }\r\n};\n\nconst targetMap = new WeakMap();\r\n// The number of effects currently being tracked recursively.\r\nlet effectTrackDepth = 0;\r\nlet trackOpBit = 1;\r\n/**\r\n * The bitwise track markers support at most 30 levels op recursion.\r\n * This value is chosen to enable modern JS engines to use a SMI on all platforms.\r\n * When recursion depth is greater, fall back to using a full cleanup.\r\n */\r\nconst maxMarkerBits = 30;\r\nconst effectStack = [];\r\nlet activeEffect;\r\nconst ITERATE_KEY = Symbol(( true) ? 'iterate' : 0);\r\nconst MAP_KEY_ITERATE_KEY = Symbol(( true) ? 'Map key iterate' : 0);\r\nclass ReactiveEffect {\r\n    constructor(fn, scheduler = null, scope) {\r\n        this.fn = fn;\r\n        this.scheduler = scheduler;\r\n        this.active = true;\r\n        this.deps = [];\r\n        recordEffectScope(this, scope);\r\n    }\r\n    run() {\r\n        if (!this.active) {\r\n            return this.fn();\r\n        }\r\n        if (!effectStack.includes(this)) {\r\n            try {\r\n                effectStack.push((activeEffect = this));\r\n                enableTracking();\r\n                trackOpBit = 1 << ++effectTrackDepth;\r\n                if (effectTrackDepth <= maxMarkerBits) {\r\n                    initDepMarkers(this);\r\n                }\r\n                else {\r\n                    cleanupEffect(this);\r\n                }\r\n                return this.fn();\r\n            }\r\n            finally {\r\n                if (effectTrackDepth <= maxMarkerBits) {\r\n                    finalizeDepMarkers(this);\r\n                }\r\n                trackOpBit = 1 << --effectTrackDepth;\r\n                resetTracking();\r\n                effectStack.pop();\r\n                const n = effectStack.length;\r\n                activeEffect = n > 0 ? effectStack[n - 1] : undefined;\r\n            }\r\n        }\r\n    }\r\n    stop() {\r\n        if (this.active) {\r\n            cleanupEffect(this);\r\n            if (this.onStop) {\r\n                this.onStop();\r\n            }\r\n            this.active = false;\r\n        }\r\n    }\r\n}\r\nfunction cleanupEffect(effect) {\r\n    const { deps } = effect;\r\n    if (deps.length) {\r\n        for (let i = 0; i < deps.length; i++) {\r\n            deps[i].delete(effect);\r\n        }\r\n        deps.length = 0;\r\n    }\r\n}\r\nfunction effect(fn, options) {\r\n    if (fn.effect) {\r\n        fn = fn.effect.fn;\r\n    }\r\n    const _effect = new ReactiveEffect(fn);\r\n    if (options) {\r\n        (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.extend)(_effect, options);\r\n        if (options.scope)\r\n            recordEffectScope(_effect, options.scope);\r\n    }\r\n    if (!options || !options.lazy) {\r\n        _effect.run();\r\n    }\r\n    const runner = _effect.run.bind(_effect);\r\n    runner.effect = _effect;\r\n    return runner;\r\n}\r\nfunction stop(runner) {\r\n    runner.effect.stop();\r\n}\r\nlet shouldTrack = true;\r\nconst trackStack = [];\r\nfunction pauseTracking() {\r\n    trackStack.push(shouldTrack);\r\n    shouldTrack = false;\r\n}\r\nfunction enableTracking() {\r\n    trackStack.push(shouldTrack);\r\n    shouldTrack = true;\r\n}\r\nfunction resetTracking() {\r\n    const last = trackStack.pop();\r\n    shouldTrack = last === undefined ? true : last;\r\n}\r\nfunction track(target, type, key) {\r\n    if (!isTracking()) {\r\n        return;\r\n    }\r\n    let depsMap = targetMap.get(target);\r\n    if (!depsMap) {\r\n        targetMap.set(target, (depsMap = new Map()));\r\n    }\r\n    let dep = depsMap.get(key);\r\n    if (!dep) {\r\n        depsMap.set(key, (dep = createDep()));\r\n    }\r\n    const eventInfo = ( true)\r\n        ? { effect: activeEffect, target, type, key }\r\n        : 0;\r\n    trackEffects(dep, eventInfo);\r\n}\r\nfunction isTracking() {\r\n    return shouldTrack && activeEffect !== undefined;\r\n}\r\nfunction trackEffects(dep, debuggerEventExtraInfo) {\r\n    let shouldTrack = false;\r\n    if (effectTrackDepth <= maxMarkerBits) {\r\n        if (!newTracked(dep)) {\r\n            dep.n |= trackOpBit; // set newly tracked\r\n            shouldTrack = !wasTracked(dep);\r\n        }\r\n    }\r\n    else {\r\n        // Full cleanup mode.\r\n        shouldTrack = !dep.has(activeEffect);\r\n    }\r\n    if (shouldTrack) {\r\n        dep.add(activeEffect);\r\n        activeEffect.deps.push(dep);\r\n        if (( true) && activeEffect.onTrack) {\r\n            activeEffect.onTrack(Object.assign({\r\n                effect: activeEffect\r\n            }, debuggerEventExtraInfo));\r\n        }\r\n    }\r\n}\r\nfunction trigger(target, type, key, newValue, oldValue, oldTarget) {\r\n    const depsMap = targetMap.get(target);\r\n    if (!depsMap) {\r\n        // never been tracked\r\n        return;\r\n    }\r\n    let deps = [];\r\n    if (type === \"clear\" /* CLEAR */) {\r\n        // collection being cleared\r\n        // trigger all effects for target\r\n        deps = [...depsMap.values()];\r\n    }\r\n    else if (key === 'length' && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(target)) {\r\n        depsMap.forEach((dep, key) => {\r\n            if (key === 'length' || key >= newValue) {\r\n                deps.push(dep);\r\n            }\r\n        });\r\n    }\r\n    else {\r\n        // schedule runs for SET | ADD | DELETE\r\n        if (key !== void 0) {\r\n            deps.push(depsMap.get(key));\r\n        }\r\n        // also run for iteration key on ADD | DELETE | Map.SET\r\n        switch (type) {\r\n            case \"add\" /* ADD */:\r\n                if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(target)) {\r\n                    deps.push(depsMap.get(ITERATE_KEY));\r\n                    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isMap)(target)) {\r\n                        deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));\r\n                    }\r\n                }\r\n                else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isIntegerKey)(key)) {\r\n                    // new index added to array -> length changes\r\n                    deps.push(depsMap.get('length'));\r\n                }\r\n                break;\r\n            case \"delete\" /* DELETE */:\r\n                if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(target)) {\r\n                    deps.push(depsMap.get(ITERATE_KEY));\r\n                    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isMap)(target)) {\r\n                        deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));\r\n                    }\r\n                }\r\n                break;\r\n            case \"set\" /* SET */:\r\n                if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isMap)(target)) {\r\n                    deps.push(depsMap.get(ITERATE_KEY));\r\n                }\r\n                break;\r\n        }\r\n    }\r\n    const eventInfo = ( true)\r\n        ? { target, type, key, newValue, oldValue, oldTarget }\r\n        : 0;\r\n    if (deps.length === 1) {\r\n        if (deps[0]) {\r\n            if ((true)) {\r\n                triggerEffects(deps[0], eventInfo);\r\n            }\r\n            else {}\r\n        }\r\n    }\r\n    else {\r\n        const effects = [];\r\n        for (const dep of deps) {\r\n            if (dep) {\r\n                effects.push(...dep);\r\n            }\r\n        }\r\n        if ((true)) {\r\n            triggerEffects(createDep(effects), eventInfo);\r\n        }\r\n        else {}\r\n    }\r\n}\r\nfunction triggerEffects(dep, debuggerEventExtraInfo) {\r\n    // spread into array for stabilization\r\n    for (const effect of (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(dep) ? dep : [...dep]) {\r\n        if (effect !== activeEffect || effect.allowRecurse) {\r\n            if (( true) && effect.onTrigger) {\r\n                effect.onTrigger((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.extend)({ effect }, debuggerEventExtraInfo));\r\n            }\r\n            if (effect.scheduler) {\r\n                effect.scheduler();\r\n            }\r\n            else {\r\n                effect.run();\r\n            }\r\n        }\r\n    }\r\n}\n\nconst isNonTrackableKeys = /*#__PURE__*/ (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.makeMap)(`__proto__,__v_isRef,__isVue`);\r\nconst builtInSymbols = new Set(Object.getOwnPropertyNames(Symbol)\r\n    .map(key => Symbol[key])\r\n    .filter(_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isSymbol));\r\nconst get = /*#__PURE__*/ createGetter();\r\nconst shallowGet = /*#__PURE__*/ createGetter(false, true);\r\nconst readonlyGet = /*#__PURE__*/ createGetter(true);\r\nconst shallowReadonlyGet = /*#__PURE__*/ createGetter(true, true);\r\nconst arrayInstrumentations = /*#__PURE__*/ createArrayInstrumentations();\r\nfunction createArrayInstrumentations() {\r\n    const instrumentations = {};\r\n    ['includes', 'indexOf', 'lastIndexOf'].forEach(key => {\r\n        instrumentations[key] = function (...args) {\r\n            const arr = toRaw(this);\r\n            for (let i = 0, l = this.length; i < l; i++) {\r\n                track(arr, \"get\" /* GET */, i + '');\r\n            }\r\n            // we run the method using the original args first (which may be reactive)\r\n            const res = arr[key](...args);\r\n            if (res === -1 || res === false) {\r\n                // if that didn't work, run it again using raw values.\r\n                return arr[key](...args.map(toRaw));\r\n            }\r\n            else {\r\n                return res;\r\n            }\r\n        };\r\n    });\r\n    ['push', 'pop', 'shift', 'unshift', 'splice'].forEach(key => {\r\n        instrumentations[key] = function (...args) {\r\n            pauseTracking();\r\n            const res = toRaw(this)[key].apply(this, args);\r\n            resetTracking();\r\n            return res;\r\n        };\r\n    });\r\n    return instrumentations;\r\n}\r\nfunction createGetter(isReadonly = false, shallow = false) {\r\n    return function get(target, key, receiver) {\r\n        if (key === \"__v_isReactive\" /* IS_REACTIVE */) {\r\n            return !isReadonly;\r\n        }\r\n        else if (key === \"__v_isReadonly\" /* IS_READONLY */) {\r\n            return isReadonly;\r\n        }\r\n        else if (key === \"__v_raw\" /* RAW */ &&\r\n            receiver ===\r\n                (isReadonly\r\n                    ? shallow\r\n                        ? shallowReadonlyMap\r\n                        : readonlyMap\r\n                    : shallow\r\n                        ? shallowReactiveMap\r\n                        : reactiveMap).get(target)) {\r\n            return target;\r\n        }\r\n        const targetIsArray = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(target);\r\n        if (!isReadonly && targetIsArray && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasOwn)(arrayInstrumentations, key)) {\r\n            return Reflect.get(arrayInstrumentations, key, receiver);\r\n        }\r\n        const res = Reflect.get(target, key, receiver);\r\n        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isSymbol)(key) ? builtInSymbols.has(key) : isNonTrackableKeys(key)) {\r\n            return res;\r\n        }\r\n        if (!isReadonly) {\r\n            track(target, \"get\" /* GET */, key);\r\n        }\r\n        if (shallow) {\r\n            return res;\r\n        }\r\n        if (isRef(res)) {\r\n            // ref unwrapping - does not apply for Array + integer key.\r\n            const shouldUnwrap = !targetIsArray || !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isIntegerKey)(key);\r\n            return shouldUnwrap ? res.value : res;\r\n        }\r\n        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isObject)(res)) {\r\n            // Convert returned value into a proxy as well. we do the isObject check\r\n            // here to avoid invalid value warning. Also need to lazy access readonly\r\n            // and reactive here to avoid circular dependency.\r\n            return isReadonly ? readonly(res) : reactive(res);\r\n        }\r\n        return res;\r\n    };\r\n}\r\nconst set = /*#__PURE__*/ createSetter();\r\nconst shallowSet = /*#__PURE__*/ createSetter(true);\r\nfunction createSetter(shallow = false) {\r\n    return function set(target, key, value, receiver) {\r\n        let oldValue = target[key];\r\n        if (!shallow) {\r\n            value = toRaw(value);\r\n            oldValue = toRaw(oldValue);\r\n            if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(target) && isRef(oldValue) && !isRef(value)) {\r\n                oldValue.value = value;\r\n                return true;\r\n            }\r\n        }\r\n        const hadKey = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(target) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isIntegerKey)(key)\r\n            ? Number(key) < target.length\r\n            : (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasOwn)(target, key);\r\n        const result = Reflect.set(target, key, value, receiver);\r\n        // don't trigger if target is something up in the prototype chain of original\r\n        if (target === toRaw(receiver)) {\r\n            if (!hadKey) {\r\n                trigger(target, \"add\" /* ADD */, key, value);\r\n            }\r\n            else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasChanged)(value, oldValue)) {\r\n                trigger(target, \"set\" /* SET */, key, value, oldValue);\r\n            }\r\n        }\r\n        return result;\r\n    };\r\n}\r\nfunction deleteProperty(target, key) {\r\n    const hadKey = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasOwn)(target, key);\r\n    const oldValue = target[key];\r\n    const result = Reflect.deleteProperty(target, key);\r\n    if (result && hadKey) {\r\n        trigger(target, \"delete\" /* DELETE */, key, undefined, oldValue);\r\n    }\r\n    return result;\r\n}\r\nfunction has(target, key) {\r\n    const result = Reflect.has(target, key);\r\n    if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isSymbol)(key) || !builtInSymbols.has(key)) {\r\n        track(target, \"has\" /* HAS */, key);\r\n    }\r\n    return result;\r\n}\r\nfunction ownKeys(target) {\r\n    track(target, \"iterate\" /* ITERATE */, (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(target) ? 'length' : ITERATE_KEY);\r\n    return Reflect.ownKeys(target);\r\n}\r\nconst mutableHandlers = {\r\n    get,\r\n    set,\r\n    deleteProperty,\r\n    has,\r\n    ownKeys\r\n};\r\nconst readonlyHandlers = {\r\n    get: readonlyGet,\r\n    set(target, key) {\r\n        if ((true)) {\r\n            console.warn(`Set operation on key \"${String(key)}\" failed: target is readonly.`, target);\r\n        }\r\n        return true;\r\n    },\r\n    deleteProperty(target, key) {\r\n        if ((true)) {\r\n            console.warn(`Delete operation on key \"${String(key)}\" failed: target is readonly.`, target);\r\n        }\r\n        return true;\r\n    }\r\n};\r\nconst shallowReactiveHandlers = /*#__PURE__*/ (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.extend)({}, mutableHandlers, {\r\n    get: shallowGet,\r\n    set: shallowSet\r\n});\r\n// Props handlers are special in the sense that it should not unwrap top-level\r\n// refs (in order to allow refs to be explicitly passed down), but should\r\n// retain the reactivity of the normal readonly object.\r\nconst shallowReadonlyHandlers = /*#__PURE__*/ (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.extend)({}, readonlyHandlers, {\r\n    get: shallowReadonlyGet\r\n});\n\nconst toShallow = (value) => value;\r\nconst getProto = (v) => Reflect.getPrototypeOf(v);\r\nfunction get$1(target, key, isReadonly = false, isShallow = false) {\r\n    // #1772: readonly(reactive(Map)) should return readonly + reactive version\r\n    // of the value\r\n    target = target[\"__v_raw\" /* RAW */];\r\n    const rawTarget = toRaw(target);\r\n    const rawKey = toRaw(key);\r\n    if (key !== rawKey) {\r\n        !isReadonly && track(rawTarget, \"get\" /* GET */, key);\r\n    }\r\n    !isReadonly && track(rawTarget, \"get\" /* GET */, rawKey);\r\n    const { has } = getProto(rawTarget);\r\n    const wrap = isShallow ? toShallow : isReadonly ? toReadonly : toReactive;\r\n    if (has.call(rawTarget, key)) {\r\n        return wrap(target.get(key));\r\n    }\r\n    else if (has.call(rawTarget, rawKey)) {\r\n        return wrap(target.get(rawKey));\r\n    }\r\n    else if (target !== rawTarget) {\r\n        // #3602 readonly(reactive(Map))\r\n        // ensure that the nested reactive `Map` can do tracking for itself\r\n        target.get(key);\r\n    }\r\n}\r\nfunction has$1(key, isReadonly = false) {\r\n    const target = this[\"__v_raw\" /* RAW */];\r\n    const rawTarget = toRaw(target);\r\n    const rawKey = toRaw(key);\r\n    if (key !== rawKey) {\r\n        !isReadonly && track(rawTarget, \"has\" /* HAS */, key);\r\n    }\r\n    !isReadonly && track(rawTarget, \"has\" /* HAS */, rawKey);\r\n    return key === rawKey\r\n        ? target.has(key)\r\n        : target.has(key) || target.has(rawKey);\r\n}\r\nfunction size(target, isReadonly = false) {\r\n    target = target[\"__v_raw\" /* RAW */];\r\n    !isReadonly && track(toRaw(target), \"iterate\" /* ITERATE */, ITERATE_KEY);\r\n    return Reflect.get(target, 'size', target);\r\n}\r\nfunction add(value) {\r\n    value = toRaw(value);\r\n    const target = toRaw(this);\r\n    const proto = getProto(target);\r\n    const hadKey = proto.has.call(target, value);\r\n    if (!hadKey) {\r\n        target.add(value);\r\n        trigger(target, \"add\" /* ADD */, value, value);\r\n    }\r\n    return this;\r\n}\r\nfunction set$1(key, value) {\r\n    value = toRaw(value);\r\n    const target = toRaw(this);\r\n    const { has, get } = getProto(target);\r\n    let hadKey = has.call(target, key);\r\n    if (!hadKey) {\r\n        key = toRaw(key);\r\n        hadKey = has.call(target, key);\r\n    }\r\n    else if ((true)) {\r\n        checkIdentityKeys(target, has, key);\r\n    }\r\n    const oldValue = get.call(target, key);\r\n    target.set(key, value);\r\n    if (!hadKey) {\r\n        trigger(target, \"add\" /* ADD */, key, value);\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasChanged)(value, oldValue)) {\r\n        trigger(target, \"set\" /* SET */, key, value, oldValue);\r\n    }\r\n    return this;\r\n}\r\nfunction deleteEntry(key) {\r\n    const target = toRaw(this);\r\n    const { has, get } = getProto(target);\r\n    let hadKey = has.call(target, key);\r\n    if (!hadKey) {\r\n        key = toRaw(key);\r\n        hadKey = has.call(target, key);\r\n    }\r\n    else if ((true)) {\r\n        checkIdentityKeys(target, has, key);\r\n    }\r\n    const oldValue = get ? get.call(target, key) : undefined;\r\n    // forward the operation before queueing reactions\r\n    const result = target.delete(key);\r\n    if (hadKey) {\r\n        trigger(target, \"delete\" /* DELETE */, key, undefined, oldValue);\r\n    }\r\n    return result;\r\n}\r\nfunction clear() {\r\n    const target = toRaw(this);\r\n    const hadItems = target.size !== 0;\r\n    const oldTarget = ( true)\r\n        ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isMap)(target)\r\n            ? new Map(target)\r\n            : new Set(target)\r\n        : 0;\r\n    // forward the operation before queueing reactions\r\n    const result = target.clear();\r\n    if (hadItems) {\r\n        trigger(target, \"clear\" /* CLEAR */, undefined, undefined, oldTarget);\r\n    }\r\n    return result;\r\n}\r\nfunction createForEach(isReadonly, isShallow) {\r\n    return function forEach(callback, thisArg) {\r\n        const observed = this;\r\n        const target = observed[\"__v_raw\" /* RAW */];\r\n        const rawTarget = toRaw(target);\r\n        const wrap = isShallow ? toShallow : isReadonly ? toReadonly : toReactive;\r\n        !isReadonly && track(rawTarget, \"iterate\" /* ITERATE */, ITERATE_KEY);\r\n        return target.forEach((value, key) => {\r\n            // important: make sure the callback is\r\n            // 1. invoked with the reactive map as `this` and 3rd arg\r\n            // 2. the value received should be a corresponding reactive/readonly.\r\n            return callback.call(thisArg, wrap(value), wrap(key), observed);\r\n        });\r\n    };\r\n}\r\nfunction createIterableMethod(method, isReadonly, isShallow) {\r\n    return function (...args) {\r\n        const target = this[\"__v_raw\" /* RAW */];\r\n        const rawTarget = toRaw(target);\r\n        const targetIsMap = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isMap)(rawTarget);\r\n        const isPair = method === 'entries' || (method === Symbol.iterator && targetIsMap);\r\n        const isKeyOnly = method === 'keys' && targetIsMap;\r\n        const innerIterator = target[method](...args);\r\n        const wrap = isShallow ? toShallow : isReadonly ? toReadonly : toReactive;\r\n        !isReadonly &&\r\n            track(rawTarget, \"iterate\" /* ITERATE */, isKeyOnly ? MAP_KEY_ITERATE_KEY : ITERATE_KEY);\r\n        // return a wrapped iterator which returns observed versions of the\r\n        // values emitted from the real iterator\r\n        return {\r\n            // iterator protocol\r\n            next() {\r\n                const { value, done } = innerIterator.next();\r\n                return done\r\n                    ? { value, done }\r\n                    : {\r\n                        value: isPair ? [wrap(value[0]), wrap(value[1])] : wrap(value),\r\n                        done\r\n                    };\r\n            },\r\n            // iterable protocol\r\n            [Symbol.iterator]() {\r\n                return this;\r\n            }\r\n        };\r\n    };\r\n}\r\nfunction createReadonlyMethod(type) {\r\n    return function (...args) {\r\n        if ((true)) {\r\n            const key = args[0] ? `on key \"${args[0]}\" ` : ``;\r\n            console.warn(`${(0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.capitalize)(type)} operation ${key}failed: target is readonly.`, toRaw(this));\r\n        }\r\n        return type === \"delete\" /* DELETE */ ? false : this;\r\n    };\r\n}\r\nfunction createInstrumentations() {\r\n    const mutableInstrumentations = {\r\n        get(key) {\r\n            return get$1(this, key);\r\n        },\r\n        get size() {\r\n            return size(this);\r\n        },\r\n        has: has$1,\r\n        add,\r\n        set: set$1,\r\n        delete: deleteEntry,\r\n        clear,\r\n        forEach: createForEach(false, false)\r\n    };\r\n    const shallowInstrumentations = {\r\n        get(key) {\r\n            return get$1(this, key, false, true);\r\n        },\r\n        get size() {\r\n            return size(this);\r\n        },\r\n        has: has$1,\r\n        add,\r\n        set: set$1,\r\n        delete: deleteEntry,\r\n        clear,\r\n        forEach: createForEach(false, true)\r\n    };\r\n    const readonlyInstrumentations = {\r\n        get(key) {\r\n            return get$1(this, key, true);\r\n        },\r\n        get size() {\r\n            return size(this, true);\r\n        },\r\n        has(key) {\r\n            return has$1.call(this, key, true);\r\n        },\r\n        add: createReadonlyMethod(\"add\" /* ADD */),\r\n        set: createReadonlyMethod(\"set\" /* SET */),\r\n        delete: createReadonlyMethod(\"delete\" /* DELETE */),\r\n        clear: createReadonlyMethod(\"clear\" /* CLEAR */),\r\n        forEach: createForEach(true, false)\r\n    };\r\n    const shallowReadonlyInstrumentations = {\r\n        get(key) {\r\n            return get$1(this, key, true, true);\r\n        },\r\n        get size() {\r\n            return size(this, true);\r\n        },\r\n        has(key) {\r\n            return has$1.call(this, key, true);\r\n        },\r\n        add: createReadonlyMethod(\"add\" /* ADD */),\r\n        set: createReadonlyMethod(\"set\" /* SET */),\r\n        delete: createReadonlyMethod(\"delete\" /* DELETE */),\r\n        clear: createReadonlyMethod(\"clear\" /* CLEAR */),\r\n        forEach: createForEach(true, true)\r\n    };\r\n    const iteratorMethods = ['keys', 'values', 'entries', Symbol.iterator];\r\n    iteratorMethods.forEach(method => {\r\n        mutableInstrumentations[method] = createIterableMethod(method, false, false);\r\n        readonlyInstrumentations[method] = createIterableMethod(method, true, false);\r\n        shallowInstrumentations[method] = createIterableMethod(method, false, true);\r\n        shallowReadonlyInstrumentations[method] = createIterableMethod(method, true, true);\r\n    });\r\n    return [\r\n        mutableInstrumentations,\r\n        readonlyInstrumentations,\r\n        shallowInstrumentations,\r\n        shallowReadonlyInstrumentations\r\n    ];\r\n}\r\nconst [mutableInstrumentations, readonlyInstrumentations, shallowInstrumentations, shallowReadonlyInstrumentations] = /* #__PURE__*/ createInstrumentations();\r\nfunction createInstrumentationGetter(isReadonly, shallow) {\r\n    const instrumentations = shallow\r\n        ? isReadonly\r\n            ? shallowReadonlyInstrumentations\r\n            : shallowInstrumentations\r\n        : isReadonly\r\n            ? readonlyInstrumentations\r\n            : mutableInstrumentations;\r\n    return (target, key, receiver) => {\r\n        if (key === \"__v_isReactive\" /* IS_REACTIVE */) {\r\n            return !isReadonly;\r\n        }\r\n        else if (key === \"__v_isReadonly\" /* IS_READONLY */) {\r\n            return isReadonly;\r\n        }\r\n        else if (key === \"__v_raw\" /* RAW */) {\r\n            return target;\r\n        }\r\n        return Reflect.get((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasOwn)(instrumentations, key) && key in target\r\n            ? instrumentations\r\n            : target, key, receiver);\r\n    };\r\n}\r\nconst mutableCollectionHandlers = {\r\n    get: /*#__PURE__*/ createInstrumentationGetter(false, false)\r\n};\r\nconst shallowCollectionHandlers = {\r\n    get: /*#__PURE__*/ createInstrumentationGetter(false, true)\r\n};\r\nconst readonlyCollectionHandlers = {\r\n    get: /*#__PURE__*/ createInstrumentationGetter(true, false)\r\n};\r\nconst shallowReadonlyCollectionHandlers = {\r\n    get: /*#__PURE__*/ createInstrumentationGetter(true, true)\r\n};\r\nfunction checkIdentityKeys(target, has, key) {\r\n    const rawKey = toRaw(key);\r\n    if (rawKey !== key && has.call(target, rawKey)) {\r\n        const type = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.toRawType)(target);\r\n        console.warn(`Reactive ${type} contains both the raw and reactive ` +\r\n            `versions of the same object${type === `Map` ? ` as keys` : ``}, ` +\r\n            `which can lead to inconsistencies. ` +\r\n            `Avoid differentiating between the raw and reactive versions ` +\r\n            `of an object and only use the reactive version if possible.`);\r\n    }\r\n}\n\nconst reactiveMap = new WeakMap();\r\nconst shallowReactiveMap = new WeakMap();\r\nconst readonlyMap = new WeakMap();\r\nconst shallowReadonlyMap = new WeakMap();\r\nfunction targetTypeMap(rawType) {\r\n    switch (rawType) {\r\n        case 'Object':\r\n        case 'Array':\r\n            return 1 /* COMMON */;\r\n        case 'Map':\r\n        case 'Set':\r\n        case 'WeakMap':\r\n        case 'WeakSet':\r\n            return 2 /* COLLECTION */;\r\n        default:\r\n            return 0 /* INVALID */;\r\n    }\r\n}\r\nfunction getTargetType(value) {\r\n    return value[\"__v_skip\" /* SKIP */] || !Object.isExtensible(value)\r\n        ? 0 /* INVALID */\r\n        : targetTypeMap((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.toRawType)(value));\r\n}\r\nfunction reactive(target) {\r\n    // if trying to observe a readonly proxy, return the readonly version.\r\n    if (target && target[\"__v_isReadonly\" /* IS_READONLY */]) {\r\n        return target;\r\n    }\r\n    return createReactiveObject(target, false, mutableHandlers, mutableCollectionHandlers, reactiveMap);\r\n}\r\n/**\r\n * Return a shallowly-reactive copy of the original object, where only the root\r\n * level properties are reactive. It also does not auto-unwrap refs (even at the\r\n * root level).\r\n */\r\nfunction shallowReactive(target) {\r\n    return createReactiveObject(target, false, shallowReactiveHandlers, shallowCollectionHandlers, shallowReactiveMap);\r\n}\r\n/**\r\n * Creates a readonly copy of the original object. Note the returned copy is not\r\n * made reactive, but `readonly` can be called on an already reactive object.\r\n */\r\nfunction readonly(target) {\r\n    return createReactiveObject(target, true, readonlyHandlers, readonlyCollectionHandlers, readonlyMap);\r\n}\r\n/**\r\n * Returns a reactive-copy of the original object, where only the root level\r\n * properties are readonly, and does NOT unwrap refs nor recursively convert\r\n * returned properties.\r\n * This is used for creating the props proxy object for stateful components.\r\n */\r\nfunction shallowReadonly(target) {\r\n    return createReactiveObject(target, true, shallowReadonlyHandlers, shallowReadonlyCollectionHandlers, shallowReadonlyMap);\r\n}\r\nfunction createReactiveObject(target, isReadonly, baseHandlers, collectionHandlers, proxyMap) {\r\n    if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isObject)(target)) {\r\n        if ((true)) {\r\n            console.warn(`value cannot be made reactive: ${String(target)}`);\r\n        }\r\n        return target;\r\n    }\r\n    // target is already a Proxy, return it.\r\n    // exception: calling readonly() on a reactive object\r\n    if (target[\"__v_raw\" /* RAW */] &&\r\n        !(isReadonly && target[\"__v_isReactive\" /* IS_REACTIVE */])) {\r\n        return target;\r\n    }\r\n    // target already has corresponding Proxy\r\n    const existingProxy = proxyMap.get(target);\r\n    if (existingProxy) {\r\n        return existingProxy;\r\n    }\r\n    // only a whitelist of value types can be observed.\r\n    const targetType = getTargetType(target);\r\n    if (targetType === 0 /* INVALID */) {\r\n        return target;\r\n    }\r\n    const proxy = new Proxy(target, targetType === 2 /* COLLECTION */ ? collectionHandlers : baseHandlers);\r\n    proxyMap.set(target, proxy);\r\n    return proxy;\r\n}\r\nfunction isReactive(value) {\r\n    if (isReadonly(value)) {\r\n        return isReactive(value[\"__v_raw\" /* RAW */]);\r\n    }\r\n    return !!(value && value[\"__v_isReactive\" /* IS_REACTIVE */]);\r\n}\r\nfunction isReadonly(value) {\r\n    return !!(value && value[\"__v_isReadonly\" /* IS_READONLY */]);\r\n}\r\nfunction isProxy(value) {\r\n    return isReactive(value) || isReadonly(value);\r\n}\r\nfunction toRaw(observed) {\r\n    const raw = observed && observed[\"__v_raw\" /* RAW */];\r\n    return raw ? toRaw(raw) : observed;\r\n}\r\nfunction markRaw(value) {\r\n    (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.def)(value, \"__v_skip\" /* SKIP */, true);\r\n    return value;\r\n}\r\nconst toReactive = (value) => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isObject)(value) ? reactive(value) : value;\r\nconst toReadonly = (value) => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isObject)(value) ? readonly(value) : value;\n\nfunction trackRefValue(ref) {\r\n    if (isTracking()) {\r\n        ref = toRaw(ref);\r\n        if (!ref.dep) {\r\n            ref.dep = createDep();\r\n        }\r\n        if ((true)) {\r\n            trackEffects(ref.dep, {\r\n                target: ref,\r\n                type: \"get\" /* GET */,\r\n                key: 'value'\r\n            });\r\n        }\r\n        else {}\r\n    }\r\n}\r\nfunction triggerRefValue(ref, newVal) {\r\n    ref = toRaw(ref);\r\n    if (ref.dep) {\r\n        if ((true)) {\r\n            triggerEffects(ref.dep, {\r\n                target: ref,\r\n                type: \"set\" /* SET */,\r\n                key: 'value',\r\n                newValue: newVal\r\n            });\r\n        }\r\n        else {}\r\n    }\r\n}\r\nfunction isRef(r) {\r\n    return Boolean(r && r.__v_isRef === true);\r\n}\r\nfunction ref(value) {\r\n    return createRef(value, false);\r\n}\r\nfunction shallowRef(value) {\r\n    return createRef(value, true);\r\n}\r\nfunction createRef(rawValue, shallow) {\r\n    if (isRef(rawValue)) {\r\n        return rawValue;\r\n    }\r\n    return new RefImpl(rawValue, shallow);\r\n}\r\nclass RefImpl {\r\n    constructor(value, _shallow) {\r\n        this._shallow = _shallow;\r\n        this.dep = undefined;\r\n        this.__v_isRef = true;\r\n        this._rawValue = _shallow ? value : toRaw(value);\r\n        this._value = _shallow ? value : toReactive(value);\r\n    }\r\n    get value() {\r\n        trackRefValue(this);\r\n        return this._value;\r\n    }\r\n    set value(newVal) {\r\n        newVal = this._shallow ? newVal : toRaw(newVal);\r\n        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.hasChanged)(newVal, this._rawValue)) {\r\n            this._rawValue = newVal;\r\n            this._value = this._shallow ? newVal : toReactive(newVal);\r\n            triggerRefValue(this, newVal);\r\n        }\r\n    }\r\n}\r\nfunction triggerRef(ref) {\r\n    triggerRefValue(ref, ( true) ? ref.value : 0);\r\n}\r\nfunction unref(ref) {\r\n    return isRef(ref) ? ref.value : ref;\r\n}\r\nconst shallowUnwrapHandlers = {\r\n    get: (target, key, receiver) => unref(Reflect.get(target, key, receiver)),\r\n    set: (target, key, value, receiver) => {\r\n        const oldValue = target[key];\r\n        if (isRef(oldValue) && !isRef(value)) {\r\n            oldValue.value = value;\r\n            return true;\r\n        }\r\n        else {\r\n            return Reflect.set(target, key, value, receiver);\r\n        }\r\n    }\r\n};\r\nfunction proxyRefs(objectWithRefs) {\r\n    return isReactive(objectWithRefs)\r\n        ? objectWithRefs\r\n        : new Proxy(objectWithRefs, shallowUnwrapHandlers);\r\n}\r\nclass CustomRefImpl {\r\n    constructor(factory) {\r\n        this.dep = undefined;\r\n        this.__v_isRef = true;\r\n        const { get, set } = factory(() => trackRefValue(this), () => triggerRefValue(this));\r\n        this._get = get;\r\n        this._set = set;\r\n    }\r\n    get value() {\r\n        return this._get();\r\n    }\r\n    set value(newVal) {\r\n        this._set(newVal);\r\n    }\r\n}\r\nfunction customRef(factory) {\r\n    return new CustomRefImpl(factory);\r\n}\r\nfunction toRefs(object) {\r\n    if (( true) && !isProxy(object)) {\r\n        console.warn(`toRefs() expects a reactive object but received a plain one.`);\r\n    }\r\n    const ret = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isArray)(object) ? new Array(object.length) : {};\r\n    for (const key in object) {\r\n        ret[key] = toRef(object, key);\r\n    }\r\n    return ret;\r\n}\r\nclass ObjectRefImpl {\r\n    constructor(_object, _key) {\r\n        this._object = _object;\r\n        this._key = _key;\r\n        this.__v_isRef = true;\r\n    }\r\n    get value() {\r\n        return this._object[this._key];\r\n    }\r\n    set value(newVal) {\r\n        this._object[this._key] = newVal;\r\n    }\r\n}\r\nfunction toRef(object, key) {\r\n    const val = object[key];\r\n    return isRef(val) ? val : new ObjectRefImpl(object, key);\r\n}\n\nclass ComputedRefImpl {\r\n    constructor(getter, _setter, isReadonly) {\r\n        this._setter = _setter;\r\n        this.dep = undefined;\r\n        this._dirty = true;\r\n        this.__v_isRef = true;\r\n        this.effect = new ReactiveEffect(getter, () => {\r\n            if (!this._dirty) {\r\n                this._dirty = true;\r\n                triggerRefValue(this);\r\n            }\r\n        });\r\n        this[\"__v_isReadonly\" /* IS_READONLY */] = isReadonly;\r\n    }\r\n    get value() {\r\n        // the computed ref may get wrapped by other proxies e.g. readonly() #3376\r\n        const self = toRaw(this);\r\n        trackRefValue(self);\r\n        if (self._dirty) {\r\n            self._dirty = false;\r\n            self._value = self.effect.run();\r\n        }\r\n        return self._value;\r\n    }\r\n    set value(newValue) {\r\n        this._setter(newValue);\r\n    }\r\n}\r\nfunction computed(getterOrOptions, debugOptions) {\r\n    let getter;\r\n    let setter;\r\n    const onlyGetter = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_0__.isFunction)(getterOrOptions);\r\n    if (onlyGetter) {\r\n        getter = getterOrOptions;\r\n        setter = ( true)\r\n            ? () => {\r\n                console.warn('Write operation failed: computed value is readonly');\r\n            }\r\n            : 0;\r\n    }\r\n    else {\r\n        getter = getterOrOptions.get;\r\n        setter = getterOrOptions.set;\r\n    }\r\n    const cRef = new ComputedRefImpl(getter, setter, onlyGetter || !setter);\r\n    if (( true) && debugOptions) {\r\n        cRef.effect.onTrack = debugOptions.onTrack;\r\n        cRef.effect.onTrigger = debugOptions.onTrigger;\r\n    }\r\n    return cRef;\r\n}\n\nvar _a;\r\nconst tick = Promise.resolve();\r\nconst queue = [];\r\nlet queued = false;\r\nconst scheduler = (fn) => {\r\n    queue.push(fn);\r\n    if (!queued) {\r\n        queued = true;\r\n        tick.then(flush);\r\n    }\r\n};\r\nconst flush = () => {\r\n    for (let i = 0; i < queue.length; i++) {\r\n        queue[i]();\r\n    }\r\n    queue.length = 0;\r\n    queued = false;\r\n};\r\nclass DeferredComputedRefImpl {\r\n    constructor(getter) {\r\n        this.dep = undefined;\r\n        this._dirty = true;\r\n        this.__v_isRef = true;\r\n        this[_a] = true;\r\n        let compareTarget;\r\n        let hasCompareTarget = false;\r\n        let scheduled = false;\r\n        this.effect = new ReactiveEffect(getter, (computedTrigger) => {\r\n            if (this.dep) {\r\n                if (computedTrigger) {\r\n                    compareTarget = this._value;\r\n                    hasCompareTarget = true;\r\n                }\r\n                else if (!scheduled) {\r\n                    const valueToCompare = hasCompareTarget ? compareTarget : this._value;\r\n                    scheduled = true;\r\n                    hasCompareTarget = false;\r\n                    scheduler(() => {\r\n                        if (this.effect.active && this._get() !== valueToCompare) {\r\n                            triggerRefValue(this);\r\n                        }\r\n                        scheduled = false;\r\n                    });\r\n                }\r\n                // chained upstream computeds are notified synchronously to ensure\r\n                // value invalidation in case of sync access; normal effects are\r\n                // deferred to be triggered in scheduler.\r\n                for (const e of this.dep) {\r\n                    if (e.computed) {\r\n                        e.scheduler(true /* computedTrigger */);\r\n                    }\r\n                }\r\n            }\r\n            this._dirty = true;\r\n        });\r\n        this.effect.computed = true;\r\n    }\r\n    _get() {\r\n        if (this._dirty) {\r\n            this._dirty = false;\r\n            return (this._value = this.effect.run());\r\n        }\r\n        return this._value;\r\n    }\r\n    get value() {\r\n        trackRefValue(this);\r\n        // the computed ref may get wrapped by other proxies e.g. readonly() #3376\r\n        return toRaw(this)._get();\r\n    }\r\n}\r\n_a = \"__v_isReadonly\" /* IS_READONLY */;\r\nfunction deferredComputed(getter) {\r\n    return new DeferredComputedRefImpl(getter);\r\n}\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@vue/reactivity/dist/reactivity.esm-bundler.js\n");

/***/ }),

/***/ "./node_modules/@vue/runtime-core/dist/runtime-core.esm-bundler.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@vue/runtime-core/dist/runtime-core.esm-bundler.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"EffectScope\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.EffectScope),\n/* harmony export */   \"ReactiveEffect\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.ReactiveEffect),\n/* harmony export */   \"computed\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.computed),\n/* harmony export */   \"customRef\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.customRef),\n/* harmony export */   \"effect\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.effect),\n/* harmony export */   \"effectScope\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.effectScope),\n/* harmony export */   \"getCurrentScope\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.getCurrentScope),\n/* harmony export */   \"isProxy\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isProxy),\n/* harmony export */   \"isReactive\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isReactive),\n/* harmony export */   \"isReadonly\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isReadonly),\n/* harmony export */   \"isRef\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef),\n/* harmony export */   \"markRaw\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.markRaw),\n/* harmony export */   \"onScopeDispose\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.onScopeDispose),\n/* harmony export */   \"proxyRefs\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.proxyRefs),\n/* harmony export */   \"reactive\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.reactive),\n/* harmony export */   \"readonly\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.readonly),\n/* harmony export */   \"ref\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.ref),\n/* harmony export */   \"shallowReactive\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReactive),\n/* harmony export */   \"shallowReadonly\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly),\n/* harmony export */   \"shallowRef\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowRef),\n/* harmony export */   \"stop\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.stop),\n/* harmony export */   \"toRaw\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw),\n/* harmony export */   \"toRef\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRef),\n/* harmony export */   \"toRefs\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRefs),\n/* harmony export */   \"triggerRef\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.triggerRef),\n/* harmony export */   \"unref\": () => (/* reexport safe */ _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.unref),\n/* harmony export */   \"camelize\": () => (/* reexport safe */ _vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize),\n/* harmony export */   \"capitalize\": () => (/* reexport safe */ _vue_shared__WEBPACK_IMPORTED_MODULE_1__.capitalize),\n/* harmony export */   \"normalizeClass\": () => (/* reexport safe */ _vue_shared__WEBPACK_IMPORTED_MODULE_1__.normalizeClass),\n/* harmony export */   \"normalizeProps\": () => (/* reexport safe */ _vue_shared__WEBPACK_IMPORTED_MODULE_1__.normalizeProps),\n/* harmony export */   \"normalizeStyle\": () => (/* reexport safe */ _vue_shared__WEBPACK_IMPORTED_MODULE_1__.normalizeStyle),\n/* harmony export */   \"toDisplayString\": () => (/* reexport safe */ _vue_shared__WEBPACK_IMPORTED_MODULE_1__.toDisplayString),\n/* harmony export */   \"toHandlerKey\": () => (/* reexport safe */ _vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey),\n/* harmony export */   \"BaseTransition\": () => (/* binding */ BaseTransition),\n/* harmony export */   \"Comment\": () => (/* binding */ Comment),\n/* harmony export */   \"Fragment\": () => (/* binding */ Fragment),\n/* harmony export */   \"KeepAlive\": () => (/* binding */ KeepAlive),\n/* harmony export */   \"Static\": () => (/* binding */ Static),\n/* harmony export */   \"Suspense\": () => (/* binding */ Suspense),\n/* harmony export */   \"Teleport\": () => (/* binding */ Teleport),\n/* harmony export */   \"Text\": () => (/* binding */ Text),\n/* harmony export */   \"callWithAsyncErrorHandling\": () => (/* binding */ callWithAsyncErrorHandling),\n/* harmony export */   \"callWithErrorHandling\": () => (/* binding */ callWithErrorHandling),\n/* harmony export */   \"cloneVNode\": () => (/* binding */ cloneVNode),\n/* harmony export */   \"compatUtils\": () => (/* binding */ compatUtils),\n/* harmony export */   \"createBlock\": () => (/* binding */ createBlock),\n/* harmony export */   \"createCommentVNode\": () => (/* binding */ createCommentVNode),\n/* harmony export */   \"createElementBlock\": () => (/* binding */ createElementBlock),\n/* harmony export */   \"createElementVNode\": () => (/* binding */ createBaseVNode),\n/* harmony export */   \"createHydrationRenderer\": () => (/* binding */ createHydrationRenderer),\n/* harmony export */   \"createPropsRestProxy\": () => (/* binding */ createPropsRestProxy),\n/* harmony export */   \"createRenderer\": () => (/* binding */ createRenderer),\n/* harmony export */   \"createSlots\": () => (/* binding */ createSlots),\n/* harmony export */   \"createStaticVNode\": () => (/* binding */ createStaticVNode),\n/* harmony export */   \"createTextVNode\": () => (/* binding */ createTextVNode),\n/* harmony export */   \"createVNode\": () => (/* binding */ createVNode),\n/* harmony export */   \"defineAsyncComponent\": () => (/* binding */ defineAsyncComponent),\n/* harmony export */   \"defineComponent\": () => (/* binding */ defineComponent),\n/* harmony export */   \"defineEmits\": () => (/* binding */ defineEmits),\n/* harmony export */   \"defineExpose\": () => (/* binding */ defineExpose),\n/* harmony export */   \"defineProps\": () => (/* binding */ defineProps),\n/* harmony export */   \"devtools\": () => (/* binding */ devtools),\n/* harmony export */   \"getCurrentInstance\": () => (/* binding */ getCurrentInstance),\n/* harmony export */   \"getTransitionRawChildren\": () => (/* binding */ getTransitionRawChildren),\n/* harmony export */   \"guardReactiveProps\": () => (/* binding */ guardReactiveProps),\n/* harmony export */   \"h\": () => (/* binding */ h),\n/* harmony export */   \"handleError\": () => (/* binding */ handleError),\n/* harmony export */   \"initCustomFormatter\": () => (/* binding */ initCustomFormatter),\n/* harmony export */   \"inject\": () => (/* binding */ inject),\n/* harmony export */   \"isMemoSame\": () => (/* binding */ isMemoSame),\n/* harmony export */   \"isRuntimeOnly\": () => (/* binding */ isRuntimeOnly),\n/* harmony export */   \"isVNode\": () => (/* binding */ isVNode),\n/* harmony export */   \"mergeDefaults\": () => (/* binding */ mergeDefaults),\n/* harmony export */   \"mergeProps\": () => (/* binding */ mergeProps),\n/* harmony export */   \"nextTick\": () => (/* binding */ nextTick),\n/* harmony export */   \"onActivated\": () => (/* binding */ onActivated),\n/* harmony export */   \"onBeforeMount\": () => (/* binding */ onBeforeMount),\n/* harmony export */   \"onBeforeUnmount\": () => (/* binding */ onBeforeUnmount),\n/* harmony export */   \"onBeforeUpdate\": () => (/* binding */ onBeforeUpdate),\n/* harmony export */   \"onDeactivated\": () => (/* binding */ onDeactivated),\n/* harmony export */   \"onErrorCaptured\": () => (/* binding */ onErrorCaptured),\n/* harmony export */   \"onMounted\": () => (/* binding */ onMounted),\n/* harmony export */   \"onRenderTracked\": () => (/* binding */ onRenderTracked),\n/* harmony export */   \"onRenderTriggered\": () => (/* binding */ onRenderTriggered),\n/* harmony export */   \"onServerPrefetch\": () => (/* binding */ onServerPrefetch),\n/* harmony export */   \"onUnmounted\": () => (/* binding */ onUnmounted),\n/* harmony export */   \"onUpdated\": () => (/* binding */ onUpdated),\n/* harmony export */   \"openBlock\": () => (/* binding */ openBlock),\n/* harmony export */   \"popScopeId\": () => (/* binding */ popScopeId),\n/* harmony export */   \"provide\": () => (/* binding */ provide),\n/* harmony export */   \"pushScopeId\": () => (/* binding */ pushScopeId),\n/* harmony export */   \"queuePostFlushCb\": () => (/* binding */ queuePostFlushCb),\n/* harmony export */   \"registerRuntimeCompiler\": () => (/* binding */ registerRuntimeCompiler),\n/* harmony export */   \"renderList\": () => (/* binding */ renderList),\n/* harmony export */   \"renderSlot\": () => (/* binding */ renderSlot),\n/* harmony export */   \"resolveComponent\": () => (/* binding */ resolveComponent),\n/* harmony export */   \"resolveDirective\": () => (/* binding */ resolveDirective),\n/* harmony export */   \"resolveDynamicComponent\": () => (/* binding */ resolveDynamicComponent),\n/* harmony export */   \"resolveFilter\": () => (/* binding */ resolveFilter),\n/* harmony export */   \"resolveTransitionHooks\": () => (/* binding */ resolveTransitionHooks),\n/* harmony export */   \"setBlockTracking\": () => (/* binding */ setBlockTracking),\n/* harmony export */   \"setDevtoolsHook\": () => (/* binding */ setDevtoolsHook),\n/* harmony export */   \"setTransitionHooks\": () => (/* binding */ setTransitionHooks),\n/* harmony export */   \"ssrContextKey\": () => (/* binding */ ssrContextKey),\n/* harmony export */   \"ssrUtils\": () => (/* binding */ ssrUtils),\n/* harmony export */   \"toHandlers\": () => (/* binding */ toHandlers),\n/* harmony export */   \"transformVNodeArgs\": () => (/* binding */ transformVNodeArgs),\n/* harmony export */   \"useAttrs\": () => (/* binding */ useAttrs),\n/* harmony export */   \"useSSRContext\": () => (/* binding */ useSSRContext),\n/* harmony export */   \"useSlots\": () => (/* binding */ useSlots),\n/* harmony export */   \"useTransitionState\": () => (/* binding */ useTransitionState),\n/* harmony export */   \"version\": () => (/* binding */ version),\n/* harmony export */   \"warn\": () => (/* binding */ warn),\n/* harmony export */   \"watch\": () => (/* binding */ watch),\n/* harmony export */   \"watchEffect\": () => (/* binding */ watchEffect),\n/* harmony export */   \"watchPostEffect\": () => (/* binding */ watchPostEffect),\n/* harmony export */   \"watchSyncEffect\": () => (/* binding */ watchSyncEffect),\n/* harmony export */   \"withAsyncContext\": () => (/* binding */ withAsyncContext),\n/* harmony export */   \"withCtx\": () => (/* binding */ withCtx),\n/* harmony export */   \"withDefaults\": () => (/* binding */ withDefaults),\n/* harmony export */   \"withDirectives\": () => (/* binding */ withDirectives),\n/* harmony export */   \"withMemo\": () => (/* binding */ withMemo),\n/* harmony export */   \"withScopeId\": () => (/* binding */ withScopeId)\n/* harmony export */ });\n/* harmony import */ var _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @vue/reactivity */ \"./node_modules/@vue/reactivity/dist/reactivity.esm-bundler.js\");\n/* harmony import */ var _vue_shared__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @vue/shared */ \"./node_modules/@vue/shared/dist/shared.esm-bundler.js\");\n\n\n\n\n\n/* eslint-disable no-restricted-globals */\r\nlet isHmrUpdating = false;\r\nconst hmrDirtyComponents = new Set();\r\n// Expose the HMR runtime on the global object\r\n// This makes it entirely tree-shakable without polluting the exports and makes\r\n// it easier to be used in toolings like vue-loader\r\n// Note: for a component to be eligible for HMR it also needs the __hmrId option\r\n// to be set so that its instances can be registered / removed.\r\nif ((true)) {\r\n    (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.getGlobalThis)().__VUE_HMR_RUNTIME__ = {\r\n        createRecord: tryWrap(createRecord),\r\n        rerender: tryWrap(rerender),\r\n        reload: tryWrap(reload)\r\n    };\r\n}\r\nconst map = new Map();\r\nfunction registerHMR(instance) {\r\n    const id = instance.type.__hmrId;\r\n    let record = map.get(id);\r\n    if (!record) {\r\n        createRecord(id, instance.type);\r\n        record = map.get(id);\r\n    }\r\n    record.instances.add(instance);\r\n}\r\nfunction unregisterHMR(instance) {\r\n    map.get(instance.type.__hmrId).instances.delete(instance);\r\n}\r\nfunction createRecord(id, initialDef) {\r\n    if (map.has(id)) {\r\n        return false;\r\n    }\r\n    map.set(id, {\r\n        initialDef: normalizeClassComponent(initialDef),\r\n        instances: new Set()\r\n    });\r\n    return true;\r\n}\r\nfunction normalizeClassComponent(component) {\r\n    return isClassComponent(component) ? component.__vccOpts : component;\r\n}\r\nfunction rerender(id, newRender) {\r\n    const record = map.get(id);\r\n    if (!record) {\r\n        return;\r\n    }\r\n    // update initial record (for not-yet-rendered component)\r\n    record.initialDef.render = newRender;\r\n    [...record.instances].forEach(instance => {\r\n        if (newRender) {\r\n            instance.render = newRender;\r\n            normalizeClassComponent(instance.type).render = newRender;\r\n        }\r\n        instance.renderCache = [];\r\n        // this flag forces child components with slot content to update\r\n        isHmrUpdating = true;\r\n        instance.update();\r\n        isHmrUpdating = false;\r\n    });\r\n}\r\nfunction reload(id, newComp) {\r\n    const record = map.get(id);\r\n    if (!record)\r\n        return;\r\n    newComp = normalizeClassComponent(newComp);\r\n    // update initial def (for not-yet-rendered components)\r\n    updateComponentDef(record.initialDef, newComp);\r\n    // create a snapshot which avoids the set being mutated during updates\r\n    const instances = [...record.instances];\r\n    for (const instance of instances) {\r\n        const oldComp = normalizeClassComponent(instance.type);\r\n        if (!hmrDirtyComponents.has(oldComp)) {\r\n            // 1. Update existing comp definition to match new one\r\n            if (oldComp !== record.initialDef) {\r\n                updateComponentDef(oldComp, newComp);\r\n            }\r\n            // 2. mark definition dirty. This forces the renderer to replace the\r\n            // component on patch.\r\n            hmrDirtyComponents.add(oldComp);\r\n        }\r\n        // 3. invalidate options resolution cache\r\n        instance.appContext.optionsCache.delete(instance.type);\r\n        // 4. actually update\r\n        if (instance.ceReload) {\r\n            // custom element\r\n            hmrDirtyComponents.add(oldComp);\r\n            instance.ceReload(newComp.styles);\r\n            hmrDirtyComponents.delete(oldComp);\r\n        }\r\n        else if (instance.parent) {\r\n            // 4. Force the parent instance to re-render. This will cause all updated\r\n            // components to be unmounted and re-mounted. Queue the update so that we\r\n            // don't end up forcing the same parent to re-render multiple times.\r\n            queueJob(instance.parent.update);\r\n            // instance is the inner component of an async custom element\r\n            // invoke to reset styles\r\n            if (instance.parent.type.__asyncLoader &&\r\n                instance.parent.ceReload) {\r\n                instance.parent.ceReload(newComp.styles);\r\n            }\r\n        }\r\n        else if (instance.appContext.reload) {\r\n            // root instance mounted via createApp() has a reload method\r\n            instance.appContext.reload();\r\n        }\r\n        else if (typeof window !== 'undefined') {\r\n            // root instance inside tree created via raw render(). Force reload.\r\n            window.location.reload();\r\n        }\r\n        else {\r\n            console.warn('[HMR] Root or manually mounted instance modified. Full reload required.');\r\n        }\r\n    }\r\n    // 5. make sure to cleanup dirty hmr components after update\r\n    queuePostFlushCb(() => {\r\n        for (const instance of instances) {\r\n            hmrDirtyComponents.delete(normalizeClassComponent(instance.type));\r\n        }\r\n    });\r\n}\r\nfunction updateComponentDef(oldComp, newComp) {\r\n    (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(oldComp, newComp);\r\n    for (const key in oldComp) {\r\n        if (key !== '__file' && !(key in newComp)) {\r\n            delete oldComp[key];\r\n        }\r\n    }\r\n}\r\nfunction tryWrap(fn) {\r\n    return (id, arg) => {\r\n        try {\r\n            return fn(id, arg);\r\n        }\r\n        catch (e) {\r\n            console.error(e);\r\n            console.warn(`[HMR] Something went wrong during Vue component hot-reload. ` +\r\n                `Full reload required.`);\r\n        }\r\n    };\r\n}\n\nlet devtools;\r\nlet buffer = [];\r\nlet devtoolsNotInstalled = false;\r\nfunction emit(event, ...args) {\r\n    if (devtools) {\r\n        devtools.emit(event, ...args);\r\n    }\r\n    else if (!devtoolsNotInstalled) {\r\n        buffer.push({ event, args });\r\n    }\r\n}\r\nfunction setDevtoolsHook(hook, target) {\r\n    var _a, _b;\r\n    devtools = hook;\r\n    if (devtools) {\r\n        devtools.enabled = true;\r\n        buffer.forEach(({ event, args }) => devtools.emit(event, ...args));\r\n        buffer = [];\r\n    }\r\n    else if (\r\n    // handle late devtools injection - only do this if we are in an actual\r\n    // browser environment to avoid the timer handle stalling test runner exit\r\n    // (#4815)\r\n    // eslint-disable-next-line no-restricted-globals\r\n    typeof window !== 'undefined' &&\r\n        // some envs mock window but not fully\r\n        window.HTMLElement &&\r\n        // also exclude jsdom\r\n        !((_b = (_a = window.navigator) === null || _a === void 0 ? void 0 : _a.userAgent) === null || _b === void 0 ? void 0 : _b.includes('jsdom'))) {\r\n        const replay = (target.__VUE_DEVTOOLS_HOOK_REPLAY__ =\r\n            target.__VUE_DEVTOOLS_HOOK_REPLAY__ || []);\r\n        replay.push((newHook) => {\r\n            setDevtoolsHook(newHook, target);\r\n        });\r\n        // clear buffer after 3s - the user probably doesn't have devtools installed\r\n        // at all, and keeping the buffer will cause memory leaks (#4738)\r\n        setTimeout(() => {\r\n            if (!devtools) {\r\n                target.__VUE_DEVTOOLS_HOOK_REPLAY__ = null;\r\n                devtoolsNotInstalled = true;\r\n                buffer = [];\r\n            }\r\n        }, 3000);\r\n    }\r\n    else {\r\n        // non-browser env, assume not installed\r\n        devtoolsNotInstalled = true;\r\n        buffer = [];\r\n    }\r\n}\r\nfunction devtoolsInitApp(app, version) {\r\n    emit(\"app:init\" /* APP_INIT */, app, version, {\r\n        Fragment,\r\n        Text,\r\n        Comment,\r\n        Static\r\n    });\r\n}\r\nfunction devtoolsUnmountApp(app) {\r\n    emit(\"app:unmount\" /* APP_UNMOUNT */, app);\r\n}\r\nconst devtoolsComponentAdded = /*#__PURE__*/ createDevtoolsComponentHook(\"component:added\" /* COMPONENT_ADDED */);\r\nconst devtoolsComponentUpdated = \r\n/*#__PURE__*/ createDevtoolsComponentHook(\"component:updated\" /* COMPONENT_UPDATED */);\r\nconst devtoolsComponentRemoved = \r\n/*#__PURE__*/ createDevtoolsComponentHook(\"component:removed\" /* COMPONENT_REMOVED */);\r\nfunction createDevtoolsComponentHook(hook) {\r\n    return (component) => {\r\n        emit(hook, component.appContext.app, component.uid, component.parent ? component.parent.uid : undefined, component);\r\n    };\r\n}\r\nconst devtoolsPerfStart = /*#__PURE__*/ createDevtoolsPerformanceHook(\"perf:start\" /* PERFORMANCE_START */);\r\nconst devtoolsPerfEnd = /*#__PURE__*/ createDevtoolsPerformanceHook(\"perf:end\" /* PERFORMANCE_END */);\r\nfunction createDevtoolsPerformanceHook(hook) {\r\n    return (component, type, time) => {\r\n        emit(hook, component.appContext.app, component.uid, component, type, time);\r\n    };\r\n}\r\nfunction devtoolsComponentEmit(component, event, params) {\r\n    emit(\"component:emit\" /* COMPONENT_EMIT */, component.appContext.app, component, event, params);\r\n}\n\nfunction emit$1(instance, event, ...rawArgs) {\r\n    const props = instance.vnode.props || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;\r\n    if ((true)) {\r\n        const { emitsOptions, propsOptions: [propsOptions] } = instance;\r\n        if (emitsOptions) {\r\n            if (!(event in emitsOptions) &&\r\n                !(false )) {\r\n                if (!propsOptions || !((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey)(event) in propsOptions)) {\r\n                    warn(`Component emitted event \"${event}\" but it is neither declared in ` +\r\n                        `the emits option nor as an \"${(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey)(event)}\" prop.`);\r\n                }\r\n            }\r\n            else {\r\n                const validator = emitsOptions[event];\r\n                if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(validator)) {\r\n                    const isValid = validator(...rawArgs);\r\n                    if (!isValid) {\r\n                        warn(`Invalid event arguments: event validation failed for event \"${event}\".`);\r\n                    }\r\n                }\r\n            }\r\n        }\r\n    }\r\n    let args = rawArgs;\r\n    const isModelListener = event.startsWith('update:');\r\n    // for v-model update:xxx events, apply modifiers on args\r\n    const modelArg = isModelListener && event.slice(7);\r\n    if (modelArg && modelArg in props) {\r\n        const modifiersKey = `${modelArg === 'modelValue' ? 'model' : modelArg}Modifiers`;\r\n        const { number, trim } = props[modifiersKey] || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;\r\n        if (trim) {\r\n            args = rawArgs.map(a => a.trim());\r\n        }\r\n        else if (number) {\r\n            args = rawArgs.map(_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toNumber);\r\n        }\r\n    }\r\n    if (true) {\r\n        devtoolsComponentEmit(instance, event, args);\r\n    }\r\n    if ((true)) {\r\n        const lowerCaseEvent = event.toLowerCase();\r\n        if (lowerCaseEvent !== event && props[(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey)(lowerCaseEvent)]) {\r\n            warn(`Event \"${lowerCaseEvent}\" is emitted in component ` +\r\n                `${formatComponentName(instance, instance.type)} but the handler is registered for \"${event}\". ` +\r\n                `Note that HTML attributes are case-insensitive and you cannot use ` +\r\n                `v-on to listen to camelCase events when using in-DOM templates. ` +\r\n                `You should probably use \"${(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(event)}\" instead of \"${event}\".`);\r\n        }\r\n    }\r\n    let handlerName;\r\n    let handler = props[(handlerName = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey)(event))] ||\r\n        // also try camelCase event handler (#2249)\r\n        props[(handlerName = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey)((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(event)))];\r\n    // for v-model update:xxx events, also trigger kebab-case equivalent\r\n    // for props passed via kebab-case\r\n    if (!handler && isModelListener) {\r\n        handler = props[(handlerName = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey)((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(event)))];\r\n    }\r\n    if (handler) {\r\n        callWithAsyncErrorHandling(handler, instance, 6 /* COMPONENT_EVENT_HANDLER */, args);\r\n    }\r\n    const onceHandler = props[handlerName + `Once`];\r\n    if (onceHandler) {\r\n        if (!instance.emitted) {\r\n            instance.emitted = {};\r\n        }\r\n        else if (instance.emitted[handlerName]) {\r\n            return;\r\n        }\r\n        instance.emitted[handlerName] = true;\r\n        callWithAsyncErrorHandling(onceHandler, instance, 6 /* COMPONENT_EVENT_HANDLER */, args);\r\n    }\r\n}\r\nfunction normalizeEmitsOptions(comp, appContext, asMixin = false) {\r\n    const cache = appContext.emitsCache;\r\n    const cached = cache.get(comp);\r\n    if (cached !== undefined) {\r\n        return cached;\r\n    }\r\n    const raw = comp.emits;\r\n    let normalized = {};\r\n    // apply mixin/extends props\r\n    let hasExtends = false;\r\n    if (__VUE_OPTIONS_API__ && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(comp)) {\r\n        const extendEmits = (raw) => {\r\n            const normalizedFromExtend = normalizeEmitsOptions(raw, appContext, true);\r\n            if (normalizedFromExtend) {\r\n                hasExtends = true;\r\n                (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(normalized, normalizedFromExtend);\r\n            }\r\n        };\r\n        if (!asMixin && appContext.mixins.length) {\r\n            appContext.mixins.forEach(extendEmits);\r\n        }\r\n        if (comp.extends) {\r\n            extendEmits(comp.extends);\r\n        }\r\n        if (comp.mixins) {\r\n            comp.mixins.forEach(extendEmits);\r\n        }\r\n    }\r\n    if (!raw && !hasExtends) {\r\n        cache.set(comp, null);\r\n        return null;\r\n    }\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(raw)) {\r\n        raw.forEach(key => (normalized[key] = null));\r\n    }\r\n    else {\r\n        (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(normalized, raw);\r\n    }\r\n    cache.set(comp, normalized);\r\n    return normalized;\r\n}\r\n// Check if an incoming prop key is a declared emit event listener.\r\n// e.g. With `emits: { click: null }`, props named `onClick` and `onclick` are\r\n// both considered matched listeners.\r\nfunction isEmitListener(options, key) {\r\n    if (!options || !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isOn)(key)) {\r\n        return false;\r\n    }\r\n    key = key.slice(2).replace(/Once$/, '');\r\n    return ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(options, key[0].toLowerCase() + key.slice(1)) ||\r\n        (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(options, (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(key)) ||\r\n        (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(options, key));\r\n}\n\n/**\r\n * mark the current rendering instance for asset resolution (e.g.\r\n * resolveComponent, resolveDirective) during render\r\n */\r\nlet currentRenderingInstance = null;\r\nlet currentScopeId = null;\r\n/**\r\n * Note: rendering calls maybe nested. The function returns the parent rendering\r\n * instance if present, which should be restored after the render is done:\r\n *\r\n * ```js\r\n * const prev = setCurrentRenderingInstance(i)\r\n * // ...render\r\n * setCurrentRenderingInstance(prev)\r\n * ```\r\n */\r\nfunction setCurrentRenderingInstance(instance) {\r\n    const prev = currentRenderingInstance;\r\n    currentRenderingInstance = instance;\r\n    currentScopeId = (instance && instance.type.__scopeId) || null;\r\n    return prev;\r\n}\r\n/**\r\n * Set scope id when creating hoisted vnodes.\r\n * @private compiler helper\r\n */\r\nfunction pushScopeId(id) {\r\n    currentScopeId = id;\r\n}\r\n/**\r\n * Technically we no longer need this after 3.0.8 but we need to keep the same\r\n * API for backwards compat w/ code generated by compilers.\r\n * @private\r\n */\r\nfunction popScopeId() {\r\n    currentScopeId = null;\r\n}\r\n/**\r\n * Only for backwards compat\r\n * @private\r\n */\r\nconst withScopeId = (_id) => withCtx;\r\n/**\r\n * Wrap a slot function to memoize current rendering instance\r\n * @private compiler helper\r\n */\r\nfunction withCtx(fn, ctx = currentRenderingInstance, isNonScopedSlot // false only\r\n) {\r\n    if (!ctx)\r\n        return fn;\r\n    // already normalized\r\n    if (fn._n) {\r\n        return fn;\r\n    }\r\n    const renderFnWithContext = (...args) => {\r\n        // If a user calls a compiled slot inside a template expression (#1745), it\r\n        // can mess up block tracking, so by default we disable block tracking and\r\n        // force bail out when invoking a compiled slot (indicated by the ._d flag).\r\n        // This isn't necessary if rendering a compiled `<slot>`, so we flip the\r\n        // ._d flag off when invoking the wrapped fn inside `renderSlot`.\r\n        if (renderFnWithContext._d) {\r\n            setBlockTracking(-1);\r\n        }\r\n        const prevInstance = setCurrentRenderingInstance(ctx);\r\n        const res = fn(...args);\r\n        setCurrentRenderingInstance(prevInstance);\r\n        if (renderFnWithContext._d) {\r\n            setBlockTracking(1);\r\n        }\r\n        if (true) {\r\n            devtoolsComponentUpdated(ctx);\r\n        }\r\n        return res;\r\n    };\r\n    // mark normalized to avoid duplicated wrapping\r\n    renderFnWithContext._n = true;\r\n    // mark this as compiled by default\r\n    // this is used in vnode.ts -> normalizeChildren() to set the slot\r\n    // rendering flag.\r\n    renderFnWithContext._c = true;\r\n    // disable block tracking by default\r\n    renderFnWithContext._d = true;\r\n    return renderFnWithContext;\r\n}\n\n/**\r\n * dev only flag to track whether $attrs was used during render.\r\n * If $attrs was used during render then the warning for failed attrs\r\n * fallthrough can be suppressed.\r\n */\r\nlet accessedAttrs = false;\r\nfunction markAttrsAccessed() {\r\n    accessedAttrs = true;\r\n}\r\nfunction renderComponentRoot(instance) {\r\n    const { type: Component, vnode, proxy, withProxy, props, propsOptions: [propsOptions], slots, attrs, emit, render, renderCache, data, setupState, ctx, inheritAttrs } = instance;\r\n    let result;\r\n    let fallthroughAttrs;\r\n    const prev = setCurrentRenderingInstance(instance);\r\n    if ((true)) {\r\n        accessedAttrs = false;\r\n    }\r\n    try {\r\n        if (vnode.shapeFlag & 4 /* STATEFUL_COMPONENT */) {\r\n            // withProxy is a proxy with a different `has` trap only for\r\n            // runtime-compiled render functions using `with` block.\r\n            const proxyToUse = withProxy || proxy;\r\n            result = normalizeVNode(render.call(proxyToUse, proxyToUse, renderCache, props, setupState, data, ctx));\r\n            fallthroughAttrs = attrs;\r\n        }\r\n        else {\r\n            // functional\r\n            const render = Component;\r\n            // in dev, mark attrs accessed if optional props (attrs === props)\r\n            if (( true) && attrs === props) {\r\n                markAttrsAccessed();\r\n            }\r\n            result = normalizeVNode(render.length > 1\r\n                ? render(props, ( true)\r\n                    ? {\r\n                        get attrs() {\r\n                            markAttrsAccessed();\r\n                            return attrs;\r\n                        },\r\n                        slots,\r\n                        emit\r\n                    }\r\n                    : 0)\r\n                : render(props, null /* we know it doesn't need it */));\r\n            fallthroughAttrs = Component.props\r\n                ? attrs\r\n                : getFunctionalFallthrough(attrs);\r\n        }\r\n    }\r\n    catch (err) {\r\n        blockStack.length = 0;\r\n        handleError(err, instance, 1 /* RENDER_FUNCTION */);\r\n        result = createVNode(Comment);\r\n    }\r\n    // attr merging\r\n    // in dev mode, comments are preserved, and it's possible for a template\r\n    // to have comments along side the root element which makes it a fragment\r\n    let root = result;\r\n    let setRoot = undefined;\r\n    if (( true) &&\r\n        result.patchFlag > 0 &&\r\n        result.patchFlag & 2048 /* DEV_ROOT_FRAGMENT */) {\r\n        [root, setRoot] = getChildRoot(result);\r\n    }\r\n    if (fallthroughAttrs && inheritAttrs !== false) {\r\n        const keys = Object.keys(fallthroughAttrs);\r\n        const { shapeFlag } = root;\r\n        if (keys.length) {\r\n            if (shapeFlag & (1 /* ELEMENT */ | 6 /* COMPONENT */)) {\r\n                if (propsOptions && keys.some(_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isModelListener)) {\r\n                    // If a v-model listener (onUpdate:xxx) has a corresponding declared\r\n                    // prop, it indicates this component expects to handle v-model and\r\n                    // it should not fallthrough.\r\n                    // related: #1543, #1643, #1989\r\n                    fallthroughAttrs = filterModelListeners(fallthroughAttrs, propsOptions);\r\n                }\r\n                root = cloneVNode(root, fallthroughAttrs);\r\n            }\r\n            else if (( true) && !accessedAttrs && root.type !== Comment) {\r\n                const allAttrs = Object.keys(attrs);\r\n                const eventAttrs = [];\r\n                const extraAttrs = [];\r\n                for (let i = 0, l = allAttrs.length; i < l; i++) {\r\n                    const key = allAttrs[i];\r\n                    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isOn)(key)) {\r\n                        // ignore v-model handlers when they fail to fallthrough\r\n                        if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isModelListener)(key)) {\r\n                            // remove `on`, lowercase first letter to reflect event casing\r\n                            // accurately\r\n                            eventAttrs.push(key[2].toLowerCase() + key.slice(3));\r\n                        }\r\n                    }\r\n                    else {\r\n                        extraAttrs.push(key);\r\n                    }\r\n                }\r\n                if (extraAttrs.length) {\r\n                    warn(`Extraneous non-props attributes (` +\r\n                        `${extraAttrs.join(', ')}) ` +\r\n                        `were passed to component but could not be automatically inherited ` +\r\n                        `because component renders fragment or text root nodes.`);\r\n                }\r\n                if (eventAttrs.length) {\r\n                    warn(`Extraneous non-emits event listeners (` +\r\n                        `${eventAttrs.join(', ')}) ` +\r\n                        `were passed to component but could not be automatically inherited ` +\r\n                        `because component renders fragment or text root nodes. ` +\r\n                        `If the listener is intended to be a component custom event listener only, ` +\r\n                        `declare it using the \"emits\" option.`);\r\n                }\r\n            }\r\n        }\r\n    }\r\n    // inherit directives\r\n    if (vnode.dirs) {\r\n        if (( true) && !isElementRoot(root)) {\r\n            warn(`Runtime directive used on component with non-element root node. ` +\r\n                `The directives will not function as intended.`);\r\n        }\r\n        root.dirs = root.dirs ? root.dirs.concat(vnode.dirs) : vnode.dirs;\r\n    }\r\n    // inherit transition data\r\n    if (vnode.transition) {\r\n        if (( true) && !isElementRoot(root)) {\r\n            warn(`Component inside <Transition> renders non-element root node ` +\r\n                `that cannot be animated.`);\r\n        }\r\n        root.transition = vnode.transition;\r\n    }\r\n    if (( true) && setRoot) {\r\n        setRoot(root);\r\n    }\r\n    else {\r\n        result = root;\r\n    }\r\n    setCurrentRenderingInstance(prev);\r\n    return result;\r\n}\r\n/**\r\n * dev only\r\n * In dev mode, template root level comments are rendered, which turns the\r\n * template into a fragment root, but we need to locate the single element\r\n * root for attrs and scope id processing.\r\n */\r\nconst getChildRoot = (vnode) => {\r\n    const rawChildren = vnode.children;\r\n    const dynamicChildren = vnode.dynamicChildren;\r\n    const childRoot = filterSingleRoot(rawChildren);\r\n    if (!childRoot) {\r\n        return [vnode, undefined];\r\n    }\r\n    const index = rawChildren.indexOf(childRoot);\r\n    const dynamicIndex = dynamicChildren ? dynamicChildren.indexOf(childRoot) : -1;\r\n    const setRoot = (updatedRoot) => {\r\n        rawChildren[index] = updatedRoot;\r\n        if (dynamicChildren) {\r\n            if (dynamicIndex > -1) {\r\n                dynamicChildren[dynamicIndex] = updatedRoot;\r\n            }\r\n            else if (updatedRoot.patchFlag > 0) {\r\n                vnode.dynamicChildren = [...dynamicChildren, updatedRoot];\r\n            }\r\n        }\r\n    };\r\n    return [normalizeVNode(childRoot), setRoot];\r\n};\r\nfunction filterSingleRoot(children) {\r\n    let singleRoot;\r\n    for (let i = 0; i < children.length; i++) {\r\n        const child = children[i];\r\n        if (isVNode(child)) {\r\n            // ignore user comment\r\n            if (child.type !== Comment || child.children === 'v-if') {\r\n                if (singleRoot) {\r\n                    // has more than 1 non-comment child, return now\r\n                    return;\r\n                }\r\n                else {\r\n                    singleRoot = child;\r\n                }\r\n            }\r\n        }\r\n        else {\r\n            return;\r\n        }\r\n    }\r\n    return singleRoot;\r\n}\r\nconst getFunctionalFallthrough = (attrs) => {\r\n    let res;\r\n    for (const key in attrs) {\r\n        if (key === 'class' || key === 'style' || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isOn)(key)) {\r\n            (res || (res = {}))[key] = attrs[key];\r\n        }\r\n    }\r\n    return res;\r\n};\r\nconst filterModelListeners = (attrs, props) => {\r\n    const res = {};\r\n    for (const key in attrs) {\r\n        if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isModelListener)(key) || !(key.slice(9) in props)) {\r\n            res[key] = attrs[key];\r\n        }\r\n    }\r\n    return res;\r\n};\r\nconst isElementRoot = (vnode) => {\r\n    return (vnode.shapeFlag & (6 /* COMPONENT */ | 1 /* ELEMENT */) ||\r\n        vnode.type === Comment // potential v-if branch switch\r\n    );\r\n};\r\nfunction shouldUpdateComponent(prevVNode, nextVNode, optimized) {\r\n    const { props: prevProps, children: prevChildren, component } = prevVNode;\r\n    const { props: nextProps, children: nextChildren, patchFlag } = nextVNode;\r\n    const emits = component.emitsOptions;\r\n    // Parent component's render function was hot-updated. Since this may have\r\n    // caused the child component's slots content to have changed, we need to\r\n    // force the child to update as well.\r\n    if (( true) && (prevChildren || nextChildren) && isHmrUpdating) {\r\n        return true;\r\n    }\r\n    // force child update for runtime directive or transition on component vnode.\r\n    if (nextVNode.dirs || nextVNode.transition) {\r\n        return true;\r\n    }\r\n    if (optimized && patchFlag >= 0) {\r\n        if (patchFlag & 1024 /* DYNAMIC_SLOTS */) {\r\n            // slot content that references values that might have changed,\r\n            // e.g. in a v-for\r\n            return true;\r\n        }\r\n        if (patchFlag & 16 /* FULL_PROPS */) {\r\n            if (!prevProps) {\r\n                return !!nextProps;\r\n            }\r\n            // presence of this flag indicates props are always non-null\r\n            return hasPropsChanged(prevProps, nextProps, emits);\r\n        }\r\n        else if (patchFlag & 8 /* PROPS */) {\r\n            const dynamicProps = nextVNode.dynamicProps;\r\n            for (let i = 0; i < dynamicProps.length; i++) {\r\n                const key = dynamicProps[i];\r\n                if (nextProps[key] !== prevProps[key] &&\r\n                    !isEmitListener(emits, key)) {\r\n                    return true;\r\n                }\r\n            }\r\n        }\r\n    }\r\n    else {\r\n        // this path is only taken by manually written render functions\r\n        // so presence of any children leads to a forced update\r\n        if (prevChildren || nextChildren) {\r\n            if (!nextChildren || !nextChildren.$stable) {\r\n                return true;\r\n            }\r\n        }\r\n        if (prevProps === nextProps) {\r\n            return false;\r\n        }\r\n        if (!prevProps) {\r\n            return !!nextProps;\r\n        }\r\n        if (!nextProps) {\r\n            return true;\r\n        }\r\n        return hasPropsChanged(prevProps, nextProps, emits);\r\n    }\r\n    return false;\r\n}\r\nfunction hasPropsChanged(prevProps, nextProps, emitsOptions) {\r\n    const nextKeys = Object.keys(nextProps);\r\n    if (nextKeys.length !== Object.keys(prevProps).length) {\r\n        return true;\r\n    }\r\n    for (let i = 0; i < nextKeys.length; i++) {\r\n        const key = nextKeys[i];\r\n        if (nextProps[key] !== prevProps[key] &&\r\n            !isEmitListener(emitsOptions, key)) {\r\n            return true;\r\n        }\r\n    }\r\n    return false;\r\n}\r\nfunction updateHOCHostEl({ vnode, parent }, el // HostNode\r\n) {\r\n    while (parent && parent.subTree === vnode) {\r\n        (vnode = parent.vnode).el = el;\r\n        parent = parent.parent;\r\n    }\r\n}\n\nconst isSuspense = (type) => type.__isSuspense;\r\n// Suspense exposes a component-like API, and is treated like a component\r\n// in the compiler, but internally it's a special built-in type that hooks\r\n// directly into the renderer.\r\nconst SuspenseImpl = {\r\n    name: 'Suspense',\r\n    // In order to make Suspense tree-shakable, we need to avoid importing it\r\n    // directly in the renderer. The renderer checks for the __isSuspense flag\r\n    // on a vnode's type and calls the `process` method, passing in renderer\r\n    // internals.\r\n    __isSuspense: true,\r\n    process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, \r\n    // platform-specific impl passed from renderer\r\n    rendererInternals) {\r\n        if (n1 == null) {\r\n            mountSuspense(n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, rendererInternals);\r\n        }\r\n        else {\r\n            patchSuspense(n1, n2, container, anchor, parentComponent, isSVG, slotScopeIds, optimized, rendererInternals);\r\n        }\r\n    },\r\n    hydrate: hydrateSuspense,\r\n    create: createSuspenseBoundary,\r\n    normalize: normalizeSuspenseChildren\r\n};\r\n// Force-casted public typing for h and TSX props inference\r\nconst Suspense = (SuspenseImpl );\r\nfunction triggerEvent(vnode, name) {\r\n    const eventListener = vnode.props && vnode.props[name];\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(eventListener)) {\r\n        eventListener();\r\n    }\r\n}\r\nfunction mountSuspense(vnode, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, rendererInternals) {\r\n    const { p: patch, o: { createElement } } = rendererInternals;\r\n    const hiddenContainer = createElement('div');\r\n    const suspense = (vnode.suspense = createSuspenseBoundary(vnode, parentSuspense, parentComponent, container, hiddenContainer, anchor, isSVG, slotScopeIds, optimized, rendererInternals));\r\n    // start mounting the content subtree in an off-dom container\r\n    patch(null, (suspense.pendingBranch = vnode.ssContent), hiddenContainer, null, parentComponent, suspense, isSVG, slotScopeIds);\r\n    // now check if we have encountered any async deps\r\n    if (suspense.deps > 0) {\r\n        // has async\r\n        // invoke @fallback event\r\n        triggerEvent(vnode, 'onPending');\r\n        triggerEvent(vnode, 'onFallback');\r\n        // mount the fallback tree\r\n        patch(null, vnode.ssFallback, container, anchor, parentComponent, null, // fallback tree will not have suspense context\r\n        isSVG, slotScopeIds);\r\n        setActiveBranch(suspense, vnode.ssFallback);\r\n    }\r\n    else {\r\n        // Suspense has no async deps. Just resolve.\r\n        suspense.resolve();\r\n    }\r\n}\r\nfunction patchSuspense(n1, n2, container, anchor, parentComponent, isSVG, slotScopeIds, optimized, { p: patch, um: unmount, o: { createElement } }) {\r\n    const suspense = (n2.suspense = n1.suspense);\r\n    suspense.vnode = n2;\r\n    n2.el = n1.el;\r\n    const newBranch = n2.ssContent;\r\n    const newFallback = n2.ssFallback;\r\n    const { activeBranch, pendingBranch, isInFallback, isHydrating } = suspense;\r\n    if (pendingBranch) {\r\n        suspense.pendingBranch = newBranch;\r\n        if (isSameVNodeType(newBranch, pendingBranch)) {\r\n            // same root type but content may have changed.\r\n            patch(pendingBranch, newBranch, suspense.hiddenContainer, null, parentComponent, suspense, isSVG, slotScopeIds, optimized);\r\n            if (suspense.deps <= 0) {\r\n                suspense.resolve();\r\n            }\r\n            else if (isInFallback) {\r\n                patch(activeBranch, newFallback, container, anchor, parentComponent, null, // fallback tree will not have suspense context\r\n                isSVG, slotScopeIds, optimized);\r\n                setActiveBranch(suspense, newFallback);\r\n            }\r\n        }\r\n        else {\r\n            // toggled before pending tree is resolved\r\n            suspense.pendingId++;\r\n            if (isHydrating) {\r\n                // if toggled before hydration is finished, the current DOM tree is\r\n                // no longer valid. set it as the active branch so it will be unmounted\r\n                // when resolved\r\n                suspense.isHydrating = false;\r\n                suspense.activeBranch = pendingBranch;\r\n            }\r\n            else {\r\n                unmount(pendingBranch, parentComponent, suspense);\r\n            }\r\n            // increment pending ID. this is used to invalidate async callbacks\r\n            // reset suspense state\r\n            suspense.deps = 0;\r\n            // discard effects from pending branch\r\n            suspense.effects.length = 0;\r\n            // discard previous container\r\n            suspense.hiddenContainer = createElement('div');\r\n            if (isInFallback) {\r\n                // already in fallback state\r\n                patch(null, newBranch, suspense.hiddenContainer, null, parentComponent, suspense, isSVG, slotScopeIds, optimized);\r\n                if (suspense.deps <= 0) {\r\n                    suspense.resolve();\r\n                }\r\n                else {\r\n                    patch(activeBranch, newFallback, container, anchor, parentComponent, null, // fallback tree will not have suspense context\r\n                    isSVG, slotScopeIds, optimized);\r\n                    setActiveBranch(suspense, newFallback);\r\n                }\r\n            }\r\n            else if (activeBranch && isSameVNodeType(newBranch, activeBranch)) {\r\n                // toggled \"back\" to current active branch\r\n                patch(activeBranch, newBranch, container, anchor, parentComponent, suspense, isSVG, slotScopeIds, optimized);\r\n                // force resolve\r\n                suspense.resolve(true);\r\n            }\r\n            else {\r\n                // switched to a 3rd branch\r\n                patch(null, newBranch, suspense.hiddenContainer, null, parentComponent, suspense, isSVG, slotScopeIds, optimized);\r\n                if (suspense.deps <= 0) {\r\n                    suspense.resolve();\r\n                }\r\n            }\r\n        }\r\n    }\r\n    else {\r\n        if (activeBranch && isSameVNodeType(newBranch, activeBranch)) {\r\n            // root did not change, just normal patch\r\n            patch(activeBranch, newBranch, container, anchor, parentComponent, suspense, isSVG, slotScopeIds, optimized);\r\n            setActiveBranch(suspense, newBranch);\r\n        }\r\n        else {\r\n            // root node toggled\r\n            // invoke @pending event\r\n            triggerEvent(n2, 'onPending');\r\n            // mount pending branch in off-dom container\r\n            suspense.pendingBranch = newBranch;\r\n            suspense.pendingId++;\r\n            patch(null, newBranch, suspense.hiddenContainer, null, parentComponent, suspense, isSVG, slotScopeIds, optimized);\r\n            if (suspense.deps <= 0) {\r\n                // incoming branch has no async deps, resolve now.\r\n                suspense.resolve();\r\n            }\r\n            else {\r\n                const { timeout, pendingId } = suspense;\r\n                if (timeout > 0) {\r\n                    setTimeout(() => {\r\n                        if (suspense.pendingId === pendingId) {\r\n                            suspense.fallback(newFallback);\r\n                        }\r\n                    }, timeout);\r\n                }\r\n                else if (timeout === 0) {\r\n                    suspense.fallback(newFallback);\r\n                }\r\n            }\r\n        }\r\n    }\r\n}\r\nlet hasWarned = false;\r\nfunction createSuspenseBoundary(vnode, parent, parentComponent, container, hiddenContainer, anchor, isSVG, slotScopeIds, optimized, rendererInternals, isHydrating = false) {\r\n    /* istanbul ignore if */\r\n    if ( true && !hasWarned) {\r\n        hasWarned = true;\r\n        // @ts-ignore `console.info` cannot be null error\r\n        console[console.info ? 'info' : 'log'](`<Suspense> is an experimental feature and its API will likely change.`);\r\n    }\r\n    const { p: patch, m: move, um: unmount, n: next, o: { parentNode, remove } } = rendererInternals;\r\n    const timeout = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toNumber)(vnode.props && vnode.props.timeout);\r\n    const suspense = {\r\n        vnode,\r\n        parent,\r\n        parentComponent,\r\n        isSVG,\r\n        container,\r\n        hiddenContainer,\r\n        anchor,\r\n        deps: 0,\r\n        pendingId: 0,\r\n        timeout: typeof timeout === 'number' ? timeout : -1,\r\n        activeBranch: null,\r\n        pendingBranch: null,\r\n        isInFallback: true,\r\n        isHydrating,\r\n        isUnmounted: false,\r\n        effects: [],\r\n        resolve(resume = false) {\r\n            if ((true)) {\r\n                if (!resume && !suspense.pendingBranch) {\r\n                    throw new Error(`suspense.resolve() is called without a pending branch.`);\r\n                }\r\n                if (suspense.isUnmounted) {\r\n                    throw new Error(`suspense.resolve() is called on an already unmounted suspense boundary.`);\r\n                }\r\n            }\r\n            const { vnode, activeBranch, pendingBranch, pendingId, effects, parentComponent, container } = suspense;\r\n            if (suspense.isHydrating) {\r\n                suspense.isHydrating = false;\r\n            }\r\n            else if (!resume) {\r\n                const delayEnter = activeBranch &&\r\n                    pendingBranch.transition &&\r\n                    pendingBranch.transition.mode === 'out-in';\r\n                if (delayEnter) {\r\n                    activeBranch.transition.afterLeave = () => {\r\n                        if (pendingId === suspense.pendingId) {\r\n                            move(pendingBranch, container, anchor, 0 /* ENTER */);\r\n                        }\r\n                    };\r\n                }\r\n                // this is initial anchor on mount\r\n                let { anchor } = suspense;\r\n                // unmount current active tree\r\n                if (activeBranch) {\r\n                    // if the fallback tree was mounted, it may have been moved\r\n                    // as part of a parent suspense. get the latest anchor for insertion\r\n                    anchor = next(activeBranch);\r\n                    unmount(activeBranch, parentComponent, suspense, true);\r\n                }\r\n                if (!delayEnter) {\r\n                    // move content from off-dom container to actual container\r\n                    move(pendingBranch, container, anchor, 0 /* ENTER */);\r\n                }\r\n            }\r\n            setActiveBranch(suspense, pendingBranch);\r\n            suspense.pendingBranch = null;\r\n            suspense.isInFallback = false;\r\n            // flush buffered effects\r\n            // check if there is a pending parent suspense\r\n            let parent = suspense.parent;\r\n            let hasUnresolvedAncestor = false;\r\n            while (parent) {\r\n                if (parent.pendingBranch) {\r\n                    // found a pending parent suspense, merge buffered post jobs\r\n                    // into that parent\r\n                    parent.effects.push(...effects);\r\n                    hasUnresolvedAncestor = true;\r\n                    break;\r\n                }\r\n                parent = parent.parent;\r\n            }\r\n            // no pending parent suspense, flush all jobs\r\n            if (!hasUnresolvedAncestor) {\r\n                queuePostFlushCb(effects);\r\n            }\r\n            suspense.effects = [];\r\n            // invoke @resolve event\r\n            triggerEvent(vnode, 'onResolve');\r\n        },\r\n        fallback(fallbackVNode) {\r\n            if (!suspense.pendingBranch) {\r\n                return;\r\n            }\r\n            const { vnode, activeBranch, parentComponent, container, isSVG } = suspense;\r\n            // invoke @fallback event\r\n            triggerEvent(vnode, 'onFallback');\r\n            const anchor = next(activeBranch);\r\n            const mountFallback = () => {\r\n                if (!suspense.isInFallback) {\r\n                    return;\r\n                }\r\n                // mount the fallback tree\r\n                patch(null, fallbackVNode, container, anchor, parentComponent, null, // fallback tree will not have suspense context\r\n                isSVG, slotScopeIds, optimized);\r\n                setActiveBranch(suspense, fallbackVNode);\r\n            };\r\n            const delayEnter = fallbackVNode.transition && fallbackVNode.transition.mode === 'out-in';\r\n            if (delayEnter) {\r\n                activeBranch.transition.afterLeave = mountFallback;\r\n            }\r\n            suspense.isInFallback = true;\r\n            // unmount current active branch\r\n            unmount(activeBranch, parentComponent, null, // no suspense so unmount hooks fire now\r\n            true // shouldRemove\r\n            );\r\n            if (!delayEnter) {\r\n                mountFallback();\r\n            }\r\n        },\r\n        move(container, anchor, type) {\r\n            suspense.activeBranch &&\r\n                move(suspense.activeBranch, container, anchor, type);\r\n            suspense.container = container;\r\n        },\r\n        next() {\r\n            return suspense.activeBranch && next(suspense.activeBranch);\r\n        },\r\n        registerDep(instance, setupRenderEffect) {\r\n            const isInPendingSuspense = !!suspense.pendingBranch;\r\n            if (isInPendingSuspense) {\r\n                suspense.deps++;\r\n            }\r\n            const hydratedEl = instance.vnode.el;\r\n            instance\r\n                .asyncDep.catch(err => {\r\n                handleError(err, instance, 0 /* SETUP_FUNCTION */);\r\n            })\r\n                .then(asyncSetupResult => {\r\n                // retry when the setup() promise resolves.\r\n                // component may have been unmounted before resolve.\r\n                if (instance.isUnmounted ||\r\n                    suspense.isUnmounted ||\r\n                    suspense.pendingId !== instance.suspenseId) {\r\n                    return;\r\n                }\r\n                // retry from this component\r\n                instance.asyncResolved = true;\r\n                const { vnode } = instance;\r\n                if ((true)) {\r\n                    pushWarningContext(vnode);\r\n                }\r\n                handleSetupResult(instance, asyncSetupResult, false);\r\n                if (hydratedEl) {\r\n                    // vnode may have been replaced if an update happened before the\r\n                    // async dep is resolved.\r\n                    vnode.el = hydratedEl;\r\n                }\r\n                const placeholder = !hydratedEl && instance.subTree.el;\r\n                setupRenderEffect(instance, vnode, \r\n                // component may have been moved before resolve.\r\n                // if this is not a hydration, instance.subTree will be the comment\r\n                // placeholder.\r\n                parentNode(hydratedEl || instance.subTree.el), \r\n                // anchor will not be used if this is hydration, so only need to\r\n                // consider the comment placeholder case.\r\n                hydratedEl ? null : next(instance.subTree), suspense, isSVG, optimized);\r\n                if (placeholder) {\r\n                    remove(placeholder);\r\n                }\r\n                updateHOCHostEl(instance, vnode.el);\r\n                if ((true)) {\r\n                    popWarningContext();\r\n                }\r\n                // only decrease deps count if suspense is not already resolved\r\n                if (isInPendingSuspense && --suspense.deps === 0) {\r\n                    suspense.resolve();\r\n                }\r\n            });\r\n        },\r\n        unmount(parentSuspense, doRemove) {\r\n            suspense.isUnmounted = true;\r\n            if (suspense.activeBranch) {\r\n                unmount(suspense.activeBranch, parentComponent, parentSuspense, doRemove);\r\n            }\r\n            if (suspense.pendingBranch) {\r\n                unmount(suspense.pendingBranch, parentComponent, parentSuspense, doRemove);\r\n            }\r\n        }\r\n    };\r\n    return suspense;\r\n}\r\nfunction hydrateSuspense(node, vnode, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, rendererInternals, hydrateNode) {\r\n    /* eslint-disable no-restricted-globals */\r\n    const suspense = (vnode.suspense = createSuspenseBoundary(vnode, parentSuspense, parentComponent, node.parentNode, document.createElement('div'), null, isSVG, slotScopeIds, optimized, rendererInternals, true /* hydrating */));\r\n    // there are two possible scenarios for server-rendered suspense:\r\n    // - success: ssr content should be fully resolved\r\n    // - failure: ssr content should be the fallback branch.\r\n    // however, on the client we don't really know if it has failed or not\r\n    // attempt to hydrate the DOM assuming it has succeeded, but we still\r\n    // need to construct a suspense boundary first\r\n    const result = hydrateNode(node, (suspense.pendingBranch = vnode.ssContent), parentComponent, suspense, slotScopeIds, optimized);\r\n    if (suspense.deps === 0) {\r\n        suspense.resolve();\r\n    }\r\n    return result;\r\n    /* eslint-enable no-restricted-globals */\r\n}\r\nfunction normalizeSuspenseChildren(vnode) {\r\n    const { shapeFlag, children } = vnode;\r\n    const isSlotChildren = shapeFlag & 32 /* SLOTS_CHILDREN */;\r\n    vnode.ssContent = normalizeSuspenseSlot(isSlotChildren ? children.default : children);\r\n    vnode.ssFallback = isSlotChildren\r\n        ? normalizeSuspenseSlot(children.fallback)\r\n        : createVNode(Comment);\r\n}\r\nfunction normalizeSuspenseSlot(s) {\r\n    let block;\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(s)) {\r\n        const trackBlock = isBlockTreeEnabled && s._c;\r\n        if (trackBlock) {\r\n            // disableTracking: false\r\n            // allow block tracking for compiled slots\r\n            // (see ./componentRenderContext.ts)\r\n            s._d = false;\r\n            openBlock();\r\n        }\r\n        s = s();\r\n        if (trackBlock) {\r\n            s._d = true;\r\n            block = currentBlock;\r\n            closeBlock();\r\n        }\r\n    }\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(s)) {\r\n        const singleChild = filterSingleRoot(s);\r\n        if (( true) && !singleChild) {\r\n            warn(`<Suspense> slots expect a single root node.`);\r\n        }\r\n        s = singleChild;\r\n    }\r\n    s = normalizeVNode(s);\r\n    if (block && !s.dynamicChildren) {\r\n        s.dynamicChildren = block.filter(c => c !== s);\r\n    }\r\n    return s;\r\n}\r\nfunction queueEffectWithSuspense(fn, suspense) {\r\n    if (suspense && suspense.pendingBranch) {\r\n        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(fn)) {\r\n            suspense.effects.push(...fn);\r\n        }\r\n        else {\r\n            suspense.effects.push(fn);\r\n        }\r\n    }\r\n    else {\r\n        queuePostFlushCb(fn);\r\n    }\r\n}\r\nfunction setActiveBranch(suspense, branch) {\r\n    suspense.activeBranch = branch;\r\n    const { vnode, parentComponent } = suspense;\r\n    const el = (vnode.el = branch.el);\r\n    // in case suspense is the root node of a component,\r\n    // recursively update the HOC el\r\n    if (parentComponent && parentComponent.subTree === vnode) {\r\n        parentComponent.vnode.el = el;\r\n        updateHOCHostEl(parentComponent, el);\r\n    }\r\n}\n\nfunction provide(key, value) {\r\n    if (!currentInstance) {\r\n        if ((true)) {\r\n            warn(`provide() can only be used inside setup().`);\r\n        }\r\n    }\r\n    else {\r\n        let provides = currentInstance.provides;\r\n        // by default an instance inherits its parent's provides object\r\n        // but when it needs to provide values of its own, it creates its\r\n        // own provides object using parent provides object as prototype.\r\n        // this way in `inject` we can simply look up injections from direct\r\n        // parent and let the prototype chain do the work.\r\n        const parentProvides = currentInstance.parent && currentInstance.parent.provides;\r\n        if (parentProvides === provides) {\r\n            provides = currentInstance.provides = Object.create(parentProvides);\r\n        }\r\n        // TS doesn't allow symbol as index type\r\n        provides[key] = value;\r\n    }\r\n}\r\nfunction inject(key, defaultValue, treatDefaultAsFactory = false) {\r\n    // fallback to `currentRenderingInstance` so that this can be called in\r\n    // a functional component\r\n    const instance = currentInstance || currentRenderingInstance;\r\n    if (instance) {\r\n        // #2400\r\n        // to support `app.use` plugins,\r\n        // fallback to appContext's `provides` if the intance is at root\r\n        const provides = instance.parent == null\r\n            ? instance.vnode.appContext && instance.vnode.appContext.provides\r\n            : instance.parent.provides;\r\n        if (provides && key in provides) {\r\n            // TS doesn't allow symbol as index type\r\n            return provides[key];\r\n        }\r\n        else if (arguments.length > 1) {\r\n            return treatDefaultAsFactory && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(defaultValue)\r\n                ? defaultValue.call(instance.proxy)\r\n                : defaultValue;\r\n        }\r\n        else if ((true)) {\r\n            warn(`injection \"${String(key)}\" not found.`);\r\n        }\r\n    }\r\n    else if ((true)) {\r\n        warn(`inject() can only be used inside setup() or functional components.`);\r\n    }\r\n}\n\nfunction useTransitionState() {\r\n    const state = {\r\n        isMounted: false,\r\n        isLeaving: false,\r\n        isUnmounting: false,\r\n        leavingVNodes: new Map()\r\n    };\r\n    onMounted(() => {\r\n        state.isMounted = true;\r\n    });\r\n    onBeforeUnmount(() => {\r\n        state.isUnmounting = true;\r\n    });\r\n    return state;\r\n}\r\nconst TransitionHookValidator = [Function, Array];\r\nconst BaseTransitionImpl = {\r\n    name: `BaseTransition`,\r\n    props: {\r\n        mode: String,\r\n        appear: Boolean,\r\n        persisted: Boolean,\r\n        // enter\r\n        onBeforeEnter: TransitionHookValidator,\r\n        onEnter: TransitionHookValidator,\r\n        onAfterEnter: TransitionHookValidator,\r\n        onEnterCancelled: TransitionHookValidator,\r\n        // leave\r\n        onBeforeLeave: TransitionHookValidator,\r\n        onLeave: TransitionHookValidator,\r\n        onAfterLeave: TransitionHookValidator,\r\n        onLeaveCancelled: TransitionHookValidator,\r\n        // appear\r\n        onBeforeAppear: TransitionHookValidator,\r\n        onAppear: TransitionHookValidator,\r\n        onAfterAppear: TransitionHookValidator,\r\n        onAppearCancelled: TransitionHookValidator\r\n    },\r\n    setup(props, { slots }) {\r\n        const instance = getCurrentInstance();\r\n        const state = useTransitionState();\r\n        let prevTransitionKey;\r\n        return () => {\r\n            const children = slots.default && getTransitionRawChildren(slots.default(), true);\r\n            if (!children || !children.length) {\r\n                return;\r\n            }\r\n            // warn multiple elements\r\n            if (( true) && children.length > 1) {\r\n                warn('<transition> can only be used on a single element or component. Use ' +\r\n                    '<transition-group> for lists.');\r\n            }\r\n            // there's no need to track reactivity for these props so use the raw\r\n            // props for a bit better perf\r\n            const rawProps = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(props);\r\n            const { mode } = rawProps;\r\n            // check mode\r\n            if (( true) && mode && !['in-out', 'out-in', 'default'].includes(mode)) {\r\n                warn(`invalid <transition> mode: ${mode}`);\r\n            }\r\n            // at this point children has a guaranteed length of 1.\r\n            const child = children[0];\r\n            if (state.isLeaving) {\r\n                return emptyPlaceholder(child);\r\n            }\r\n            // in the case of <transition><keep-alive/></transition>, we need to\r\n            // compare the type of the kept-alive children.\r\n            const innerChild = getKeepAliveChild(child);\r\n            if (!innerChild) {\r\n                return emptyPlaceholder(child);\r\n            }\r\n            const enterHooks = resolveTransitionHooks(innerChild, rawProps, state, instance);\r\n            setTransitionHooks(innerChild, enterHooks);\r\n            const oldChild = instance.subTree;\r\n            const oldInnerChild = oldChild && getKeepAliveChild(oldChild);\r\n            let transitionKeyChanged = false;\r\n            const { getTransitionKey } = innerChild.type;\r\n            if (getTransitionKey) {\r\n                const key = getTransitionKey();\r\n                if (prevTransitionKey === undefined) {\r\n                    prevTransitionKey = key;\r\n                }\r\n                else if (key !== prevTransitionKey) {\r\n                    prevTransitionKey = key;\r\n                    transitionKeyChanged = true;\r\n                }\r\n            }\r\n            // handle mode\r\n            if (oldInnerChild &&\r\n                oldInnerChild.type !== Comment &&\r\n                (!isSameVNodeType(innerChild, oldInnerChild) || transitionKeyChanged)) {\r\n                const leavingHooks = resolveTransitionHooks(oldInnerChild, rawProps, state, instance);\r\n                // update old tree's hooks in case of dynamic transition\r\n                setTransitionHooks(oldInnerChild, leavingHooks);\r\n                // switching between different views\r\n                if (mode === 'out-in') {\r\n                    state.isLeaving = true;\r\n                    // return placeholder node and queue update when leave finishes\r\n                    leavingHooks.afterLeave = () => {\r\n                        state.isLeaving = false;\r\n                        instance.update();\r\n                    };\r\n                    return emptyPlaceholder(child);\r\n                }\r\n                else if (mode === 'in-out' && innerChild.type !== Comment) {\r\n                    leavingHooks.delayLeave = (el, earlyRemove, delayedLeave) => {\r\n                        const leavingVNodesCache = getLeavingNodesForType(state, oldInnerChild);\r\n                        leavingVNodesCache[String(oldInnerChild.key)] = oldInnerChild;\r\n                        // early removal callback\r\n                        el._leaveCb = () => {\r\n                            earlyRemove();\r\n                            el._leaveCb = undefined;\r\n                            delete enterHooks.delayedLeave;\r\n                        };\r\n                        enterHooks.delayedLeave = delayedLeave;\r\n                    };\r\n                }\r\n            }\r\n            return child;\r\n        };\r\n    }\r\n};\r\n// export the public type for h/tsx inference\r\n// also to avoid inline import() in generated d.ts files\r\nconst BaseTransition = BaseTransitionImpl;\r\nfunction getLeavingNodesForType(state, vnode) {\r\n    const { leavingVNodes } = state;\r\n    let leavingVNodesCache = leavingVNodes.get(vnode.type);\r\n    if (!leavingVNodesCache) {\r\n        leavingVNodesCache = Object.create(null);\r\n        leavingVNodes.set(vnode.type, leavingVNodesCache);\r\n    }\r\n    return leavingVNodesCache;\r\n}\r\n// The transition hooks are attached to the vnode as vnode.transition\r\n// and will be called at appropriate timing in the renderer.\r\nfunction resolveTransitionHooks(vnode, props, state, instance) {\r\n    const { appear, mode, persisted = false, onBeforeEnter, onEnter, onAfterEnter, onEnterCancelled, onBeforeLeave, onLeave, onAfterLeave, onLeaveCancelled, onBeforeAppear, onAppear, onAfterAppear, onAppearCancelled } = props;\r\n    const key = String(vnode.key);\r\n    const leavingVNodesCache = getLeavingNodesForType(state, vnode);\r\n    const callHook = (hook, args) => {\r\n        hook &&\r\n            callWithAsyncErrorHandling(hook, instance, 9 /* TRANSITION_HOOK */, args);\r\n    };\r\n    const hooks = {\r\n        mode,\r\n        persisted,\r\n        beforeEnter(el) {\r\n            let hook = onBeforeEnter;\r\n            if (!state.isMounted) {\r\n                if (appear) {\r\n                    hook = onBeforeAppear || onBeforeEnter;\r\n                }\r\n                else {\r\n                    return;\r\n                }\r\n            }\r\n            // for same element (v-show)\r\n            if (el._leaveCb) {\r\n                el._leaveCb(true /* cancelled */);\r\n            }\r\n            // for toggled element with same key (v-if)\r\n            const leavingVNode = leavingVNodesCache[key];\r\n            if (leavingVNode &&\r\n                isSameVNodeType(vnode, leavingVNode) &&\r\n                leavingVNode.el._leaveCb) {\r\n                // force early removal (not cancelled)\r\n                leavingVNode.el._leaveCb();\r\n            }\r\n            callHook(hook, [el]);\r\n        },\r\n        enter(el) {\r\n            let hook = onEnter;\r\n            let afterHook = onAfterEnter;\r\n            let cancelHook = onEnterCancelled;\r\n            if (!state.isMounted) {\r\n                if (appear) {\r\n                    hook = onAppear || onEnter;\r\n                    afterHook = onAfterAppear || onAfterEnter;\r\n                    cancelHook = onAppearCancelled || onEnterCancelled;\r\n                }\r\n                else {\r\n                    return;\r\n                }\r\n            }\r\n            let called = false;\r\n            const done = (el._enterCb = (cancelled) => {\r\n                if (called)\r\n                    return;\r\n                called = true;\r\n                if (cancelled) {\r\n                    callHook(cancelHook, [el]);\r\n                }\r\n                else {\r\n                    callHook(afterHook, [el]);\r\n                }\r\n                if (hooks.delayedLeave) {\r\n                    hooks.delayedLeave();\r\n                }\r\n                el._enterCb = undefined;\r\n            });\r\n            if (hook) {\r\n                hook(el, done);\r\n                if (hook.length <= 1) {\r\n                    done();\r\n                }\r\n            }\r\n            else {\r\n                done();\r\n            }\r\n        },\r\n        leave(el, remove) {\r\n            const key = String(vnode.key);\r\n            if (el._enterCb) {\r\n                el._enterCb(true /* cancelled */);\r\n            }\r\n            if (state.isUnmounting) {\r\n                return remove();\r\n            }\r\n            callHook(onBeforeLeave, [el]);\r\n            let called = false;\r\n            const done = (el._leaveCb = (cancelled) => {\r\n                if (called)\r\n                    return;\r\n                called = true;\r\n                remove();\r\n                if (cancelled) {\r\n                    callHook(onLeaveCancelled, [el]);\r\n                }\r\n                else {\r\n                    callHook(onAfterLeave, [el]);\r\n                }\r\n                el._leaveCb = undefined;\r\n                if (leavingVNodesCache[key] === vnode) {\r\n                    delete leavingVNodesCache[key];\r\n                }\r\n            });\r\n            leavingVNodesCache[key] = vnode;\r\n            if (onLeave) {\r\n                onLeave(el, done);\r\n                if (onLeave.length <= 1) {\r\n                    done();\r\n                }\r\n            }\r\n            else {\r\n                done();\r\n            }\r\n        },\r\n        clone(vnode) {\r\n            return resolveTransitionHooks(vnode, props, state, instance);\r\n        }\r\n    };\r\n    return hooks;\r\n}\r\n// the placeholder really only handles one special case: KeepAlive\r\n// in the case of a KeepAlive in a leave phase we need to return a KeepAlive\r\n// placeholder with empty content to avoid the KeepAlive instance from being\r\n// unmounted.\r\nfunction emptyPlaceholder(vnode) {\r\n    if (isKeepAlive(vnode)) {\r\n        vnode = cloneVNode(vnode);\r\n        vnode.children = null;\r\n        return vnode;\r\n    }\r\n}\r\nfunction getKeepAliveChild(vnode) {\r\n    return isKeepAlive(vnode)\r\n        ? vnode.children\r\n            ? vnode.children[0]\r\n            : undefined\r\n        : vnode;\r\n}\r\nfunction setTransitionHooks(vnode, hooks) {\r\n    if (vnode.shapeFlag & 6 /* COMPONENT */ && vnode.component) {\r\n        setTransitionHooks(vnode.component.subTree, hooks);\r\n    }\r\n    else if (vnode.shapeFlag & 128 /* SUSPENSE */) {\r\n        vnode.ssContent.transition = hooks.clone(vnode.ssContent);\r\n        vnode.ssFallback.transition = hooks.clone(vnode.ssFallback);\r\n    }\r\n    else {\r\n        vnode.transition = hooks;\r\n    }\r\n}\r\nfunction getTransitionRawChildren(children, keepComment = false) {\r\n    let ret = [];\r\n    let keyedFragmentCount = 0;\r\n    for (let i = 0; i < children.length; i++) {\r\n        const child = children[i];\r\n        // handle fragment children case, e.g. v-for\r\n        if (child.type === Fragment) {\r\n            if (child.patchFlag & 128 /* KEYED_FRAGMENT */)\r\n                keyedFragmentCount++;\r\n            ret = ret.concat(getTransitionRawChildren(child.children, keepComment));\r\n        }\r\n        // comment placeholders should be skipped, e.g. v-if\r\n        else if (keepComment || child.type !== Comment) {\r\n            ret.push(child);\r\n        }\r\n    }\r\n    // #1126 if a transition children list contains multiple sub fragments, these\r\n    // fragments will be merged into a flat children array. Since each v-for\r\n    // fragment may contain different static bindings inside, we need to de-op\r\n    // these children to force full diffs to ensure correct behavior.\r\n    if (keyedFragmentCount > 1) {\r\n        for (let i = 0; i < ret.length; i++) {\r\n            ret[i].patchFlag = -2 /* BAIL */;\r\n        }\r\n    }\r\n    return ret;\r\n}\n\n// implementation, close to no-op\r\nfunction defineComponent(options) {\r\n    return (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(options) ? { setup: options, name: options.name } : options;\r\n}\n\nconst isAsyncWrapper = (i) => !!i.type.__asyncLoader;\r\nfunction defineAsyncComponent(source) {\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(source)) {\r\n        source = { loader: source };\r\n    }\r\n    const { loader, loadingComponent, errorComponent, delay = 200, timeout, // undefined = never times out\r\n    suspensible = true, onError: userOnError } = source;\r\n    let pendingRequest = null;\r\n    let resolvedComp;\r\n    let retries = 0;\r\n    const retry = () => {\r\n        retries++;\r\n        pendingRequest = null;\r\n        return load();\r\n    };\r\n    const load = () => {\r\n        let thisRequest;\r\n        return (pendingRequest ||\r\n            (thisRequest = pendingRequest =\r\n                loader()\r\n                    .catch(err => {\r\n                    err = err instanceof Error ? err : new Error(String(err));\r\n                    if (userOnError) {\r\n                        return new Promise((resolve, reject) => {\r\n                            const userRetry = () => resolve(retry());\r\n                            const userFail = () => reject(err);\r\n                            userOnError(err, userRetry, userFail, retries + 1);\r\n                        });\r\n                    }\r\n                    else {\r\n                        throw err;\r\n                    }\r\n                })\r\n                    .then((comp) => {\r\n                    if (thisRequest !== pendingRequest && pendingRequest) {\r\n                        return pendingRequest;\r\n                    }\r\n                    if (( true) && !comp) {\r\n                        warn(`Async component loader resolved to undefined. ` +\r\n                            `If you are using retry(), make sure to return its return value.`);\r\n                    }\r\n                    // interop module default\r\n                    if (comp &&\r\n                        (comp.__esModule || comp[Symbol.toStringTag] === 'Module')) {\r\n                        comp = comp.default;\r\n                    }\r\n                    if (( true) && comp && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(comp) && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(comp)) {\r\n                        throw new Error(`Invalid async component load result: ${comp}`);\r\n                    }\r\n                    resolvedComp = comp;\r\n                    return comp;\r\n                })));\r\n    };\r\n    return defineComponent({\r\n        name: 'AsyncComponentWrapper',\r\n        __asyncLoader: load,\r\n        get __asyncResolved() {\r\n            return resolvedComp;\r\n        },\r\n        setup() {\r\n            const instance = currentInstance;\r\n            // already resolved\r\n            if (resolvedComp) {\r\n                return () => createInnerComp(resolvedComp, instance);\r\n            }\r\n            const onError = (err) => {\r\n                pendingRequest = null;\r\n                handleError(err, instance, 13 /* ASYNC_COMPONENT_LOADER */, !errorComponent /* do not throw in dev if user provided error component */);\r\n            };\r\n            // suspense-controlled or SSR.\r\n            if ((suspensible && instance.suspense) ||\r\n                (isInSSRComponentSetup)) {\r\n                return load()\r\n                    .then(comp => {\r\n                    return () => createInnerComp(comp, instance);\r\n                })\r\n                    .catch(err => {\r\n                    onError(err);\r\n                    return () => errorComponent\r\n                        ? createVNode(errorComponent, {\r\n                            error: err\r\n                        })\r\n                        : null;\r\n                });\r\n            }\r\n            const loaded = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.ref)(false);\r\n            const error = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.ref)();\r\n            const delayed = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.ref)(!!delay);\r\n            if (delay) {\r\n                setTimeout(() => {\r\n                    delayed.value = false;\r\n                }, delay);\r\n            }\r\n            if (timeout != null) {\r\n                setTimeout(() => {\r\n                    if (!loaded.value && !error.value) {\r\n                        const err = new Error(`Async component timed out after ${timeout}ms.`);\r\n                        onError(err);\r\n                        error.value = err;\r\n                    }\r\n                }, timeout);\r\n            }\r\n            load()\r\n                .then(() => {\r\n                loaded.value = true;\r\n                if (instance.parent && isKeepAlive(instance.parent.vnode)) {\r\n                    // parent is keep-alive, force update so the loaded component's\r\n                    // name is taken into account\r\n                    queueJob(instance.parent.update);\r\n                }\r\n            })\r\n                .catch(err => {\r\n                onError(err);\r\n                error.value = err;\r\n            });\r\n            return () => {\r\n                if (loaded.value && resolvedComp) {\r\n                    return createInnerComp(resolvedComp, instance);\r\n                }\r\n                else if (error.value && errorComponent) {\r\n                    return createVNode(errorComponent, {\r\n                        error: error.value\r\n                    });\r\n                }\r\n                else if (loadingComponent && !delayed.value) {\r\n                    return createVNode(loadingComponent);\r\n                }\r\n            };\r\n        }\r\n    });\r\n}\r\nfunction createInnerComp(comp, { vnode: { ref, props, children } }) {\r\n    const vnode = createVNode(comp, props, children);\r\n    // ensure inner component inherits the async wrapper's ref owner\r\n    vnode.ref = ref;\r\n    return vnode;\r\n}\n\nconst isKeepAlive = (vnode) => vnode.type.__isKeepAlive;\r\nconst KeepAliveImpl = {\r\n    name: `KeepAlive`,\r\n    // Marker for special handling inside the renderer. We are not using a ===\r\n    // check directly on KeepAlive in the renderer, because importing it directly\r\n    // would prevent it from being tree-shaken.\r\n    __isKeepAlive: true,\r\n    props: {\r\n        include: [String, RegExp, Array],\r\n        exclude: [String, RegExp, Array],\r\n        max: [String, Number]\r\n    },\r\n    setup(props, { slots }) {\r\n        const instance = getCurrentInstance();\r\n        // KeepAlive communicates with the instantiated renderer via the\r\n        // ctx where the renderer passes in its internals,\r\n        // and the KeepAlive instance exposes activate/deactivate implementations.\r\n        // The whole point of this is to avoid importing KeepAlive directly in the\r\n        // renderer to facilitate tree-shaking.\r\n        const sharedContext = instance.ctx;\r\n        // if the internal renderer is not registered, it indicates that this is server-side rendering,\r\n        // for KeepAlive, we just need to render its children\r\n        if (!sharedContext.renderer) {\r\n            return slots.default;\r\n        }\r\n        const cache = new Map();\r\n        const keys = new Set();\r\n        let current = null;\r\n        if (true) {\r\n            instance.__v_cache = cache;\r\n        }\r\n        const parentSuspense = instance.suspense;\r\n        const { renderer: { p: patch, m: move, um: _unmount, o: { createElement } } } = sharedContext;\r\n        const storageContainer = createElement('div');\r\n        sharedContext.activate = (vnode, container, anchor, isSVG, optimized) => {\r\n            const instance = vnode.component;\r\n            move(vnode, container, anchor, 0 /* ENTER */, parentSuspense);\r\n            // in case props have changed\r\n            patch(instance.vnode, vnode, container, anchor, instance, parentSuspense, isSVG, vnode.slotScopeIds, optimized);\r\n            queuePostRenderEffect(() => {\r\n                instance.isDeactivated = false;\r\n                if (instance.a) {\r\n                    (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.invokeArrayFns)(instance.a);\r\n                }\r\n                const vnodeHook = vnode.props && vnode.props.onVnodeMounted;\r\n                if (vnodeHook) {\r\n                    invokeVNodeHook(vnodeHook, instance.parent, vnode);\r\n                }\r\n            }, parentSuspense);\r\n            if (true) {\r\n                // Update components tree\r\n                devtoolsComponentAdded(instance);\r\n            }\r\n        };\r\n        sharedContext.deactivate = (vnode) => {\r\n            const instance = vnode.component;\r\n            move(vnode, storageContainer, null, 1 /* LEAVE */, parentSuspense);\r\n            queuePostRenderEffect(() => {\r\n                if (instance.da) {\r\n                    (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.invokeArrayFns)(instance.da);\r\n                }\r\n                const vnodeHook = vnode.props && vnode.props.onVnodeUnmounted;\r\n                if (vnodeHook) {\r\n                    invokeVNodeHook(vnodeHook, instance.parent, vnode);\r\n                }\r\n                instance.isDeactivated = true;\r\n            }, parentSuspense);\r\n            if (true) {\r\n                // Update components tree\r\n                devtoolsComponentAdded(instance);\r\n            }\r\n        };\r\n        function unmount(vnode) {\r\n            // reset the shapeFlag so it can be properly unmounted\r\n            resetShapeFlag(vnode);\r\n            _unmount(vnode, instance, parentSuspense);\r\n        }\r\n        function pruneCache(filter) {\r\n            cache.forEach((vnode, key) => {\r\n                const name = getComponentName(vnode.type);\r\n                if (name && (!filter || !filter(name))) {\r\n                    pruneCacheEntry(key);\r\n                }\r\n            });\r\n        }\r\n        function pruneCacheEntry(key) {\r\n            const cached = cache.get(key);\r\n            if (!current || cached.type !== current.type) {\r\n                unmount(cached);\r\n            }\r\n            else if (current) {\r\n                // current active instance should no longer be kept-alive.\r\n                // we can't unmount it now but it might be later, so reset its flag now.\r\n                resetShapeFlag(current);\r\n            }\r\n            cache.delete(key);\r\n            keys.delete(key);\r\n        }\r\n        // prune cache on include/exclude prop change\r\n        watch(() => [props.include, props.exclude], ([include, exclude]) => {\r\n            include && pruneCache(name => matches(include, name));\r\n            exclude && pruneCache(name => !matches(exclude, name));\r\n        }, \r\n        // prune post-render after `current` has been updated\r\n        { flush: 'post', deep: true });\r\n        // cache sub tree after render\r\n        let pendingCacheKey = null;\r\n        const cacheSubtree = () => {\r\n            // fix #1621, the pendingCacheKey could be 0\r\n            if (pendingCacheKey != null) {\r\n                cache.set(pendingCacheKey, getInnerChild(instance.subTree));\r\n            }\r\n        };\r\n        onMounted(cacheSubtree);\r\n        onUpdated(cacheSubtree);\r\n        onBeforeUnmount(() => {\r\n            cache.forEach(cached => {\r\n                const { subTree, suspense } = instance;\r\n                const vnode = getInnerChild(subTree);\r\n                if (cached.type === vnode.type) {\r\n                    // current instance will be unmounted as part of keep-alive's unmount\r\n                    resetShapeFlag(vnode);\r\n                    // but invoke its deactivated hook here\r\n                    const da = vnode.component.da;\r\n                    da && queuePostRenderEffect(da, suspense);\r\n                    return;\r\n                }\r\n                unmount(cached);\r\n            });\r\n        });\r\n        return () => {\r\n            pendingCacheKey = null;\r\n            if (!slots.default) {\r\n                return null;\r\n            }\r\n            const children = slots.default();\r\n            const rawVNode = children[0];\r\n            if (children.length > 1) {\r\n                if ((true)) {\r\n                    warn(`KeepAlive should contain exactly one component child.`);\r\n                }\r\n                current = null;\r\n                return children;\r\n            }\r\n            else if (!isVNode(rawVNode) ||\r\n                (!(rawVNode.shapeFlag & 4 /* STATEFUL_COMPONENT */) &&\r\n                    !(rawVNode.shapeFlag & 128 /* SUSPENSE */))) {\r\n                current = null;\r\n                return rawVNode;\r\n            }\r\n            let vnode = getInnerChild(rawVNode);\r\n            const comp = vnode.type;\r\n            // for async components, name check should be based in its loaded\r\n            // inner component if available\r\n            const name = getComponentName(isAsyncWrapper(vnode)\r\n                ? vnode.type.__asyncResolved || {}\r\n                : comp);\r\n            const { include, exclude, max } = props;\r\n            if ((include && (!name || !matches(include, name))) ||\r\n                (exclude && name && matches(exclude, name))) {\r\n                current = vnode;\r\n                return rawVNode;\r\n            }\r\n            const key = vnode.key == null ? comp : vnode.key;\r\n            const cachedVNode = cache.get(key);\r\n            // clone vnode if it's reused because we are going to mutate it\r\n            if (vnode.el) {\r\n                vnode = cloneVNode(vnode);\r\n                if (rawVNode.shapeFlag & 128 /* SUSPENSE */) {\r\n                    rawVNode.ssContent = vnode;\r\n                }\r\n            }\r\n            // #1513 it's possible for the returned vnode to be cloned due to attr\r\n            // fallthrough or scopeId, so the vnode here may not be the final vnode\r\n            // that is mounted. Instead of caching it directly, we store the pending\r\n            // key and cache `instance.subTree` (the normalized vnode) in\r\n            // beforeMount/beforeUpdate hooks.\r\n            pendingCacheKey = key;\r\n            if (cachedVNode) {\r\n                // copy over mounted state\r\n                vnode.el = cachedVNode.el;\r\n                vnode.component = cachedVNode.component;\r\n                if (vnode.transition) {\r\n                    // recursively update transition hooks on subTree\r\n                    setTransitionHooks(vnode, vnode.transition);\r\n                }\r\n                // avoid vnode being mounted as fresh\r\n                vnode.shapeFlag |= 512 /* COMPONENT_KEPT_ALIVE */;\r\n                // make this key the freshest\r\n                keys.delete(key);\r\n                keys.add(key);\r\n            }\r\n            else {\r\n                keys.add(key);\r\n                // prune oldest entry\r\n                if (max && keys.size > parseInt(max, 10)) {\r\n                    pruneCacheEntry(keys.values().next().value);\r\n                }\r\n            }\r\n            // avoid vnode being unmounted\r\n            vnode.shapeFlag |= 256 /* COMPONENT_SHOULD_KEEP_ALIVE */;\r\n            current = vnode;\r\n            return rawVNode;\r\n        };\r\n    }\r\n};\r\n// export the public type for h/tsx inference\r\n// also to avoid inline import() in generated d.ts files\r\nconst KeepAlive = KeepAliveImpl;\r\nfunction matches(pattern, name) {\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(pattern)) {\r\n        return pattern.some((p) => matches(p, name));\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(pattern)) {\r\n        return pattern.split(',').indexOf(name) > -1;\r\n    }\r\n    else if (pattern.test) {\r\n        return pattern.test(name);\r\n    }\r\n    /* istanbul ignore next */\r\n    return false;\r\n}\r\nfunction onActivated(hook, target) {\r\n    registerKeepAliveHook(hook, \"a\" /* ACTIVATED */, target);\r\n}\r\nfunction onDeactivated(hook, target) {\r\n    registerKeepAliveHook(hook, \"da\" /* DEACTIVATED */, target);\r\n}\r\nfunction registerKeepAliveHook(hook, type, target = currentInstance) {\r\n    // cache the deactivate branch check wrapper for injected hooks so the same\r\n    // hook can be properly deduped by the scheduler. \"__wdc\" stands for \"with\r\n    // deactivation check\".\r\n    const wrappedHook = hook.__wdc ||\r\n        (hook.__wdc = () => {\r\n            // only fire the hook if the target instance is NOT in a deactivated branch.\r\n            let current = target;\r\n            while (current) {\r\n                if (current.isDeactivated) {\r\n                    return;\r\n                }\r\n                current = current.parent;\r\n            }\r\n            hook();\r\n        });\r\n    injectHook(type, wrappedHook, target);\r\n    // In addition to registering it on the target instance, we walk up the parent\r\n    // chain and register it on all ancestor instances that are keep-alive roots.\r\n    // This avoids the need to walk the entire component tree when invoking these\r\n    // hooks, and more importantly, avoids the need to track child components in\r\n    // arrays.\r\n    if (target) {\r\n        let current = target.parent;\r\n        while (current && current.parent) {\r\n            if (isKeepAlive(current.parent.vnode)) {\r\n                injectToKeepAliveRoot(wrappedHook, type, target, current);\r\n            }\r\n            current = current.parent;\r\n        }\r\n    }\r\n}\r\nfunction injectToKeepAliveRoot(hook, type, target, keepAliveRoot) {\r\n    // injectHook wraps the original for error handling, so make sure to remove\r\n    // the wrapped version.\r\n    const injected = injectHook(type, hook, keepAliveRoot, true /* prepend */);\r\n    onUnmounted(() => {\r\n        (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.remove)(keepAliveRoot[type], injected);\r\n    }, target);\r\n}\r\nfunction resetShapeFlag(vnode) {\r\n    let shapeFlag = vnode.shapeFlag;\r\n    if (shapeFlag & 256 /* COMPONENT_SHOULD_KEEP_ALIVE */) {\r\n        shapeFlag -= 256 /* COMPONENT_SHOULD_KEEP_ALIVE */;\r\n    }\r\n    if (shapeFlag & 512 /* COMPONENT_KEPT_ALIVE */) {\r\n        shapeFlag -= 512 /* COMPONENT_KEPT_ALIVE */;\r\n    }\r\n    vnode.shapeFlag = shapeFlag;\r\n}\r\nfunction getInnerChild(vnode) {\r\n    return vnode.shapeFlag & 128 /* SUSPENSE */ ? vnode.ssContent : vnode;\r\n}\n\nfunction injectHook(type, hook, target = currentInstance, prepend = false) {\r\n    if (target) {\r\n        const hooks = target[type] || (target[type] = []);\r\n        // cache the error handling wrapper for injected hooks so the same hook\r\n        // can be properly deduped by the scheduler. \"__weh\" stands for \"with error\r\n        // handling\".\r\n        const wrappedHook = hook.__weh ||\r\n            (hook.__weh = (...args) => {\r\n                if (target.isUnmounted) {\r\n                    return;\r\n                }\r\n                // disable tracking inside all lifecycle hooks\r\n                // since they can potentially be called inside effects.\r\n                (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.pauseTracking)();\r\n                // Set currentInstance during hook invocation.\r\n                // This assumes the hook does not synchronously trigger other hooks, which\r\n                // can only be false when the user does something really funky.\r\n                setCurrentInstance(target);\r\n                const res = callWithAsyncErrorHandling(hook, target, type, args);\r\n                unsetCurrentInstance();\r\n                (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.resetTracking)();\r\n                return res;\r\n            });\r\n        if (prepend) {\r\n            hooks.unshift(wrappedHook);\r\n        }\r\n        else {\r\n            hooks.push(wrappedHook);\r\n        }\r\n        return wrappedHook;\r\n    }\r\n    else if ((true)) {\r\n        const apiName = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey)(ErrorTypeStrings[type].replace(/ hook$/, ''));\r\n        warn(`${apiName} is called when there is no active component instance to be ` +\r\n            `associated with. ` +\r\n            `Lifecycle injection APIs can only be used during execution of setup().` +\r\n            (` If you are using async setup(), make sure to register lifecycle ` +\r\n                    `hooks before the first await statement.`\r\n                ));\r\n    }\r\n}\r\nconst createHook = (lifecycle) => (hook, target = currentInstance) => \r\n// post-create lifecycle registrations are noops during SSR (except for serverPrefetch)\r\n(!isInSSRComponentSetup || lifecycle === \"sp\" /* SERVER_PREFETCH */) &&\r\n    injectHook(lifecycle, hook, target);\r\nconst onBeforeMount = createHook(\"bm\" /* BEFORE_MOUNT */);\r\nconst onMounted = createHook(\"m\" /* MOUNTED */);\r\nconst onBeforeUpdate = createHook(\"bu\" /* BEFORE_UPDATE */);\r\nconst onUpdated = createHook(\"u\" /* UPDATED */);\r\nconst onBeforeUnmount = createHook(\"bum\" /* BEFORE_UNMOUNT */);\r\nconst onUnmounted = createHook(\"um\" /* UNMOUNTED */);\r\nconst onServerPrefetch = createHook(\"sp\" /* SERVER_PREFETCH */);\r\nconst onRenderTriggered = createHook(\"rtg\" /* RENDER_TRIGGERED */);\r\nconst onRenderTracked = createHook(\"rtc\" /* RENDER_TRACKED */);\r\nfunction onErrorCaptured(hook, target = currentInstance) {\r\n    injectHook(\"ec\" /* ERROR_CAPTURED */, hook, target);\r\n}\n\nfunction createDuplicateChecker() {\r\n    const cache = Object.create(null);\r\n    return (type, key) => {\r\n        if (cache[key]) {\r\n            warn(`${type} property \"${key}\" is already defined in ${cache[key]}.`);\r\n        }\r\n        else {\r\n            cache[key] = type;\r\n        }\r\n    };\r\n}\r\nlet shouldCacheAccess = true;\r\nfunction applyOptions(instance) {\r\n    const options = resolveMergedOptions(instance);\r\n    const publicThis = instance.proxy;\r\n    const ctx = instance.ctx;\r\n    // do not cache property access on public proxy during state initialization\r\n    shouldCacheAccess = false;\r\n    // call beforeCreate first before accessing other options since\r\n    // the hook may mutate resolved options (#2791)\r\n    if (options.beforeCreate) {\r\n        callHook(options.beforeCreate, instance, \"bc\" /* BEFORE_CREATE */);\r\n    }\r\n    const { \r\n    // state\r\n    data: dataOptions, computed: computedOptions, methods, watch: watchOptions, provide: provideOptions, inject: injectOptions, \r\n    // lifecycle\r\n    created, beforeMount, mounted, beforeUpdate, updated, activated, deactivated, beforeDestroy, beforeUnmount, destroyed, unmounted, render, renderTracked, renderTriggered, errorCaptured, serverPrefetch, \r\n    // public API\r\n    expose, inheritAttrs, \r\n    // assets\r\n    components, directives, filters } = options;\r\n    const checkDuplicateProperties = ( true) ? createDuplicateChecker() : 0;\r\n    if ((true)) {\r\n        const [propsOptions] = instance.propsOptions;\r\n        if (propsOptions) {\r\n            for (const key in propsOptions) {\r\n                checkDuplicateProperties(\"Props\" /* PROPS */, key);\r\n            }\r\n        }\r\n    }\r\n    // options initialization order (to be consistent with Vue 2):\r\n    // - props (already done outside of this function)\r\n    // - inject\r\n    // - methods\r\n    // - data (deferred since it relies on `this` access)\r\n    // - computed\r\n    // - watch (deferred since it relies on `this` access)\r\n    if (injectOptions) {\r\n        resolveInjections(injectOptions, ctx, checkDuplicateProperties, instance.appContext.config.unwrapInjectedRef);\r\n    }\r\n    if (methods) {\r\n        for (const key in methods) {\r\n            const methodHandler = methods[key];\r\n            if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(methodHandler)) {\r\n                // In dev mode, we use the `createRenderContext` function to define\r\n                // methods to the proxy target, and those are read-only but\r\n                // reconfigurable, so it needs to be redefined here\r\n                if ((true)) {\r\n                    Object.defineProperty(ctx, key, {\r\n                        value: methodHandler.bind(publicThis),\r\n                        configurable: true,\r\n                        enumerable: true,\r\n                        writable: true\r\n                    });\r\n                }\r\n                else {}\r\n                if ((true)) {\r\n                    checkDuplicateProperties(\"Methods\" /* METHODS */, key);\r\n                }\r\n            }\r\n            else if ((true)) {\r\n                warn(`Method \"${key}\" has type \"${typeof methodHandler}\" in the component definition. ` +\r\n                    `Did you reference the function correctly?`);\r\n            }\r\n        }\r\n    }\r\n    if (dataOptions) {\r\n        if (( true) && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(dataOptions)) {\r\n            warn(`The data option must be a function. ` +\r\n                `Plain object usage is no longer supported.`);\r\n        }\r\n        const data = dataOptions.call(publicThis, publicThis);\r\n        if (( true) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isPromise)(data)) {\r\n            warn(`data() returned a Promise - note data() cannot be async; If you ` +\r\n                `intend to perform data fetching before component renders, use ` +\r\n                `async setup() + <Suspense>.`);\r\n        }\r\n        if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(data)) {\r\n            ( true) && warn(`data() should return an object.`);\r\n        }\r\n        else {\r\n            instance.data = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.reactive)(data);\r\n            if ((true)) {\r\n                for (const key in data) {\r\n                    checkDuplicateProperties(\"Data\" /* DATA */, key);\r\n                    // expose data on ctx during dev\r\n                    if (key[0] !== '$' && key[0] !== '_') {\r\n                        Object.defineProperty(ctx, key, {\r\n                            configurable: true,\r\n                            enumerable: true,\r\n                            get: () => data[key],\r\n                            set: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP\r\n                        });\r\n                    }\r\n                }\r\n            }\r\n        }\r\n    }\r\n    // state initialization complete at this point - start caching access\r\n    shouldCacheAccess = true;\r\n    if (computedOptions) {\r\n        for (const key in computedOptions) {\r\n            const opt = computedOptions[key];\r\n            const get = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(opt)\r\n                ? opt.bind(publicThis, publicThis)\r\n                : (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(opt.get)\r\n                    ? opt.get.bind(publicThis, publicThis)\r\n                    : _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP;\r\n            if (( true) && get === _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP) {\r\n                warn(`Computed property \"${key}\" has no getter.`);\r\n            }\r\n            const set = !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(opt) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(opt.set)\r\n                ? opt.set.bind(publicThis)\r\n                : ( true)\r\n                    ? () => {\r\n                        warn(`Write operation failed: computed property \"${key}\" is readonly.`);\r\n                    }\r\n                    : 0;\r\n            const c = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.computed)({\r\n                get,\r\n                set\r\n            });\r\n            Object.defineProperty(ctx, key, {\r\n                enumerable: true,\r\n                configurable: true,\r\n                get: () => c.value,\r\n                set: v => (c.value = v)\r\n            });\r\n            if ((true)) {\r\n                checkDuplicateProperties(\"Computed\" /* COMPUTED */, key);\r\n            }\r\n        }\r\n    }\r\n    if (watchOptions) {\r\n        for (const key in watchOptions) {\r\n            createWatcher(watchOptions[key], ctx, publicThis, key);\r\n        }\r\n    }\r\n    if (provideOptions) {\r\n        const provides = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(provideOptions)\r\n            ? provideOptions.call(publicThis)\r\n            : provideOptions;\r\n        Reflect.ownKeys(provides).forEach(key => {\r\n            provide(key, provides[key]);\r\n        });\r\n    }\r\n    if (created) {\r\n        callHook(created, instance, \"c\" /* CREATED */);\r\n    }\r\n    function registerLifecycleHook(register, hook) {\r\n        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(hook)) {\r\n            hook.forEach(_hook => register(_hook.bind(publicThis)));\r\n        }\r\n        else if (hook) {\r\n            register(hook.bind(publicThis));\r\n        }\r\n    }\r\n    registerLifecycleHook(onBeforeMount, beforeMount);\r\n    registerLifecycleHook(onMounted, mounted);\r\n    registerLifecycleHook(onBeforeUpdate, beforeUpdate);\r\n    registerLifecycleHook(onUpdated, updated);\r\n    registerLifecycleHook(onActivated, activated);\r\n    registerLifecycleHook(onDeactivated, deactivated);\r\n    registerLifecycleHook(onErrorCaptured, errorCaptured);\r\n    registerLifecycleHook(onRenderTracked, renderTracked);\r\n    registerLifecycleHook(onRenderTriggered, renderTriggered);\r\n    registerLifecycleHook(onBeforeUnmount, beforeUnmount);\r\n    registerLifecycleHook(onUnmounted, unmounted);\r\n    registerLifecycleHook(onServerPrefetch, serverPrefetch);\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(expose)) {\r\n        if (expose.length) {\r\n            const exposed = instance.exposed || (instance.exposed = {});\r\n            expose.forEach(key => {\r\n                Object.defineProperty(exposed, key, {\r\n                    get: () => publicThis[key],\r\n                    set: val => (publicThis[key] = val)\r\n                });\r\n            });\r\n        }\r\n        else if (!instance.exposed) {\r\n            instance.exposed = {};\r\n        }\r\n    }\r\n    // options that are handled when creating the instance but also need to be\r\n    // applied from mixins\r\n    if (render && instance.render === _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP) {\r\n        instance.render = render;\r\n    }\r\n    if (inheritAttrs != null) {\r\n        instance.inheritAttrs = inheritAttrs;\r\n    }\r\n    // asset options.\r\n    if (components)\r\n        instance.components = components;\r\n    if (directives)\r\n        instance.directives = directives;\r\n}\r\nfunction resolveInjections(injectOptions, ctx, checkDuplicateProperties = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP, unwrapRef = false) {\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(injectOptions)) {\r\n        injectOptions = normalizeInject(injectOptions);\r\n    }\r\n    for (const key in injectOptions) {\r\n        const opt = injectOptions[key];\r\n        let injected;\r\n        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(opt)) {\r\n            if ('default' in opt) {\r\n                injected = inject(opt.from || key, opt.default, true /* treat default function as factory */);\r\n            }\r\n            else {\r\n                injected = inject(opt.from || key);\r\n            }\r\n        }\r\n        else {\r\n            injected = inject(opt);\r\n        }\r\n        if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(injected)) {\r\n            // TODO remove the check in 3.3\r\n            if (unwrapRef) {\r\n                Object.defineProperty(ctx, key, {\r\n                    enumerable: true,\r\n                    configurable: true,\r\n                    get: () => injected.value,\r\n                    set: v => (injected.value = v)\r\n                });\r\n            }\r\n            else {\r\n                if ((true)) {\r\n                    warn(`injected property \"${key}\" is a ref and will be auto-unwrapped ` +\r\n                        `and no longer needs \\`.value\\` in the next minor release. ` +\r\n                        `To opt-in to the new behavior now, ` +\r\n                        `set \\`app.config.unwrapInjectedRef = true\\` (this config is ` +\r\n                        `temporary and will not be needed in the future.)`);\r\n                }\r\n                ctx[key] = injected;\r\n            }\r\n        }\r\n        else {\r\n            ctx[key] = injected;\r\n        }\r\n        if ((true)) {\r\n            checkDuplicateProperties(\"Inject\" /* INJECT */, key);\r\n        }\r\n    }\r\n}\r\nfunction callHook(hook, instance, type) {\r\n    callWithAsyncErrorHandling((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(hook)\r\n        ? hook.map(h => h.bind(instance.proxy))\r\n        : hook.bind(instance.proxy), instance, type);\r\n}\r\nfunction createWatcher(raw, ctx, publicThis, key) {\r\n    const getter = key.includes('.')\r\n        ? createPathGetter(publicThis, key)\r\n        : () => publicThis[key];\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(raw)) {\r\n        const handler = ctx[raw];\r\n        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(handler)) {\r\n            watch(getter, handler);\r\n        }\r\n        else if ((true)) {\r\n            warn(`Invalid watch handler specified by key \"${raw}\"`, handler);\r\n        }\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(raw)) {\r\n        watch(getter, raw.bind(publicThis));\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(raw)) {\r\n        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(raw)) {\r\n            raw.forEach(r => createWatcher(r, ctx, publicThis, key));\r\n        }\r\n        else {\r\n            const handler = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(raw.handler)\r\n                ? raw.handler.bind(publicThis)\r\n                : ctx[raw.handler];\r\n            if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(handler)) {\r\n                watch(getter, handler, raw);\r\n            }\r\n            else if ((true)) {\r\n                warn(`Invalid watch handler specified by key \"${raw.handler}\"`, handler);\r\n            }\r\n        }\r\n    }\r\n    else if ((true)) {\r\n        warn(`Invalid watch option: \"${key}\"`, raw);\r\n    }\r\n}\r\n/**\r\n * Resolve merged options and cache it on the component.\r\n * This is done only once per-component since the merging does not involve\r\n * instances.\r\n */\r\nfunction resolveMergedOptions(instance) {\r\n    const base = instance.type;\r\n    const { mixins, extends: extendsOptions } = base;\r\n    const { mixins: globalMixins, optionsCache: cache, config: { optionMergeStrategies } } = instance.appContext;\r\n    const cached = cache.get(base);\r\n    let resolved;\r\n    if (cached) {\r\n        resolved = cached;\r\n    }\r\n    else if (!globalMixins.length && !mixins && !extendsOptions) {\r\n        {\r\n            resolved = base;\r\n        }\r\n    }\r\n    else {\r\n        resolved = {};\r\n        if (globalMixins.length) {\r\n            globalMixins.forEach(m => mergeOptions(resolved, m, optionMergeStrategies, true));\r\n        }\r\n        mergeOptions(resolved, base, optionMergeStrategies);\r\n    }\r\n    cache.set(base, resolved);\r\n    return resolved;\r\n}\r\nfunction mergeOptions(to, from, strats, asMixin = false) {\r\n    const { mixins, extends: extendsOptions } = from;\r\n    if (extendsOptions) {\r\n        mergeOptions(to, extendsOptions, strats, true);\r\n    }\r\n    if (mixins) {\r\n        mixins.forEach((m) => mergeOptions(to, m, strats, true));\r\n    }\r\n    for (const key in from) {\r\n        if (asMixin && key === 'expose') {\r\n            ( true) &&\r\n                warn(`\"expose\" option is ignored when declared in mixins or extends. ` +\r\n                    `It should only be declared in the base component itself.`);\r\n        }\r\n        else {\r\n            const strat = internalOptionMergeStrats[key] || (strats && strats[key]);\r\n            to[key] = strat ? strat(to[key], from[key]) : from[key];\r\n        }\r\n    }\r\n    return to;\r\n}\r\nconst internalOptionMergeStrats = {\r\n    data: mergeDataFn,\r\n    props: mergeObjectOptions,\r\n    emits: mergeObjectOptions,\r\n    // objects\r\n    methods: mergeObjectOptions,\r\n    computed: mergeObjectOptions,\r\n    // lifecycle\r\n    beforeCreate: mergeAsArray,\r\n    created: mergeAsArray,\r\n    beforeMount: mergeAsArray,\r\n    mounted: mergeAsArray,\r\n    beforeUpdate: mergeAsArray,\r\n    updated: mergeAsArray,\r\n    beforeDestroy: mergeAsArray,\r\n    beforeUnmount: mergeAsArray,\r\n    destroyed: mergeAsArray,\r\n    unmounted: mergeAsArray,\r\n    activated: mergeAsArray,\r\n    deactivated: mergeAsArray,\r\n    errorCaptured: mergeAsArray,\r\n    serverPrefetch: mergeAsArray,\r\n    // assets\r\n    components: mergeObjectOptions,\r\n    directives: mergeObjectOptions,\r\n    // watch\r\n    watch: mergeWatchOptions,\r\n    // provide / inject\r\n    provide: mergeDataFn,\r\n    inject: mergeInject\r\n};\r\nfunction mergeDataFn(to, from) {\r\n    if (!from) {\r\n        return to;\r\n    }\r\n    if (!to) {\r\n        return from;\r\n    }\r\n    return function mergedDataFn() {\r\n        return ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend))((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(to) ? to.call(this, this) : to, (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(from) ? from.call(this, this) : from);\r\n    };\r\n}\r\nfunction mergeInject(to, from) {\r\n    return mergeObjectOptions(normalizeInject(to), normalizeInject(from));\r\n}\r\nfunction normalizeInject(raw) {\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(raw)) {\r\n        const res = {};\r\n        for (let i = 0; i < raw.length; i++) {\r\n            res[raw[i]] = raw[i];\r\n        }\r\n        return res;\r\n    }\r\n    return raw;\r\n}\r\nfunction mergeAsArray(to, from) {\r\n    return to ? [...new Set([].concat(to, from))] : from;\r\n}\r\nfunction mergeObjectOptions(to, from) {\r\n    return to ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(Object.create(null), to), from) : from;\r\n}\r\nfunction mergeWatchOptions(to, from) {\r\n    if (!to)\r\n        return from;\r\n    if (!from)\r\n        return to;\r\n    const merged = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(Object.create(null), to);\r\n    for (const key in from) {\r\n        merged[key] = mergeAsArray(to[key], from[key]);\r\n    }\r\n    return merged;\r\n}\n\nfunction initProps(instance, rawProps, isStateful, // result of bitwise flag comparison\r\nisSSR = false) {\r\n    const props = {};\r\n    const attrs = {};\r\n    (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.def)(attrs, InternalObjectKey, 1);\r\n    instance.propsDefaults = Object.create(null);\r\n    setFullProps(instance, rawProps, props, attrs);\r\n    // ensure all declared prop keys are present\r\n    for (const key in instance.propsOptions[0]) {\r\n        if (!(key in props)) {\r\n            props[key] = undefined;\r\n        }\r\n    }\r\n    // validation\r\n    if ((true)) {\r\n        validateProps(rawProps || {}, props, instance);\r\n    }\r\n    if (isStateful) {\r\n        // stateful\r\n        instance.props = isSSR ? props : (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReactive)(props);\r\n    }\r\n    else {\r\n        if (!instance.type.props) {\r\n            // functional w/ optional props, props === attrs\r\n            instance.props = attrs;\r\n        }\r\n        else {\r\n            // functional w/ declared props\r\n            instance.props = props;\r\n        }\r\n    }\r\n    instance.attrs = attrs;\r\n}\r\nfunction updateProps(instance, rawProps, rawPrevProps, optimized) {\r\n    const { props, attrs, vnode: { patchFlag } } = instance;\r\n    const rawCurrentProps = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(props);\r\n    const [options] = instance.propsOptions;\r\n    let hasAttrsChanged = false;\r\n    if (\r\n    // always force full diff in dev\r\n    // - #1942 if hmr is enabled with sfc component\r\n    // - vite#872 non-sfc component used by sfc component\r\n    !(( true) &&\r\n        (instance.type.__hmrId ||\r\n            (instance.parent && instance.parent.type.__hmrId))) &&\r\n        (optimized || patchFlag > 0) &&\r\n        !(patchFlag & 16 /* FULL_PROPS */)) {\r\n        if (patchFlag & 8 /* PROPS */) {\r\n            // Compiler-generated props & no keys change, just set the updated\r\n            // the props.\r\n            const propsToUpdate = instance.vnode.dynamicProps;\r\n            for (let i = 0; i < propsToUpdate.length; i++) {\r\n                let key = propsToUpdate[i];\r\n                // PROPS flag guarantees rawProps to be non-null\r\n                const value = rawProps[key];\r\n                if (options) {\r\n                    // attr / props separation was done on init and will be consistent\r\n                    // in this code path, so just check if attrs have it.\r\n                    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(attrs, key)) {\r\n                        if (value !== attrs[key]) {\r\n                            attrs[key] = value;\r\n                            hasAttrsChanged = true;\r\n                        }\r\n                    }\r\n                    else {\r\n                        const camelizedKey = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(key);\r\n                        props[camelizedKey] = resolvePropValue(options, rawCurrentProps, camelizedKey, value, instance, false /* isAbsent */);\r\n                    }\r\n                }\r\n                else {\r\n                    if (value !== attrs[key]) {\r\n                        attrs[key] = value;\r\n                        hasAttrsChanged = true;\r\n                    }\r\n                }\r\n            }\r\n        }\r\n    }\r\n    else {\r\n        // full props update.\r\n        if (setFullProps(instance, rawProps, props, attrs)) {\r\n            hasAttrsChanged = true;\r\n        }\r\n        // in case of dynamic props, check if we need to delete keys from\r\n        // the props object\r\n        let kebabKey;\r\n        for (const key in rawCurrentProps) {\r\n            if (!rawProps ||\r\n                // for camelCase\r\n                (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(rawProps, key) &&\r\n                    // it's possible the original props was passed in as kebab-case\r\n                    // and converted to camelCase (#955)\r\n                    ((kebabKey = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(key)) === key || !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(rawProps, kebabKey)))) {\r\n                if (options) {\r\n                    if (rawPrevProps &&\r\n                        // for camelCase\r\n                        (rawPrevProps[key] !== undefined ||\r\n                            // for kebab-case\r\n                            rawPrevProps[kebabKey] !== undefined)) {\r\n                        props[key] = resolvePropValue(options, rawCurrentProps, key, undefined, instance, true /* isAbsent */);\r\n                    }\r\n                }\r\n                else {\r\n                    delete props[key];\r\n                }\r\n            }\r\n        }\r\n        // in the case of functional component w/o props declaration, props and\r\n        // attrs point to the same object so it should already have been updated.\r\n        if (attrs !== rawCurrentProps) {\r\n            for (const key in attrs) {\r\n                if (!rawProps || !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(rawProps, key)) {\r\n                    delete attrs[key];\r\n                    hasAttrsChanged = true;\r\n                }\r\n            }\r\n        }\r\n    }\r\n    // trigger updates for $attrs in case it's used in component slots\r\n    if (hasAttrsChanged) {\r\n        (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.trigger)(instance, \"set\" /* SET */, '$attrs');\r\n    }\r\n    if ((true)) {\r\n        validateProps(rawProps || {}, props, instance);\r\n    }\r\n}\r\nfunction setFullProps(instance, rawProps, props, attrs) {\r\n    const [options, needCastKeys] = instance.propsOptions;\r\n    let hasAttrsChanged = false;\r\n    let rawCastValues;\r\n    if (rawProps) {\r\n        for (let key in rawProps) {\r\n            // key, ref are reserved and never passed down\r\n            if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isReservedProp)(key)) {\r\n                continue;\r\n            }\r\n            const value = rawProps[key];\r\n            // prop option names are camelized during normalization, so to support\r\n            // kebab -> camel conversion here we need to camelize the key.\r\n            let camelKey;\r\n            if (options && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(options, (camelKey = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(key)))) {\r\n                if (!needCastKeys || !needCastKeys.includes(camelKey)) {\r\n                    props[camelKey] = value;\r\n                }\r\n                else {\r\n                    (rawCastValues || (rawCastValues = {}))[camelKey] = value;\r\n                }\r\n            }\r\n            else if (!isEmitListener(instance.emitsOptions, key)) {\r\n                if (value !== attrs[key]) {\r\n                    attrs[key] = value;\r\n                    hasAttrsChanged = true;\r\n                }\r\n            }\r\n        }\r\n    }\r\n    if (needCastKeys) {\r\n        const rawCurrentProps = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(props);\r\n        const castValues = rawCastValues || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;\r\n        for (let i = 0; i < needCastKeys.length; i++) {\r\n            const key = needCastKeys[i];\r\n            props[key] = resolvePropValue(options, rawCurrentProps, key, castValues[key], instance, !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(castValues, key));\r\n        }\r\n    }\r\n    return hasAttrsChanged;\r\n}\r\nfunction resolvePropValue(options, props, key, value, instance, isAbsent) {\r\n    const opt = options[key];\r\n    if (opt != null) {\r\n        const hasDefault = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(opt, 'default');\r\n        // default values\r\n        if (hasDefault && value === undefined) {\r\n            const defaultValue = opt.default;\r\n            if (opt.type !== Function && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(defaultValue)) {\r\n                const { propsDefaults } = instance;\r\n                if (key in propsDefaults) {\r\n                    value = propsDefaults[key];\r\n                }\r\n                else {\r\n                    setCurrentInstance(instance);\r\n                    value = propsDefaults[key] = defaultValue.call(null, props);\r\n                    unsetCurrentInstance();\r\n                }\r\n            }\r\n            else {\r\n                value = defaultValue;\r\n            }\r\n        }\r\n        // boolean casting\r\n        if (opt[0 /* shouldCast */]) {\r\n            if (isAbsent && !hasDefault) {\r\n                value = false;\r\n            }\r\n            else if (opt[1 /* shouldCastTrue */] &&\r\n                (value === '' || value === (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(key))) {\r\n                value = true;\r\n            }\r\n        }\r\n    }\r\n    return value;\r\n}\r\nfunction normalizePropsOptions(comp, appContext, asMixin = false) {\r\n    const cache = appContext.propsCache;\r\n    const cached = cache.get(comp);\r\n    if (cached) {\r\n        return cached;\r\n    }\r\n    const raw = comp.props;\r\n    const normalized = {};\r\n    const needCastKeys = [];\r\n    // apply mixin/extends props\r\n    let hasExtends = false;\r\n    if (__VUE_OPTIONS_API__ && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(comp)) {\r\n        const extendProps = (raw) => {\r\n            hasExtends = true;\r\n            const [props, keys] = normalizePropsOptions(raw, appContext, true);\r\n            (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(normalized, props);\r\n            if (keys)\r\n                needCastKeys.push(...keys);\r\n        };\r\n        if (!asMixin && appContext.mixins.length) {\r\n            appContext.mixins.forEach(extendProps);\r\n        }\r\n        if (comp.extends) {\r\n            extendProps(comp.extends);\r\n        }\r\n        if (comp.mixins) {\r\n            comp.mixins.forEach(extendProps);\r\n        }\r\n    }\r\n    if (!raw && !hasExtends) {\r\n        cache.set(comp, _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_ARR);\r\n        return _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_ARR;\r\n    }\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(raw)) {\r\n        for (let i = 0; i < raw.length; i++) {\r\n            if (( true) && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(raw[i])) {\r\n                warn(`props must be strings when using array syntax.`, raw[i]);\r\n            }\r\n            const normalizedKey = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(raw[i]);\r\n            if (validatePropName(normalizedKey)) {\r\n                normalized[normalizedKey] = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;\r\n            }\r\n        }\r\n    }\r\n    else if (raw) {\r\n        if (( true) && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(raw)) {\r\n            warn(`invalid props options`, raw);\r\n        }\r\n        for (const key in raw) {\r\n            const normalizedKey = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(key);\r\n            if (validatePropName(normalizedKey)) {\r\n                const opt = raw[key];\r\n                const prop = (normalized[normalizedKey] =\r\n                    (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(opt) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(opt) ? { type: opt } : opt);\r\n                if (prop) {\r\n                    const booleanIndex = getTypeIndex(Boolean, prop.type);\r\n                    const stringIndex = getTypeIndex(String, prop.type);\r\n                    prop[0 /* shouldCast */] = booleanIndex > -1;\r\n                    prop[1 /* shouldCastTrue */] =\r\n                        stringIndex < 0 || booleanIndex < stringIndex;\r\n                    // if the prop needs boolean casting or default value\r\n                    if (booleanIndex > -1 || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(prop, 'default')) {\r\n                        needCastKeys.push(normalizedKey);\r\n                    }\r\n                }\r\n            }\r\n        }\r\n    }\r\n    const res = [normalized, needCastKeys];\r\n    cache.set(comp, res);\r\n    return res;\r\n}\r\nfunction validatePropName(key) {\r\n    if (key[0] !== '$') {\r\n        return true;\r\n    }\r\n    else if ((true)) {\r\n        warn(`Invalid prop name: \"${key}\" is a reserved property.`);\r\n    }\r\n    return false;\r\n}\r\n// use function string name to check type constructors\r\n// so that it works across vms / iframes.\r\nfunction getType(ctor) {\r\n    const match = ctor && ctor.toString().match(/^\\s*function (\\w+)/);\r\n    return match ? match[1] : ctor === null ? 'null' : '';\r\n}\r\nfunction isSameType(a, b) {\r\n    return getType(a) === getType(b);\r\n}\r\nfunction getTypeIndex(type, expectedTypes) {\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(expectedTypes)) {\r\n        return expectedTypes.findIndex(t => isSameType(t, type));\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(expectedTypes)) {\r\n        return isSameType(expectedTypes, type) ? 0 : -1;\r\n    }\r\n    return -1;\r\n}\r\n/**\r\n * dev only\r\n */\r\nfunction validateProps(rawProps, props, instance) {\r\n    const resolvedValues = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(props);\r\n    const options = instance.propsOptions[0];\r\n    for (const key in options) {\r\n        let opt = options[key];\r\n        if (opt == null)\r\n            continue;\r\n        validateProp(key, resolvedValues[key], opt, !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(rawProps, key) && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(rawProps, (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hyphenate)(key)));\r\n    }\r\n}\r\n/**\r\n * dev only\r\n */\r\nfunction validateProp(name, value, prop, isAbsent) {\r\n    const { type, required, validator } = prop;\r\n    // required!\r\n    if (required && isAbsent) {\r\n        warn('Missing required prop: \"' + name + '\"');\r\n        return;\r\n    }\r\n    // missing but optional\r\n    if (value == null && !prop.required) {\r\n        return;\r\n    }\r\n    // type check\r\n    if (type != null && type !== true) {\r\n        let isValid = false;\r\n        const types = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(type) ? type : [type];\r\n        const expectedTypes = [];\r\n        // value is valid as long as one of the specified types match\r\n        for (let i = 0; i < types.length && !isValid; i++) {\r\n            const { valid, expectedType } = assertType(value, types[i]);\r\n            expectedTypes.push(expectedType || '');\r\n            isValid = valid;\r\n        }\r\n        if (!isValid) {\r\n            warn(getInvalidTypeMessage(name, value, expectedTypes));\r\n            return;\r\n        }\r\n    }\r\n    // custom validator\r\n    if (validator && !validator(value)) {\r\n        warn('Invalid prop: custom validator check failed for prop \"' + name + '\".');\r\n    }\r\n}\r\nconst isSimpleType = /*#__PURE__*/ (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.makeMap)('String,Number,Boolean,Function,Symbol,BigInt');\r\n/**\r\n * dev only\r\n */\r\nfunction assertType(value, type) {\r\n    let valid;\r\n    const expectedType = getType(type);\r\n    if (isSimpleType(expectedType)) {\r\n        const t = typeof value;\r\n        valid = t === expectedType.toLowerCase();\r\n        // for primitive wrapper objects\r\n        if (!valid && t === 'object') {\r\n            valid = value instanceof type;\r\n        }\r\n    }\r\n    else if (expectedType === 'Object') {\r\n        valid = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(value);\r\n    }\r\n    else if (expectedType === 'Array') {\r\n        valid = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(value);\r\n    }\r\n    else if (expectedType === 'null') {\r\n        valid = value === null;\r\n    }\r\n    else {\r\n        valid = value instanceof type;\r\n    }\r\n    return {\r\n        valid,\r\n        expectedType\r\n    };\r\n}\r\n/**\r\n * dev only\r\n */\r\nfunction getInvalidTypeMessage(name, value, expectedTypes) {\r\n    let message = `Invalid prop: type check failed for prop \"${name}\".` +\r\n        ` Expected ${expectedTypes.map(_vue_shared__WEBPACK_IMPORTED_MODULE_1__.capitalize).join(' | ')}`;\r\n    const expectedType = expectedTypes[0];\r\n    const receivedType = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toRawType)(value);\r\n    const expectedValue = styleValue(value, expectedType);\r\n    const receivedValue = styleValue(value, receivedType);\r\n    // check if we need to specify expected value\r\n    if (expectedTypes.length === 1 &&\r\n        isExplicable(expectedType) &&\r\n        !isBoolean(expectedType, receivedType)) {\r\n        message += ` with value ${expectedValue}`;\r\n    }\r\n    message += `, got ${receivedType} `;\r\n    // check if we need to specify received value\r\n    if (isExplicable(receivedType)) {\r\n        message += `with value ${receivedValue}.`;\r\n    }\r\n    return message;\r\n}\r\n/**\r\n * dev only\r\n */\r\nfunction styleValue(value, type) {\r\n    if (type === 'String') {\r\n        return `\"${value}\"`;\r\n    }\r\n    else if (type === 'Number') {\r\n        return `${Number(value)}`;\r\n    }\r\n    else {\r\n        return `${value}`;\r\n    }\r\n}\r\n/**\r\n * dev only\r\n */\r\nfunction isExplicable(type) {\r\n    const explicitTypes = ['string', 'number', 'boolean'];\r\n    return explicitTypes.some(elem => type.toLowerCase() === elem);\r\n}\r\n/**\r\n * dev only\r\n */\r\nfunction isBoolean(...args) {\r\n    return args.some(elem => elem.toLowerCase() === 'boolean');\r\n}\n\nconst isInternalKey = (key) => key[0] === '_' || key === '$stable';\r\nconst normalizeSlotValue = (value) => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(value)\r\n    ? value.map(normalizeVNode)\r\n    : [normalizeVNode(value)];\r\nconst normalizeSlot = (key, rawSlot, ctx) => {\r\n    const normalized = withCtx((...args) => {\r\n        if (( true) && currentInstance) {\r\n            warn(`Slot \"${key}\" invoked outside of the render function: ` +\r\n                `this will not track dependencies used in the slot. ` +\r\n                `Invoke the slot function inside the render function instead.`);\r\n        }\r\n        return normalizeSlotValue(rawSlot(...args));\r\n    }, ctx);\r\n    normalized._c = false;\r\n    return normalized;\r\n};\r\nconst normalizeObjectSlots = (rawSlots, slots, instance) => {\r\n    const ctx = rawSlots._ctx;\r\n    for (const key in rawSlots) {\r\n        if (isInternalKey(key))\r\n            continue;\r\n        const value = rawSlots[key];\r\n        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(value)) {\r\n            slots[key] = normalizeSlot(key, value, ctx);\r\n        }\r\n        else if (value != null) {\r\n            if (true) {\r\n                warn(`Non-function value encountered for slot \"${key}\". ` +\r\n                    `Prefer function slots for better performance.`);\r\n            }\r\n            const normalized = normalizeSlotValue(value);\r\n            slots[key] = () => normalized;\r\n        }\r\n    }\r\n};\r\nconst normalizeVNodeSlots = (instance, children) => {\r\n    if (( true) &&\r\n        !isKeepAlive(instance.vnode) &&\r\n        !(false )) {\r\n        warn(`Non-function value encountered for default slot. ` +\r\n            `Prefer function slots for better performance.`);\r\n    }\r\n    const normalized = normalizeSlotValue(children);\r\n    instance.slots.default = () => normalized;\r\n};\r\nconst initSlots = (instance, children) => {\r\n    if (instance.vnode.shapeFlag & 32 /* SLOTS_CHILDREN */) {\r\n        const type = children._;\r\n        if (type) {\r\n            // users can get the shallow readonly version of the slots object through `this.$slots`,\r\n            // we should avoid the proxy object polluting the slots of the internal instance\r\n            instance.slots = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(children);\r\n            // make compiler marker non-enumerable\r\n            (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.def)(children, '_', type);\r\n        }\r\n        else {\r\n            normalizeObjectSlots(children, (instance.slots = {}));\r\n        }\r\n    }\r\n    else {\r\n        instance.slots = {};\r\n        if (children) {\r\n            normalizeVNodeSlots(instance, children);\r\n        }\r\n    }\r\n    (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.def)(instance.slots, InternalObjectKey, 1);\r\n};\r\nconst updateSlots = (instance, children, optimized) => {\r\n    const { vnode, slots } = instance;\r\n    let needDeletionCheck = true;\r\n    let deletionComparisonTarget = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;\r\n    if (vnode.shapeFlag & 32 /* SLOTS_CHILDREN */) {\r\n        const type = children._;\r\n        if (type) {\r\n            // compiled slots.\r\n            if (( true) && isHmrUpdating) {\r\n                // Parent was HMR updated so slot content may have changed.\r\n                // force update slots and mark instance for hmr as well\r\n                (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(slots, children);\r\n            }\r\n            else if (optimized && type === 1 /* STABLE */) {\r\n                // compiled AND stable.\r\n                // no need to update, and skip stale slots removal.\r\n                needDeletionCheck = false;\r\n            }\r\n            else {\r\n                // compiled but dynamic (v-if/v-for on slots) - update slots, but skip\r\n                // normalization.\r\n                (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(slots, children);\r\n                // #2893\r\n                // when rendering the optimized slots by manually written render function,\r\n                // we need to delete the `slots._` flag if necessary to make subsequent updates reliable,\r\n                // i.e. let the `renderSlot` create the bailed Fragment\r\n                if (!optimized && type === 1 /* STABLE */) {\r\n                    delete slots._;\r\n                }\r\n            }\r\n        }\r\n        else {\r\n            needDeletionCheck = !children.$stable;\r\n            normalizeObjectSlots(children, slots);\r\n        }\r\n        deletionComparisonTarget = children;\r\n    }\r\n    else if (children) {\r\n        // non slot object children (direct value) passed to a component\r\n        normalizeVNodeSlots(instance, children);\r\n        deletionComparisonTarget = { default: 1 };\r\n    }\r\n    // delete stale slots\r\n    if (needDeletionCheck) {\r\n        for (const key in slots) {\r\n            if (!isInternalKey(key) && !(key in deletionComparisonTarget)) {\r\n                delete slots[key];\r\n            }\r\n        }\r\n    }\r\n};\n\n/**\r\nRuntime helper for applying directives to a vnode. Example usage:\r\n\nconst comp = resolveComponent('comp')\r\nconst foo = resolveDirective('foo')\r\nconst bar = resolveDirective('bar')\r\n\nreturn withDirectives(h(comp), [\r\n  [foo, this.x],\r\n  [bar, this.y]\r\n])\r\n*/\r\nconst isBuiltInDirective = /*#__PURE__*/ (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.makeMap)('bind,cloak,else-if,else,for,html,if,model,on,once,pre,show,slot,text,memo');\r\nfunction validateDirectiveName(name) {\r\n    if (isBuiltInDirective(name)) {\r\n        warn('Do not use built-in directive ids as custom directive id: ' + name);\r\n    }\r\n}\r\n/**\r\n * Adds directives to a VNode.\r\n */\r\nfunction withDirectives(vnode, directives) {\r\n    const internalInstance = currentRenderingInstance;\r\n    if (internalInstance === null) {\r\n        ( true) && warn(`withDirectives can only be used inside render functions.`);\r\n        return vnode;\r\n    }\r\n    const instance = internalInstance.proxy;\r\n    const bindings = vnode.dirs || (vnode.dirs = []);\r\n    for (let i = 0; i < directives.length; i++) {\r\n        let [dir, value, arg, modifiers = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ] = directives[i];\r\n        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(dir)) {\r\n            dir = {\r\n                mounted: dir,\r\n                updated: dir\r\n            };\r\n        }\r\n        if (dir.deep) {\r\n            traverse(value);\r\n        }\r\n        bindings.push({\r\n            dir,\r\n            instance,\r\n            value,\r\n            oldValue: void 0,\r\n            arg,\r\n            modifiers\r\n        });\r\n    }\r\n    return vnode;\r\n}\r\nfunction invokeDirectiveHook(vnode, prevVNode, instance, name) {\r\n    const bindings = vnode.dirs;\r\n    const oldBindings = prevVNode && prevVNode.dirs;\r\n    for (let i = 0; i < bindings.length; i++) {\r\n        const binding = bindings[i];\r\n        if (oldBindings) {\r\n            binding.oldValue = oldBindings[i].value;\r\n        }\r\n        let hook = binding.dir[name];\r\n        if (hook) {\r\n            // disable tracking inside all lifecycle hooks\r\n            // since they can potentially be called inside effects.\r\n            (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.pauseTracking)();\r\n            callWithAsyncErrorHandling(hook, instance, 8 /* DIRECTIVE_HOOK */, [\r\n                vnode.el,\r\n                binding,\r\n                vnode,\r\n                prevVNode\r\n            ]);\r\n            (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.resetTracking)();\r\n        }\r\n    }\r\n}\n\nfunction createAppContext() {\r\n    return {\r\n        app: null,\r\n        config: {\r\n            isNativeTag: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NO,\r\n            performance: false,\r\n            globalProperties: {},\r\n            optionMergeStrategies: {},\r\n            errorHandler: undefined,\r\n            warnHandler: undefined,\r\n            compilerOptions: {}\r\n        },\r\n        mixins: [],\r\n        components: {},\r\n        directives: {},\r\n        provides: Object.create(null),\r\n        optionsCache: new WeakMap(),\r\n        propsCache: new WeakMap(),\r\n        emitsCache: new WeakMap()\r\n    };\r\n}\r\nlet uid = 0;\r\nfunction createAppAPI(render, hydrate) {\r\n    return function createApp(rootComponent, rootProps = null) {\r\n        if (rootProps != null && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(rootProps)) {\r\n            ( true) && warn(`root props passed to app.mount() must be an object.`);\r\n            rootProps = null;\r\n        }\r\n        const context = createAppContext();\r\n        const installedPlugins = new Set();\r\n        let isMounted = false;\r\n        const app = (context.app = {\r\n            _uid: uid++,\r\n            _component: rootComponent,\r\n            _props: rootProps,\r\n            _container: null,\r\n            _context: context,\r\n            _instance: null,\r\n            version,\r\n            get config() {\r\n                return context.config;\r\n            },\r\n            set config(v) {\r\n                if ((true)) {\r\n                    warn(`app.config cannot be replaced. Modify individual options instead.`);\r\n                }\r\n            },\r\n            use(plugin, ...options) {\r\n                if (installedPlugins.has(plugin)) {\r\n                    ( true) && warn(`Plugin has already been applied to target app.`);\r\n                }\r\n                else if (plugin && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(plugin.install)) {\r\n                    installedPlugins.add(plugin);\r\n                    plugin.install(app, ...options);\r\n                }\r\n                else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(plugin)) {\r\n                    installedPlugins.add(plugin);\r\n                    plugin(app, ...options);\r\n                }\r\n                else if ((true)) {\r\n                    warn(`A plugin must either be a function or an object with an \"install\" ` +\r\n                        `function.`);\r\n                }\r\n                return app;\r\n            },\r\n            mixin(mixin) {\r\n                if (__VUE_OPTIONS_API__) {\r\n                    if (!context.mixins.includes(mixin)) {\r\n                        context.mixins.push(mixin);\r\n                    }\r\n                    else if ((true)) {\r\n                        warn('Mixin has already been applied to target app' +\r\n                            (mixin.name ? `: ${mixin.name}` : ''));\r\n                    }\r\n                }\r\n                else if ((true)) {\r\n                    warn('Mixins are only available in builds supporting Options API');\r\n                }\r\n                return app;\r\n            },\r\n            component(name, component) {\r\n                if ((true)) {\r\n                    validateComponentName(name, context.config);\r\n                }\r\n                if (!component) {\r\n                    return context.components[name];\r\n                }\r\n                if (( true) && context.components[name]) {\r\n                    warn(`Component \"${name}\" has already been registered in target app.`);\r\n                }\r\n                context.components[name] = component;\r\n                return app;\r\n            },\r\n            directive(name, directive) {\r\n                if ((true)) {\r\n                    validateDirectiveName(name);\r\n                }\r\n                if (!directive) {\r\n                    return context.directives[name];\r\n                }\r\n                if (( true) && context.directives[name]) {\r\n                    warn(`Directive \"${name}\" has already been registered in target app.`);\r\n                }\r\n                context.directives[name] = directive;\r\n                return app;\r\n            },\r\n            mount(rootContainer, isHydrate, isSVG) {\r\n                if (!isMounted) {\r\n                    const vnode = createVNode(rootComponent, rootProps);\r\n                    // store app context on the root VNode.\r\n                    // this will be set on the root instance on initial mount.\r\n                    vnode.appContext = context;\r\n                    // HMR root reload\r\n                    if ((true)) {\r\n                        context.reload = () => {\r\n                            render(cloneVNode(vnode), rootContainer, isSVG);\r\n                        };\r\n                    }\r\n                    if (isHydrate && hydrate) {\r\n                        hydrate(vnode, rootContainer);\r\n                    }\r\n                    else {\r\n                        render(vnode, rootContainer, isSVG);\r\n                    }\r\n                    isMounted = true;\r\n                    app._container = rootContainer;\r\n                    rootContainer.__vue_app__ = app;\r\n                    if (true) {\r\n                        app._instance = vnode.component;\r\n                        devtoolsInitApp(app, version);\r\n                    }\r\n                    return getExposeProxy(vnode.component) || vnode.component.proxy;\r\n                }\r\n                else if ((true)) {\r\n                    warn(`App has already been mounted.\\n` +\r\n                        `If you want to remount the same app, move your app creation logic ` +\r\n                        `into a factory function and create fresh app instances for each ` +\r\n                        `mount - e.g. \\`const createMyApp = () => createApp(App)\\``);\r\n                }\r\n            },\r\n            unmount() {\r\n                if (isMounted) {\r\n                    render(null, app._container);\r\n                    if (true) {\r\n                        app._instance = null;\r\n                        devtoolsUnmountApp(app);\r\n                    }\r\n                    delete app._container.__vue_app__;\r\n                }\r\n                else if ((true)) {\r\n                    warn(`Cannot unmount an app that is not mounted.`);\r\n                }\r\n            },\r\n            provide(key, value) {\r\n                if (( true) && key in context.provides) {\r\n                    warn(`App already provides property with key \"${String(key)}\". ` +\r\n                        `It will be overwritten with the new value.`);\r\n                }\r\n                // TypeScript doesn't allow symbols as index type\r\n                // https://github.com/Microsoft/TypeScript/issues/24587\r\n                context.provides[key] = value;\r\n                return app;\r\n            }\r\n        });\r\n        return app;\r\n    };\r\n}\n\nlet hasMismatch = false;\r\nconst isSVGContainer = (container) => /svg/.test(container.namespaceURI) && container.tagName !== 'foreignObject';\r\nconst isComment = (node) => node.nodeType === 8 /* COMMENT */;\r\n// Note: hydration is DOM-specific\r\n// But we have to place it in core due to tight coupling with core - splitting\r\n// it out creates a ton of unnecessary complexity.\r\n// Hydration also depends on some renderer internal logic which needs to be\r\n// passed in via arguments.\r\nfunction createHydrationFunctions(rendererInternals) {\r\n    const { mt: mountComponent, p: patch, o: { patchProp, nextSibling, parentNode, remove, insert, createComment } } = rendererInternals;\r\n    const hydrate = (vnode, container) => {\r\n        if (!container.hasChildNodes()) {\r\n            ( true) &&\r\n                warn(`Attempting to hydrate existing markup but container is empty. ` +\r\n                    `Performing full mount instead.`);\r\n            patch(null, vnode, container);\r\n            flushPostFlushCbs();\r\n            return;\r\n        }\r\n        hasMismatch = false;\r\n        hydrateNode(container.firstChild, vnode, null, null, null);\r\n        flushPostFlushCbs();\r\n        if (hasMismatch && !false) {\r\n            // this error should show up in production\r\n            console.error(`Hydration completed but contains mismatches.`);\r\n        }\r\n    };\r\n    const hydrateNode = (node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized = false) => {\r\n        const isFragmentStart = isComment(node) && node.data === '[';\r\n        const onMismatch = () => handleMismatch(node, vnode, parentComponent, parentSuspense, slotScopeIds, isFragmentStart);\r\n        const { type, ref, shapeFlag } = vnode;\r\n        const domType = node.nodeType;\r\n        vnode.el = node;\r\n        let nextNode = null;\r\n        switch (type) {\r\n            case Text:\r\n                if (domType !== 3 /* TEXT */) {\r\n                    nextNode = onMismatch();\r\n                }\r\n                else {\r\n                    if (node.data !== vnode.children) {\r\n                        hasMismatch = true;\r\n                        ( true) &&\r\n                            warn(`Hydration text mismatch:` +\r\n                                `\\n- Client: ${JSON.stringify(node.data)}` +\r\n                                `\\n- Server: ${JSON.stringify(vnode.children)}`);\r\n                        node.data = vnode.children;\r\n                    }\r\n                    nextNode = nextSibling(node);\r\n                }\r\n                break;\r\n            case Comment:\r\n                if (domType !== 8 /* COMMENT */ || isFragmentStart) {\r\n                    nextNode = onMismatch();\r\n                }\r\n                else {\r\n                    nextNode = nextSibling(node);\r\n                }\r\n                break;\r\n            case Static:\r\n                if (domType !== 1 /* ELEMENT */) {\r\n                    nextNode = onMismatch();\r\n                }\r\n                else {\r\n                    // determine anchor, adopt content\r\n                    nextNode = node;\r\n                    // if the static vnode has its content stripped during build,\r\n                    // adopt it from the server-rendered HTML.\r\n                    const needToAdoptContent = !vnode.children.length;\r\n                    for (let i = 0; i < vnode.staticCount; i++) {\r\n                        if (needToAdoptContent)\r\n                            vnode.children += nextNode.outerHTML;\r\n                        if (i === vnode.staticCount - 1) {\r\n                            vnode.anchor = nextNode;\r\n                        }\r\n                        nextNode = nextSibling(nextNode);\r\n                    }\r\n                    return nextNode;\r\n                }\r\n                break;\r\n            case Fragment:\r\n                if (!isFragmentStart) {\r\n                    nextNode = onMismatch();\r\n                }\r\n                else {\r\n                    nextNode = hydrateFragment(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized);\r\n                }\r\n                break;\r\n            default:\r\n                if (shapeFlag & 1 /* ELEMENT */) {\r\n                    if (domType !== 1 /* ELEMENT */ ||\r\n                        vnode.type.toLowerCase() !==\r\n                            node.tagName.toLowerCase()) {\r\n                        nextNode = onMismatch();\r\n                    }\r\n                    else {\r\n                        nextNode = hydrateElement(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized);\r\n                    }\r\n                }\r\n                else if (shapeFlag & 6 /* COMPONENT */) {\r\n                    // when setting up the render effect, if the initial vnode already\r\n                    // has .el set, the component will perform hydration instead of mount\r\n                    // on its sub-tree.\r\n                    vnode.slotScopeIds = slotScopeIds;\r\n                    const container = parentNode(node);\r\n                    mountComponent(vnode, container, null, parentComponent, parentSuspense, isSVGContainer(container), optimized);\r\n                    // component may be async, so in the case of fragments we cannot rely\r\n                    // on component's rendered output to determine the end of the fragment\r\n                    // instead, we do a lookahead to find the end anchor node.\r\n                    nextNode = isFragmentStart\r\n                        ? locateClosingAsyncAnchor(node)\r\n                        : nextSibling(node);\r\n                    // #3787\r\n                    // if component is async, it may get moved / unmounted before its\r\n                    // inner component is loaded, so we need to give it a placeholder\r\n                    // vnode that matches its adopted DOM.\r\n                    if (isAsyncWrapper(vnode)) {\r\n                        let subTree;\r\n                        if (isFragmentStart) {\r\n                            subTree = createVNode(Fragment);\r\n                            subTree.anchor = nextNode\r\n                                ? nextNode.previousSibling\r\n                                : container.lastChild;\r\n                        }\r\n                        else {\r\n                            subTree =\r\n                                node.nodeType === 3 ? createTextVNode('') : createVNode('div');\r\n                        }\r\n                        subTree.el = node;\r\n                        vnode.component.subTree = subTree;\r\n                    }\r\n                }\r\n                else if (shapeFlag & 64 /* TELEPORT */) {\r\n                    if (domType !== 8 /* COMMENT */) {\r\n                        nextNode = onMismatch();\r\n                    }\r\n                    else {\r\n                        nextNode = vnode.type.hydrate(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized, rendererInternals, hydrateChildren);\r\n                    }\r\n                }\r\n                else if (shapeFlag & 128 /* SUSPENSE */) {\r\n                    nextNode = vnode.type.hydrate(node, vnode, parentComponent, parentSuspense, isSVGContainer(parentNode(node)), slotScopeIds, optimized, rendererInternals, hydrateNode);\r\n                }\r\n                else if ((true)) {\r\n                    warn('Invalid HostVNode type:', type, `(${typeof type})`);\r\n                }\r\n        }\r\n        if (ref != null) {\r\n            setRef(ref, null, parentSuspense, vnode);\r\n        }\r\n        return nextNode;\r\n    };\r\n    const hydrateElement = (el, vnode, parentComponent, parentSuspense, slotScopeIds, optimized) => {\r\n        optimized = optimized || !!vnode.dynamicChildren;\r\n        const { type, props, patchFlag, shapeFlag, dirs } = vnode;\r\n        // #4006 for form elements with non-string v-model value bindings\r\n        // e.g. <option :value=\"obj\">, <input type=\"checkbox\" :true-value=\"1\">\r\n        const forcePatchValue = (type === 'input' && dirs) || type === 'option';\r\n        // skip props & children if this is hoisted static nodes\r\n        if (forcePatchValue || patchFlag !== -1 /* HOISTED */) {\r\n            if (dirs) {\r\n                invokeDirectiveHook(vnode, null, parentComponent, 'created');\r\n            }\r\n            // props\r\n            if (props) {\r\n                if (forcePatchValue ||\r\n                    !optimized ||\r\n                    patchFlag & (16 /* FULL_PROPS */ | 32 /* HYDRATE_EVENTS */)) {\r\n                    for (const key in props) {\r\n                        if ((forcePatchValue && key.endsWith('value')) ||\r\n                            ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isOn)(key) && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isReservedProp)(key))) {\r\n                            patchProp(el, key, null, props[key], false, undefined, parentComponent);\r\n                        }\r\n                    }\r\n                }\r\n                else if (props.onClick) {\r\n                    // Fast path for click listeners (which is most often) to avoid\r\n                    // iterating through props.\r\n                    patchProp(el, 'onClick', null, props.onClick, false, undefined, parentComponent);\r\n                }\r\n            }\r\n            // vnode / directive hooks\r\n            let vnodeHooks;\r\n            if ((vnodeHooks = props && props.onVnodeBeforeMount)) {\r\n                invokeVNodeHook(vnodeHooks, parentComponent, vnode);\r\n            }\r\n            if (dirs) {\r\n                invokeDirectiveHook(vnode, null, parentComponent, 'beforeMount');\r\n            }\r\n            if ((vnodeHooks = props && props.onVnodeMounted) || dirs) {\r\n                queueEffectWithSuspense(() => {\r\n                    vnodeHooks && invokeVNodeHook(vnodeHooks, parentComponent, vnode);\r\n                    dirs && invokeDirectiveHook(vnode, null, parentComponent, 'mounted');\r\n                }, parentSuspense);\r\n            }\r\n            // children\r\n            if (shapeFlag & 16 /* ARRAY_CHILDREN */ &&\r\n                // skip if element has innerHTML / textContent\r\n                !(props && (props.innerHTML || props.textContent))) {\r\n                let next = hydrateChildren(el.firstChild, vnode, el, parentComponent, parentSuspense, slotScopeIds, optimized);\r\n                let hasWarned = false;\r\n                while (next) {\r\n                    hasMismatch = true;\r\n                    if (( true) && !hasWarned) {\r\n                        warn(`Hydration children mismatch in <${vnode.type}>: ` +\r\n                            `server rendered element contains more child nodes than client vdom.`);\r\n                        hasWarned = true;\r\n                    }\r\n                    // The SSRed DOM contains more nodes than it should. Remove them.\r\n                    const cur = next;\r\n                    next = next.nextSibling;\r\n                    remove(cur);\r\n                }\r\n            }\r\n            else if (shapeFlag & 8 /* TEXT_CHILDREN */) {\r\n                if (el.textContent !== vnode.children) {\r\n                    hasMismatch = true;\r\n                    ( true) &&\r\n                        warn(`Hydration text content mismatch in <${vnode.type}>:\\n` +\r\n                            `- Client: ${el.textContent}\\n` +\r\n                            `- Server: ${vnode.children}`);\r\n                    el.textContent = vnode.children;\r\n                }\r\n            }\r\n        }\r\n        return el.nextSibling;\r\n    };\r\n    const hydrateChildren = (node, parentVNode, container, parentComponent, parentSuspense, slotScopeIds, optimized) => {\r\n        optimized = optimized || !!parentVNode.dynamicChildren;\r\n        const children = parentVNode.children;\r\n        const l = children.length;\r\n        let hasWarned = false;\r\n        for (let i = 0; i < l; i++) {\r\n            const vnode = optimized\r\n                ? children[i]\r\n                : (children[i] = normalizeVNode(children[i]));\r\n            if (node) {\r\n                node = hydrateNode(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized);\r\n            }\r\n            else if (vnode.type === Text && !vnode.children) {\r\n                continue;\r\n            }\r\n            else {\r\n                hasMismatch = true;\r\n                if (( true) && !hasWarned) {\r\n                    warn(`Hydration children mismatch in <${container.tagName.toLowerCase()}>: ` +\r\n                        `server rendered element contains fewer child nodes than client vdom.`);\r\n                    hasWarned = true;\r\n                }\r\n                // the SSRed DOM didn't contain enough nodes. Mount the missing ones.\r\n                patch(null, vnode, container, null, parentComponent, parentSuspense, isSVGContainer(container), slotScopeIds);\r\n            }\r\n        }\r\n        return node;\r\n    };\r\n    const hydrateFragment = (node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized) => {\r\n        const { slotScopeIds: fragmentSlotScopeIds } = vnode;\r\n        if (fragmentSlotScopeIds) {\r\n            slotScopeIds = slotScopeIds\r\n                ? slotScopeIds.concat(fragmentSlotScopeIds)\r\n                : fragmentSlotScopeIds;\r\n        }\r\n        const container = parentNode(node);\r\n        const next = hydrateChildren(nextSibling(node), vnode, container, parentComponent, parentSuspense, slotScopeIds, optimized);\r\n        if (next && isComment(next) && next.data === ']') {\r\n            return nextSibling((vnode.anchor = next));\r\n        }\r\n        else {\r\n            // fragment didn't hydrate successfully, since we didn't get a end anchor\r\n            // back. This should have led to node/children mismatch warnings.\r\n            hasMismatch = true;\r\n            // since the anchor is missing, we need to create one and insert it\r\n            insert((vnode.anchor = createComment(`]`)), container, next);\r\n            return next;\r\n        }\r\n    };\r\n    const handleMismatch = (node, vnode, parentComponent, parentSuspense, slotScopeIds, isFragment) => {\r\n        hasMismatch = true;\r\n        ( true) &&\r\n            warn(`Hydration node mismatch:\\n- Client vnode:`, vnode.type, `\\n- Server rendered DOM:`, node, node.nodeType === 3 /* TEXT */\r\n                ? `(text)`\r\n                : isComment(node) && node.data === '['\r\n                    ? `(start of fragment)`\r\n                    : ``);\r\n        vnode.el = null;\r\n        if (isFragment) {\r\n            // remove excessive fragment nodes\r\n            const end = locateClosingAsyncAnchor(node);\r\n            while (true) {\r\n                const next = nextSibling(node);\r\n                if (next && next !== end) {\r\n                    remove(next);\r\n                }\r\n                else {\r\n                    break;\r\n                }\r\n            }\r\n        }\r\n        const next = nextSibling(node);\r\n        const container = parentNode(node);\r\n        remove(node);\r\n        patch(null, vnode, container, next, parentComponent, parentSuspense, isSVGContainer(container), slotScopeIds);\r\n        return next;\r\n    };\r\n    const locateClosingAsyncAnchor = (node) => {\r\n        let match = 0;\r\n        while (node) {\r\n            node = nextSibling(node);\r\n            if (node && isComment(node)) {\r\n                if (node.data === '[')\r\n                    match++;\r\n                if (node.data === ']') {\r\n                    if (match === 0) {\r\n                        return nextSibling(node);\r\n                    }\r\n                    else {\r\n                        match--;\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        return node;\r\n    };\r\n    return [hydrate, hydrateNode];\r\n}\n\nlet supported;\r\nlet perf;\r\nfunction startMeasure(instance, type) {\r\n    if (instance.appContext.config.performance && isSupported()) {\r\n        perf.mark(`vue-${type}-${instance.uid}`);\r\n    }\r\n    if (true) {\r\n        devtoolsPerfStart(instance, type, supported ? perf.now() : Date.now());\r\n    }\r\n}\r\nfunction endMeasure(instance, type) {\r\n    if (instance.appContext.config.performance && isSupported()) {\r\n        const startTag = `vue-${type}-${instance.uid}`;\r\n        const endTag = startTag + `:end`;\r\n        perf.mark(endTag);\r\n        perf.measure(`<${formatComponentName(instance, instance.type)}> ${type}`, startTag, endTag);\r\n        perf.clearMarks(startTag);\r\n        perf.clearMarks(endTag);\r\n    }\r\n    if (true) {\r\n        devtoolsPerfEnd(instance, type, supported ? perf.now() : Date.now());\r\n    }\r\n}\r\nfunction isSupported() {\r\n    if (supported !== undefined) {\r\n        return supported;\r\n    }\r\n    /* eslint-disable no-restricted-globals */\r\n    if (typeof window !== 'undefined' && window.performance) {\r\n        supported = true;\r\n        perf = window.performance;\r\n    }\r\n    else {\r\n        supported = false;\r\n    }\r\n    /* eslint-enable no-restricted-globals */\r\n    return supported;\r\n}\n\n/**\r\n * This is only called in esm-bundler builds.\r\n * It is called when a renderer is created, in `baseCreateRenderer` so that\r\n * importing runtime-core is side-effects free.\r\n *\r\n * istanbul-ignore-next\r\n */\r\nfunction initFeatureFlags() {\r\n    const needWarn = [];\r\n    if (typeof __VUE_OPTIONS_API__ !== 'boolean') {\r\n        ( true) && needWarn.push(`__VUE_OPTIONS_API__`);\r\n        (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.getGlobalThis)().__VUE_OPTIONS_API__ = true;\r\n    }\r\n    if (typeof __VUE_PROD_DEVTOOLS__ !== 'boolean') {\r\n        ( true) && needWarn.push(`__VUE_PROD_DEVTOOLS__`);\r\n        (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.getGlobalThis)().__VUE_PROD_DEVTOOLS__ = false;\r\n    }\r\n    if (( true) && needWarn.length) {\r\n        const multi = needWarn.length > 1;\r\n        console.warn(`Feature flag${multi ? `s` : ``} ${needWarn.join(', ')} ${multi ? `are` : `is`} not explicitly defined. You are running the esm-bundler build of Vue, ` +\r\n            `which expects these compile-time feature flags to be globally injected ` +\r\n            `via the bundler config in order to get better tree-shaking in the ` +\r\n            `production bundle.\\n\\n` +\r\n            `For more details, see http://link.vuejs.org/feature-flags.`);\r\n    }\r\n}\n\nconst queuePostRenderEffect = queueEffectWithSuspense\r\n    ;\r\n/**\r\n * The createRenderer function accepts two generic arguments:\r\n * HostNode and HostElement, corresponding to Node and Element types in the\r\n * host environment. For example, for runtime-dom, HostNode would be the DOM\r\n * `Node` interface and HostElement would be the DOM `Element` interface.\r\n *\r\n * Custom renderers can pass in the platform specific types like this:\r\n *\r\n * ``` js\r\n * const { render, createApp } = createRenderer<Node, Element>({\r\n *   patchProp,\r\n *   ...nodeOps\r\n * })\r\n * ```\r\n */\r\nfunction createRenderer(options) {\r\n    return baseCreateRenderer(options);\r\n}\r\n// Separate API for creating hydration-enabled renderer.\r\n// Hydration logic is only used when calling this function, making it\r\n// tree-shakable.\r\nfunction createHydrationRenderer(options) {\r\n    return baseCreateRenderer(options, createHydrationFunctions);\r\n}\r\n// implementation\r\nfunction baseCreateRenderer(options, createHydrationFns) {\r\n    // compile-time feature flags check\r\n    {\r\n        initFeatureFlags();\r\n    }\r\n    const target = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.getGlobalThis)();\r\n    target.__VUE__ = true;\r\n    if (true) {\r\n        setDevtoolsHook(target.__VUE_DEVTOOLS_GLOBAL_HOOK__, target);\r\n    }\r\n    const { insert: hostInsert, remove: hostRemove, patchProp: hostPatchProp, createElement: hostCreateElement, createText: hostCreateText, createComment: hostCreateComment, setText: hostSetText, setElementText: hostSetElementText, parentNode: hostParentNode, nextSibling: hostNextSibling, setScopeId: hostSetScopeId = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP, cloneNode: hostCloneNode, insertStaticContent: hostInsertStaticContent } = options;\r\n    // Note: functions inside this closure should use `const xxx = () => {}`\r\n    // style in order to prevent being inlined by minifiers.\r\n    const patch = (n1, n2, container, anchor = null, parentComponent = null, parentSuspense = null, isSVG = false, slotScopeIds = null, optimized = ( true) && isHmrUpdating ? false : !!n2.dynamicChildren) => {\r\n        if (n1 === n2) {\r\n            return;\r\n        }\r\n        // patching & not same type, unmount old tree\r\n        if (n1 && !isSameVNodeType(n1, n2)) {\r\n            anchor = getNextHostNode(n1);\r\n            unmount(n1, parentComponent, parentSuspense, true);\r\n            n1 = null;\r\n        }\r\n        if (n2.patchFlag === -2 /* BAIL */) {\r\n            optimized = false;\r\n            n2.dynamicChildren = null;\r\n        }\r\n        const { type, ref, shapeFlag } = n2;\r\n        switch (type) {\r\n            case Text:\r\n                processText(n1, n2, container, anchor);\r\n                break;\r\n            case Comment:\r\n                processCommentNode(n1, n2, container, anchor);\r\n                break;\r\n            case Static:\r\n                if (n1 == null) {\r\n                    mountStaticNode(n2, container, anchor, isSVG);\r\n                }\r\n                else if ((true)) {\r\n                    patchStaticNode(n1, n2, container, isSVG);\r\n                }\r\n                break;\r\n            case Fragment:\r\n                processFragment(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n                break;\r\n            default:\r\n                if (shapeFlag & 1 /* ELEMENT */) {\r\n                    processElement(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n                }\r\n                else if (shapeFlag & 6 /* COMPONENT */) {\r\n                    processComponent(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n                }\r\n                else if (shapeFlag & 64 /* TELEPORT */) {\r\n                    type.process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals);\r\n                }\r\n                else if (shapeFlag & 128 /* SUSPENSE */) {\r\n                    type.process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals);\r\n                }\r\n                else if ((true)) {\r\n                    warn('Invalid VNode type:', type, `(${typeof type})`);\r\n                }\r\n        }\r\n        // set ref\r\n        if (ref != null && parentComponent) {\r\n            setRef(ref, n1 && n1.ref, parentSuspense, n2 || n1, !n2);\r\n        }\r\n    };\r\n    const processText = (n1, n2, container, anchor) => {\r\n        if (n1 == null) {\r\n            hostInsert((n2.el = hostCreateText(n2.children)), container, anchor);\r\n        }\r\n        else {\r\n            const el = (n2.el = n1.el);\r\n            if (n2.children !== n1.children) {\r\n                hostSetText(el, n2.children);\r\n            }\r\n        }\r\n    };\r\n    const processCommentNode = (n1, n2, container, anchor) => {\r\n        if (n1 == null) {\r\n            hostInsert((n2.el = hostCreateComment(n2.children || '')), container, anchor);\r\n        }\r\n        else {\r\n            // there's no support for dynamic comments\r\n            n2.el = n1.el;\r\n        }\r\n    };\r\n    const mountStaticNode = (n2, container, anchor, isSVG) => {\r\n        [n2.el, n2.anchor] = hostInsertStaticContent(n2.children, container, anchor, isSVG);\r\n    };\r\n    /**\r\n     * Dev / HMR only\r\n     */\r\n    const patchStaticNode = (n1, n2, container, isSVG) => {\r\n        // static nodes are only patched during dev for HMR\r\n        if (n2.children !== n1.children) {\r\n            const anchor = hostNextSibling(n1.anchor);\r\n            // remove existing\r\n            removeStaticNode(n1);\r\n            [n2.el, n2.anchor] = hostInsertStaticContent(n2.children, container, anchor, isSVG);\r\n        }\r\n        else {\r\n            n2.el = n1.el;\r\n            n2.anchor = n1.anchor;\r\n        }\r\n    };\r\n    const moveStaticNode = ({ el, anchor }, container, nextSibling) => {\r\n        let next;\r\n        while (el && el !== anchor) {\r\n            next = hostNextSibling(el);\r\n            hostInsert(el, container, nextSibling);\r\n            el = next;\r\n        }\r\n        hostInsert(anchor, container, nextSibling);\r\n    };\r\n    const removeStaticNode = ({ el, anchor }) => {\r\n        let next;\r\n        while (el && el !== anchor) {\r\n            next = hostNextSibling(el);\r\n            hostRemove(el);\r\n            el = next;\r\n        }\r\n        hostRemove(anchor);\r\n    };\r\n    const processElement = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {\r\n        isSVG = isSVG || n2.type === 'svg';\r\n        if (n1 == null) {\r\n            mountElement(n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n        }\r\n        else {\r\n            patchElement(n1, n2, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n        }\r\n    };\r\n    const mountElement = (vnode, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {\r\n        let el;\r\n        let vnodeHook;\r\n        const { type, props, shapeFlag, transition, patchFlag, dirs } = vnode;\r\n        if (false /* HOISTED */) {}\r\n        else {\r\n            el = vnode.el = hostCreateElement(vnode.type, isSVG, props && props.is, props);\r\n            // mount children first, since some props may rely on child content\r\n            // being already rendered, e.g. `<select value>`\r\n            if (shapeFlag & 8 /* TEXT_CHILDREN */) {\r\n                hostSetElementText(el, vnode.children);\r\n            }\r\n            else if (shapeFlag & 16 /* ARRAY_CHILDREN */) {\r\n                mountChildren(vnode.children, el, null, parentComponent, parentSuspense, isSVG && type !== 'foreignObject', slotScopeIds, optimized);\r\n            }\r\n            if (dirs) {\r\n                invokeDirectiveHook(vnode, null, parentComponent, 'created');\r\n            }\r\n            // props\r\n            if (props) {\r\n                for (const key in props) {\r\n                    if (key !== 'value' && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isReservedProp)(key)) {\r\n                        hostPatchProp(el, key, null, props[key], isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);\r\n                    }\r\n                }\r\n                /**\r\n                 * Special case for setting value on DOM elements:\r\n                 * - it can be order-sensitive (e.g. should be set *after* min/max, #2325, #4024)\r\n                 * - it needs to be forced (#1471)\r\n                 * #2353 proposes adding another renderer option to configure this, but\r\n                 * the properties affects are so finite it is worth special casing it\r\n                 * here to reduce the complexity. (Special casing it also should not\r\n                 * affect non-DOM renderers)\r\n                 */\r\n                if ('value' in props) {\r\n                    hostPatchProp(el, 'value', null, props.value);\r\n                }\r\n                if ((vnodeHook = props.onVnodeBeforeMount)) {\r\n                    invokeVNodeHook(vnodeHook, parentComponent, vnode);\r\n                }\r\n            }\r\n            // scopeId\r\n            setScopeId(el, vnode, vnode.scopeId, slotScopeIds, parentComponent);\r\n        }\r\n        if (true) {\r\n            Object.defineProperty(el, '__vnode', {\r\n                value: vnode,\r\n                enumerable: false\r\n            });\r\n            Object.defineProperty(el, '__vueParentComponent', {\r\n                value: parentComponent,\r\n                enumerable: false\r\n            });\r\n        }\r\n        if (dirs) {\r\n            invokeDirectiveHook(vnode, null, parentComponent, 'beforeMount');\r\n        }\r\n        // #1583 For inside suspense + suspense not resolved case, enter hook should call when suspense resolved\r\n        // #1689 For inside suspense + suspense resolved case, just call it\r\n        const needCallTransitionHooks = (!parentSuspense || (parentSuspense && !parentSuspense.pendingBranch)) &&\r\n            transition &&\r\n            !transition.persisted;\r\n        if (needCallTransitionHooks) {\r\n            transition.beforeEnter(el);\r\n        }\r\n        hostInsert(el, container, anchor);\r\n        if ((vnodeHook = props && props.onVnodeMounted) ||\r\n            needCallTransitionHooks ||\r\n            dirs) {\r\n            queuePostRenderEffect(() => {\r\n                vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);\r\n                needCallTransitionHooks && transition.enter(el);\r\n                dirs && invokeDirectiveHook(vnode, null, parentComponent, 'mounted');\r\n            }, parentSuspense);\r\n        }\r\n    };\r\n    const setScopeId = (el, vnode, scopeId, slotScopeIds, parentComponent) => {\r\n        if (scopeId) {\r\n            hostSetScopeId(el, scopeId);\r\n        }\r\n        if (slotScopeIds) {\r\n            for (let i = 0; i < slotScopeIds.length; i++) {\r\n                hostSetScopeId(el, slotScopeIds[i]);\r\n            }\r\n        }\r\n        if (parentComponent) {\r\n            let subTree = parentComponent.subTree;\r\n            if (( true) &&\r\n                subTree.patchFlag > 0 &&\r\n                subTree.patchFlag & 2048 /* DEV_ROOT_FRAGMENT */) {\r\n                subTree =\r\n                    filterSingleRoot(subTree.children) || subTree;\r\n            }\r\n            if (vnode === subTree) {\r\n                const parentVNode = parentComponent.vnode;\r\n                setScopeId(el, parentVNode, parentVNode.scopeId, parentVNode.slotScopeIds, parentComponent.parent);\r\n            }\r\n        }\r\n    };\r\n    const mountChildren = (children, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, start = 0) => {\r\n        for (let i = start; i < children.length; i++) {\r\n            const child = (children[i] = optimized\r\n                ? cloneIfMounted(children[i])\r\n                : normalizeVNode(children[i]));\r\n            patch(null, child, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n        }\r\n    };\r\n    const patchElement = (n1, n2, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {\r\n        const el = (n2.el = n1.el);\r\n        let { patchFlag, dynamicChildren, dirs } = n2;\r\n        // #1426 take the old vnode's patch flag into account since user may clone a\r\n        // compiler-generated vnode, which de-opts to FULL_PROPS\r\n        patchFlag |= n1.patchFlag & 16 /* FULL_PROPS */;\r\n        const oldProps = n1.props || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;\r\n        const newProps = n2.props || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ;\r\n        let vnodeHook;\r\n        if ((vnodeHook = newProps.onVnodeBeforeUpdate)) {\r\n            invokeVNodeHook(vnodeHook, parentComponent, n2, n1);\r\n        }\r\n        if (dirs) {\r\n            invokeDirectiveHook(n2, n1, parentComponent, 'beforeUpdate');\r\n        }\r\n        if (( true) && isHmrUpdating) {\r\n            // HMR updated, force full diff\r\n            patchFlag = 0;\r\n            optimized = false;\r\n            dynamicChildren = null;\r\n        }\r\n        const areChildrenSVG = isSVG && n2.type !== 'foreignObject';\r\n        if (dynamicChildren) {\r\n            patchBlockChildren(n1.dynamicChildren, dynamicChildren, el, parentComponent, parentSuspense, areChildrenSVG, slotScopeIds);\r\n            if (( true) && parentComponent && parentComponent.type.__hmrId) {\r\n                traverseStaticChildren(n1, n2);\r\n            }\r\n        }\r\n        else if (!optimized) {\r\n            // full diff\r\n            patchChildren(n1, n2, el, null, parentComponent, parentSuspense, areChildrenSVG, slotScopeIds, false);\r\n        }\r\n        if (patchFlag > 0) {\r\n            // the presence of a patchFlag means this element's render code was\r\n            // generated by the compiler and can take the fast path.\r\n            // in this path old node and new node are guaranteed to have the same shape\r\n            // (i.e. at the exact same position in the source template)\r\n            if (patchFlag & 16 /* FULL_PROPS */) {\r\n                // element props contain dynamic keys, full diff needed\r\n                patchProps(el, n2, oldProps, newProps, parentComponent, parentSuspense, isSVG);\r\n            }\r\n            else {\r\n                // class\r\n                // this flag is matched when the element has dynamic class bindings.\r\n                if (patchFlag & 2 /* CLASS */) {\r\n                    if (oldProps.class !== newProps.class) {\r\n                        hostPatchProp(el, 'class', null, newProps.class, isSVG);\r\n                    }\r\n                }\r\n                // style\r\n                // this flag is matched when the element has dynamic style bindings\r\n                if (patchFlag & 4 /* STYLE */) {\r\n                    hostPatchProp(el, 'style', oldProps.style, newProps.style, isSVG);\r\n                }\r\n                // props\r\n                // This flag is matched when the element has dynamic prop/attr bindings\r\n                // other than class and style. The keys of dynamic prop/attrs are saved for\r\n                // faster iteration.\r\n                // Note dynamic keys like :[foo]=\"bar\" will cause this optimization to\r\n                // bail out and go through a full diff because we need to unset the old key\r\n                if (patchFlag & 8 /* PROPS */) {\r\n                    // if the flag is present then dynamicProps must be non-null\r\n                    const propsToUpdate = n2.dynamicProps;\r\n                    for (let i = 0; i < propsToUpdate.length; i++) {\r\n                        const key = propsToUpdate[i];\r\n                        const prev = oldProps[key];\r\n                        const next = newProps[key];\r\n                        // #1471 force patch value\r\n                        if (next !== prev || key === 'value') {\r\n                            hostPatchProp(el, key, prev, next, isSVG, n1.children, parentComponent, parentSuspense, unmountChildren);\r\n                        }\r\n                    }\r\n                }\r\n            }\r\n            // text\r\n            // This flag is matched when the element has only dynamic text children.\r\n            if (patchFlag & 1 /* TEXT */) {\r\n                if (n1.children !== n2.children) {\r\n                    hostSetElementText(el, n2.children);\r\n                }\r\n            }\r\n        }\r\n        else if (!optimized && dynamicChildren == null) {\r\n            // unoptimized, full diff\r\n            patchProps(el, n2, oldProps, newProps, parentComponent, parentSuspense, isSVG);\r\n        }\r\n        if ((vnodeHook = newProps.onVnodeUpdated) || dirs) {\r\n            queuePostRenderEffect(() => {\r\n                vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, n2, n1);\r\n                dirs && invokeDirectiveHook(n2, n1, parentComponent, 'updated');\r\n            }, parentSuspense);\r\n        }\r\n    };\r\n    // The fast path for blocks.\r\n    const patchBlockChildren = (oldChildren, newChildren, fallbackContainer, parentComponent, parentSuspense, isSVG, slotScopeIds) => {\r\n        for (let i = 0; i < newChildren.length; i++) {\r\n            const oldVNode = oldChildren[i];\r\n            const newVNode = newChildren[i];\r\n            // Determine the container (parent element) for the patch.\r\n            const container = \r\n            // oldVNode may be an errored async setup() component inside Suspense\r\n            // which will not have a mounted element\r\n            oldVNode.el &&\r\n                // - In the case of a Fragment, we need to provide the actual parent\r\n                // of the Fragment itself so it can move its children.\r\n                (oldVNode.type === Fragment ||\r\n                    // - In the case of different nodes, there is going to be a replacement\r\n                    // which also requires the correct parent container\r\n                    !isSameVNodeType(oldVNode, newVNode) ||\r\n                    // - In the case of a component, it could contain anything.\r\n                    oldVNode.shapeFlag & (6 /* COMPONENT */ | 64 /* TELEPORT */))\r\n                ? hostParentNode(oldVNode.el)\r\n                : // In other cases, the parent container is not actually used so we\r\n                    // just pass the block element here to avoid a DOM parentNode call.\r\n                    fallbackContainer;\r\n            patch(oldVNode, newVNode, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, true);\r\n        }\r\n    };\r\n    const patchProps = (el, vnode, oldProps, newProps, parentComponent, parentSuspense, isSVG) => {\r\n        if (oldProps !== newProps) {\r\n            for (const key in newProps) {\r\n                // empty string is not valid prop\r\n                if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isReservedProp)(key))\r\n                    continue;\r\n                const next = newProps[key];\r\n                const prev = oldProps[key];\r\n                // defer patching value\r\n                if (next !== prev && key !== 'value') {\r\n                    hostPatchProp(el, key, prev, next, isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);\r\n                }\r\n            }\r\n            if (oldProps !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ) {\r\n                for (const key in oldProps) {\r\n                    if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isReservedProp)(key) && !(key in newProps)) {\r\n                        hostPatchProp(el, key, oldProps[key], null, isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);\r\n                    }\r\n                }\r\n            }\r\n            if ('value' in newProps) {\r\n                hostPatchProp(el, 'value', oldProps.value, newProps.value);\r\n            }\r\n        }\r\n    };\r\n    const processFragment = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {\r\n        const fragmentStartAnchor = (n2.el = n1 ? n1.el : hostCreateText(''));\r\n        const fragmentEndAnchor = (n2.anchor = n1 ? n1.anchor : hostCreateText(''));\r\n        let { patchFlag, dynamicChildren, slotScopeIds: fragmentSlotScopeIds } = n2;\r\n        if (( true) && isHmrUpdating) {\r\n            // HMR updated, force full diff\r\n            patchFlag = 0;\r\n            optimized = false;\r\n            dynamicChildren = null;\r\n        }\r\n        // check if this is a slot fragment with :slotted scope ids\r\n        if (fragmentSlotScopeIds) {\r\n            slotScopeIds = slotScopeIds\r\n                ? slotScopeIds.concat(fragmentSlotScopeIds)\r\n                : fragmentSlotScopeIds;\r\n        }\r\n        if (n1 == null) {\r\n            hostInsert(fragmentStartAnchor, container, anchor);\r\n            hostInsert(fragmentEndAnchor, container, anchor);\r\n            // a fragment can only have array children\r\n            // since they are either generated by the compiler, or implicitly created\r\n            // from arrays.\r\n            mountChildren(n2.children, container, fragmentEndAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n        }\r\n        else {\r\n            if (patchFlag > 0 &&\r\n                patchFlag & 64 /* STABLE_FRAGMENT */ &&\r\n                dynamicChildren &&\r\n                // #2715 the previous fragment could've been a BAILed one as a result\r\n                // of renderSlot() with no valid children\r\n                n1.dynamicChildren) {\r\n                // a stable fragment (template root or <template v-for>) doesn't need to\r\n                // patch children order, but it may contain dynamicChildren.\r\n                patchBlockChildren(n1.dynamicChildren, dynamicChildren, container, parentComponent, parentSuspense, isSVG, slotScopeIds);\r\n                if (( true) && parentComponent && parentComponent.type.__hmrId) {\r\n                    traverseStaticChildren(n1, n2);\r\n                }\r\n                else if (\r\n                // #2080 if the stable fragment has a key, it's a <template v-for> that may\r\n                //  get moved around. Make sure all root level vnodes inherit el.\r\n                // #2134 or if it's a component root, it may also get moved around\r\n                // as the component is being moved.\r\n                n2.key != null ||\r\n                    (parentComponent && n2 === parentComponent.subTree)) {\r\n                    traverseStaticChildren(n1, n2, true /* shallow */);\r\n                }\r\n            }\r\n            else {\r\n                // keyed / unkeyed, or manual fragments.\r\n                // for keyed & unkeyed, since they are compiler generated from v-for,\r\n                // each child is guaranteed to be a block so the fragment will never\r\n                // have dynamicChildren.\r\n                patchChildren(n1, n2, container, fragmentEndAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n            }\r\n        }\r\n    };\r\n    const processComponent = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {\r\n        n2.slotScopeIds = slotScopeIds;\r\n        if (n1 == null) {\r\n            if (n2.shapeFlag & 512 /* COMPONENT_KEPT_ALIVE */) {\r\n                parentComponent.ctx.activate(n2, container, anchor, isSVG, optimized);\r\n            }\r\n            else {\r\n                mountComponent(n2, container, anchor, parentComponent, parentSuspense, isSVG, optimized);\r\n            }\r\n        }\r\n        else {\r\n            updateComponent(n1, n2, optimized);\r\n        }\r\n    };\r\n    const mountComponent = (initialVNode, container, anchor, parentComponent, parentSuspense, isSVG, optimized) => {\r\n        const instance = (initialVNode.component = createComponentInstance(initialVNode, parentComponent, parentSuspense));\r\n        if (( true) && instance.type.__hmrId) {\r\n            registerHMR(instance);\r\n        }\r\n        if ((true)) {\r\n            pushWarningContext(initialVNode);\r\n            startMeasure(instance, `mount`);\r\n        }\r\n        // inject renderer internals for keepAlive\r\n        if (isKeepAlive(initialVNode)) {\r\n            instance.ctx.renderer = internals;\r\n        }\r\n        // resolve props and slots for setup context\r\n        {\r\n            if ((true)) {\r\n                startMeasure(instance, `init`);\r\n            }\r\n            setupComponent(instance);\r\n            if ((true)) {\r\n                endMeasure(instance, `init`);\r\n            }\r\n        }\r\n        // setup() is async. This component relies on async logic to be resolved\r\n        // before proceeding\r\n        if (instance.asyncDep) {\r\n            parentSuspense && parentSuspense.registerDep(instance, setupRenderEffect);\r\n            // Give it a placeholder if this is not hydration\r\n            // TODO handle self-defined fallback\r\n            if (!initialVNode.el) {\r\n                const placeholder = (instance.subTree = createVNode(Comment));\r\n                processCommentNode(null, placeholder, container, anchor);\r\n            }\r\n            return;\r\n        }\r\n        setupRenderEffect(instance, initialVNode, container, anchor, parentSuspense, isSVG, optimized);\r\n        if ((true)) {\r\n            popWarningContext();\r\n            endMeasure(instance, `mount`);\r\n        }\r\n    };\r\n    const updateComponent = (n1, n2, optimized) => {\r\n        const instance = (n2.component = n1.component);\r\n        if (shouldUpdateComponent(n1, n2, optimized)) {\r\n            if (instance.asyncDep &&\r\n                !instance.asyncResolved) {\r\n                // async & still pending - just update props and slots\r\n                // since the component's reactive effect for render isn't set-up yet\r\n                if ((true)) {\r\n                    pushWarningContext(n2);\r\n                }\r\n                updateComponentPreRender(instance, n2, optimized);\r\n                if ((true)) {\r\n                    popWarningContext();\r\n                }\r\n                return;\r\n            }\r\n            else {\r\n                // normal update\r\n                instance.next = n2;\r\n                // in case the child component is also queued, remove it to avoid\r\n                // double updating the same child component in the same flush.\r\n                invalidateJob(instance.update);\r\n                // instance.update is the reactive effect.\r\n                instance.update();\r\n            }\r\n        }\r\n        else {\r\n            // no update needed. just copy over properties\r\n            n2.component = n1.component;\r\n            n2.el = n1.el;\r\n            instance.vnode = n2;\r\n        }\r\n    };\r\n    const setupRenderEffect = (instance, initialVNode, container, anchor, parentSuspense, isSVG, optimized) => {\r\n        const componentUpdateFn = () => {\r\n            if (!instance.isMounted) {\r\n                let vnodeHook;\r\n                const { el, props } = initialVNode;\r\n                const { bm, m, parent } = instance;\r\n                const isAsyncWrapperVNode = isAsyncWrapper(initialVNode);\r\n                effect.allowRecurse = false;\r\n                // beforeMount hook\r\n                if (bm) {\r\n                    (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.invokeArrayFns)(bm);\r\n                }\r\n                // onVnodeBeforeMount\r\n                if (!isAsyncWrapperVNode &&\r\n                    (vnodeHook = props && props.onVnodeBeforeMount)) {\r\n                    invokeVNodeHook(vnodeHook, parent, initialVNode);\r\n                }\r\n                effect.allowRecurse = true;\r\n                if (el && hydrateNode) {\r\n                    // vnode has adopted host node - perform hydration instead of mount.\r\n                    const hydrateSubTree = () => {\r\n                        if ((true)) {\r\n                            startMeasure(instance, `render`);\r\n                        }\r\n                        instance.subTree = renderComponentRoot(instance);\r\n                        if ((true)) {\r\n                            endMeasure(instance, `render`);\r\n                        }\r\n                        if ((true)) {\r\n                            startMeasure(instance, `hydrate`);\r\n                        }\r\n                        hydrateNode(el, instance.subTree, instance, parentSuspense, null);\r\n                        if ((true)) {\r\n                            endMeasure(instance, `hydrate`);\r\n                        }\r\n                    };\r\n                    if (isAsyncWrapperVNode) {\r\n                        initialVNode.type.__asyncLoader().then(\r\n                        // note: we are moving the render call into an async callback,\r\n                        // which means it won't track dependencies - but it's ok because\r\n                        // a server-rendered async wrapper is already in resolved state\r\n                        // and it will never need to change.\r\n                        () => !instance.isUnmounted && hydrateSubTree());\r\n                    }\r\n                    else {\r\n                        hydrateSubTree();\r\n                    }\r\n                }\r\n                else {\r\n                    if ((true)) {\r\n                        startMeasure(instance, `render`);\r\n                    }\r\n                    const subTree = (instance.subTree = renderComponentRoot(instance));\r\n                    if ((true)) {\r\n                        endMeasure(instance, `render`);\r\n                    }\r\n                    if ((true)) {\r\n                        startMeasure(instance, `patch`);\r\n                    }\r\n                    patch(null, subTree, container, anchor, instance, parentSuspense, isSVG);\r\n                    if ((true)) {\r\n                        endMeasure(instance, `patch`);\r\n                    }\r\n                    initialVNode.el = subTree.el;\r\n                }\r\n                // mounted hook\r\n                if (m) {\r\n                    queuePostRenderEffect(m, parentSuspense);\r\n                }\r\n                // onVnodeMounted\r\n                if (!isAsyncWrapperVNode &&\r\n                    (vnodeHook = props && props.onVnodeMounted)) {\r\n                    const scopedInitialVNode = initialVNode;\r\n                    queuePostRenderEffect(() => invokeVNodeHook(vnodeHook, parent, scopedInitialVNode), parentSuspense);\r\n                }\r\n                // activated hook for keep-alive roots.\r\n                // #1742 activated hook must be accessed after first render\r\n                // since the hook may be injected by a child keep-alive\r\n                if (initialVNode.shapeFlag & 256 /* COMPONENT_SHOULD_KEEP_ALIVE */) {\r\n                    instance.a && queuePostRenderEffect(instance.a, parentSuspense);\r\n                }\r\n                instance.isMounted = true;\r\n                if (true) {\r\n                    devtoolsComponentAdded(instance);\r\n                }\r\n                // #2458: deference mount-only object parameters to prevent memleaks\r\n                initialVNode = container = anchor = null;\r\n            }\r\n            else {\r\n                // updateComponent\r\n                // This is triggered by mutation of component's own state (next: null)\r\n                // OR parent calling processComponent (next: VNode)\r\n                let { next, bu, u, parent, vnode } = instance;\r\n                let originNext = next;\r\n                let vnodeHook;\r\n                if ((true)) {\r\n                    pushWarningContext(next || instance.vnode);\r\n                }\r\n                // Disallow component effect recursion during pre-lifecycle hooks.\r\n                effect.allowRecurse = false;\r\n                if (next) {\r\n                    next.el = vnode.el;\r\n                    updateComponentPreRender(instance, next, optimized);\r\n                }\r\n                else {\r\n                    next = vnode;\r\n                }\r\n                // beforeUpdate hook\r\n                if (bu) {\r\n                    (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.invokeArrayFns)(bu);\r\n                }\r\n                // onVnodeBeforeUpdate\r\n                if ((vnodeHook = next.props && next.props.onVnodeBeforeUpdate)) {\r\n                    invokeVNodeHook(vnodeHook, parent, next, vnode);\r\n                }\r\n                effect.allowRecurse = true;\r\n                // render\r\n                if ((true)) {\r\n                    startMeasure(instance, `render`);\r\n                }\r\n                const nextTree = renderComponentRoot(instance);\r\n                if ((true)) {\r\n                    endMeasure(instance, `render`);\r\n                }\r\n                const prevTree = instance.subTree;\r\n                instance.subTree = nextTree;\r\n                if ((true)) {\r\n                    startMeasure(instance, `patch`);\r\n                }\r\n                patch(prevTree, nextTree, \r\n                // parent may have changed if it's in a teleport\r\n                hostParentNode(prevTree.el), \r\n                // anchor may have changed if it's in a fragment\r\n                getNextHostNode(prevTree), instance, parentSuspense, isSVG);\r\n                if ((true)) {\r\n                    endMeasure(instance, `patch`);\r\n                }\r\n                next.el = nextTree.el;\r\n                if (originNext === null) {\r\n                    // self-triggered update. In case of HOC, update parent component\r\n                    // vnode el. HOC is indicated by parent instance's subTree pointing\r\n                    // to child component's vnode\r\n                    updateHOCHostEl(instance, nextTree.el);\r\n                }\r\n                // updated hook\r\n                if (u) {\r\n                    queuePostRenderEffect(u, parentSuspense);\r\n                }\r\n                // onVnodeUpdated\r\n                if ((vnodeHook = next.props && next.props.onVnodeUpdated)) {\r\n                    queuePostRenderEffect(() => invokeVNodeHook(vnodeHook, parent, next, vnode), parentSuspense);\r\n                }\r\n                if (true) {\r\n                    devtoolsComponentUpdated(instance);\r\n                }\r\n                if ((true)) {\r\n                    popWarningContext();\r\n                }\r\n            }\r\n        };\r\n        // create reactive effect for rendering\r\n        const effect = new _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.ReactiveEffect(componentUpdateFn, () => queueJob(instance.update), instance.scope // track it in component's effect scope\r\n        );\r\n        const update = (instance.update = effect.run.bind(effect));\r\n        update.id = instance.uid;\r\n        // allowRecurse\r\n        // #1801, #2043 component render effects should allow recursive updates\r\n        effect.allowRecurse = update.allowRecurse = true;\r\n        if ((true)) {\r\n            effect.onTrack = instance.rtc\r\n                ? e => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.invokeArrayFns)(instance.rtc, e)\r\n                : void 0;\r\n            effect.onTrigger = instance.rtg\r\n                ? e => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.invokeArrayFns)(instance.rtg, e)\r\n                : void 0;\r\n            // @ts-ignore (for scheduler)\r\n            update.ownerInstance = instance;\r\n        }\r\n        update();\r\n    };\r\n    const updateComponentPreRender = (instance, nextVNode, optimized) => {\r\n        nextVNode.component = instance;\r\n        const prevProps = instance.vnode.props;\r\n        instance.vnode = nextVNode;\r\n        instance.next = null;\r\n        updateProps(instance, nextVNode.props, prevProps, optimized);\r\n        updateSlots(instance, nextVNode.children, optimized);\r\n        (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.pauseTracking)();\r\n        // props update may have triggered pre-flush watchers.\r\n        // flush them before the render update.\r\n        flushPreFlushCbs(undefined, instance.update);\r\n        (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.resetTracking)();\r\n    };\r\n    const patchChildren = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized = false) => {\r\n        const c1 = n1 && n1.children;\r\n        const prevShapeFlag = n1 ? n1.shapeFlag : 0;\r\n        const c2 = n2.children;\r\n        const { patchFlag, shapeFlag } = n2;\r\n        // fast path\r\n        if (patchFlag > 0) {\r\n            if (patchFlag & 128 /* KEYED_FRAGMENT */) {\r\n                // this could be either fully-keyed or mixed (some keyed some not)\r\n                // presence of patchFlag means children are guaranteed to be arrays\r\n                patchKeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n                return;\r\n            }\r\n            else if (patchFlag & 256 /* UNKEYED_FRAGMENT */) {\r\n                // unkeyed\r\n                patchUnkeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n                return;\r\n            }\r\n        }\r\n        // children has 3 possibilities: text, array or no children.\r\n        if (shapeFlag & 8 /* TEXT_CHILDREN */) {\r\n            // text children fast path\r\n            if (prevShapeFlag & 16 /* ARRAY_CHILDREN */) {\r\n                unmountChildren(c1, parentComponent, parentSuspense);\r\n            }\r\n            if (c2 !== c1) {\r\n                hostSetElementText(container, c2);\r\n            }\r\n        }\r\n        else {\r\n            if (prevShapeFlag & 16 /* ARRAY_CHILDREN */) {\r\n                // prev children was array\r\n                if (shapeFlag & 16 /* ARRAY_CHILDREN */) {\r\n                    // two arrays, cannot assume anything, do full diff\r\n                    patchKeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n                }\r\n                else {\r\n                    // no new children, just unmount old\r\n                    unmountChildren(c1, parentComponent, parentSuspense, true);\r\n                }\r\n            }\r\n            else {\r\n                // prev children was text OR null\r\n                // new children is array OR null\r\n                if (prevShapeFlag & 8 /* TEXT_CHILDREN */) {\r\n                    hostSetElementText(container, '');\r\n                }\r\n                // mount new if array\r\n                if (shapeFlag & 16 /* ARRAY_CHILDREN */) {\r\n                    mountChildren(c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n                }\r\n            }\r\n        }\r\n    };\r\n    const patchUnkeyedChildren = (c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {\r\n        c1 = c1 || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_ARR;\r\n        c2 = c2 || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_ARR;\r\n        const oldLength = c1.length;\r\n        const newLength = c2.length;\r\n        const commonLength = Math.min(oldLength, newLength);\r\n        let i;\r\n        for (i = 0; i < commonLength; i++) {\r\n            const nextChild = (c2[i] = optimized\r\n                ? cloneIfMounted(c2[i])\r\n                : normalizeVNode(c2[i]));\r\n            patch(c1[i], nextChild, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n        }\r\n        if (oldLength > newLength) {\r\n            // remove old\r\n            unmountChildren(c1, parentComponent, parentSuspense, true, false, commonLength);\r\n        }\r\n        else {\r\n            // mount new\r\n            mountChildren(c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, commonLength);\r\n        }\r\n    };\r\n    // can be all-keyed or mixed\r\n    const patchKeyedChildren = (c1, c2, container, parentAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {\r\n        let i = 0;\r\n        const l2 = c2.length;\r\n        let e1 = c1.length - 1; // prev ending index\r\n        let e2 = l2 - 1; // next ending index\r\n        // 1. sync from start\r\n        // (a b) c\r\n        // (a b) d e\r\n        while (i <= e1 && i <= e2) {\r\n            const n1 = c1[i];\r\n            const n2 = (c2[i] = optimized\r\n                ? cloneIfMounted(c2[i])\r\n                : normalizeVNode(c2[i]));\r\n            if (isSameVNodeType(n1, n2)) {\r\n                patch(n1, n2, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n            }\r\n            else {\r\n                break;\r\n            }\r\n            i++;\r\n        }\r\n        // 2. sync from end\r\n        // a (b c)\r\n        // d e (b c)\r\n        while (i <= e1 && i <= e2) {\r\n            const n1 = c1[e1];\r\n            const n2 = (c2[e2] = optimized\r\n                ? cloneIfMounted(c2[e2])\r\n                : normalizeVNode(c2[e2]));\r\n            if (isSameVNodeType(n1, n2)) {\r\n                patch(n1, n2, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n            }\r\n            else {\r\n                break;\r\n            }\r\n            e1--;\r\n            e2--;\r\n        }\r\n        // 3. common sequence + mount\r\n        // (a b)\r\n        // (a b) c\r\n        // i = 2, e1 = 1, e2 = 2\r\n        // (a b)\r\n        // c (a b)\r\n        // i = 0, e1 = -1, e2 = 0\r\n        if (i > e1) {\r\n            if (i <= e2) {\r\n                const nextPos = e2 + 1;\r\n                const anchor = nextPos < l2 ? c2[nextPos].el : parentAnchor;\r\n                while (i <= e2) {\r\n                    patch(null, (c2[i] = optimized\r\n                        ? cloneIfMounted(c2[i])\r\n                        : normalizeVNode(c2[i])), container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n                    i++;\r\n                }\r\n            }\r\n        }\r\n        // 4. common sequence + unmount\r\n        // (a b) c\r\n        // (a b)\r\n        // i = 2, e1 = 2, e2 = 1\r\n        // a (b c)\r\n        // (b c)\r\n        // i = 0, e1 = 0, e2 = -1\r\n        else if (i > e2) {\r\n            while (i <= e1) {\r\n                unmount(c1[i], parentComponent, parentSuspense, true);\r\n                i++;\r\n            }\r\n        }\r\n        // 5. unknown sequence\r\n        // [i ... e1 + 1]: a b [c d e] f g\r\n        // [i ... e2 + 1]: a b [e d c h] f g\r\n        // i = 2, e1 = 4, e2 = 5\r\n        else {\r\n            const s1 = i; // prev starting index\r\n            const s2 = i; // next starting index\r\n            // 5.1 build key:index map for newChildren\r\n            const keyToNewIndexMap = new Map();\r\n            for (i = s2; i <= e2; i++) {\r\n                const nextChild = (c2[i] = optimized\r\n                    ? cloneIfMounted(c2[i])\r\n                    : normalizeVNode(c2[i]));\r\n                if (nextChild.key != null) {\r\n                    if (( true) && keyToNewIndexMap.has(nextChild.key)) {\r\n                        warn(`Duplicate keys found during update:`, JSON.stringify(nextChild.key), `Make sure keys are unique.`);\r\n                    }\r\n                    keyToNewIndexMap.set(nextChild.key, i);\r\n                }\r\n            }\r\n            // 5.2 loop through old children left to be patched and try to patch\r\n            // matching nodes & remove nodes that are no longer present\r\n            let j;\r\n            let patched = 0;\r\n            const toBePatched = e2 - s2 + 1;\r\n            let moved = false;\r\n            // used to track whether any node has moved\r\n            let maxNewIndexSoFar = 0;\r\n            // works as Map<newIndex, oldIndex>\r\n            // Note that oldIndex is offset by +1\r\n            // and oldIndex = 0 is a special value indicating the new node has\r\n            // no corresponding old node.\r\n            // used for determining longest stable subsequence\r\n            const newIndexToOldIndexMap = new Array(toBePatched);\r\n            for (i = 0; i < toBePatched; i++)\r\n                newIndexToOldIndexMap[i] = 0;\r\n            for (i = s1; i <= e1; i++) {\r\n                const prevChild = c1[i];\r\n                if (patched >= toBePatched) {\r\n                    // all new children have been patched so this can only be a removal\r\n                    unmount(prevChild, parentComponent, parentSuspense, true);\r\n                    continue;\r\n                }\r\n                let newIndex;\r\n                if (prevChild.key != null) {\r\n                    newIndex = keyToNewIndexMap.get(prevChild.key);\r\n                }\r\n                else {\r\n                    // key-less node, try to locate a key-less node of the same type\r\n                    for (j = s2; j <= e2; j++) {\r\n                        if (newIndexToOldIndexMap[j - s2] === 0 &&\r\n                            isSameVNodeType(prevChild, c2[j])) {\r\n                            newIndex = j;\r\n                            break;\r\n                        }\r\n                    }\r\n                }\r\n                if (newIndex === undefined) {\r\n                    unmount(prevChild, parentComponent, parentSuspense, true);\r\n                }\r\n                else {\r\n                    newIndexToOldIndexMap[newIndex - s2] = i + 1;\r\n                    if (newIndex >= maxNewIndexSoFar) {\r\n                        maxNewIndexSoFar = newIndex;\r\n                    }\r\n                    else {\r\n                        moved = true;\r\n                    }\r\n                    patch(prevChild, c2[newIndex], container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n                    patched++;\r\n                }\r\n            }\r\n            // 5.3 move and mount\r\n            // generate longest stable subsequence only when nodes have moved\r\n            const increasingNewIndexSequence = moved\r\n                ? getSequence(newIndexToOldIndexMap)\r\n                : _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_ARR;\r\n            j = increasingNewIndexSequence.length - 1;\r\n            // looping backwards so that we can use last patched node as anchor\r\n            for (i = toBePatched - 1; i >= 0; i--) {\r\n                const nextIndex = s2 + i;\r\n                const nextChild = c2[nextIndex];\r\n                const anchor = nextIndex + 1 < l2 ? c2[nextIndex + 1].el : parentAnchor;\r\n                if (newIndexToOldIndexMap[i] === 0) {\r\n                    // mount new\r\n                    patch(null, nextChild, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n                }\r\n                else if (moved) {\r\n                    // move if:\r\n                    // There is no stable subsequence (e.g. a reverse)\r\n                    // OR current node is not among the stable sequence\r\n                    if (j < 0 || i !== increasingNewIndexSequence[j]) {\r\n                        move(nextChild, container, anchor, 2 /* REORDER */);\r\n                    }\r\n                    else {\r\n                        j--;\r\n                    }\r\n                }\r\n            }\r\n        }\r\n    };\r\n    const move = (vnode, container, anchor, moveType, parentSuspense = null) => {\r\n        const { el, type, transition, children, shapeFlag } = vnode;\r\n        if (shapeFlag & 6 /* COMPONENT */) {\r\n            move(vnode.component.subTree, container, anchor, moveType);\r\n            return;\r\n        }\r\n        if (shapeFlag & 128 /* SUSPENSE */) {\r\n            vnode.suspense.move(container, anchor, moveType);\r\n            return;\r\n        }\r\n        if (shapeFlag & 64 /* TELEPORT */) {\r\n            type.move(vnode, container, anchor, internals);\r\n            return;\r\n        }\r\n        if (type === Fragment) {\r\n            hostInsert(el, container, anchor);\r\n            for (let i = 0; i < children.length; i++) {\r\n                move(children[i], container, anchor, moveType);\r\n            }\r\n            hostInsert(vnode.anchor, container, anchor);\r\n            return;\r\n        }\r\n        if (type === Static) {\r\n            moveStaticNode(vnode, container, anchor);\r\n            return;\r\n        }\r\n        // single nodes\r\n        const needTransition = moveType !== 2 /* REORDER */ &&\r\n            shapeFlag & 1 /* ELEMENT */ &&\r\n            transition;\r\n        if (needTransition) {\r\n            if (moveType === 0 /* ENTER */) {\r\n                transition.beforeEnter(el);\r\n                hostInsert(el, container, anchor);\r\n                queuePostRenderEffect(() => transition.enter(el), parentSuspense);\r\n            }\r\n            else {\r\n                const { leave, delayLeave, afterLeave } = transition;\r\n                const remove = () => hostInsert(el, container, anchor);\r\n                const performLeave = () => {\r\n                    leave(el, () => {\r\n                        remove();\r\n                        afterLeave && afterLeave();\r\n                    });\r\n                };\r\n                if (delayLeave) {\r\n                    delayLeave(el, remove, performLeave);\r\n                }\r\n                else {\r\n                    performLeave();\r\n                }\r\n            }\r\n        }\r\n        else {\r\n            hostInsert(el, container, anchor);\r\n        }\r\n    };\r\n    const unmount = (vnode, parentComponent, parentSuspense, doRemove = false, optimized = false) => {\r\n        const { type, props, ref, children, dynamicChildren, shapeFlag, patchFlag, dirs } = vnode;\r\n        // unset ref\r\n        if (ref != null) {\r\n            setRef(ref, null, parentSuspense, vnode, true);\r\n        }\r\n        if (shapeFlag & 256 /* COMPONENT_SHOULD_KEEP_ALIVE */) {\r\n            parentComponent.ctx.deactivate(vnode);\r\n            return;\r\n        }\r\n        const shouldInvokeDirs = shapeFlag & 1 /* ELEMENT */ && dirs;\r\n        const shouldInvokeVnodeHook = !isAsyncWrapper(vnode);\r\n        let vnodeHook;\r\n        if (shouldInvokeVnodeHook &&\r\n            (vnodeHook = props && props.onVnodeBeforeUnmount)) {\r\n            invokeVNodeHook(vnodeHook, parentComponent, vnode);\r\n        }\r\n        if (shapeFlag & 6 /* COMPONENT */) {\r\n            unmountComponent(vnode.component, parentSuspense, doRemove);\r\n        }\r\n        else {\r\n            if (shapeFlag & 128 /* SUSPENSE */) {\r\n                vnode.suspense.unmount(parentSuspense, doRemove);\r\n                return;\r\n            }\r\n            if (shouldInvokeDirs) {\r\n                invokeDirectiveHook(vnode, null, parentComponent, 'beforeUnmount');\r\n            }\r\n            if (shapeFlag & 64 /* TELEPORT */) {\r\n                vnode.type.remove(vnode, parentComponent, parentSuspense, optimized, internals, doRemove);\r\n            }\r\n            else if (dynamicChildren &&\r\n                // #1153: fast path should not be taken for non-stable (v-for) fragments\r\n                (type !== Fragment ||\r\n                    (patchFlag > 0 && patchFlag & 64 /* STABLE_FRAGMENT */))) {\r\n                // fast path for block nodes: only need to unmount dynamic children.\r\n                unmountChildren(dynamicChildren, parentComponent, parentSuspense, false, true);\r\n            }\r\n            else if ((type === Fragment &&\r\n                patchFlag &\r\n                    (128 /* KEYED_FRAGMENT */ | 256 /* UNKEYED_FRAGMENT */)) ||\r\n                (!optimized && shapeFlag & 16 /* ARRAY_CHILDREN */)) {\r\n                unmountChildren(children, parentComponent, parentSuspense);\r\n            }\r\n            if (doRemove) {\r\n                remove(vnode);\r\n            }\r\n        }\r\n        if ((shouldInvokeVnodeHook &&\r\n            (vnodeHook = props && props.onVnodeUnmounted)) ||\r\n            shouldInvokeDirs) {\r\n            queuePostRenderEffect(() => {\r\n                vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);\r\n                shouldInvokeDirs &&\r\n                    invokeDirectiveHook(vnode, null, parentComponent, 'unmounted');\r\n            }, parentSuspense);\r\n        }\r\n    };\r\n    const remove = vnode => {\r\n        const { type, el, anchor, transition } = vnode;\r\n        if (type === Fragment) {\r\n            removeFragment(el, anchor);\r\n            return;\r\n        }\r\n        if (type === Static) {\r\n            removeStaticNode(vnode);\r\n            return;\r\n        }\r\n        const performRemove = () => {\r\n            hostRemove(el);\r\n            if (transition && !transition.persisted && transition.afterLeave) {\r\n                transition.afterLeave();\r\n            }\r\n        };\r\n        if (vnode.shapeFlag & 1 /* ELEMENT */ &&\r\n            transition &&\r\n            !transition.persisted) {\r\n            const { leave, delayLeave } = transition;\r\n            const performLeave = () => leave(el, performRemove);\r\n            if (delayLeave) {\r\n                delayLeave(vnode.el, performRemove, performLeave);\r\n            }\r\n            else {\r\n                performLeave();\r\n            }\r\n        }\r\n        else {\r\n            performRemove();\r\n        }\r\n    };\r\n    const removeFragment = (cur, end) => {\r\n        // For fragments, directly remove all contained DOM nodes.\r\n        // (fragment child nodes cannot have transition)\r\n        let next;\r\n        while (cur !== end) {\r\n            next = hostNextSibling(cur);\r\n            hostRemove(cur);\r\n            cur = next;\r\n        }\r\n        hostRemove(end);\r\n    };\r\n    const unmountComponent = (instance, parentSuspense, doRemove) => {\r\n        if (( true) && instance.type.__hmrId) {\r\n            unregisterHMR(instance);\r\n        }\r\n        const { bum, scope, update, subTree, um } = instance;\r\n        // beforeUnmount hook\r\n        if (bum) {\r\n            (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.invokeArrayFns)(bum);\r\n        }\r\n        // stop effects in component scope\r\n        scope.stop();\r\n        // update may be null if a component is unmounted before its async\r\n        // setup has resolved.\r\n        if (update) {\r\n            // so that scheduler will no longer invoke it\r\n            update.active = false;\r\n            unmount(subTree, instance, parentSuspense, doRemove);\r\n        }\r\n        // unmounted hook\r\n        if (um) {\r\n            queuePostRenderEffect(um, parentSuspense);\r\n        }\r\n        queuePostRenderEffect(() => {\r\n            instance.isUnmounted = true;\r\n        }, parentSuspense);\r\n        // A component with async dep inside a pending suspense is unmounted before\r\n        // its async dep resolves. This should remove the dep from the suspense, and\r\n        // cause the suspense to resolve immediately if that was the last dep.\r\n        if (parentSuspense &&\r\n            parentSuspense.pendingBranch &&\r\n            !parentSuspense.isUnmounted &&\r\n            instance.asyncDep &&\r\n            !instance.asyncResolved &&\r\n            instance.suspenseId === parentSuspense.pendingId) {\r\n            parentSuspense.deps--;\r\n            if (parentSuspense.deps === 0) {\r\n                parentSuspense.resolve();\r\n            }\r\n        }\r\n        if (true) {\r\n            devtoolsComponentRemoved(instance);\r\n        }\r\n    };\r\n    const unmountChildren = (children, parentComponent, parentSuspense, doRemove = false, optimized = false, start = 0) => {\r\n        for (let i = start; i < children.length; i++) {\r\n            unmount(children[i], parentComponent, parentSuspense, doRemove, optimized);\r\n        }\r\n    };\r\n    const getNextHostNode = vnode => {\r\n        if (vnode.shapeFlag & 6 /* COMPONENT */) {\r\n            return getNextHostNode(vnode.component.subTree);\r\n        }\r\n        if (vnode.shapeFlag & 128 /* SUSPENSE */) {\r\n            return vnode.suspense.next();\r\n        }\r\n        return hostNextSibling((vnode.anchor || vnode.el));\r\n    };\r\n    const render = (vnode, container, isSVG) => {\r\n        if (vnode == null) {\r\n            if (container._vnode) {\r\n                unmount(container._vnode, null, null, true);\r\n            }\r\n        }\r\n        else {\r\n            patch(container._vnode || null, vnode, container, null, null, null, isSVG);\r\n        }\r\n        flushPostFlushCbs();\r\n        container._vnode = vnode;\r\n    };\r\n    const internals = {\r\n        p: patch,\r\n        um: unmount,\r\n        m: move,\r\n        r: remove,\r\n        mt: mountComponent,\r\n        mc: mountChildren,\r\n        pc: patchChildren,\r\n        pbc: patchBlockChildren,\r\n        n: getNextHostNode,\r\n        o: options\r\n    };\r\n    let hydrate;\r\n    let hydrateNode;\r\n    if (createHydrationFns) {\r\n        [hydrate, hydrateNode] = createHydrationFns(internals);\r\n    }\r\n    return {\r\n        render,\r\n        hydrate,\r\n        createApp: createAppAPI(render, hydrate)\r\n    };\r\n}\r\nfunction setRef(rawRef, oldRawRef, parentSuspense, vnode, isUnmount = false) {\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(rawRef)) {\r\n        rawRef.forEach((r, i) => setRef(r, oldRawRef && ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(oldRawRef) ? oldRawRef[i] : oldRawRef), parentSuspense, vnode, isUnmount));\r\n        return;\r\n    }\r\n    if (isAsyncWrapper(vnode) && !isUnmount) {\r\n        // when mounting async components, nothing needs to be done,\r\n        // because the template ref is forwarded to inner component\r\n        return;\r\n    }\r\n    const refValue = vnode.shapeFlag & 4 /* STATEFUL_COMPONENT */\r\n        ? getExposeProxy(vnode.component) || vnode.component.proxy\r\n        : vnode.el;\r\n    const value = isUnmount ? null : refValue;\r\n    const { i: owner, r: ref } = rawRef;\r\n    if (( true) && !owner) {\r\n        warn(`Missing ref owner context. ref cannot be used on hoisted vnodes. ` +\r\n            `A vnode with ref must be created inside the render function.`);\r\n        return;\r\n    }\r\n    const oldRef = oldRawRef && oldRawRef.r;\r\n    const refs = owner.refs === _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ ? (owner.refs = {}) : owner.refs;\r\n    const setupState = owner.setupState;\r\n    // dynamic ref changed. unset old ref\r\n    if (oldRef != null && oldRef !== ref) {\r\n        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(oldRef)) {\r\n            refs[oldRef] = null;\r\n            if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(setupState, oldRef)) {\r\n                setupState[oldRef] = null;\r\n            }\r\n        }\r\n        else if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(oldRef)) {\r\n            oldRef.value = null;\r\n        }\r\n    }\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(ref)) {\r\n        const doSet = () => {\r\n            {\r\n                refs[ref] = value;\r\n            }\r\n            if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(setupState, ref)) {\r\n                setupState[ref] = value;\r\n            }\r\n        };\r\n        // #1789: for non-null values, set them after render\r\n        // null values means this is unmount and it should not overwrite another\r\n        // ref with the same key\r\n        if (value) {\r\n            doSet.id = -1;\r\n            queuePostRenderEffect(doSet, parentSuspense);\r\n        }\r\n        else {\r\n            doSet();\r\n        }\r\n    }\r\n    else if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(ref)) {\r\n        const doSet = () => {\r\n            ref.value = value;\r\n        };\r\n        if (value) {\r\n            doSet.id = -1;\r\n            queuePostRenderEffect(doSet, parentSuspense);\r\n        }\r\n        else {\r\n            doSet();\r\n        }\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(ref)) {\r\n        callWithErrorHandling(ref, owner, 12 /* FUNCTION_REF */, [value, refs]);\r\n    }\r\n    else if ((true)) {\r\n        warn('Invalid template ref type:', value, `(${typeof value})`);\r\n    }\r\n}\r\nfunction invokeVNodeHook(hook, instance, vnode, prevVNode = null) {\r\n    callWithAsyncErrorHandling(hook, instance, 7 /* VNODE_HOOK */, [\r\n        vnode,\r\n        prevVNode\r\n    ]);\r\n}\r\n/**\r\n * #1156\r\n * When a component is HMR-enabled, we need to make sure that all static nodes\r\n * inside a block also inherit the DOM element from the previous tree so that\r\n * HMR updates (which are full updates) can retrieve the element for patching.\r\n *\r\n * #2080\r\n * Inside keyed `template` fragment static children, if a fragment is moved,\r\n * the children will always be moved. Therefore, in order to ensure correct move\r\n * position, el should be inherited from previous nodes.\r\n */\r\nfunction traverseStaticChildren(n1, n2, shallow = false) {\r\n    const ch1 = n1.children;\r\n    const ch2 = n2.children;\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(ch1) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(ch2)) {\r\n        for (let i = 0; i < ch1.length; i++) {\r\n            // this is only called in the optimized path so array children are\r\n            // guaranteed to be vnodes\r\n            const c1 = ch1[i];\r\n            let c2 = ch2[i];\r\n            if (c2.shapeFlag & 1 /* ELEMENT */ && !c2.dynamicChildren) {\r\n                if (c2.patchFlag <= 0 || c2.patchFlag === 32 /* HYDRATE_EVENTS */) {\r\n                    c2 = ch2[i] = cloneIfMounted(ch2[i]);\r\n                    c2.el = c1.el;\r\n                }\r\n                if (!shallow)\r\n                    traverseStaticChildren(c1, c2);\r\n            }\r\n            // also inherit for comment nodes, but not placeholders (e.g. v-if which\r\n            // would have received .el during block patch)\r\n            if (( true) && c2.type === Comment && !c2.el) {\r\n                c2.el = c1.el;\r\n            }\r\n        }\r\n    }\r\n}\r\n// https://en.wikipedia.org/wiki/Longest_increasing_subsequence\r\nfunction getSequence(arr) {\r\n    const p = arr.slice();\r\n    const result = [0];\r\n    let i, j, u, v, c;\r\n    const len = arr.length;\r\n    for (i = 0; i < len; i++) {\r\n        const arrI = arr[i];\r\n        if (arrI !== 0) {\r\n            j = result[result.length - 1];\r\n            if (arr[j] < arrI) {\r\n                p[i] = j;\r\n                result.push(i);\r\n                continue;\r\n            }\r\n            u = 0;\r\n            v = result.length - 1;\r\n            while (u < v) {\r\n                c = (u + v) >> 1;\r\n                if (arr[result[c]] < arrI) {\r\n                    u = c + 1;\r\n                }\r\n                else {\r\n                    v = c;\r\n                }\r\n            }\r\n            if (arrI < arr[result[u]]) {\r\n                if (u > 0) {\r\n                    p[i] = result[u - 1];\r\n                }\r\n                result[u] = i;\r\n            }\r\n        }\r\n    }\r\n    u = result.length;\r\n    v = result[u - 1];\r\n    while (u-- > 0) {\r\n        result[u] = v;\r\n        v = p[v];\r\n    }\r\n    return result;\r\n}\n\nconst isTeleport = (type) => type.__isTeleport;\r\nconst isTeleportDisabled = (props) => props && (props.disabled || props.disabled === '');\r\nconst isTargetSVG = (target) => typeof SVGElement !== 'undefined' && target instanceof SVGElement;\r\nconst resolveTarget = (props, select) => {\r\n    const targetSelector = props && props.to;\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(targetSelector)) {\r\n        if (!select) {\r\n            ( true) &&\r\n                warn(`Current renderer does not support string target for Teleports. ` +\r\n                    `(missing querySelector renderer option)`);\r\n            return null;\r\n        }\r\n        else {\r\n            const target = select(targetSelector);\r\n            if (!target) {\r\n                ( true) &&\r\n                    warn(`Failed to locate Teleport target with selector \"${targetSelector}\". ` +\r\n                        `Note the target element must exist before the component is mounted - ` +\r\n                        `i.e. the target cannot be rendered by the component itself, and ` +\r\n                        `ideally should be outside of the entire Vue component tree.`);\r\n            }\r\n            return target;\r\n        }\r\n    }\r\n    else {\r\n        if (( true) && !targetSelector && !isTeleportDisabled(props)) {\r\n            warn(`Invalid Teleport target: ${targetSelector}`);\r\n        }\r\n        return targetSelector;\r\n    }\r\n};\r\nconst TeleportImpl = {\r\n    __isTeleport: true,\r\n    process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals) {\r\n        const { mc: mountChildren, pc: patchChildren, pbc: patchBlockChildren, o: { insert, querySelector, createText, createComment } } = internals;\r\n        const disabled = isTeleportDisabled(n2.props);\r\n        let { shapeFlag, children, dynamicChildren } = n2;\r\n        // #3302\r\n        // HMR updated, force full diff\r\n        if (( true) && isHmrUpdating) {\r\n            optimized = false;\r\n            dynamicChildren = null;\r\n        }\r\n        if (n1 == null) {\r\n            // insert anchors in the main view\r\n            const placeholder = (n2.el = ( true)\r\n                ? createComment('teleport start')\r\n                : 0);\r\n            const mainAnchor = (n2.anchor = ( true)\r\n                ? createComment('teleport end')\r\n                : 0);\r\n            insert(placeholder, container, anchor);\r\n            insert(mainAnchor, container, anchor);\r\n            const target = (n2.target = resolveTarget(n2.props, querySelector));\r\n            const targetAnchor = (n2.targetAnchor = createText(''));\r\n            if (target) {\r\n                insert(targetAnchor, target);\r\n                // #2652 we could be teleporting from a non-SVG tree into an SVG tree\r\n                isSVG = isSVG || isTargetSVG(target);\r\n            }\r\n            else if (( true) && !disabled) {\r\n                warn('Invalid Teleport target on mount:', target, `(${typeof target})`);\r\n            }\r\n            const mount = (container, anchor) => {\r\n                // Teleport *always* has Array children. This is enforced in both the\r\n                // compiler and vnode children normalization.\r\n                if (shapeFlag & 16 /* ARRAY_CHILDREN */) {\r\n                    mountChildren(children, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);\r\n                }\r\n            };\r\n            if (disabled) {\r\n                mount(container, mainAnchor);\r\n            }\r\n            else if (target) {\r\n                mount(target, targetAnchor);\r\n            }\r\n        }\r\n        else {\r\n            // update content\r\n            n2.el = n1.el;\r\n            const mainAnchor = (n2.anchor = n1.anchor);\r\n            const target = (n2.target = n1.target);\r\n            const targetAnchor = (n2.targetAnchor = n1.targetAnchor);\r\n            const wasDisabled = isTeleportDisabled(n1.props);\r\n            const currentContainer = wasDisabled ? container : target;\r\n            const currentAnchor = wasDisabled ? mainAnchor : targetAnchor;\r\n            isSVG = isSVG || isTargetSVG(target);\r\n            if (dynamicChildren) {\r\n                // fast path when the teleport happens to be a block root\r\n                patchBlockChildren(n1.dynamicChildren, dynamicChildren, currentContainer, parentComponent, parentSuspense, isSVG, slotScopeIds);\r\n                // even in block tree mode we need to make sure all root-level nodes\r\n                // in the teleport inherit previous DOM references so that they can\r\n                // be moved in future patches.\r\n                traverseStaticChildren(n1, n2, true);\r\n            }\r\n            else if (!optimized) {\r\n                patchChildren(n1, n2, currentContainer, currentAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, false);\r\n            }\r\n            if (disabled) {\r\n                if (!wasDisabled) {\r\n                    // enabled -> disabled\r\n                    // move into main container\r\n                    moveTeleport(n2, container, mainAnchor, internals, 1 /* TOGGLE */);\r\n                }\r\n            }\r\n            else {\r\n                // target changed\r\n                if ((n2.props && n2.props.to) !== (n1.props && n1.props.to)) {\r\n                    const nextTarget = (n2.target = resolveTarget(n2.props, querySelector));\r\n                    if (nextTarget) {\r\n                        moveTeleport(n2, nextTarget, null, internals, 0 /* TARGET_CHANGE */);\r\n                    }\r\n                    else if ((true)) {\r\n                        warn('Invalid Teleport target on update:', target, `(${typeof target})`);\r\n                    }\r\n                }\r\n                else if (wasDisabled) {\r\n                    // disabled -> enabled\r\n                    // move into teleport target\r\n                    moveTeleport(n2, target, targetAnchor, internals, 1 /* TOGGLE */);\r\n                }\r\n            }\r\n        }\r\n    },\r\n    remove(vnode, parentComponent, parentSuspense, optimized, { um: unmount, o: { remove: hostRemove } }, doRemove) {\r\n        const { shapeFlag, children, anchor, targetAnchor, target, props } = vnode;\r\n        if (target) {\r\n            hostRemove(targetAnchor);\r\n        }\r\n        // an unmounted teleport should always remove its children if not disabled\r\n        if (doRemove || !isTeleportDisabled(props)) {\r\n            hostRemove(anchor);\r\n            if (shapeFlag & 16 /* ARRAY_CHILDREN */) {\r\n                for (let i = 0; i < children.length; i++) {\r\n                    const child = children[i];\r\n                    unmount(child, parentComponent, parentSuspense, true, !!child.dynamicChildren);\r\n                }\r\n            }\r\n        }\r\n    },\r\n    move: moveTeleport,\r\n    hydrate: hydrateTeleport\r\n};\r\nfunction moveTeleport(vnode, container, parentAnchor, { o: { insert }, m: move }, moveType = 2 /* REORDER */) {\r\n    // move target anchor if this is a target change.\r\n    if (moveType === 0 /* TARGET_CHANGE */) {\r\n        insert(vnode.targetAnchor, container, parentAnchor);\r\n    }\r\n    const { el, anchor, shapeFlag, children, props } = vnode;\r\n    const isReorder = moveType === 2 /* REORDER */;\r\n    // move main view anchor if this is a re-order.\r\n    if (isReorder) {\r\n        insert(el, container, parentAnchor);\r\n    }\r\n    // if this is a re-order and teleport is enabled (content is in target)\r\n    // do not move children. So the opposite is: only move children if this\r\n    // is not a reorder, or the teleport is disabled\r\n    if (!isReorder || isTeleportDisabled(props)) {\r\n        // Teleport has either Array children or no children.\r\n        if (shapeFlag & 16 /* ARRAY_CHILDREN */) {\r\n            for (let i = 0; i < children.length; i++) {\r\n                move(children[i], container, parentAnchor, 2 /* REORDER */);\r\n            }\r\n        }\r\n    }\r\n    // move main view anchor if this is a re-order.\r\n    if (isReorder) {\r\n        insert(anchor, container, parentAnchor);\r\n    }\r\n}\r\nfunction hydrateTeleport(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized, { o: { nextSibling, parentNode, querySelector } }, hydrateChildren) {\r\n    const target = (vnode.target = resolveTarget(vnode.props, querySelector));\r\n    if (target) {\r\n        // if multiple teleports rendered to the same target element, we need to\r\n        // pick up from where the last teleport finished instead of the first node\r\n        const targetNode = target._lpa || target.firstChild;\r\n        if (vnode.shapeFlag & 16 /* ARRAY_CHILDREN */) {\r\n            if (isTeleportDisabled(vnode.props)) {\r\n                vnode.anchor = hydrateChildren(nextSibling(node), vnode, parentNode(node), parentComponent, parentSuspense, slotScopeIds, optimized);\r\n                vnode.targetAnchor = targetNode;\r\n            }\r\n            else {\r\n                vnode.anchor = nextSibling(node);\r\n                vnode.targetAnchor = hydrateChildren(targetNode, vnode, target, parentComponent, parentSuspense, slotScopeIds, optimized);\r\n            }\r\n            target._lpa =\r\n                vnode.targetAnchor && nextSibling(vnode.targetAnchor);\r\n        }\r\n    }\r\n    return vnode.anchor && nextSibling(vnode.anchor);\r\n}\r\n// Force-casted public typing for h and TSX props inference\r\nconst Teleport = TeleportImpl;\n\nconst COMPONENTS = 'components';\r\nconst DIRECTIVES = 'directives';\r\n/**\r\n * @private\r\n */\r\nfunction resolveComponent(name, maybeSelfReference) {\r\n    return resolveAsset(COMPONENTS, name, true, maybeSelfReference) || name;\r\n}\r\nconst NULL_DYNAMIC_COMPONENT = Symbol();\r\n/**\r\n * @private\r\n */\r\nfunction resolveDynamicComponent(component) {\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(component)) {\r\n        return resolveAsset(COMPONENTS, component, false) || component;\r\n    }\r\n    else {\r\n        // invalid types will fallthrough to createVNode and raise warning\r\n        return (component || NULL_DYNAMIC_COMPONENT);\r\n    }\r\n}\r\n/**\r\n * @private\r\n */\r\nfunction resolveDirective(name) {\r\n    return resolveAsset(DIRECTIVES, name);\r\n}\r\n// implementation\r\nfunction resolveAsset(type, name, warnMissing = true, maybeSelfReference = false) {\r\n    const instance = currentRenderingInstance || currentInstance;\r\n    if (instance) {\r\n        const Component = instance.type;\r\n        // explicit self name has highest priority\r\n        if (type === COMPONENTS) {\r\n            const selfName = getComponentName(Component);\r\n            if (selfName &&\r\n                (selfName === name ||\r\n                    selfName === (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(name) ||\r\n                    selfName === (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.capitalize)((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(name)))) {\r\n                return Component;\r\n            }\r\n        }\r\n        const res = \r\n        // local registration\r\n        // check instance[type] first which is resolved for options API\r\n        resolve(instance[type] || Component[type], name) ||\r\n            // global registration\r\n            resolve(instance.appContext[type], name);\r\n        if (!res && maybeSelfReference) {\r\n            // fallback to implicit self-reference\r\n            return Component;\r\n        }\r\n        if (( true) && warnMissing && !res) {\r\n            const extra = type === COMPONENTS\r\n                ? `\\nIf this is a native custom element, make sure to exclude it from ` +\r\n                    `component resolution via compilerOptions.isCustomElement.`\r\n                : ``;\r\n            warn(`Failed to resolve ${type.slice(0, -1)}: ${name}${extra}`);\r\n        }\r\n        return res;\r\n    }\r\n    else if ((true)) {\r\n        warn(`resolve${(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.capitalize)(type.slice(0, -1))} ` +\r\n            `can only be used in render() or setup().`);\r\n    }\r\n}\r\nfunction resolve(registry, name) {\r\n    return (registry &&\r\n        (registry[name] ||\r\n            registry[(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(name)] ||\r\n            registry[(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.capitalize)((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.camelize)(name))]));\r\n}\n\nconst Fragment = Symbol(( true) ? 'Fragment' : 0);\r\nconst Text = Symbol(( true) ? 'Text' : 0);\r\nconst Comment = Symbol(( true) ? 'Comment' : 0);\r\nconst Static = Symbol(( true) ? 'Static' : 0);\r\n// Since v-if and v-for are the two possible ways node structure can dynamically\r\n// change, once we consider v-if branches and each v-for fragment a block, we\r\n// can divide a template into nested blocks, and within each block the node\r\n// structure would be stable. This allows us to skip most children diffing\r\n// and only worry about the dynamic nodes (indicated by patch flags).\r\nconst blockStack = [];\r\nlet currentBlock = null;\r\n/**\r\n * Open a block.\r\n * This must be called before `createBlock`. It cannot be part of `createBlock`\r\n * because the children of the block are evaluated before `createBlock` itself\r\n * is called. The generated code typically looks like this:\r\n *\r\n * ```js\r\n * function render() {\r\n *   return (openBlock(),createBlock('div', null, [...]))\r\n * }\r\n * ```\r\n * disableTracking is true when creating a v-for fragment block, since a v-for\r\n * fragment always diffs its children.\r\n *\r\n * @private\r\n */\r\nfunction openBlock(disableTracking = false) {\r\n    blockStack.push((currentBlock = disableTracking ? null : []));\r\n}\r\nfunction closeBlock() {\r\n    blockStack.pop();\r\n    currentBlock = blockStack[blockStack.length - 1] || null;\r\n}\r\n// Whether we should be tracking dynamic child nodes inside a block.\r\n// Only tracks when this value is > 0\r\n// We are not using a simple boolean because this value may need to be\r\n// incremented/decremented by nested usage of v-once (see below)\r\nlet isBlockTreeEnabled = 1;\r\n/**\r\n * Block tracking sometimes needs to be disabled, for example during the\r\n * creation of a tree that needs to be cached by v-once. The compiler generates\r\n * code like this:\r\n *\r\n * ``` js\r\n * _cache[1] || (\r\n *   setBlockTracking(-1),\r\n *   _cache[1] = createVNode(...),\r\n *   setBlockTracking(1),\r\n *   _cache[1]\r\n * )\r\n * ```\r\n *\r\n * @private\r\n */\r\nfunction setBlockTracking(value) {\r\n    isBlockTreeEnabled += value;\r\n}\r\nfunction setupBlock(vnode) {\r\n    // save current block children on the block vnode\r\n    vnode.dynamicChildren =\r\n        isBlockTreeEnabled > 0 ? currentBlock || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_ARR : null;\r\n    // close block\r\n    closeBlock();\r\n    // a block is always going to be patched, so track it as a child of its\r\n    // parent block\r\n    if (isBlockTreeEnabled > 0 && currentBlock) {\r\n        currentBlock.push(vnode);\r\n    }\r\n    return vnode;\r\n}\r\n/**\r\n * @private\r\n */\r\nfunction createElementBlock(type, props, children, patchFlag, dynamicProps, shapeFlag) {\r\n    return setupBlock(createBaseVNode(type, props, children, patchFlag, dynamicProps, shapeFlag, true /* isBlock */));\r\n}\r\n/**\r\n * Create a block root vnode. Takes the same exact arguments as `createVNode`.\r\n * A block root keeps track of dynamic nodes within the block in the\r\n * `dynamicChildren` array.\r\n *\r\n * @private\r\n */\r\nfunction createBlock(type, props, children, patchFlag, dynamicProps) {\r\n    return setupBlock(createVNode(type, props, children, patchFlag, dynamicProps, true /* isBlock: prevent a block from tracking itself */));\r\n}\r\nfunction isVNode(value) {\r\n    return value ? value.__v_isVNode === true : false;\r\n}\r\nfunction isSameVNodeType(n1, n2) {\r\n    if (( true) &&\r\n        n2.shapeFlag & 6 /* COMPONENT */ &&\r\n        hmrDirtyComponents.has(n2.type)) {\r\n        // HMR only: if the component has been hot-updated, force a reload.\r\n        return false;\r\n    }\r\n    return n1.type === n2.type && n1.key === n2.key;\r\n}\r\nlet vnodeArgsTransformer;\r\n/**\r\n * Internal API for registering an arguments transform for createVNode\r\n * used for creating stubs in the test-utils\r\n * It is *internal* but needs to be exposed for test-utils to pick up proper\r\n * typings\r\n */\r\nfunction transformVNodeArgs(transformer) {\r\n    vnodeArgsTransformer = transformer;\r\n}\r\nconst createVNodeWithArgsTransform = (...args) => {\r\n    return _createVNode(...(vnodeArgsTransformer\r\n        ? vnodeArgsTransformer(args, currentRenderingInstance)\r\n        : args));\r\n};\r\nconst InternalObjectKey = `__vInternal`;\r\nconst normalizeKey = ({ key }) => key != null ? key : null;\r\nconst normalizeRef = ({ ref }) => {\r\n    return (ref != null\r\n        ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(ref) || (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(ref) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(ref)\r\n            ? { i: currentRenderingInstance, r: ref }\r\n            : ref\r\n        : null);\r\n};\r\nfunction createBaseVNode(type, props = null, children = null, patchFlag = 0, dynamicProps = null, shapeFlag = type === Fragment ? 0 : 1 /* ELEMENT */, isBlockNode = false, needFullChildrenNormalization = false) {\r\n    const vnode = {\r\n        __v_isVNode: true,\r\n        __v_skip: true,\r\n        type,\r\n        props,\r\n        key: props && normalizeKey(props),\r\n        ref: props && normalizeRef(props),\r\n        scopeId: currentScopeId,\r\n        slotScopeIds: null,\r\n        children,\r\n        component: null,\r\n        suspense: null,\r\n        ssContent: null,\r\n        ssFallback: null,\r\n        dirs: null,\r\n        transition: null,\r\n        el: null,\r\n        anchor: null,\r\n        target: null,\r\n        targetAnchor: null,\r\n        staticCount: 0,\r\n        shapeFlag,\r\n        patchFlag,\r\n        dynamicProps,\r\n        dynamicChildren: null,\r\n        appContext: null\r\n    };\r\n    if (needFullChildrenNormalization) {\r\n        normalizeChildren(vnode, children);\r\n        // normalize suspense children\r\n        if (shapeFlag & 128 /* SUSPENSE */) {\r\n            type.normalize(vnode);\r\n        }\r\n    }\r\n    else if (children) {\r\n        // compiled element vnode - if children is passed, only possible types are\r\n        // string or Array.\r\n        vnode.shapeFlag |= (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(children)\r\n            ? 8 /* TEXT_CHILDREN */\r\n            : 16 /* ARRAY_CHILDREN */;\r\n    }\r\n    // validate key\r\n    if (( true) && vnode.key !== vnode.key) {\r\n        warn(`VNode created with invalid key (NaN). VNode type:`, vnode.type);\r\n    }\r\n    // track vnode for block tree\r\n    if (isBlockTreeEnabled > 0 &&\r\n        // avoid a block node from tracking itself\r\n        !isBlockNode &&\r\n        // has current parent block\r\n        currentBlock &&\r\n        // presence of a patch flag indicates this node needs patching on updates.\r\n        // component nodes also should always be patched, because even if the\r\n        // component doesn't need to update, it needs to persist the instance on to\r\n        // the next vnode so that it can be properly unmounted later.\r\n        (vnode.patchFlag > 0 || shapeFlag & 6 /* COMPONENT */) &&\r\n        // the EVENTS flag is only for hydration and if it is the only flag, the\r\n        // vnode should not be considered dynamic due to handler caching.\r\n        vnode.patchFlag !== 32 /* HYDRATE_EVENTS */) {\r\n        currentBlock.push(vnode);\r\n    }\r\n    return vnode;\r\n}\r\nconst createVNode = (( true) ? createVNodeWithArgsTransform : 0);\r\nfunction _createVNode(type, props = null, children = null, patchFlag = 0, dynamicProps = null, isBlockNode = false) {\r\n    if (!type || type === NULL_DYNAMIC_COMPONENT) {\r\n        if (( true) && !type) {\r\n            warn(`Invalid vnode type when creating vnode: ${type}.`);\r\n        }\r\n        type = Comment;\r\n    }\r\n    if (isVNode(type)) {\r\n        // createVNode receiving an existing vnode. This happens in cases like\r\n        // <component :is=\"vnode\"/>\r\n        // #2078 make sure to merge refs during the clone instead of overwriting it\r\n        const cloned = cloneVNode(type, props, true /* mergeRef: true */);\r\n        if (children) {\r\n            normalizeChildren(cloned, children);\r\n        }\r\n        return cloned;\r\n    }\r\n    // class component normalization.\r\n    if (isClassComponent(type)) {\r\n        type = type.__vccOpts;\r\n    }\r\n    // class & style normalization.\r\n    if (props) {\r\n        // for reactive or proxy objects, we need to clone it to enable mutation.\r\n        props = guardReactiveProps(props);\r\n        let { class: klass, style } = props;\r\n        if (klass && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(klass)) {\r\n            props.class = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.normalizeClass)(klass);\r\n        }\r\n        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(style)) {\r\n            // reactive state objects need to be cloned since they are likely to be\r\n            // mutated\r\n            if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isProxy)(style) && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(style)) {\r\n                style = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({}, style);\r\n            }\r\n            props.style = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.normalizeStyle)(style);\r\n        }\r\n    }\r\n    // encode the vnode type information into a bitmap\r\n    const shapeFlag = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(type)\r\n        ? 1 /* ELEMENT */\r\n        : isSuspense(type)\r\n            ? 128 /* SUSPENSE */\r\n            : isTeleport(type)\r\n                ? 64 /* TELEPORT */\r\n                : (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(type)\r\n                    ? 4 /* STATEFUL_COMPONENT */\r\n                    : (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(type)\r\n                        ? 2 /* FUNCTIONAL_COMPONENT */\r\n                        : 0;\r\n    if (( true) && shapeFlag & 4 /* STATEFUL_COMPONENT */ && (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isProxy)(type)) {\r\n        type = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(type);\r\n        warn(`Vue received a Component which was made a reactive object. This can ` +\r\n            `lead to unnecessary performance overhead, and should be avoided by ` +\r\n            `marking the component with \\`markRaw\\` or using \\`shallowRef\\` ` +\r\n            `instead of \\`ref\\`.`, `\\nComponent that was made reactive: `, type);\r\n    }\r\n    return createBaseVNode(type, props, children, patchFlag, dynamicProps, shapeFlag, isBlockNode, true);\r\n}\r\nfunction guardReactiveProps(props) {\r\n    if (!props)\r\n        return null;\r\n    return (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isProxy)(props) || InternalObjectKey in props\r\n        ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({}, props)\r\n        : props;\r\n}\r\nfunction cloneVNode(vnode, extraProps, mergeRef = false) {\r\n    // This is intentionally NOT using spread or extend to avoid the runtime\r\n    // key enumeration cost.\r\n    const { props, ref, patchFlag, children } = vnode;\r\n    const mergedProps = extraProps ? mergeProps(props || {}, extraProps) : props;\r\n    const cloned = {\r\n        __v_isVNode: true,\r\n        __v_skip: true,\r\n        type: vnode.type,\r\n        props: mergedProps,\r\n        key: mergedProps && normalizeKey(mergedProps),\r\n        ref: extraProps && extraProps.ref\r\n            ? // #2078 in the case of <component :is=\"vnode\" ref=\"extra\"/>\r\n                // if the vnode itself already has a ref, cloneVNode will need to merge\r\n                // the refs so the single vnode can be set on multiple refs\r\n                mergeRef && ref\r\n                    ? (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(ref)\r\n                        ? ref.concat(normalizeRef(extraProps))\r\n                        : [ref, normalizeRef(extraProps)]\r\n                    : normalizeRef(extraProps)\r\n            : ref,\r\n        scopeId: vnode.scopeId,\r\n        slotScopeIds: vnode.slotScopeIds,\r\n        children: ( true) && patchFlag === -1 /* HOISTED */ && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(children)\r\n            ? children.map(deepCloneVNode)\r\n            : children,\r\n        target: vnode.target,\r\n        targetAnchor: vnode.targetAnchor,\r\n        staticCount: vnode.staticCount,\r\n        shapeFlag: vnode.shapeFlag,\r\n        // if the vnode is cloned with extra props, we can no longer assume its\r\n        // existing patch flag to be reliable and need to add the FULL_PROPS flag.\r\n        // note: perserve flag for fragments since they use the flag for children\r\n        // fast paths only.\r\n        patchFlag: extraProps && vnode.type !== Fragment\r\n            ? patchFlag === -1 // hoisted node\r\n                ? 16 /* FULL_PROPS */\r\n                : patchFlag | 16 /* FULL_PROPS */\r\n            : patchFlag,\r\n        dynamicProps: vnode.dynamicProps,\r\n        dynamicChildren: vnode.dynamicChildren,\r\n        appContext: vnode.appContext,\r\n        dirs: vnode.dirs,\r\n        transition: vnode.transition,\r\n        // These should technically only be non-null on mounted VNodes. However,\r\n        // they *should* be copied for kept-alive vnodes. So we just always copy\r\n        // them since them being non-null during a mount doesn't affect the logic as\r\n        // they will simply be overwritten.\r\n        component: vnode.component,\r\n        suspense: vnode.suspense,\r\n        ssContent: vnode.ssContent && cloneVNode(vnode.ssContent),\r\n        ssFallback: vnode.ssFallback && cloneVNode(vnode.ssFallback),\r\n        el: vnode.el,\r\n        anchor: vnode.anchor\r\n    };\r\n    return cloned;\r\n}\r\n/**\r\n * Dev only, for HMR of hoisted vnodes reused in v-for\r\n * https://github.com/vitejs/vite/issues/2022\r\n */\r\nfunction deepCloneVNode(vnode) {\r\n    const cloned = cloneVNode(vnode);\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(vnode.children)) {\r\n        cloned.children = vnode.children.map(deepCloneVNode);\r\n    }\r\n    return cloned;\r\n}\r\n/**\r\n * @private\r\n */\r\nfunction createTextVNode(text = ' ', flag = 0) {\r\n    return createVNode(Text, null, text, flag);\r\n}\r\n/**\r\n * @private\r\n */\r\nfunction createStaticVNode(content, numberOfNodes) {\r\n    // A static vnode can contain multiple stringified elements, and the number\r\n    // of elements is necessary for hydration.\r\n    const vnode = createVNode(Static, null, content);\r\n    vnode.staticCount = numberOfNodes;\r\n    return vnode;\r\n}\r\n/**\r\n * @private\r\n */\r\nfunction createCommentVNode(text = '', \r\n// when used as the v-else branch, the comment node must be created as a\r\n// block to ensure correct updates.\r\nasBlock = false) {\r\n    return asBlock\r\n        ? (openBlock(), createBlock(Comment, null, text))\r\n        : createVNode(Comment, null, text);\r\n}\r\nfunction normalizeVNode(child) {\r\n    if (child == null || typeof child === 'boolean') {\r\n        // empty placeholder\r\n        return createVNode(Comment);\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(child)) {\r\n        // fragment\r\n        return createVNode(Fragment, null, \r\n        // #3666, avoid reference pollution when reusing vnode\r\n        child.slice());\r\n    }\r\n    else if (typeof child === 'object') {\r\n        // already vnode, this should be the most common since compiled templates\r\n        // always produce all-vnode children arrays\r\n        return cloneIfMounted(child);\r\n    }\r\n    else {\r\n        // strings and numbers\r\n        return createVNode(Text, null, String(child));\r\n    }\r\n}\r\n// optimized normalization for template-compiled render fns\r\nfunction cloneIfMounted(child) {\r\n    return child.el === null || child.memo ? child : cloneVNode(child);\r\n}\r\nfunction normalizeChildren(vnode, children) {\r\n    let type = 0;\r\n    const { shapeFlag } = vnode;\r\n    if (children == null) {\r\n        children = null;\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(children)) {\r\n        type = 16 /* ARRAY_CHILDREN */;\r\n    }\r\n    else if (typeof children === 'object') {\r\n        if (shapeFlag & (1 /* ELEMENT */ | 64 /* TELEPORT */)) {\r\n            // Normalize slot to plain children for plain element and Teleport\r\n            const slot = children.default;\r\n            if (slot) {\r\n                // _c marker is added by withCtx() indicating this is a compiled slot\r\n                slot._c && (slot._d = false);\r\n                normalizeChildren(vnode, slot());\r\n                slot._c && (slot._d = true);\r\n            }\r\n            return;\r\n        }\r\n        else {\r\n            type = 32 /* SLOTS_CHILDREN */;\r\n            const slotFlag = children._;\r\n            if (!slotFlag && !(InternalObjectKey in children)) {\r\n                children._ctx = currentRenderingInstance;\r\n            }\r\n            else if (slotFlag === 3 /* FORWARDED */ && currentRenderingInstance) {\r\n                // a child component receives forwarded slots from the parent.\r\n                // its slot type is determined by its parent's slot type.\r\n                if (currentRenderingInstance.slots._ === 1 /* STABLE */) {\r\n                    children._ = 1 /* STABLE */;\r\n                }\r\n                else {\r\n                    children._ = 2 /* DYNAMIC */;\r\n                    vnode.patchFlag |= 1024 /* DYNAMIC_SLOTS */;\r\n                }\r\n            }\r\n        }\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(children)) {\r\n        children = { default: children, _ctx: currentRenderingInstance };\r\n        type = 32 /* SLOTS_CHILDREN */;\r\n    }\r\n    else {\r\n        children = String(children);\r\n        // force teleport children to array so it can be moved around\r\n        if (shapeFlag & 64 /* TELEPORT */) {\r\n            type = 16 /* ARRAY_CHILDREN */;\r\n            children = [createTextVNode(children)];\r\n        }\r\n        else {\r\n            type = 8 /* TEXT_CHILDREN */;\r\n        }\r\n    }\r\n    vnode.children = children;\r\n    vnode.shapeFlag |= type;\r\n}\r\nfunction mergeProps(...args) {\r\n    const ret = {};\r\n    for (let i = 0; i < args.length; i++) {\r\n        const toMerge = args[i];\r\n        for (const key in toMerge) {\r\n            if (key === 'class') {\r\n                if (ret.class !== toMerge.class) {\r\n                    ret.class = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.normalizeClass)([ret.class, toMerge.class]);\r\n                }\r\n            }\r\n            else if (key === 'style') {\r\n                ret.style = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.normalizeStyle)([ret.style, toMerge.style]);\r\n            }\r\n            else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isOn)(key)) {\r\n                const existing = ret[key];\r\n                const incoming = toMerge[key];\r\n                if (existing !== incoming &&\r\n                    !((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(existing) && existing.includes(incoming))) {\r\n                    ret[key] = existing\r\n                        ? [].concat(existing, incoming)\r\n                        : incoming;\r\n                }\r\n            }\r\n            else if (key !== '') {\r\n                ret[key] = toMerge[key];\r\n            }\r\n        }\r\n    }\r\n    return ret;\r\n}\n\n/**\r\n * Actual implementation\r\n */\r\nfunction renderList(source, renderItem, cache, index) {\r\n    let ret;\r\n    const cached = (cache && cache[index]);\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(source) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(source)) {\r\n        ret = new Array(source.length);\r\n        for (let i = 0, l = source.length; i < l; i++) {\r\n            ret[i] = renderItem(source[i], i, undefined, cached && cached[i]);\r\n        }\r\n    }\r\n    else if (typeof source === 'number') {\r\n        if (( true) && !Number.isInteger(source)) {\r\n            warn(`The v-for range expect an integer value but got ${source}.`);\r\n            return [];\r\n        }\r\n        ret = new Array(source);\r\n        for (let i = 0; i < source; i++) {\r\n            ret[i] = renderItem(i + 1, i, undefined, cached && cached[i]);\r\n        }\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(source)) {\r\n        if (source[Symbol.iterator]) {\r\n            ret = Array.from(source, (item, i) => renderItem(item, i, undefined, cached && cached[i]));\r\n        }\r\n        else {\r\n            const keys = Object.keys(source);\r\n            ret = new Array(keys.length);\r\n            for (let i = 0, l = keys.length; i < l; i++) {\r\n                const key = keys[i];\r\n                ret[i] = renderItem(source[key], key, i, cached && cached[i]);\r\n            }\r\n        }\r\n    }\r\n    else {\r\n        ret = [];\r\n    }\r\n    if (cache) {\r\n        cache[index] = ret;\r\n    }\r\n    return ret;\r\n}\n\n/**\r\n * Compiler runtime helper for creating dynamic slots object\r\n * @private\r\n */\r\nfunction createSlots(slots, dynamicSlots) {\r\n    for (let i = 0; i < dynamicSlots.length; i++) {\r\n        const slot = dynamicSlots[i];\r\n        // array of dynamic slot generated by <template v-for=\"...\" #[...]>\r\n        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(slot)) {\r\n            for (let j = 0; j < slot.length; j++) {\r\n                slots[slot[j].name] = slot[j].fn;\r\n            }\r\n        }\r\n        else if (slot) {\r\n            // conditional single slot generated by <template v-if=\"...\" #foo>\r\n            slots[slot.name] = slot.fn;\r\n        }\r\n    }\r\n    return slots;\r\n}\n\n/**\r\n * Compiler runtime helper for rendering `<slot/>`\r\n * @private\r\n */\r\nfunction renderSlot(slots, name, props = {}, \r\n// this is not a user-facing function, so the fallback is always generated by\r\n// the compiler and guaranteed to be a function returning an array\r\nfallback, noSlotted) {\r\n    if (currentRenderingInstance.isCE) {\r\n        return createVNode('slot', name === 'default' ? null : { name }, fallback && fallback());\r\n    }\r\n    let slot = slots[name];\r\n    if (( true) && slot && slot.length > 1) {\r\n        warn(`SSR-optimized slot function detected in a non-SSR-optimized render ` +\r\n            `function. You need to mark this component with $dynamic-slots in the ` +\r\n            `parent template.`);\r\n        slot = () => [];\r\n    }\r\n    // a compiled slot disables block tracking by default to avoid manual\r\n    // invocation interfering with template-based block tracking, but in\r\n    // `renderSlot` we can be sure that it's template-based so we can force\r\n    // enable it.\r\n    if (slot && slot._c) {\r\n        slot._d = false;\r\n    }\r\n    openBlock();\r\n    const validSlotContent = slot && ensureValidVNode(slot(props));\r\n    const rendered = createBlock(Fragment, { key: props.key || `_${name}` }, validSlotContent || (fallback ? fallback() : []), validSlotContent && slots._ === 1 /* STABLE */\r\n        ? 64 /* STABLE_FRAGMENT */\r\n        : -2 /* BAIL */);\r\n    if (!noSlotted && rendered.scopeId) {\r\n        rendered.slotScopeIds = [rendered.scopeId + '-s'];\r\n    }\r\n    if (slot && slot._c) {\r\n        slot._d = true;\r\n    }\r\n    return rendered;\r\n}\r\nfunction ensureValidVNode(vnodes) {\r\n    return vnodes.some(child => {\r\n        if (!isVNode(child))\r\n            return true;\r\n        if (child.type === Comment)\r\n            return false;\r\n        if (child.type === Fragment &&\r\n            !ensureValidVNode(child.children))\r\n            return false;\r\n        return true;\r\n    })\r\n        ? vnodes\r\n        : null;\r\n}\n\n/**\r\n * For prefixing keys in v-on=\"obj\" with \"on\"\r\n * @private\r\n */\r\nfunction toHandlers(obj) {\r\n    const ret = {};\r\n    if (( true) && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(obj)) {\r\n        warn(`v-on with no argument expects an object value.`);\r\n        return ret;\r\n    }\r\n    for (const key in obj) {\r\n        ret[(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.toHandlerKey)(key)] = obj[key];\r\n    }\r\n    return ret;\r\n}\n\n/**\r\n * #2437 In Vue 3, functional components do not have a public instance proxy but\r\n * they exist in the internal parent chain. For code that relies on traversing\r\n * public $parent chains, skip functional ones and go to the parent instead.\r\n */\r\nconst getPublicInstance = (i) => {\r\n    if (!i)\r\n        return null;\r\n    if (isStatefulComponent(i))\r\n        return getExposeProxy(i) || i.proxy;\r\n    return getPublicInstance(i.parent);\r\n};\r\nconst publicPropertiesMap = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)(Object.create(null), {\r\n    $: i => i,\r\n    $el: i => i.vnode.el,\r\n    $data: i => i.data,\r\n    $props: i => (( true) ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly)(i.props) : 0),\r\n    $attrs: i => (( true) ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly)(i.attrs) : 0),\r\n    $slots: i => (( true) ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly)(i.slots) : 0),\r\n    $refs: i => (( true) ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly)(i.refs) : 0),\r\n    $parent: i => getPublicInstance(i.parent),\r\n    $root: i => getPublicInstance(i.root),\r\n    $emit: i => i.emit,\r\n    $options: i => (__VUE_OPTIONS_API__ ? resolveMergedOptions(i) : i.type),\r\n    $forceUpdate: i => () => queueJob(i.update),\r\n    $nextTick: i => nextTick.bind(i.proxy),\r\n    $watch: i => (__VUE_OPTIONS_API__ ? instanceWatch.bind(i) : _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP)\r\n});\r\nconst PublicInstanceProxyHandlers = {\r\n    get({ _: instance }, key) {\r\n        const { ctx, setupState, data, props, accessCache, type, appContext } = instance;\r\n        // for internal formatters to know that this is a Vue instance\r\n        if (( true) && key === '__isVue') {\r\n            return true;\r\n        }\r\n        // prioritize <script setup> bindings during dev.\r\n        // this allows even properties that start with _ or $ to be used - so that\r\n        // it aligns with the production behavior where the render fn is inlined and\r\n        // indeed has access to all declared variables.\r\n        if (( true) &&\r\n            setupState !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ &&\r\n            setupState.__isScriptSetup &&\r\n            (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(setupState, key)) {\r\n            return setupState[key];\r\n        }\r\n        // data / props / ctx\r\n        // This getter gets called for every property access on the render context\r\n        // during render and is a major hotspot. The most expensive part of this\r\n        // is the multiple hasOwn() calls. It's much faster to do a simple property\r\n        // access on a plain object, so we use an accessCache object (with null\r\n        // prototype) to memoize what access type a key corresponds to.\r\n        let normalizedProps;\r\n        if (key[0] !== '$') {\r\n            const n = accessCache[key];\r\n            if (n !== undefined) {\r\n                switch (n) {\r\n                    case 0 /* SETUP */:\r\n                        return setupState[key];\r\n                    case 1 /* DATA */:\r\n                        return data[key];\r\n                    case 3 /* CONTEXT */:\r\n                        return ctx[key];\r\n                    case 2 /* PROPS */:\r\n                        return props[key];\r\n                    // default: just fallthrough\r\n                }\r\n            }\r\n            else if (setupState !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(setupState, key)) {\r\n                accessCache[key] = 0 /* SETUP */;\r\n                return setupState[key];\r\n            }\r\n            else if (data !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(data, key)) {\r\n                accessCache[key] = 1 /* DATA */;\r\n                return data[key];\r\n            }\r\n            else if (\r\n            // only cache other properties when instance has declared (thus stable)\r\n            // props\r\n            (normalizedProps = instance.propsOptions[0]) &&\r\n                (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(normalizedProps, key)) {\r\n                accessCache[key] = 2 /* PROPS */;\r\n                return props[key];\r\n            }\r\n            else if (ctx !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(ctx, key)) {\r\n                accessCache[key] = 3 /* CONTEXT */;\r\n                return ctx[key];\r\n            }\r\n            else if (!__VUE_OPTIONS_API__ || shouldCacheAccess) {\r\n                accessCache[key] = 4 /* OTHER */;\r\n            }\r\n        }\r\n        const publicGetter = publicPropertiesMap[key];\r\n        let cssModule, globalProperties;\r\n        // public $xxx properties\r\n        if (publicGetter) {\r\n            if (key === '$attrs') {\r\n                (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.track)(instance, \"get\" /* GET */, key);\r\n                ( true) && markAttrsAccessed();\r\n            }\r\n            return publicGetter(instance);\r\n        }\r\n        else if (\r\n        // css module (injected by vue-loader)\r\n        (cssModule = type.__cssModules) &&\r\n            (cssModule = cssModule[key])) {\r\n            return cssModule;\r\n        }\r\n        else if (ctx !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(ctx, key)) {\r\n            // user may set custom properties to `this` that start with `$`\r\n            accessCache[key] = 3 /* CONTEXT */;\r\n            return ctx[key];\r\n        }\r\n        else if (\r\n        // global properties\r\n        ((globalProperties = appContext.config.globalProperties),\r\n            (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(globalProperties, key))) {\r\n            {\r\n                return globalProperties[key];\r\n            }\r\n        }\r\n        else if (( true) &&\r\n            currentRenderingInstance &&\r\n            (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(key) ||\r\n                // #1091 avoid internal isRef/isVNode checks on component instance leading\r\n                // to infinite warning loop\r\n                key.indexOf('__v') !== 0)) {\r\n            if (data !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ &&\r\n                (key[0] === '$' || key[0] === '_') &&\r\n                (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(data, key)) {\r\n                warn(`Property ${JSON.stringify(key)} must be accessed via $data because it starts with a reserved ` +\r\n                    `character (\"$\" or \"_\") and is not proxied on the render context.`);\r\n            }\r\n            else if (instance === currentRenderingInstance) {\r\n                warn(`Property ${JSON.stringify(key)} was accessed during render ` +\r\n                    `but is not defined on instance.`);\r\n            }\r\n        }\r\n    },\r\n    set({ _: instance }, key, value) {\r\n        const { data, setupState, ctx } = instance;\r\n        if (setupState !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(setupState, key)) {\r\n            setupState[key] = value;\r\n        }\r\n        else if (data !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(data, key)) {\r\n            data[key] = value;\r\n        }\r\n        else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(instance.props, key)) {\r\n            ( true) &&\r\n                warn(`Attempting to mutate prop \"${key}\". Props are readonly.`, instance);\r\n            return false;\r\n        }\r\n        if (key[0] === '$' && key.slice(1) in instance) {\r\n            ( true) &&\r\n                warn(`Attempting to mutate public property \"${key}\". ` +\r\n                    `Properties starting with $ are reserved and readonly.`, instance);\r\n            return false;\r\n        }\r\n        else {\r\n            if (( true) && key in instance.appContext.config.globalProperties) {\r\n                Object.defineProperty(ctx, key, {\r\n                    enumerable: true,\r\n                    configurable: true,\r\n                    value\r\n                });\r\n            }\r\n            else {\r\n                ctx[key] = value;\r\n            }\r\n        }\r\n        return true;\r\n    },\r\n    has({ _: { data, setupState, accessCache, ctx, appContext, propsOptions } }, key) {\r\n        let normalizedProps;\r\n        return (accessCache[key] !== undefined ||\r\n            (data !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(data, key)) ||\r\n            (setupState !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(setupState, key)) ||\r\n            ((normalizedProps = propsOptions[0]) && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(normalizedProps, key)) ||\r\n            (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(ctx, key) ||\r\n            (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(publicPropertiesMap, key) ||\r\n            (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasOwn)(appContext.config.globalProperties, key));\r\n    }\r\n};\r\nif (true) {\r\n    PublicInstanceProxyHandlers.ownKeys = (target) => {\r\n        warn(`Avoid app logic that relies on enumerating keys on a component instance. ` +\r\n            `The keys will be empty in production mode to avoid performance overhead.`);\r\n        return Reflect.ownKeys(target);\r\n    };\r\n}\r\nconst RuntimeCompiledPublicInstanceProxyHandlers = /*#__PURE__*/ (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({}, PublicInstanceProxyHandlers, {\r\n    get(target, key) {\r\n        // fast path for unscopables when using `with` block\r\n        if (key === Symbol.unscopables) {\r\n            return;\r\n        }\r\n        return PublicInstanceProxyHandlers.get(target, key, target);\r\n    },\r\n    has(_, key) {\r\n        const has = key[0] !== '_' && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isGloballyWhitelisted)(key);\r\n        if (( true) && !has && PublicInstanceProxyHandlers.has(_, key)) {\r\n            warn(`Property ${JSON.stringify(key)} should not start with _ which is a reserved prefix for Vue internals.`);\r\n        }\r\n        return has;\r\n    }\r\n});\r\n// dev only\r\n// In dev mode, the proxy target exposes the same properties as seen on `this`\r\n// for easier console inspection. In prod mode it will be an empty object so\r\n// these properties definitions can be skipped.\r\nfunction createDevRenderContext(instance) {\r\n    const target = {};\r\n    // expose internal instance for proxy handlers\r\n    Object.defineProperty(target, `_`, {\r\n        configurable: true,\r\n        enumerable: false,\r\n        get: () => instance\r\n    });\r\n    // expose public properties\r\n    Object.keys(publicPropertiesMap).forEach(key => {\r\n        Object.defineProperty(target, key, {\r\n            configurable: true,\r\n            enumerable: false,\r\n            get: () => publicPropertiesMap[key](instance),\r\n            // intercepted by the proxy so no need for implementation,\r\n            // but needed to prevent set errors\r\n            set: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP\r\n        });\r\n    });\r\n    return target;\r\n}\r\n// dev only\r\nfunction exposePropsOnRenderContext(instance) {\r\n    const { ctx, propsOptions: [propsOptions] } = instance;\r\n    if (propsOptions) {\r\n        Object.keys(propsOptions).forEach(key => {\r\n            Object.defineProperty(ctx, key, {\r\n                enumerable: true,\r\n                configurable: true,\r\n                get: () => instance.props[key],\r\n                set: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP\r\n            });\r\n        });\r\n    }\r\n}\r\n// dev only\r\nfunction exposeSetupStateOnRenderContext(instance) {\r\n    const { ctx, setupState } = instance;\r\n    Object.keys((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(setupState)).forEach(key => {\r\n        if (!setupState.__isScriptSetup) {\r\n            if (key[0] === '$' || key[0] === '_') {\r\n                warn(`setup() return property ${JSON.stringify(key)} should not start with \"$\" or \"_\" ` +\r\n                    `which are reserved prefixes for Vue internals.`);\r\n                return;\r\n            }\r\n            Object.defineProperty(ctx, key, {\r\n                enumerable: true,\r\n                configurable: true,\r\n                get: () => setupState[key],\r\n                set: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP\r\n            });\r\n        }\r\n    });\r\n}\n\nconst emptyAppContext = createAppContext();\r\nlet uid$1 = 0;\r\nfunction createComponentInstance(vnode, parent, suspense) {\r\n    const type = vnode.type;\r\n    // inherit parent app context - or - if root, adopt from root vnode\r\n    const appContext = (parent ? parent.appContext : vnode.appContext) || emptyAppContext;\r\n    const instance = {\r\n        uid: uid$1++,\r\n        vnode,\r\n        type,\r\n        parent,\r\n        appContext,\r\n        root: null,\r\n        next: null,\r\n        subTree: null,\r\n        update: null,\r\n        scope: new _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.EffectScope(true /* detached */),\r\n        render: null,\r\n        proxy: null,\r\n        exposed: null,\r\n        exposeProxy: null,\r\n        withProxy: null,\r\n        provides: parent ? parent.provides : Object.create(appContext.provides),\r\n        accessCache: null,\r\n        renderCache: [],\r\n        // local resovled assets\r\n        components: null,\r\n        directives: null,\r\n        // resolved props and emits options\r\n        propsOptions: normalizePropsOptions(type, appContext),\r\n        emitsOptions: normalizeEmitsOptions(type, appContext),\r\n        // emit\r\n        emit: null,\r\n        emitted: null,\r\n        // props default value\r\n        propsDefaults: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ,\r\n        // inheritAttrs\r\n        inheritAttrs: type.inheritAttrs,\r\n        // state\r\n        ctx: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ,\r\n        data: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ,\r\n        props: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ,\r\n        attrs: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ,\r\n        slots: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ,\r\n        refs: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ,\r\n        setupState: _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ,\r\n        setupContext: null,\r\n        // suspense related\r\n        suspense,\r\n        suspenseId: suspense ? suspense.pendingId : 0,\r\n        asyncDep: null,\r\n        asyncResolved: false,\r\n        // lifecycle hooks\r\n        // not using enums here because it results in computed properties\r\n        isMounted: false,\r\n        isUnmounted: false,\r\n        isDeactivated: false,\r\n        bc: null,\r\n        c: null,\r\n        bm: null,\r\n        m: null,\r\n        bu: null,\r\n        u: null,\r\n        um: null,\r\n        bum: null,\r\n        da: null,\r\n        a: null,\r\n        rtg: null,\r\n        rtc: null,\r\n        ec: null,\r\n        sp: null\r\n    };\r\n    if ((true)) {\r\n        instance.ctx = createDevRenderContext(instance);\r\n    }\r\n    else {}\r\n    instance.root = parent ? parent.root : instance;\r\n    instance.emit = emit$1.bind(null, instance);\r\n    // apply custom element special handling\r\n    if (vnode.ce) {\r\n        vnode.ce(instance);\r\n    }\r\n    return instance;\r\n}\r\nlet currentInstance = null;\r\nconst getCurrentInstance = () => currentInstance || currentRenderingInstance;\r\nconst setCurrentInstance = (instance) => {\r\n    currentInstance = instance;\r\n    instance.scope.on();\r\n};\r\nconst unsetCurrentInstance = () => {\r\n    currentInstance && currentInstance.scope.off();\r\n    currentInstance = null;\r\n};\r\nconst isBuiltInTag = /*#__PURE__*/ (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.makeMap)('slot,component');\r\nfunction validateComponentName(name, config) {\r\n    const appIsNativeTag = config.isNativeTag || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NO;\r\n    if (isBuiltInTag(name) || appIsNativeTag(name)) {\r\n        warn('Do not use built-in or reserved HTML elements as component id: ' + name);\r\n    }\r\n}\r\nfunction isStatefulComponent(instance) {\r\n    return instance.vnode.shapeFlag & 4 /* STATEFUL_COMPONENT */;\r\n}\r\nlet isInSSRComponentSetup = false;\r\nfunction setupComponent(instance, isSSR = false) {\r\n    isInSSRComponentSetup = isSSR;\r\n    const { props, children } = instance.vnode;\r\n    const isStateful = isStatefulComponent(instance);\r\n    initProps(instance, props, isStateful, isSSR);\r\n    initSlots(instance, children);\r\n    const setupResult = isStateful\r\n        ? setupStatefulComponent(instance, isSSR)\r\n        : undefined;\r\n    isInSSRComponentSetup = false;\r\n    return setupResult;\r\n}\r\nfunction setupStatefulComponent(instance, isSSR) {\r\n    const Component = instance.type;\r\n    if ((true)) {\r\n        if (Component.name) {\r\n            validateComponentName(Component.name, instance.appContext.config);\r\n        }\r\n        if (Component.components) {\r\n            const names = Object.keys(Component.components);\r\n            for (let i = 0; i < names.length; i++) {\r\n                validateComponentName(names[i], instance.appContext.config);\r\n            }\r\n        }\r\n        if (Component.directives) {\r\n            const names = Object.keys(Component.directives);\r\n            for (let i = 0; i < names.length; i++) {\r\n                validateDirectiveName(names[i]);\r\n            }\r\n        }\r\n        if (Component.compilerOptions && isRuntimeOnly()) {\r\n            warn(`\"compilerOptions\" is only supported when using a build of Vue that ` +\r\n                `includes the runtime compiler. Since you are using a runtime-only ` +\r\n                `build, the options should be passed via your build tool config instead.`);\r\n        }\r\n    }\r\n    // 0. create render proxy property access cache\r\n    instance.accessCache = Object.create(null);\r\n    // 1. create public instance / render proxy\r\n    // also mark it raw so it's never observed\r\n    instance.proxy = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.markRaw)(new Proxy(instance.ctx, PublicInstanceProxyHandlers));\r\n    if ((true)) {\r\n        exposePropsOnRenderContext(instance);\r\n    }\r\n    // 2. call setup()\r\n    const { setup } = Component;\r\n    if (setup) {\r\n        const setupContext = (instance.setupContext =\r\n            setup.length > 1 ? createSetupContext(instance) : null);\r\n        setCurrentInstance(instance);\r\n        (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.pauseTracking)();\r\n        const setupResult = callWithErrorHandling(setup, instance, 0 /* SETUP_FUNCTION */, [( true) ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly)(instance.props) : 0, setupContext]);\r\n        (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.resetTracking)();\r\n        unsetCurrentInstance();\r\n        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isPromise)(setupResult)) {\r\n            setupResult.then(unsetCurrentInstance, unsetCurrentInstance);\r\n            if (isSSR) {\r\n                // return the promise so server-renderer can wait on it\r\n                return setupResult\r\n                    .then((resolvedResult) => {\r\n                    handleSetupResult(instance, resolvedResult, isSSR);\r\n                })\r\n                    .catch(e => {\r\n                    handleError(e, instance, 0 /* SETUP_FUNCTION */);\r\n                });\r\n            }\r\n            else {\r\n                // async setup returned Promise.\r\n                // bail here and wait for re-entry.\r\n                instance.asyncDep = setupResult;\r\n            }\r\n        }\r\n        else {\r\n            handleSetupResult(instance, setupResult, isSSR);\r\n        }\r\n    }\r\n    else {\r\n        finishComponentSetup(instance, isSSR);\r\n    }\r\n}\r\nfunction handleSetupResult(instance, setupResult, isSSR) {\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(setupResult)) {\r\n        // setup returned an inline render function\r\n        if (instance.type.__ssrInlineRender) {\r\n            // when the function's name is `ssrRender` (compiled by SFC inline mode),\r\n            // set it as ssrRender instead.\r\n            instance.ssrRender = setupResult;\r\n        }\r\n        else {\r\n            instance.render = setupResult;\r\n        }\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(setupResult)) {\r\n        if (( true) && isVNode(setupResult)) {\r\n            warn(`setup() should not return VNodes directly - ` +\r\n                `return a render function instead.`);\r\n        }\r\n        // setup returned bindings.\r\n        // assuming a render function compiled from template is present.\r\n        if (true) {\r\n            instance.devtoolsRawSetupState = setupResult;\r\n        }\r\n        instance.setupState = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.proxyRefs)(setupResult);\r\n        if ((true)) {\r\n            exposeSetupStateOnRenderContext(instance);\r\n        }\r\n    }\r\n    else if (( true) && setupResult !== undefined) {\r\n        warn(`setup() should return an object. Received: ${setupResult === null ? 'null' : typeof setupResult}`);\r\n    }\r\n    finishComponentSetup(instance, isSSR);\r\n}\r\nlet compile;\r\nlet installWithProxy;\r\n/**\r\n * For runtime-dom to register the compiler.\r\n * Note the exported method uses any to avoid d.ts relying on the compiler types.\r\n */\r\nfunction registerRuntimeCompiler(_compile) {\r\n    compile = _compile;\r\n    installWithProxy = i => {\r\n        if (i.render._rc) {\r\n            i.withProxy = new Proxy(i.ctx, RuntimeCompiledPublicInstanceProxyHandlers);\r\n        }\r\n    };\r\n}\r\n// dev only\r\nconst isRuntimeOnly = () => !compile;\r\nfunction finishComponentSetup(instance, isSSR, skipOptions) {\r\n    const Component = instance.type;\r\n    // template / render function normalization\r\n    // could be already set when returned from setup()\r\n    if (!instance.render) {\r\n        // only do on-the-fly compile if not in SSR - SSR on-the-fly compliation\r\n        // is done by server-renderer\r\n        if (!isSSR && compile && !Component.render) {\r\n            const template = Component.template;\r\n            if (template) {\r\n                if ((true)) {\r\n                    startMeasure(instance, `compile`);\r\n                }\r\n                const { isCustomElement, compilerOptions } = instance.appContext.config;\r\n                const { delimiters, compilerOptions: componentCompilerOptions } = Component;\r\n                const finalCompilerOptions = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({\r\n                    isCustomElement,\r\n                    delimiters\r\n                }, compilerOptions), componentCompilerOptions);\r\n                Component.render = compile(template, finalCompilerOptions);\r\n                if ((true)) {\r\n                    endMeasure(instance, `compile`);\r\n                }\r\n            }\r\n        }\r\n        instance.render = (Component.render || _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP);\r\n        // for runtime-compiled render functions using `with` blocks, the render\r\n        // proxy used needs a different `has` handler which is more performant and\r\n        // also only allows a whitelist of globals to fallthrough.\r\n        if (installWithProxy) {\r\n            installWithProxy(instance);\r\n        }\r\n    }\r\n    // support for 2.x options\r\n    if (__VUE_OPTIONS_API__ && !(false )) {\r\n        setCurrentInstance(instance);\r\n        (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.pauseTracking)();\r\n        applyOptions(instance);\r\n        (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.resetTracking)();\r\n        unsetCurrentInstance();\r\n    }\r\n    // warn missing template/render\r\n    // the runtime compilation of template in SSR is done by server-render\r\n    if (( true) && !Component.render && instance.render === _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP && !isSSR) {\r\n        /* istanbul ignore if */\r\n        if (!compile && Component.template) {\r\n            warn(`Component provided template option but ` +\r\n                `runtime compilation is not supported in this build of Vue.` +\r\n                (` Configure your bundler to alias \"vue\" to \"vue/dist/vue.esm-bundler.js\".`\r\n                    ) /* should not happen */);\r\n        }\r\n        else {\r\n            warn(`Component is missing template or render function.`);\r\n        }\r\n    }\r\n}\r\nfunction createAttrsProxy(instance) {\r\n    return new Proxy(instance.attrs, ( true)\r\n        ? {\r\n            get(target, key) {\r\n                markAttrsAccessed();\r\n                (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.track)(instance, \"get\" /* GET */, '$attrs');\r\n                return target[key];\r\n            },\r\n            set() {\r\n                warn(`setupContext.attrs is readonly.`);\r\n                return false;\r\n            },\r\n            deleteProperty() {\r\n                warn(`setupContext.attrs is readonly.`);\r\n                return false;\r\n            }\r\n        }\r\n        : 0);\r\n}\r\nfunction createSetupContext(instance) {\r\n    const expose = exposed => {\r\n        if (( true) && instance.exposed) {\r\n            warn(`expose() should be called only once per setup().`);\r\n        }\r\n        instance.exposed = exposed || {};\r\n    };\r\n    let attrs;\r\n    if ((true)) {\r\n        // We use getters in dev in case libs like test-utils overwrite instance\r\n        // properties (overwrites should not be done in prod)\r\n        return Object.freeze({\r\n            get attrs() {\r\n                return attrs || (attrs = createAttrsProxy(instance));\r\n            },\r\n            get slots() {\r\n                return (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.shallowReadonly)(instance.slots);\r\n            },\r\n            get emit() {\r\n                return (event, ...args) => instance.emit(event, ...args);\r\n            },\r\n            expose\r\n        });\r\n    }\r\n    else {}\r\n}\r\nfunction getExposeProxy(instance) {\r\n    if (instance.exposed) {\r\n        return (instance.exposeProxy ||\r\n            (instance.exposeProxy = new Proxy((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.proxyRefs)((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.markRaw)(instance.exposed)), {\r\n                get(target, key) {\r\n                    if (key in target) {\r\n                        return target[key];\r\n                    }\r\n                    else if (key in publicPropertiesMap) {\r\n                        return publicPropertiesMap[key](instance);\r\n                    }\r\n                }\r\n            })));\r\n    }\r\n}\r\nconst classifyRE = /(?:^|[-_])(\\w)/g;\r\nconst classify = (str) => str.replace(classifyRE, c => c.toUpperCase()).replace(/[-_]/g, '');\r\nfunction getComponentName(Component) {\r\n    return (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(Component)\r\n        ? Component.displayName || Component.name\r\n        : Component.name;\r\n}\r\n/* istanbul ignore next */\r\nfunction formatComponentName(instance, Component, isRoot = false) {\r\n    let name = getComponentName(Component);\r\n    if (!name && Component.__file) {\r\n        const match = Component.__file.match(/([^/\\\\]+)\\.\\w+$/);\r\n        if (match) {\r\n            name = match[1];\r\n        }\r\n    }\r\n    if (!name && instance && instance.parent) {\r\n        // try to infer the name based on reverse resolution\r\n        const inferFromRegistry = (registry) => {\r\n            for (const key in registry) {\r\n                if (registry[key] === Component) {\r\n                    return key;\r\n                }\r\n            }\r\n        };\r\n        name =\r\n            inferFromRegistry(instance.components ||\r\n                instance.parent.type.components) || inferFromRegistry(instance.appContext.components);\r\n    }\r\n    return name ? classify(name) : isRoot ? `App` : `Anonymous`;\r\n}\r\nfunction isClassComponent(value) {\r\n    return (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(value) && '__vccOpts' in value;\r\n}\n\nconst stack = [];\r\nfunction pushWarningContext(vnode) {\r\n    stack.push(vnode);\r\n}\r\nfunction popWarningContext() {\r\n    stack.pop();\r\n}\r\nfunction warn(msg, ...args) {\r\n    // avoid props formatting or warn handler tracking deps that might be mutated\r\n    // during patch, leading to infinite recursion.\r\n    (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.pauseTracking)();\r\n    const instance = stack.length ? stack[stack.length - 1].component : null;\r\n    const appWarnHandler = instance && instance.appContext.config.warnHandler;\r\n    const trace = getComponentTrace();\r\n    if (appWarnHandler) {\r\n        callWithErrorHandling(appWarnHandler, instance, 11 /* APP_WARN_HANDLER */, [\r\n            msg + args.join(''),\r\n            instance && instance.proxy,\r\n            trace\r\n                .map(({ vnode }) => `at <${formatComponentName(instance, vnode.type)}>`)\r\n                .join('\\n'),\r\n            trace\r\n        ]);\r\n    }\r\n    else {\r\n        const warnArgs = [`[Vue warn]: ${msg}`, ...args];\r\n        /* istanbul ignore if */\r\n        if (trace.length &&\r\n            // avoid spamming console during tests\r\n            !false) {\r\n            warnArgs.push(`\\n`, ...formatTrace(trace));\r\n        }\r\n        console.warn(...warnArgs);\r\n    }\r\n    (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.resetTracking)();\r\n}\r\nfunction getComponentTrace() {\r\n    let currentVNode = stack[stack.length - 1];\r\n    if (!currentVNode) {\r\n        return [];\r\n    }\r\n    // we can't just use the stack because it will be incomplete during updates\r\n    // that did not start from the root. Re-construct the parent chain using\r\n    // instance parent pointers.\r\n    const normalizedStack = [];\r\n    while (currentVNode) {\r\n        const last = normalizedStack[0];\r\n        if (last && last.vnode === currentVNode) {\r\n            last.recurseCount++;\r\n        }\r\n        else {\r\n            normalizedStack.push({\r\n                vnode: currentVNode,\r\n                recurseCount: 0\r\n            });\r\n        }\r\n        const parentInstance = currentVNode.component && currentVNode.component.parent;\r\n        currentVNode = parentInstance && parentInstance.vnode;\r\n    }\r\n    return normalizedStack;\r\n}\r\n/* istanbul ignore next */\r\nfunction formatTrace(trace) {\r\n    const logs = [];\r\n    trace.forEach((entry, i) => {\r\n        logs.push(...(i === 0 ? [] : [`\\n`]), ...formatTraceEntry(entry));\r\n    });\r\n    return logs;\r\n}\r\nfunction formatTraceEntry({ vnode, recurseCount }) {\r\n    const postfix = recurseCount > 0 ? `... (${recurseCount} recursive calls)` : ``;\r\n    const isRoot = vnode.component ? vnode.component.parent == null : false;\r\n    const open = ` at <${formatComponentName(vnode.component, vnode.type, isRoot)}`;\r\n    const close = `>` + postfix;\r\n    return vnode.props\r\n        ? [open, ...formatProps(vnode.props), close]\r\n        : [open + close];\r\n}\r\n/* istanbul ignore next */\r\nfunction formatProps(props) {\r\n    const res = [];\r\n    const keys = Object.keys(props);\r\n    keys.slice(0, 3).forEach(key => {\r\n        res.push(...formatProp(key, props[key]));\r\n    });\r\n    if (keys.length > 3) {\r\n        res.push(` ...`);\r\n    }\r\n    return res;\r\n}\r\n/* istanbul ignore next */\r\nfunction formatProp(key, value, raw) {\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(value)) {\r\n        value = JSON.stringify(value);\r\n        return raw ? value : [`${key}=${value}`];\r\n    }\r\n    else if (typeof value === 'number' ||\r\n        typeof value === 'boolean' ||\r\n        value == null) {\r\n        return raw ? value : [`${key}=${value}`];\r\n    }\r\n    else if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(value)) {\r\n        value = formatProp(key, (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(value.value), true);\r\n        return raw ? value : [`${key}=Ref<`, value, `>`];\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(value)) {\r\n        return [`${key}=fn${value.name ? `<${value.name}>` : ``}`];\r\n    }\r\n    else {\r\n        value = (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(value);\r\n        return raw ? value : [`${key}=`, value];\r\n    }\r\n}\n\nconst ErrorTypeStrings = {\r\n    [\"sp\" /* SERVER_PREFETCH */]: 'serverPrefetch hook',\r\n    [\"bc\" /* BEFORE_CREATE */]: 'beforeCreate hook',\r\n    [\"c\" /* CREATED */]: 'created hook',\r\n    [\"bm\" /* BEFORE_MOUNT */]: 'beforeMount hook',\r\n    [\"m\" /* MOUNTED */]: 'mounted hook',\r\n    [\"bu\" /* BEFORE_UPDATE */]: 'beforeUpdate hook',\r\n    [\"u\" /* UPDATED */]: 'updated',\r\n    [\"bum\" /* BEFORE_UNMOUNT */]: 'beforeUnmount hook',\r\n    [\"um\" /* UNMOUNTED */]: 'unmounted hook',\r\n    [\"a\" /* ACTIVATED */]: 'activated hook',\r\n    [\"da\" /* DEACTIVATED */]: 'deactivated hook',\r\n    [\"ec\" /* ERROR_CAPTURED */]: 'errorCaptured hook',\r\n    [\"rtc\" /* RENDER_TRACKED */]: 'renderTracked hook',\r\n    [\"rtg\" /* RENDER_TRIGGERED */]: 'renderTriggered hook',\r\n    [0 /* SETUP_FUNCTION */]: 'setup function',\r\n    [1 /* RENDER_FUNCTION */]: 'render function',\r\n    [2 /* WATCH_GETTER */]: 'watcher getter',\r\n    [3 /* WATCH_CALLBACK */]: 'watcher callback',\r\n    [4 /* WATCH_CLEANUP */]: 'watcher cleanup function',\r\n    [5 /* NATIVE_EVENT_HANDLER */]: 'native event handler',\r\n    [6 /* COMPONENT_EVENT_HANDLER */]: 'component event handler',\r\n    [7 /* VNODE_HOOK */]: 'vnode hook',\r\n    [8 /* DIRECTIVE_HOOK */]: 'directive hook',\r\n    [9 /* TRANSITION_HOOK */]: 'transition hook',\r\n    [10 /* APP_ERROR_HANDLER */]: 'app errorHandler',\r\n    [11 /* APP_WARN_HANDLER */]: 'app warnHandler',\r\n    [12 /* FUNCTION_REF */]: 'ref function',\r\n    [13 /* ASYNC_COMPONENT_LOADER */]: 'async component loader',\r\n    [14 /* SCHEDULER */]: 'scheduler flush. This is likely a Vue internals bug. ' +\r\n        'Please open an issue at https://new-issue.vuejs.org/?repo=vuejs/vue-next'\r\n};\r\nfunction callWithErrorHandling(fn, instance, type, args) {\r\n    let res;\r\n    try {\r\n        res = args ? fn(...args) : fn();\r\n    }\r\n    catch (err) {\r\n        handleError(err, instance, type);\r\n    }\r\n    return res;\r\n}\r\nfunction callWithAsyncErrorHandling(fn, instance, type, args) {\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(fn)) {\r\n        const res = callWithErrorHandling(fn, instance, type, args);\r\n        if (res && (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isPromise)(res)) {\r\n            res.catch(err => {\r\n                handleError(err, instance, type);\r\n            });\r\n        }\r\n        return res;\r\n    }\r\n    const values = [];\r\n    for (let i = 0; i < fn.length; i++) {\r\n        values.push(callWithAsyncErrorHandling(fn[i], instance, type, args));\r\n    }\r\n    return values;\r\n}\r\nfunction handleError(err, instance, type, throwInDev = true) {\r\n    const contextVNode = instance ? instance.vnode : null;\r\n    if (instance) {\r\n        let cur = instance.parent;\r\n        // the exposed instance is the render proxy to keep it consistent with 2.x\r\n        const exposedInstance = instance.proxy;\r\n        // in production the hook receives only the error code\r\n        const errorInfo = ( true) ? ErrorTypeStrings[type] : 0;\r\n        while (cur) {\r\n            const errorCapturedHooks = cur.ec;\r\n            if (errorCapturedHooks) {\r\n                for (let i = 0; i < errorCapturedHooks.length; i++) {\r\n                    if (errorCapturedHooks[i](err, exposedInstance, errorInfo) === false) {\r\n                        return;\r\n                    }\r\n                }\r\n            }\r\n            cur = cur.parent;\r\n        }\r\n        // app-level handling\r\n        const appErrorHandler = instance.appContext.config.errorHandler;\r\n        if (appErrorHandler) {\r\n            callWithErrorHandling(appErrorHandler, null, 10 /* APP_ERROR_HANDLER */, [err, exposedInstance, errorInfo]);\r\n            return;\r\n        }\r\n    }\r\n    logError(err, type, contextVNode, throwInDev);\r\n}\r\nfunction logError(err, type, contextVNode, throwInDev = true) {\r\n    if ((true)) {\r\n        const info = ErrorTypeStrings[type];\r\n        if (contextVNode) {\r\n            pushWarningContext(contextVNode);\r\n        }\r\n        warn(`Unhandled error${info ? ` during execution of ${info}` : ``}`);\r\n        if (contextVNode) {\r\n            popWarningContext();\r\n        }\r\n        // crash in dev by default so it's more noticeable\r\n        if (throwInDev) {\r\n            throw err;\r\n        }\r\n        else {\r\n            console.error(err);\r\n        }\r\n    }\r\n    else {}\r\n}\n\nlet isFlushing = false;\r\nlet isFlushPending = false;\r\nconst queue = [];\r\nlet flushIndex = 0;\r\nconst pendingPreFlushCbs = [];\r\nlet activePreFlushCbs = null;\r\nlet preFlushIndex = 0;\r\nconst pendingPostFlushCbs = [];\r\nlet activePostFlushCbs = null;\r\nlet postFlushIndex = 0;\r\nconst resolvedPromise = Promise.resolve();\r\nlet currentFlushPromise = null;\r\nlet currentPreFlushParentJob = null;\r\nconst RECURSION_LIMIT = 100;\r\nfunction nextTick(fn) {\r\n    const p = currentFlushPromise || resolvedPromise;\r\n    return fn ? p.then(this ? fn.bind(this) : fn) : p;\r\n}\r\n// #2768\r\n// Use binary-search to find a suitable position in the queue,\r\n// so that the queue maintains the increasing order of job's id,\r\n// which can prevent the job from being skipped and also can avoid repeated patching.\r\nfunction findInsertionIndex(id) {\r\n    // the start index should be `flushIndex + 1`\r\n    let start = flushIndex + 1;\r\n    let end = queue.length;\r\n    while (start < end) {\r\n        const middle = (start + end) >>> 1;\r\n        const middleJobId = getId(queue[middle]);\r\n        middleJobId < id ? (start = middle + 1) : (end = middle);\r\n    }\r\n    return start;\r\n}\r\nfunction queueJob(job) {\r\n    // the dedupe search uses the startIndex argument of Array.includes()\r\n    // by default the search index includes the current job that is being run\r\n    // so it cannot recursively trigger itself again.\r\n    // if the job is a watch() callback, the search will start with a +1 index to\r\n    // allow it recursively trigger itself - it is the user's responsibility to\r\n    // ensure it doesn't end up in an infinite loop.\r\n    if ((!queue.length ||\r\n        !queue.includes(job, isFlushing && job.allowRecurse ? flushIndex + 1 : flushIndex)) &&\r\n        job !== currentPreFlushParentJob) {\r\n        if (job.id == null) {\r\n            queue.push(job);\r\n        }\r\n        else {\r\n            queue.splice(findInsertionIndex(job.id), 0, job);\r\n        }\r\n        queueFlush();\r\n    }\r\n}\r\nfunction queueFlush() {\r\n    if (!isFlushing && !isFlushPending) {\r\n        isFlushPending = true;\r\n        currentFlushPromise = resolvedPromise.then(flushJobs);\r\n    }\r\n}\r\nfunction invalidateJob(job) {\r\n    const i = queue.indexOf(job);\r\n    if (i > flushIndex) {\r\n        queue.splice(i, 1);\r\n    }\r\n}\r\nfunction queueCb(cb, activeQueue, pendingQueue, index) {\r\n    if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(cb)) {\r\n        if (!activeQueue ||\r\n            !activeQueue.includes(cb, cb.allowRecurse ? index + 1 : index)) {\r\n            pendingQueue.push(cb);\r\n        }\r\n    }\r\n    else {\r\n        // if cb is an array, it is a component lifecycle hook which can only be\r\n        // triggered by a job, which is already deduped in the main queue, so\r\n        // we can skip duplicate check here to improve perf\r\n        pendingQueue.push(...cb);\r\n    }\r\n    queueFlush();\r\n}\r\nfunction queuePreFlushCb(cb) {\r\n    queueCb(cb, activePreFlushCbs, pendingPreFlushCbs, preFlushIndex);\r\n}\r\nfunction queuePostFlushCb(cb) {\r\n    queueCb(cb, activePostFlushCbs, pendingPostFlushCbs, postFlushIndex);\r\n}\r\nfunction flushPreFlushCbs(seen, parentJob = null) {\r\n    if (pendingPreFlushCbs.length) {\r\n        currentPreFlushParentJob = parentJob;\r\n        activePreFlushCbs = [...new Set(pendingPreFlushCbs)];\r\n        pendingPreFlushCbs.length = 0;\r\n        if ((true)) {\r\n            seen = seen || new Map();\r\n        }\r\n        for (preFlushIndex = 0; preFlushIndex < activePreFlushCbs.length; preFlushIndex++) {\r\n            if (( true) &&\r\n                checkRecursiveUpdates(seen, activePreFlushCbs[preFlushIndex])) {\r\n                continue;\r\n            }\r\n            activePreFlushCbs[preFlushIndex]();\r\n        }\r\n        activePreFlushCbs = null;\r\n        preFlushIndex = 0;\r\n        currentPreFlushParentJob = null;\r\n        // recursively flush until it drains\r\n        flushPreFlushCbs(seen, parentJob);\r\n    }\r\n}\r\nfunction flushPostFlushCbs(seen) {\r\n    if (pendingPostFlushCbs.length) {\r\n        const deduped = [...new Set(pendingPostFlushCbs)];\r\n        pendingPostFlushCbs.length = 0;\r\n        // #1947 already has active queue, nested flushPostFlushCbs call\r\n        if (activePostFlushCbs) {\r\n            activePostFlushCbs.push(...deduped);\r\n            return;\r\n        }\r\n        activePostFlushCbs = deduped;\r\n        if ((true)) {\r\n            seen = seen || new Map();\r\n        }\r\n        activePostFlushCbs.sort((a, b) => getId(a) - getId(b));\r\n        for (postFlushIndex = 0; postFlushIndex < activePostFlushCbs.length; postFlushIndex++) {\r\n            if (( true) &&\r\n                checkRecursiveUpdates(seen, activePostFlushCbs[postFlushIndex])) {\r\n                continue;\r\n            }\r\n            activePostFlushCbs[postFlushIndex]();\r\n        }\r\n        activePostFlushCbs = null;\r\n        postFlushIndex = 0;\r\n    }\r\n}\r\nconst getId = (job) => job.id == null ? Infinity : job.id;\r\nfunction flushJobs(seen) {\r\n    isFlushPending = false;\r\n    isFlushing = true;\r\n    if ((true)) {\r\n        seen = seen || new Map();\r\n    }\r\n    flushPreFlushCbs(seen);\r\n    // Sort queue before flush.\r\n    // This ensures that:\r\n    // 1. Components are updated from parent to child. (because parent is always\r\n    //    created before the child so its render effect will have smaller\r\n    //    priority number)\r\n    // 2. If a component is unmounted during a parent component's update,\r\n    //    its update can be skipped.\r\n    queue.sort((a, b) => getId(a) - getId(b));\r\n    // conditional usage of checkRecursiveUpdate must be determined out of\r\n    // try ... catch block since Rollup by default de-optimizes treeshaking\r\n    // inside try-catch. This can leave all warning code unshaked. Although\r\n    // they would get eventually shaken by a minifier like terser, some minifiers\r\n    // would fail to do that (e.g. https://github.com/evanw/esbuild/issues/1610)\r\n    const check = ( true)\r\n        ? (job) => checkRecursiveUpdates(seen, job)\r\n        : 0;\r\n    try {\r\n        for (flushIndex = 0; flushIndex < queue.length; flushIndex++) {\r\n            const job = queue[flushIndex];\r\n            if (job && job.active !== false) {\r\n                if (( true) && check(job)) {\r\n                    continue;\r\n                }\r\n                // console.log(`running:`, job.id)\r\n                callWithErrorHandling(job, null, 14 /* SCHEDULER */);\r\n            }\r\n        }\r\n    }\r\n    finally {\r\n        flushIndex = 0;\r\n        queue.length = 0;\r\n        flushPostFlushCbs(seen);\r\n        isFlushing = false;\r\n        currentFlushPromise = null;\r\n        // some postFlushCb queued jobs!\r\n        // keep flushing until it drains.\r\n        if (queue.length ||\r\n            pendingPreFlushCbs.length ||\r\n            pendingPostFlushCbs.length) {\r\n            flushJobs(seen);\r\n        }\r\n    }\r\n}\r\nfunction checkRecursiveUpdates(seen, fn) {\r\n    if (!seen.has(fn)) {\r\n        seen.set(fn, 1);\r\n    }\r\n    else {\r\n        const count = seen.get(fn);\r\n        if (count > RECURSION_LIMIT) {\r\n            const instance = fn.ownerInstance;\r\n            const componentName = instance && getComponentName(instance.type);\r\n            warn(`Maximum recursive updates exceeded${componentName ? ` in component <${componentName}>` : ``}. ` +\r\n                `This means you have a reactive effect that is mutating its own ` +\r\n                `dependencies and thus recursively triggering itself. Possible sources ` +\r\n                `include component template, render function, updated hook or ` +\r\n                `watcher source function.`);\r\n            return true;\r\n        }\r\n        else {\r\n            seen.set(fn, count + 1);\r\n        }\r\n    }\r\n}\n\n// Simple effect.\r\nfunction watchEffect(effect, options) {\r\n    return doWatch(effect, null, options);\r\n}\r\nfunction watchPostEffect(effect, options) {\r\n    return doWatch(effect, null, (( true)\r\n        ? Object.assign(options || {}, { flush: 'post' })\r\n        : 0));\r\n}\r\nfunction watchSyncEffect(effect, options) {\r\n    return doWatch(effect, null, (( true)\r\n        ? Object.assign(options || {}, { flush: 'sync' })\r\n        : 0));\r\n}\r\n// initial value for watchers to trigger on undefined initial values\r\nconst INITIAL_WATCHER_VALUE = {};\r\n// implementation\r\nfunction watch(source, cb, options) {\r\n    if (( true) && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(cb)) {\r\n        warn(`\\`watch(fn, options?)\\` signature has been moved to a separate API. ` +\r\n            `Use \\`watchEffect(fn, options?)\\` instead. \\`watch\\` now only ` +\r\n            `supports \\`watch(source, cb, options?) signature.`);\r\n    }\r\n    return doWatch(source, cb, options);\r\n}\r\nfunction doWatch(source, cb, { immediate, deep, flush, onTrack, onTrigger } = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ) {\r\n    if (( true) && !cb) {\r\n        if (immediate !== undefined) {\r\n            warn(`watch() \"immediate\" option is only respected when using the ` +\r\n                `watch(source, callback, options?) signature.`);\r\n        }\r\n        if (deep !== undefined) {\r\n            warn(`watch() \"deep\" option is only respected when using the ` +\r\n                `watch(source, callback, options?) signature.`);\r\n        }\r\n    }\r\n    const warnInvalidSource = (s) => {\r\n        warn(`Invalid watch source: `, s, `A watch source can only be a getter/effect function, a ref, ` +\r\n            `a reactive object, or an array of these types.`);\r\n    };\r\n    const instance = currentInstance;\r\n    let getter;\r\n    let forceTrigger = false;\r\n    let isMultiSource = false;\r\n    if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(source)) {\r\n        getter = () => source.value;\r\n        forceTrigger = !!source._shallow;\r\n    }\r\n    else if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isReactive)(source)) {\r\n        getter = () => source;\r\n        deep = true;\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(source)) {\r\n        isMultiSource = true;\r\n        forceTrigger = source.some(_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isReactive);\r\n        getter = () => source.map(s => {\r\n            if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(s)) {\r\n                return s.value;\r\n            }\r\n            else if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isReactive)(s)) {\r\n                return traverse(s);\r\n            }\r\n            else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(s)) {\r\n                return callWithErrorHandling(s, instance, 2 /* WATCH_GETTER */);\r\n            }\r\n            else {\r\n                ( true) && warnInvalidSource(s);\r\n            }\r\n        });\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(source)) {\r\n        if (cb) {\r\n            // getter with cb\r\n            getter = () => callWithErrorHandling(source, instance, 2 /* WATCH_GETTER */);\r\n        }\r\n        else {\r\n            // no cb -> simple effect\r\n            getter = () => {\r\n                if (instance && instance.isUnmounted) {\r\n                    return;\r\n                }\r\n                if (cleanup) {\r\n                    cleanup();\r\n                }\r\n                return callWithAsyncErrorHandling(source, instance, 3 /* WATCH_CALLBACK */, [onInvalidate]);\r\n            };\r\n        }\r\n    }\r\n    else {\r\n        getter = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP;\r\n        ( true) && warnInvalidSource(source);\r\n    }\r\n    if (cb && deep) {\r\n        const baseGetter = getter;\r\n        getter = () => traverse(baseGetter());\r\n    }\r\n    let cleanup;\r\n    let onInvalidate = (fn) => {\r\n        cleanup = effect.onStop = () => {\r\n            callWithErrorHandling(fn, instance, 4 /* WATCH_CLEANUP */);\r\n        };\r\n    };\r\n    // in SSR there is no need to setup an actual effect, and it should be noop\r\n    // unless it's eager\r\n    if (isInSSRComponentSetup) {\r\n        // we will also not call the invalidate callback (+ runner is not set up)\r\n        onInvalidate = _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP;\r\n        if (!cb) {\r\n            getter();\r\n        }\r\n        else if (immediate) {\r\n            callWithAsyncErrorHandling(cb, instance, 3 /* WATCH_CALLBACK */, [\r\n                getter(),\r\n                isMultiSource ? [] : undefined,\r\n                onInvalidate\r\n            ]);\r\n        }\r\n        return _vue_shared__WEBPACK_IMPORTED_MODULE_1__.NOOP;\r\n    }\r\n    let oldValue = isMultiSource ? [] : INITIAL_WATCHER_VALUE;\r\n    const job = () => {\r\n        if (!effect.active) {\r\n            return;\r\n        }\r\n        if (cb) {\r\n            // watch(source, cb)\r\n            const newValue = effect.run();\r\n            if (deep ||\r\n                forceTrigger ||\r\n                (isMultiSource\r\n                    ? newValue.some((v, i) => (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasChanged)(v, oldValue[i]))\r\n                    : (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.hasChanged)(newValue, oldValue)) ||\r\n                (false  )) {\r\n                // cleanup before running cb again\r\n                if (cleanup) {\r\n                    cleanup();\r\n                }\r\n                callWithAsyncErrorHandling(cb, instance, 3 /* WATCH_CALLBACK */, [\r\n                    newValue,\r\n                    // pass undefined as the old value when it's changed for the first time\r\n                    oldValue === INITIAL_WATCHER_VALUE ? undefined : oldValue,\r\n                    onInvalidate\r\n                ]);\r\n                oldValue = newValue;\r\n            }\r\n        }\r\n        else {\r\n            // watchEffect\r\n            effect.run();\r\n        }\r\n    };\r\n    // important: mark the job as a watcher callback so that scheduler knows\r\n    // it is allowed to self-trigger (#1727)\r\n    job.allowRecurse = !!cb;\r\n    let scheduler;\r\n    if (flush === 'sync') {\r\n        scheduler = job; // the scheduler function gets called directly\r\n    }\r\n    else if (flush === 'post') {\r\n        scheduler = () => queuePostRenderEffect(job, instance && instance.suspense);\r\n    }\r\n    else {\r\n        // default: 'pre'\r\n        scheduler = () => {\r\n            if (!instance || instance.isMounted) {\r\n                queuePreFlushCb(job);\r\n            }\r\n            else {\r\n                // with 'pre' option, the first call must happen before\r\n                // the component is mounted so it is called synchronously.\r\n                job();\r\n            }\r\n        };\r\n    }\r\n    const effect = new _vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.ReactiveEffect(getter, scheduler);\r\n    if ((true)) {\r\n        effect.onTrack = onTrack;\r\n        effect.onTrigger = onTrigger;\r\n    }\r\n    // initial run\r\n    if (cb) {\r\n        if (immediate) {\r\n            job();\r\n        }\r\n        else {\r\n            oldValue = effect.run();\r\n        }\r\n    }\r\n    else if (flush === 'post') {\r\n        queuePostRenderEffect(effect.run.bind(effect), instance && instance.suspense);\r\n    }\r\n    else {\r\n        effect.run();\r\n    }\r\n    return () => {\r\n        effect.stop();\r\n        if (instance && instance.scope) {\r\n            (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.remove)(instance.scope.effects, effect);\r\n        }\r\n    };\r\n}\r\n// this.$watch\r\nfunction instanceWatch(source, value, options) {\r\n    const publicThis = this.proxy;\r\n    const getter = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isString)(source)\r\n        ? source.includes('.')\r\n            ? createPathGetter(publicThis, source)\r\n            : () => publicThis[source]\r\n        : source.bind(publicThis, publicThis);\r\n    let cb;\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(value)) {\r\n        cb = value;\r\n    }\r\n    else {\r\n        cb = value.handler;\r\n        options = value;\r\n    }\r\n    const cur = currentInstance;\r\n    setCurrentInstance(this);\r\n    const res = doWatch(getter, cb.bind(publicThis), options);\r\n    if (cur) {\r\n        setCurrentInstance(cur);\r\n    }\r\n    else {\r\n        unsetCurrentInstance();\r\n    }\r\n    return res;\r\n}\r\nfunction createPathGetter(ctx, path) {\r\n    const segments = path.split('.');\r\n    return () => {\r\n        let cur = ctx;\r\n        for (let i = 0; i < segments.length && cur; i++) {\r\n            cur = cur[segments[i]];\r\n        }\r\n        return cur;\r\n    };\r\n}\r\nfunction traverse(value, seen) {\r\n    if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(value) || value[\"__v_skip\" /* SKIP */]) {\r\n        return value;\r\n    }\r\n    seen = seen || new Set();\r\n    if (seen.has(value)) {\r\n        return value;\r\n    }\r\n    seen.add(value);\r\n    if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(value)) {\r\n        traverse(value.value, seen);\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(value)) {\r\n        for (let i = 0; i < value.length; i++) {\r\n            traverse(value[i], seen);\r\n        }\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isSet)(value) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isMap)(value)) {\r\n        value.forEach((v) => {\r\n            traverse(v, seen);\r\n        });\r\n    }\r\n    else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(value)) {\r\n        for (const key in value) {\r\n            traverse(value[key], seen);\r\n        }\r\n    }\r\n    return value;\r\n}\n\n// dev only\r\nconst warnRuntimeUsage = (method) => warn(`${method}() is a compiler-hint helper that is only usable inside ` +\r\n    `<script setup> of a single file component. Its arguments should be ` +\r\n    `compiled away and passing it at runtime has no effect.`);\r\n// implementation\r\nfunction defineProps() {\r\n    if ((true)) {\r\n        warnRuntimeUsage(`defineProps`);\r\n    }\r\n    return null;\r\n}\r\n// implementation\r\nfunction defineEmits() {\r\n    if ((true)) {\r\n        warnRuntimeUsage(`defineEmits`);\r\n    }\r\n    return null;\r\n}\r\n/**\r\n * Vue `<script setup>` compiler macro for declaring a component's exposed\r\n * instance properties when it is accessed by a parent component via template\r\n * refs.\r\n *\r\n * `<script setup>` components are closed by default - i.e. varaibles inside\r\n * the `<script setup>` scope is not exposed to parent unless explicitly exposed\r\n * via `defineExpose`.\r\n *\r\n * This is only usable inside `<script setup>`, is compiled away in the\r\n * output and should **not** be actually called at runtime.\r\n */\r\nfunction defineExpose(exposed) {\r\n    if ((true)) {\r\n        warnRuntimeUsage(`defineExpose`);\r\n    }\r\n}\r\n/**\r\n * Vue `<script setup>` compiler macro for providing props default values when\r\n * using type-based `defineProps` declaration.\r\n *\r\n * Example usage:\r\n * ```ts\r\n * withDefaults(defineProps<{\r\n *   size?: number\r\n *   labels?: string[]\r\n * }>(), {\r\n *   size: 3,\r\n *   labels: () => ['default label']\r\n * })\r\n * ```\r\n *\r\n * This is only usable inside `<script setup>`, is compiled away in the output\r\n * and should **not** be actually called at runtime.\r\n */\r\nfunction withDefaults(props, defaults) {\r\n    if ((true)) {\r\n        warnRuntimeUsage(`withDefaults`);\r\n    }\r\n    return null;\r\n}\r\nfunction useSlots() {\r\n    return getContext().slots;\r\n}\r\nfunction useAttrs() {\r\n    return getContext().attrs;\r\n}\r\nfunction getContext() {\r\n    const i = getCurrentInstance();\r\n    if (( true) && !i) {\r\n        warn(`useContext() called without active instance.`);\r\n    }\r\n    return i.setupContext || (i.setupContext = createSetupContext(i));\r\n}\r\n/**\r\n * Runtime helper for merging default declarations. Imported by compiled code\r\n * only.\r\n * @internal\r\n */\r\nfunction mergeDefaults(raw, defaults) {\r\n    const props = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(raw)\r\n        ? raw.reduce((normalized, p) => ((normalized[p] = {}), normalized), {})\r\n        : raw;\r\n    for (const key in defaults) {\r\n        const opt = props[key];\r\n        if (opt) {\r\n            if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(opt) || (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(opt)) {\r\n                props[key] = { type: opt, default: defaults[key] };\r\n            }\r\n            else {\r\n                opt.default = defaults[key];\r\n            }\r\n        }\r\n        else if (opt === null) {\r\n            props[key] = { default: defaults[key] };\r\n        }\r\n        else if ((true)) {\r\n            warn(`props default key \"${key}\" has no corresponding declaration.`);\r\n        }\r\n    }\r\n    return props;\r\n}\r\n/**\r\n * Used to create a proxy for the rest element when destructuring props with\r\n * defineProps().\r\n * @internal\r\n */\r\nfunction createPropsRestProxy(props, excludedKeys) {\r\n    const ret = {};\r\n    for (const key in props) {\r\n        if (!excludedKeys.includes(key)) {\r\n            Object.defineProperty(ret, key, {\r\n                enumerable: true,\r\n                get: () => props[key]\r\n            });\r\n        }\r\n    }\r\n    return ret;\r\n}\r\n/**\r\n * `<script setup>` helper for persisting the current instance context over\r\n * async/await flows.\r\n *\r\n * `@vue/compiler-sfc` converts the following:\r\n *\r\n * ```ts\r\n * const x = await foo()\r\n * ```\r\n *\r\n * into:\r\n *\r\n * ```ts\r\n * let __temp, __restore\r\n * const x = (([__temp, __restore] = withAsyncContext(() => foo())),__temp=await __temp,__restore(),__temp)\r\n * ```\r\n * @internal\r\n */\r\nfunction withAsyncContext(getAwaitable) {\r\n    const ctx = getCurrentInstance();\r\n    if (( true) && !ctx) {\r\n        warn(`withAsyncContext called without active current instance. ` +\r\n            `This is likely a bug.`);\r\n    }\r\n    let awaitable = getAwaitable();\r\n    unsetCurrentInstance();\r\n    if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isPromise)(awaitable)) {\r\n        awaitable = awaitable.catch(e => {\r\n            setCurrentInstance(ctx);\r\n            throw e;\r\n        });\r\n    }\r\n    return [awaitable, () => setCurrentInstance(ctx)];\r\n}\n\n// Actual implementation\r\nfunction h(type, propsOrChildren, children) {\r\n    const l = arguments.length;\r\n    if (l === 2) {\r\n        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(propsOrChildren) && !(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(propsOrChildren)) {\r\n            // single vnode without props\r\n            if (isVNode(propsOrChildren)) {\r\n                return createVNode(type, null, [propsOrChildren]);\r\n            }\r\n            // props without children\r\n            return createVNode(type, propsOrChildren);\r\n        }\r\n        else {\r\n            // omit props\r\n            return createVNode(type, null, propsOrChildren);\r\n        }\r\n    }\r\n    else {\r\n        if (l > 3) {\r\n            children = Array.prototype.slice.call(arguments, 2);\r\n        }\r\n        else if (l === 3 && isVNode(children)) {\r\n            children = [children];\r\n        }\r\n        return createVNode(type, propsOrChildren, children);\r\n    }\r\n}\n\nconst ssrContextKey = Symbol(( true) ? `ssrContext` : 0);\r\nconst useSSRContext = () => {\r\n    {\r\n        const ctx = inject(ssrContextKey);\r\n        if (!ctx) {\r\n            warn(`Server rendering context not provided. Make sure to only call ` +\r\n                `useSSRContext() conditionally in the server build.`);\r\n        }\r\n        return ctx;\r\n    }\r\n};\n\nfunction initCustomFormatter() {\r\n    /* eslint-disable no-restricted-globals */\r\n    if ( false || typeof window === 'undefined') {\r\n        return;\r\n    }\r\n    const vueStyle = { style: 'color:#3ba776' };\r\n    const numberStyle = { style: 'color:#0b1bc9' };\r\n    const stringStyle = { style: 'color:#b62e24' };\r\n    const keywordStyle = { style: 'color:#9d288c' };\r\n    // custom formatter for Chrome\r\n    // https://www.mattzeunert.com/2016/02/19/custom-chrome-devtools-object-formatters.html\r\n    const formatter = {\r\n        header(obj) {\r\n            // TODO also format ComponentPublicInstance & ctx.slots/attrs in setup\r\n            if (!(0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(obj)) {\r\n                return null;\r\n            }\r\n            if (obj.__isVue) {\r\n                return ['div', vueStyle, `VueInstance`];\r\n            }\r\n            else if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isRef)(obj)) {\r\n                return [\r\n                    'div',\r\n                    {},\r\n                    ['span', vueStyle, genRefFlag(obj)],\r\n                    '<',\r\n                    formatValue(obj.value),\r\n                    `>`\r\n                ];\r\n            }\r\n            else if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isReactive)(obj)) {\r\n                return [\r\n                    'div',\r\n                    {},\r\n                    ['span', vueStyle, 'Reactive'],\r\n                    '<',\r\n                    formatValue(obj),\r\n                    `>${(0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isReadonly)(obj) ? ` (readonly)` : ``}`\r\n                ];\r\n            }\r\n            else if ((0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.isReadonly)(obj)) {\r\n                return [\r\n                    'div',\r\n                    {},\r\n                    ['span', vueStyle, 'Readonly'],\r\n                    '<',\r\n                    formatValue(obj),\r\n                    '>'\r\n                ];\r\n            }\r\n            return null;\r\n        },\r\n        hasBody(obj) {\r\n            return obj && obj.__isVue;\r\n        },\r\n        body(obj) {\r\n            if (obj && obj.__isVue) {\r\n                return [\r\n                    'div',\r\n                    {},\r\n                    ...formatInstance(obj.$)\r\n                ];\r\n            }\r\n        }\r\n    };\r\n    function formatInstance(instance) {\r\n        const blocks = [];\r\n        if (instance.type.props && instance.props) {\r\n            blocks.push(createInstanceBlock('props', (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(instance.props)));\r\n        }\r\n        if (instance.setupState !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ) {\r\n            blocks.push(createInstanceBlock('setup', instance.setupState));\r\n        }\r\n        if (instance.data !== _vue_shared__WEBPACK_IMPORTED_MODULE_1__.EMPTY_OBJ) {\r\n            blocks.push(createInstanceBlock('data', (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(instance.data)));\r\n        }\r\n        const computed = extractKeys(instance, 'computed');\r\n        if (computed) {\r\n            blocks.push(createInstanceBlock('computed', computed));\r\n        }\r\n        const injected = extractKeys(instance, 'inject');\r\n        if (injected) {\r\n            blocks.push(createInstanceBlock('injected', injected));\r\n        }\r\n        blocks.push([\r\n            'div',\r\n            {},\r\n            [\r\n                'span',\r\n                {\r\n                    style: keywordStyle.style + ';opacity:0.66'\r\n                },\r\n                '$ (internal): '\r\n            ],\r\n            ['object', { object: instance }]\r\n        ]);\r\n        return blocks;\r\n    }\r\n    function createInstanceBlock(type, target) {\r\n        target = (0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.extend)({}, target);\r\n        if (!Object.keys(target).length) {\r\n            return ['span', {}];\r\n        }\r\n        return [\r\n            'div',\r\n            { style: 'line-height:1.25em;margin-bottom:0.6em' },\r\n            [\r\n                'div',\r\n                {\r\n                    style: 'color:#476582'\r\n                },\r\n                type\r\n            ],\r\n            [\r\n                'div',\r\n                {\r\n                    style: 'padding-left:1.25em'\r\n                },\r\n                ...Object.keys(target).map(key => {\r\n                    return [\r\n                        'div',\r\n                        {},\r\n                        ['span', keywordStyle, key + ': '],\r\n                        formatValue(target[key], false)\r\n                    ];\r\n                })\r\n            ]\r\n        ];\r\n    }\r\n    function formatValue(v, asRaw = true) {\r\n        if (typeof v === 'number') {\r\n            return ['span', numberStyle, v];\r\n        }\r\n        else if (typeof v === 'string') {\r\n            return ['span', stringStyle, JSON.stringify(v)];\r\n        }\r\n        else if (typeof v === 'boolean') {\r\n            return ['span', keywordStyle, v];\r\n        }\r\n        else if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(v)) {\r\n            return ['object', { object: asRaw ? (0,_vue_reactivity__WEBPACK_IMPORTED_MODULE_0__.toRaw)(v) : v }];\r\n        }\r\n        else {\r\n            return ['span', stringStyle, String(v)];\r\n        }\r\n    }\r\n    function extractKeys(instance, type) {\r\n        const Comp = instance.type;\r\n        if ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isFunction)(Comp)) {\r\n            return;\r\n        }\r\n        const extracted = {};\r\n        for (const key in instance.ctx) {\r\n            if (isKeyOfType(Comp, key, type)) {\r\n                extracted[key] = instance.ctx[key];\r\n            }\r\n        }\r\n        return extracted;\r\n    }\r\n    function isKeyOfType(Comp, key, type) {\r\n        const opts = Comp[type];\r\n        if (((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isArray)(opts) && opts.includes(key)) ||\r\n            ((0,_vue_shared__WEBPACK_IMPORTED_MODULE_1__.isObject)(opts) && key in opts)) {\r\n            return true;\r\n        }\r\n        if (Comp.extends && isKeyOfType(Comp.extends, key, type)) {\r\n            return true;\r\n        }\r\n        if (Comp.mixins && Comp.mixins.some(m => isKeyOfType(m, key, type))) {\r\n            return true;\r\n        }\r\n    }\r\n    function genRefFlag(v) {\r\n        if (v._shallow) {\r\n            return `ShallowRef`;\r\n        }\r\n        if (v.effect) {\r\n            return `ComputedRef`;\r\n        }\r\n        return `Ref`;\r\n    }\r\n    if (window.devtoolsFormatters) {\r\n        window.devtoolsFormatters.push(formatter);\r\n    }\r\n    else {\r\n        window.devtoolsFormatters = [formatter];\r\n    }\r\n}\n\nfunction withMemo(memo, render, cache, index) {\r\n    const cached = cache[index];\r\n    if (cached && isMemoSame(cached, memo)) {\r\n        return cached;\r\n    }\r\n    const ret = render();\r\n    // shallow clone\r\n    ret.memo = memo.slice();\r\n    return (cache[index] = ret);\r\n}\r\nfunction isMemoSame(cached, memo) {\r\n    const prev = cached.memo;\r\n    if (prev.length != memo.length) {\r\n        return false;\r\n    }\r\n    for (let i = 0; i < prev.length; i++) {\r\n        if (prev[i] !== memo[i]) {\r\n            return false;\r\n        }\r\n    }\r\n    // make sure to let parent block track it when returning cached\r\n    if (isBlockTreeEnabled > 0 && currentBlock) {\r\n        currentBlock.push(cached);\r\n    }\r\n    return true;\r\n}\n\n// Core API ------------------------------------------------------------------\r\nconst version = \"3.2.22\";\r\nconst _ssrUtils = {\r\n    createComponentInstance,\r\n    setupComponent,\r\n    renderComponentRoot,\r\n    setCurrentRenderingInstance,\r\n    isVNode,\r\n    normalizeVNode\r\n};\r\n/**\r\n * SSR utils for \\@vue/server-renderer. Only exposed in cjs builds.\r\n * @internal\r\n */\r\nconst ssrUtils = (_ssrUtils );\r\n/**\r\n * @internal only exposed in compat builds\r\n */\r\nconst resolveFilter = null;\r\n/**\r\n * @internal only exposed in compat builds.\r\n */\r\nconst compatUtils = (null);\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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