/*
 * Decompiled with CFR 0.152.
 */
package app.plugin.executer;

import app.plugin.executer.DataType;
import org.json.JSONArray;

public class DataParser {
    private static Object[] newArray(String type, int length) {
        switch (type) {
            case "Number[]": {
                return new Number[length];
            }
            case "Integer[]": {
                return new Integer[length];
            }
            case "Long[]": {
                return new Long[length];
            }
            case "Short[]": {
                return new Short[length];
            }
            case "Float[]": {
                return new Float[length];
            }
            case "Double[]": {
                return new Double[length];
            }
            case "Boolean[]": {
                return new Boolean[length];
            }
        }
        return new String[length];
    }

    private static void setArrayItem(String type, JSONArray src, Object[] dist) {
        block19: for (int i = 0; i < src.length(); ++i) {
            switch (type) {
                case "Number[]": {
                    dist[i] = src.getNumber(i);
                    continue block19;
                }
                case "Integer[]": {
                    dist[i] = src.getInt(i);
                    continue block19;
                }
                case "Long[]": {
                    dist[i] = src.getLong(i);
                    continue block19;
                }
                case "Short[]": {
                    dist[i] = src.getNumber(i).shortValue();
                    continue block19;
                }
                case "Float[]": {
                    dist[i] = Float.valueOf(src.getFloat(i));
                    continue block19;
                }
                case "Double[]": {
                    dist[i] = src.getDouble(i);
                    continue block19;
                }
                case "Boolean[]": {
                    dist[i] = src.getBoolean(i);
                    continue block19;
                }
                default: {
                    dist[i] = src.getString(i);
                }
            }
        }
    }

    private static Object[] parseArrayValue(String type, String str) {
        JSONArray arr = new JSONArray(str.trim());
        Object[] result = DataParser.newArray(type, arr.length());
        DataParser.setArrayItem(type, arr, result);
        return result;
    }

    private static Object parseValue(String type, String str) {
        switch (type) {
            case "Number": {
                return DataParser.parseArrayValue("Number[]", "[" + str + "]")[0];
            }
            case "int": 
            case "Integer": {
                return DataParser.parseArrayValue("Integer[]", "[" + str + "]")[0];
            }
            case "long": 
            case "Long": {
                return DataParser.parseArrayValue("Long[]", "[" + str + "]")[0];
            }
            case "short": 
            case "Short": {
                return DataParser.parseArrayValue("Short[]", "[" + str + "]")[0];
            }
            case "float": 
            case "Float": {
                return DataParser.parseArrayValue("Float[]", "[" + str + "]")[0];
            }
            case "double": 
            case "Double": {
                return DataParser.parseArrayValue("Double[]", "[" + str + "]")[0];
            }
            case "boolean": 
            case "Boolean": {
                return DataParser.parseArrayValue("Boolean[]", "[" + str + "]")[0];
            }
        }
        if (!str.startsWith("\"") || !str.endsWith("\"")) {
            str = "\"" + str + "\"";
        }
        return DataParser.parseArrayValue("String[]", "[" + str + "]")[0];
    }

    protected static Object parse(String type, String str) {
        if (DataType.isArray(type)) {
            switch (type) {
                case "int[]": {
                    return DataParser.correctIntArray(str);
                }
                case "long[]": {
                    return DataParser.correctLongArray(str);
                }
                case "short[]": {
                    return DataParser.correctShortArray(str);
                }
                case "float[]": {
                    return DataParser.correctFloatArray(str);
                }
                case "double[]": {
                    return DataParser.correctDoubleArray(str);
                }
                case "boolean[]": {
                    return DataParser.correctBooleanArray(str);
                }
            }
            return DataParser.parseArrayValue(type, str);
        }
        return DataParser.parseValue(type, str);
    }

    private static int[] correctIntArray(String methodArg) {
        Object[] tmp = DataParser.parseArrayValue("Integer[]", methodArg);
        int[] corrected = new int[tmp.length];
        for (int j = 0; j < tmp.length; ++j) {
            corrected[j] = (Integer)tmp[j];
        }
        return corrected;
    }

    private static long[] correctLongArray(String methodArg) {
        Object[] tmp = DataParser.parseArrayValue("Long[]", methodArg);
        long[] corrected = new long[tmp.length];
        for (int j = 0; j < tmp.length; ++j) {
            corrected[j] = (Long)tmp[j];
        }
        return corrected;
    }

    private static short[] correctShortArray(String methodArg) {
        Object[] tmp = DataParser.parseArrayValue("Short[]", methodArg);
        short[] corrected = new short[tmp.length];
        for (int j = 0; j < tmp.length; ++j) {
            corrected[j] = (Short)tmp[j];
        }
        return corrected;
    }

    private static float[] correctFloatArray(String methodArg) {
        Object[] tmp = DataParser.parseArrayValue("Float[]", methodArg);
        float[] corrected = new float[tmp.length];
        for (int j = 0; j < tmp.length; ++j) {
            corrected[j] = ((Float)tmp[j]).floatValue();
        }
        return corrected;
    }

    private static double[] correctDoubleArray(String methodArg) {
        Object[] tmp = DataParser.parseArrayValue("Double[]", methodArg);
        double[] corrected = new double[tmp.length];
        for (int j = 0; j < tmp.length; ++j) {
            corrected[j] = (Double)tmp[j];
        }
        return corrected;
    }

    private static boolean[] correctBooleanArray(String methodArg) {
        Object[] tmp = DataParser.parseArrayValue("Boolean[]", methodArg);
        boolean[] corrected = new boolean[tmp.length];
        for (int j = 0; j < tmp.length; ++j) {
            corrected[j] = (Boolean)tmp[j];
        }
        return corrected;
    }
}

