/*
 * Decompiled with CFR 0.152.
 */
package app.plugin.executer;

import app.plugin.executer.DataParser;
import app.plugin.executer.DataTypeClass;
import app.plugin.executer.ReflectUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import org.json.JSONWriter;

public class Invoker {
    private static StdoutRecoverer redirectStdout(ByteArrayOutputStream outContent) {
        final PrintStream originalOut = System.out;
        StdoutRecoverer recoverer = new StdoutRecoverer(){

            @Override
            public void recover() {
                System.setOut(originalOut);
            }
        };
        return recoverer;
    }

    public static void version() {
        Properties properties = new Properties();
        try {
            properties.load(Invoker.class.getResourceAsStream("/project.properties"));
            System.out.println(properties.getProperty("version"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args[0].equals("version")) {
            Invoker.version();
            return;
        }
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        StdoutRecoverer recoverer = Invoker.redirectStdout(outContent);
        String jarName = "";
        String className = "";
        String methodName = "";
        String[] argTypes = new String[]{};
        try {
            jarName = args[0];
            String methodSignature = args[1];
            int methodTypesStartFrom = methodSignature.indexOf("(");
            String types = methodSignature.substring(methodTypesStartFrom, methodSignature.length());
            String methodFullName = methodSignature.substring(0, methodTypesStartFrom);
            int methodNameStartFrom = methodFullName.lastIndexOf(46);
            className = methodFullName.substring(0, methodNameStartFrom);
            methodName = methodFullName.substring(methodNameStartFrom + 1, methodFullName.length());
            types = types.substring(1, types.length() - 1);
            argTypes = types.split(",");
        }
        catch (Exception e) {
            System.err.println("Invalid parameters");
            return;
        }
        Class[] argTypeClass = new Class[argTypes.length];
        Object[] parsedArgs = new Object[argTypes.length];
        for (int i = 0; i < parsedArgs.length; ++i) {
            String methodArg = args[i + 2];
            String argType = argTypes[i].trim();
            argTypeClass[i] = DataTypeClass.get(argType);
            parsedArgs[i] = DataParser.parse(argType, methodArg);
        }
        String path = "file:" + jarName;
        URLClassLoader urlClassLoader = null;
        Class<?> clazz = null;
        try {
            urlClassLoader = new URLClassLoader(new URL[]{new URL(path)});
            clazz = urlClassLoader.loadClass(className);
            Constructor<?> constructor = ReflectUtil.findConstructor(clazz, new Class[0]);
            Object instance = constructor.newInstance(new Object[0]);
            Method method = ReflectUtil.findMethod(clazz, methodName, argTypeClass);
            Object res = method.invoke(instance, parsedArgs);
            recoverer.recover();
            if (res == null) {
                System.out.print(outContent.toString());
            } else if (Invoker.isArray(res)) {
                System.out.print(JSONWriter.valueToString(res));
            } else {
                System.out.print(res);
            }
        }
        catch (Exception e) {
            recoverer.recover();
            e.printStackTrace();
        }
        finally {
            try {
                urlClassLoader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    private static interface StdoutRecoverer {
        public void recover();
    }
}

