var json_stringify = require('./lib/stringify.js').stringify;
var json_parse = require('./lib/parse.js')();
var enableBigInt = false;

module.exports = function (options) {
  return {
    parse: json_parse(options),
    stringify: json_stringify,
  };
};
//create the default method members with no options applied for backwards compatibility
module.exports.setEnableBigInt = function (value) {
  enableBigInt = value;
};
module.exports.parse = function (source, reviver) {
  return (enableBigInt ? json_parse : JSON.parse)(source, reviver);
};
module.exports.stringify = function (value, replacer, space) {
  return (enableBigInt ? json_stringify : JSON.stringify)(
    value,
    replacer,
    space
  );
};
module.exports.BigIntParse = json_parse;
module.exports.BigIntStringify = json_stringify;
