import { __awaiter } from "tslib";
import fs from 'fs';
import path from 'path';
import { promisify } from 'util';
import { parse as parseProtobuf } from './parse';
import { ProtobufJsonParserNode } from './protobuf-json-parser.node';
const readFile = promisify(fs.readFile);
export function parse(rootFileURL, options = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        const includeDirs = options.includes || [];
        const root = {
            name: path.basename(rootFileURL),
            relativePath: path.basename(rootFileURL),
            url: rootFileURL,
        };
        const result = parseProtobuf({
            rootFile: root,
            dependencies: includeDirs,
            protobufJsonParser: ProtobufJsonParserNode,
            appName: options.appName,
            getFileContent(url) {
                return __awaiter(this, void 0, void 0, function* () {
                    return yield readFile(url);
                });
            },
        });
        return result;
    });
}
export function toJSONFormat(rootFile, options) {
    return __awaiter(this, void 0, void 0, function* () {
        const dependencies = options.includes || [];
        const util = require('protobufjs/src/util');
        let isResolvingRootFile = true;
        let originalFS = util.fs;
        util.fs = Object.assign(Object.assign({}, fs), { readFileSync: (filePath) => {
                if (isResolvingRootFile && filePath.endsWith(rootFile.path)) {
                    isResolvingRootFile = false;
                    return Buffer.from(rootFile.content);
                }
                if (isResolvingRootFile) {
                    throw Error(`File (${filePath}) not found.`);
                }
                const file = dependencies.find((item) => filePath.endsWith(item.path));
                if (file !== undefined) {
                    return Buffer.from(file.content);
                }
                throw Error(`File (${filePath}) not found.`);
            } });
        const root = {
            name: rootFile.name,
            relativePath: path.basename(rootFile.path),
            url: rootFile.path,
        };
        try {
            const parser = new ProtobufJsonParserNode(root);
            const result = yield parser.parse();
            util.fs = originalFS;
            return result.root.toJSON();
        }
        catch (err) {
            util.fs = originalFS;
            throw err;
        }
    });
}
