import { __awaiter } from "tslib";
import { parseProtobufSpec } from './parse-protobuf-spec';
export function parse(options) {
    return __awaiter(this, void 0, void 0, function* () {
        const { rootFile, dependencies, protobufJsonParser: JsonParser, getFileContent, appName, } = options;
        try {
            const jsonParser = new JsonParser(rootFile, dependencies);
            const { root, dataResources } = yield jsonParser.parse();
            const result = yield parseProtobufSpec({
                root,
                rootFile,
                dependencies,
                dataResources,
                getFileContent,
                appName,
            });
            return result;
        }
        catch (err) {
            throw err;
        }
    });
}
