export class ProtobufJsonParserBase {
    constructor(rootFile, dependencies) {
        this.rootFile = rootFile;
        this.dependencies = dependencies;
        const fileMap = {};
        dependencies === null || dependencies === void 0 ? void 0 : dependencies.forEach((file) => {
            if (typeof file !== 'string') {
                fileMap[file.relativePath] = file;
            }
        });
        this.ctx = {
            fileMap,
            rootFile,
            usedFiles: [
                {
                    file: rootFile,
                    isRoot: true,
                },
            ],
        };
    }
}
