import { __awaiter } from "tslib";
import protobuf from 'protobufjs';
import { ProtobufJsonParserBase } from './protobuf-json-parser-base';
import { getFileDir } from './utils';
export class ProtobufJsonParserBrowser extends ProtobufJsonParserBase {
    parse() {
        return __awaiter(this, void 0, void 0, function* () {
            let root = new protobuf.Root();
            root.resolvePath = (source, target) => {
                const normalizedTarget = target.trim().replace(/^\.\//, '');
                if (this.ctx.rootFile.url.startsWith('blob:')) {
                    for (const [key, value] of Object.entries(this.ctx.fileMap)) {
                        if (!value)
                            continue;
                        if (normalizedTarget === key) {
                            this.ctx.usedFiles.push({
                                file: value,
                                isRoot: false,
                            });
                            return value.url;
                        }
                    }
                }
                else if (normalizedTarget !== this.ctx.rootFile.url) {
                    const url = `${getFileDir(this.ctx.rootFile.url)}/${normalizedTarget}`;
                    this.ctx.usedFiles.push({
                        file: {
                            name: '',
                            relativePath: normalizedTarget,
                            url,
                        },
                        isRoot: false,
                    });
                    return url;
                }
                if (target !== this.ctx.rootFile.url) {
                    throw Error(`File (${target}) not found.`);
                }
                return target;
            };
            root = yield root.load(this.rootFile.url, {
                keepCase: true,
            });
            return {
                root,
                dataResources: this.ctx.usedFiles,
            };
        });
    }
}
