export function correctURL(url) {
    return url.replace(/^(blob:)?http(s)?:\/([^/])/, '$1http$2://$3');
}
export function getFilePathFromBlobURL(url) {
    let prefixLen = `blob:${window.location.origin}`.length;
    return url.substr(prefixLen + 1);
}
export function getFilePathFromURL(url, rootFileURL) {
    let prefixLen = rootFileURL.lastIndexOf('/');
    return url.substr(prefixLen + 1);
}
export function getFileDir(url) {
    let index = url.lastIndexOf('/');
    return url.substr(0, index);
}
export function isNamespace(obj) {
    return !!obj.nested && !obj.fields;
}
export function isService(obj) {
    return !!obj.methods;
}
export function isMessage(obj) {
    return !!obj.fields;
}
export function isEnum(obj) {
    return !!(obj.values && obj.valuesById);
}
export function resolveFullName(fullName) {
    // .abc.def -> abc.def
    return fullName.replace(/^\./, '');
}
export function getFileName(url) {
    let start = url.lastIndexOf('/');
    let end = url.lastIndexOf('.');
    if (end === -1 || end < start) {
        end = url.length;
    }
    return url.substring(start + 1, end);
}
