"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toJSONFormat = exports.parse = void 0;
const tslib_1 = require("tslib");
const fs_1 = tslib_1.__importDefault(require("fs"));
const path_1 = tslib_1.__importDefault(require("path"));
const util_1 = require("util");
const parse_1 = require("./parse");
const protobuf_json_parser_node_1 = require("./protobuf-json-parser.node");
const readFile = (0, util_1.promisify)(fs_1.default.readFile);
function parse(rootFileURL, options = {}) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const includeDirs = options.includes || [];
        const root = {
            name: path_1.default.basename(rootFileURL),
            relativePath: path_1.default.basename(rootFileURL),
            url: rootFileURL,
        };
        const result = (0, parse_1.parse)({
            rootFile: root,
            dependencies: includeDirs,
            protobufJsonParser: protobuf_json_parser_node_1.ProtobufJsonParserNode,
            appName: options.appName,
            getFileContent(url) {
                return tslib_1.__awaiter(this, void 0, void 0, function* () {
                    return yield readFile(url);
                });
            },
        });
        return result;
    });
}
exports.parse = parse;
function toJSONFormat(rootFile, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const dependencies = options.includes || [];
        const util = require('protobufjs/src/util');
        let isResolvingRootFile = true;
        let originalFS = util.fs;
        util.fs = Object.assign(Object.assign({}, fs_1.default), { readFileSync: (filePath) => {
                if (isResolvingRootFile && filePath.endsWith(rootFile.path)) {
                    isResolvingRootFile = false;
                    return Buffer.from(rootFile.content);
                }
                if (isResolvingRootFile) {
                    throw Error(`File (${filePath}) not found.`);
                }
                const file = dependencies.find((item) => filePath.endsWith(item.path));
                if (file !== undefined) {
                    return Buffer.from(file.content);
                }
                throw Error(`File (${filePath}) not found.`);
            } });
        const root = {
            name: rootFile.name,
            relativePath: path_1.default.basename(rootFile.path),
            url: rootFile.path,
        };
        try {
            const parser = new protobuf_json_parser_node_1.ProtobufJsonParserNode(root);
            const result = yield parser.parse();
            util.fs = originalFS;
            return result.root.toJSON();
        }
        catch (err) {
            util.fs = originalFS;
            throw err;
        }
    });
}
exports.toJSONFormat = toJSONFormat;
