"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parse = void 0;
const tslib_1 = require("tslib");
const parse_protobuf_spec_1 = require("./parse-protobuf-spec");
function parse(options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const { rootFile, dependencies, protobufJsonParser: JsonParser, getFileContent, appName, } = options;
        try {
            const jsonParser = new JsonParser(rootFile, dependencies);
            const { root, dataResources } = yield jsonParser.parse();
            const result = yield (0, parse_protobuf_spec_1.parseProtobufSpec)({
                root,
                rootFile,
                dependencies,
                dataResources,
                getFileContent,
                appName,
            });
            return result;
        }
        catch (err) {
            throw err;
        }
    });
}
exports.parse = parse;
