"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProtobufJsonParserBrowser = void 0;
const tslib_1 = require("tslib");
const protobufjs_1 = tslib_1.__importDefault(require("protobufjs"));
const protobuf_json_parser_base_1 = require("./protobuf-json-parser-base");
const utils_1 = require("./utils");
class ProtobufJsonParserBrowser extends protobuf_json_parser_base_1.ProtobufJsonParserBase {
    parse() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            let root = new protobufjs_1.default.Root();
            root.resolvePath = (source, target) => {
                const normalizedTarget = target.trim().replace(/^\.\//, '');
                if (this.ctx.rootFile.url.startsWith('blob:')) {
                    for (const [key, value] of Object.entries(this.ctx.fileMap)) {
                        if (!value)
                            continue;
                        if (normalizedTarget === key) {
                            this.ctx.usedFiles.push({
                                file: value,
                                isRoot: false,
                            });
                            return value.url;
                        }
                    }
                }
                else if (normalizedTarget !== this.ctx.rootFile.url) {
                    const url = `${(0, utils_1.getFileDir)(this.ctx.rootFile.url)}/${normalizedTarget}`;
                    this.ctx.usedFiles.push({
                        file: {
                            name: '',
                            relativePath: normalizedTarget,
                            url,
                        },
                        isRoot: false,
                    });
                    return url;
                }
                if (target !== this.ctx.rootFile.url) {
                    throw Error(`File (${target}) not found.`);
                }
                return target;
            };
            root = yield root.load(this.rootFile.url, {
                keepCase: true,
            });
            return {
                root,
                dataResources: this.ctx.usedFiles,
            };
        });
    }
}
exports.ProtobufJsonParserBrowser = ProtobufJsonParserBrowser;
