"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFileName = exports.resolveFullName = exports.isEnum = exports.isMessage = exports.isService = exports.isNamespace = exports.getFileDir = exports.getFilePathFromURL = exports.getFilePathFromBlobURL = exports.correctURL = void 0;
function correctURL(url) {
    return url.replace(/^(blob:)?http(s)?:\/([^/])/, '$1http$2://$3');
}
exports.correctURL = correctURL;
function getFilePathFromBlobURL(url) {
    let prefixLen = `blob:${window.location.origin}`.length;
    return url.substr(prefixLen + 1);
}
exports.getFilePathFromBlobURL = getFilePathFromBlobURL;
function getFilePathFromURL(url, rootFileURL) {
    let prefixLen = rootFileURL.lastIndexOf('/');
    return url.substr(prefixLen + 1);
}
exports.getFilePathFromURL = getFilePathFromURL;
function getFileDir(url) {
    let index = url.lastIndexOf('/');
    return url.substr(0, index);
}
exports.getFileDir = getFileDir;
function isNamespace(obj) {
    return !!obj.nested && !obj.fields;
}
exports.isNamespace = isNamespace;
function isService(obj) {
    return !!obj.methods;
}
exports.isService = isService;
function isMessage(obj) {
    return !!obj.fields;
}
exports.isMessage = isMessage;
function isEnum(obj) {
    return !!(obj.values && obj.valuesById);
}
exports.isEnum = isEnum;
function resolveFullName(fullName) {
    // .abc.def -> abc.def
    return fullName.replace(/^\./, '');
}
exports.resolveFullName = resolveFullName;
function getFileName(url) {
    let start = url.lastIndexOf('/');
    let end = url.lastIndexOf('.');
    if (end === -1 || end < start) {
        end = url.length;
    }
    return url.substring(start + 1, end);
}
exports.getFileName = getFileName;
