"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Adapter = void 0;
var types_1 = require("../types");
var dubbo_1 = require("./dubbo");
var Adapter = exports.Adapter = /** @class */ (function () {
    function Adapter(options) {
        this.options = options;
    }
    Adapter.prototype._getAdapter = function () {
        var AdapterClass = Adapter.adapterMap.get(this.options.service.serviceType);
        if (!AdapterClass) {
            throw new Error("serviceType (".concat(this.options.service.serviceType, ") is not supported"));
        }
        return new AdapterClass(this.options);
    };
    Adapter.prototype.getServiceProviderPath = function (key) {
        var adapter = this._getAdapter();
        return adapter.getServiceProviderPath(key);
    };
    Adapter.prototype.processServiceProviderResult = function (result) {
        if (!Array.isArray(result) || result.length === 0) {
            return [];
        }
        var adapter = this._getAdapter();
        return adapter.processServiceProviderResult(result);
    };
    Adapter.prototype.parseMetadataList = function (appName, metadataList) {
        var adapter = this._getAdapter();
        return adapter.parseMetadataList(appName, metadataList);
    };
    Adapter.prototype.getAppInfoList = function (metadataList) {
        var adapter = this._getAdapter();
        return adapter.getAppInfoList(metadataList);
    };
    Adapter.adapterMap = new Map([
        [types_1.ServiceType.DUBBO, dubbo_1.DubboAdapter],
    ]);
    return Adapter;
}());
