"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var vitest_1 = require("vitest");
var __1 = require("..");
(0, vitest_1.describe)('getGenericTypes', function () {
    var testCases = [
        { input: 'int', output: null },
        { input: 'float[]', output: null },
        { input: 'java.util.List', output: null },
        { input: 'java.util.List<String>', output: ['java.util.List', 'String'] },
        { input: 'java.util.List<java.lang.String>', output: ['java.util.List', 'java.lang.String'] },
        { input: 'foo.bar<baz, foo, bar>', output: ['foo.bar', 'baz', 'foo', 'bar'] },
    ];
    testCases.forEach(function (_a) {
        var input = _a.input, output = _a.output;
        (0, vitest_1.it)("should match ".concat(input), function () {
            var result = (0, __1.getGenericTypes)(input);
            (0, vitest_1.expect)(result).toEqual(output);
        });
    });
});
