"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var vitest_1 = require("vitest");
var __1 = require("../");
(0, vitest_1.describe)('MessageLoader', function () {
    (0, vitest_1.describe)('Dubbo', function () {
        var testCases = [
            {
                input: {
                    parameterTypes: ['int'],
                    returnType: 'int',
                    name: '',
                },
                output: {
                    messages: [
                        {
                            name: 'request',
                            path: '/fake-method-request-id/request',
                            definitionType: 'TYPE',
                            content: '["int"]',
                            jsonSchema: [
                                {
                                    type: 'integer',
                                    minimum: -0x80000000,
                                    maximum: 0x7fffffff,
                                },
                            ],
                            moduleId: 0,
                        },
                        {
                            name: 'response',
                            path: '/fake-method-response-id/response',
                            definitionType: 'TYPE',
                            content: 'int',
                            jsonSchema: {
                                type: 'integer',
                                minimum: -0x80000000,
                                maximum: 0x7fffffff,
                            },
                            moduleId: 0,
                        },
                    ],
                    dataSchemas: [],
                },
            },
            {
                input: {
                    parameterTypes: ['java.lang.String'],
                    returnType: 'java.lang.String',
                    name: '',
                },
                output: {
                    messages: [
                        {
                            name: 'request',
                            path: '/fake-method-request-id/request',
                            definitionType: 'TYPE',
                            content: '["java.lang.String"]',
                            jsonSchema: [
                                {
                                    type: 'string',
                                },
                            ],
                            moduleId: 0,
                        },
                        {
                            name: 'response',
                            path: '/fake-method-response-id/response',
                            definitionType: 'TYPE',
                            content: 'java.lang.String',
                            jsonSchema: {
                                type: 'string',
                            },
                            moduleId: 0,
                        },
                    ],
                    dataSchemas: [],
                },
            },
            {
                input: {
                    parameterTypes: ['java.lang.String', 'int'],
                    returnType: 'java.lang.Float',
                    name: '',
                },
                output: {
                    messages: [
                        {
                            name: 'request',
                            path: '/fake-method-request-id/request',
                            definitionType: 'TYPE',
                            content: '["java.lang.String","int"]',
                            jsonSchema: [
                                {
                                    type: 'string',
                                },
                                {
                                    type: 'integer',
                                    minimum: -0x80000000,
                                    maximum: 0x7fffffff,
                                },
                            ],
                            moduleId: 0,
                        },
                        {
                            name: 'response',
                            path: '/fake-method-response-id/response',
                            definitionType: 'TYPE',
                            content: 'java.lang.Float',
                            jsonSchema: {
                                type: 'number',
                            },
                            moduleId: 0,
                        },
                    ],
                    dataSchemas: [],
                },
            },
            {
                input: {
                    parameterTypes: ['java.util.List<java.lang.String>'],
                    returnType: 'java.lang.String',
                    name: '',
                },
                output: {
                    messages: [
                        {
                            name: 'request',
                            path: '/fake-method-request-id/request',
                            definitionType: 'TYPE',
                            content: '["java.util.List<java.lang.String>"]',
                            jsonSchema: [
                                {
                                    type: 'array',
                                    items: {
                                        type: 'string',
                                    },
                                },
                            ],
                            moduleId: 0,
                        },
                        {
                            name: 'response',
                            path: '/fake-method-response-id/response',
                            definitionType: 'TYPE',
                            content: 'java.lang.String',
                            jsonSchema: {
                                type: 'string',
                            },
                            moduleId: 0,
                        },
                    ],
                    dataSchemas: [],
                },
            },
            {
                input: {
                    parameterTypes: ['java.util.Set<java.lang.String>'],
                    returnType: 'java.lang.String',
                    name: '',
                },
                output: {
                    messages: [
                        {
                            name: 'request',
                            path: '/fake-method-request-id/request',
                            definitionType: 'TYPE',
                            content: '["java.util.Set<java.lang.String>"]',
                            jsonSchema: [
                                {
                                    type: 'array',
                                    uniqueItems: true,
                                    items: {
                                        type: 'string',
                                    },
                                },
                            ],
                            moduleId: 0,
                        },
                        {
                            name: 'response',
                            path: '/fake-method-response-id/response',
                            definitionType: 'TYPE',
                            content: 'java.lang.String',
                            jsonSchema: {
                                type: 'string',
                            },
                            moduleId: 0,
                        },
                    ],
                    dataSchemas: [],
                },
            },
            {
                input: {
                    parameterTypes: ['java.lang.String[]'],
                    returnType: 'java.lang.String',
                    name: '',
                },
                output: {
                    messages: [
                        {
                            name: 'request',
                            path: '/fake-method-request-id/request',
                            definitionType: 'TYPE',
                            content: '["java.lang.String[]"]',
                            jsonSchema: [
                                {
                                    type: 'array',
                                    items: {
                                        type: 'string',
                                    },
                                },
                            ],
                            moduleId: 0,
                        },
                        {
                            name: 'response',
                            path: '/fake-method-response-id/response',
                            definitionType: 'TYPE',
                            content: 'java.lang.String',
                            jsonSchema: {
                                type: 'string',
                            },
                            moduleId: 0,
                        },
                    ],
                    dataSchemas: [],
                },
            },
            {
                input: {
                    parameterTypes: ['java.util.HashMap<java.lang.String, int>[]'],
                    returnType: 'java.util.Map<int, float>[]',
                    name: '',
                },
                output: {
                    messages: [
                        {
                            name: 'request',
                            path: '/fake-method-request-id/request',
                            definitionType: 'TYPE',
                            content: '["java.util.HashMap<java.lang.String, int>[]"]',
                            jsonSchema: [
                                {
                                    type: 'array',
                                    items: {
                                        type: 'object',
                                        additionalProperties: {
                                            type: 'integer',
                                            minimum: -0x80000000,
                                            maximum: 0x7fffffff,
                                        },
                                    },
                                },
                            ],
                            moduleId: 0,
                        },
                        {
                            name: 'response',
                            path: '/fake-method-response-id/response',
                            definitionType: 'TYPE',
                            content: 'java.util.Map<int, float>[]',
                            jsonSchema: {
                                type: 'array',
                                items: {
                                    type: 'object',
                                    additionalProperties: {
                                        type: 'number',
                                    },
                                },
                            },
                            moduleId: 0,
                        },
                    ],
                    dataSchemas: [],
                },
            },
        ];
        testCases.forEach(function (_a, i) {
            var input = _a.input, output = _a.output;
            (0, vitest_1.it)("should match load result - ".concat(i), function () {
                var loader = new __1.MessageLoader();
                loader.load({ requestId: 'fake-method-request-id', responseId: 'fake-method-response-id' }, input, '');
                var messages = loader.getMessages('');
                var dataSchemas = loader.getDataSchemas();
                var result = {
                    messages: messages,
                    dataSchemas: dataSchemas,
                    messageLength: messages.length,
                    dataSchemaLength: dataSchemas.length,
                };
                result.messages.sort(function (a, b) { return a.path.localeCompare(b.path); });
                result.dataSchemas.sort(function (a, b) { return a.path.localeCompare(b.path); });
                (0, vitest_1.expect)(result).toMatchObject({
                    messages: vitest_1.expect.arrayContaining(output.messages.sort(function (a, b) { return a.path.localeCompare(b.path); })),
                    dataSchemas: vitest_1.expect.arrayContaining(output.dataSchemas.sort(function (a, b) { return a.path.localeCompare(b.path); })),
                    messageLength: output.messages.length,
                    dataSchemaLength: output.dataSchemas.length,
                });
            });
        });
    });
});
